﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/RecurringChargeFrequency.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {

/**
 * <p>Describes a recurring charge.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/RecurringCharge">AWS
 * API Reference</a></p>
 */
class RecurringCharge {
 public:
  AWS_EC2_API RecurringCharge() = default;
  AWS_EC2_API RecurringCharge(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_EC2_API RecurringCharge& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_EC2_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_EC2_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The amount of the recurring charge.</p>
   */
  inline double GetAmount() const { return m_amount; }
  inline bool AmountHasBeenSet() const { return m_amountHasBeenSet; }
  inline void SetAmount(double value) {
    m_amountHasBeenSet = true;
    m_amount = value;
  }
  inline RecurringCharge& WithAmount(double value) {
    SetAmount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The frequency of the recurring charge.</p>
   */
  inline RecurringChargeFrequency GetFrequency() const { return m_frequency; }
  inline bool FrequencyHasBeenSet() const { return m_frequencyHasBeenSet; }
  inline void SetFrequency(RecurringChargeFrequency value) {
    m_frequencyHasBeenSet = true;
    m_frequency = value;
  }
  inline RecurringCharge& WithFrequency(RecurringChargeFrequency value) {
    SetFrequency(value);
    return *this;
  }
  ///@}
 private:
  double m_amount{0.0};
  bool m_amountHasBeenSet = false;

  RecurringChargeFrequency m_frequency{RecurringChargeFrequency::NOT_SET};
  bool m_frequencyHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
