﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/NetworkInsightsAccessScopeContent.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class GetNetworkInsightsAccessScopeContentResponse {
 public:
  AWS_EC2_API GetNetworkInsightsAccessScopeContentResponse() = default;
  AWS_EC2_API GetNetworkInsightsAccessScopeContentResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API GetNetworkInsightsAccessScopeContentResponse& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The Network Access Scope content.</p>
   */
  inline const NetworkInsightsAccessScopeContent& GetNetworkInsightsAccessScopeContent() const {
    return m_networkInsightsAccessScopeContent;
  }
  template <typename NetworkInsightsAccessScopeContentT = NetworkInsightsAccessScopeContent>
  void SetNetworkInsightsAccessScopeContent(NetworkInsightsAccessScopeContentT&& value) {
    m_networkInsightsAccessScopeContentHasBeenSet = true;
    m_networkInsightsAccessScopeContent = std::forward<NetworkInsightsAccessScopeContentT>(value);
  }
  template <typename NetworkInsightsAccessScopeContentT = NetworkInsightsAccessScopeContent>
  GetNetworkInsightsAccessScopeContentResponse& WithNetworkInsightsAccessScopeContent(NetworkInsightsAccessScopeContentT&& value) {
    SetNetworkInsightsAccessScopeContent(std::forward<NetworkInsightsAccessScopeContentT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  GetNetworkInsightsAccessScopeContentResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  NetworkInsightsAccessScopeContent m_networkInsightsAccessScopeContent;
  bool m_networkInsightsAccessScopeContentHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
