﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class ModifyInstanceCpuOptionsResponse {
 public:
  AWS_EC2_API ModifyInstanceCpuOptionsResponse() = default;
  AWS_EC2_API ModifyInstanceCpuOptionsResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API ModifyInstanceCpuOptionsResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>The ID of the instance that was updated.</p>
   */
  inline const Aws::String& GetInstanceId() const { return m_instanceId; }
  template <typename InstanceIdT = Aws::String>
  void SetInstanceId(InstanceIdT&& value) {
    m_instanceIdHasBeenSet = true;
    m_instanceId = std::forward<InstanceIdT>(value);
  }
  template <typename InstanceIdT = Aws::String>
  ModifyInstanceCpuOptionsResponse& WithInstanceId(InstanceIdT&& value) {
    SetInstanceId(std::forward<InstanceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of CPU cores that are running for the specified instance after the
   * update.</p>
   */
  inline int GetCoreCount() const { return m_coreCount; }
  inline void SetCoreCount(int value) {
    m_coreCountHasBeenSet = true;
    m_coreCount = value;
  }
  inline ModifyInstanceCpuOptionsResponse& WithCoreCount(int value) {
    SetCoreCount(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of threads that are running per CPU core for the specified
   * instance after the update.</p>
   */
  inline int GetThreadsPerCore() const { return m_threadsPerCore; }
  inline void SetThreadsPerCore(int value) {
    m_threadsPerCoreHasBeenSet = true;
    m_threadsPerCore = value;
  }
  inline ModifyInstanceCpuOptionsResponse& WithThreadsPerCore(int value) {
    SetThreadsPerCore(value);
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  ModifyInstanceCpuOptionsResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_instanceId;
  bool m_instanceIdHasBeenSet = false;

  int m_coreCount{0};
  bool m_coreCountHasBeenSet = false;

  int m_threadsPerCore{0};
  bool m_threadsPerCoreHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
