﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/kinesisvideo/KinesisVideo_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/DateTime.h>
#include <aws/kinesisvideo/model/SyncStatus.h>
#include <aws/kinesisvideo/model/EdgeConfig.h>
#include <aws/kinesisvideo/model/EdgeAgentStatus.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace KinesisVideo
{
namespace Model
{
  class DescribeEdgeConfigurationResult
  {
  public:
    AWS_KINESISVIDEO_API DescribeEdgeConfigurationResult();
    AWS_KINESISVIDEO_API DescribeEdgeConfigurationResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    AWS_KINESISVIDEO_API DescribeEdgeConfigurationResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    ///@{
    /**
     * <p>The name of the stream from which the edge configuration was updated.</p>
     */
    inline const Aws::String& GetStreamName() const{ return m_streamName; }
    inline void SetStreamName(const Aws::String& value) { m_streamName = value; }
    inline void SetStreamName(Aws::String&& value) { m_streamName = std::move(value); }
    inline void SetStreamName(const char* value) { m_streamName.assign(value); }
    inline DescribeEdgeConfigurationResult& WithStreamName(const Aws::String& value) { SetStreamName(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithStreamName(Aws::String&& value) { SetStreamName(std::move(value)); return *this;}
    inline DescribeEdgeConfigurationResult& WithStreamName(const char* value) { SetStreamName(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) of the stream.</p>
     */
    inline const Aws::String& GetStreamARN() const{ return m_streamARN; }
    inline void SetStreamARN(const Aws::String& value) { m_streamARN = value; }
    inline void SetStreamARN(Aws::String&& value) { m_streamARN = std::move(value); }
    inline void SetStreamARN(const char* value) { m_streamARN.assign(value); }
    inline DescribeEdgeConfigurationResult& WithStreamARN(const Aws::String& value) { SetStreamARN(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithStreamARN(Aws::String&& value) { SetStreamARN(std::move(value)); return *this;}
    inline DescribeEdgeConfigurationResult& WithStreamARN(const char* value) { SetStreamARN(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp at which a stream’s edge configuration was first created.</p>
     */
    inline const Aws::Utils::DateTime& GetCreationTime() const{ return m_creationTime; }
    inline void SetCreationTime(const Aws::Utils::DateTime& value) { m_creationTime = value; }
    inline void SetCreationTime(Aws::Utils::DateTime&& value) { m_creationTime = std::move(value); }
    inline DescribeEdgeConfigurationResult& WithCreationTime(const Aws::Utils::DateTime& value) { SetCreationTime(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithCreationTime(Aws::Utils::DateTime&& value) { SetCreationTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The timestamp at which a stream’s edge configuration was last updated.</p>
     */
    inline const Aws::Utils::DateTime& GetLastUpdatedTime() const{ return m_lastUpdatedTime; }
    inline void SetLastUpdatedTime(const Aws::Utils::DateTime& value) { m_lastUpdatedTime = value; }
    inline void SetLastUpdatedTime(Aws::Utils::DateTime&& value) { m_lastUpdatedTime = std::move(value); }
    inline DescribeEdgeConfigurationResult& WithLastUpdatedTime(const Aws::Utils::DateTime& value) { SetLastUpdatedTime(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithLastUpdatedTime(Aws::Utils::DateTime&& value) { SetLastUpdatedTime(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>The latest status of the edge configuration update.</p>
     */
    inline const SyncStatus& GetSyncStatus() const{ return m_syncStatus; }
    inline void SetSyncStatus(const SyncStatus& value) { m_syncStatus = value; }
    inline void SetSyncStatus(SyncStatus&& value) { m_syncStatus = std::move(value); }
    inline DescribeEdgeConfigurationResult& WithSyncStatus(const SyncStatus& value) { SetSyncStatus(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithSyncStatus(SyncStatus&& value) { SetSyncStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>A description of the generated failure status.</p>
     */
    inline const Aws::String& GetFailedStatusDetails() const{ return m_failedStatusDetails; }
    inline void SetFailedStatusDetails(const Aws::String& value) { m_failedStatusDetails = value; }
    inline void SetFailedStatusDetails(Aws::String&& value) { m_failedStatusDetails = std::move(value); }
    inline void SetFailedStatusDetails(const char* value) { m_failedStatusDetails.assign(value); }
    inline DescribeEdgeConfigurationResult& WithFailedStatusDetails(const Aws::String& value) { SetFailedStatusDetails(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithFailedStatusDetails(Aws::String&& value) { SetFailedStatusDetails(std::move(value)); return *this;}
    inline DescribeEdgeConfigurationResult& WithFailedStatusDetails(const char* value) { SetFailedStatusDetails(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>A description of the stream's edge configuration that will be used to sync
     * with the Edge Agent IoT Greengrass component. The Edge Agent component will run
     * on an IoT Hub Device setup at your premise.</p>
     */
    inline const EdgeConfig& GetEdgeConfig() const{ return m_edgeConfig; }
    inline void SetEdgeConfig(const EdgeConfig& value) { m_edgeConfig = value; }
    inline void SetEdgeConfig(EdgeConfig&& value) { m_edgeConfig = std::move(value); }
    inline DescribeEdgeConfigurationResult& WithEdgeConfig(const EdgeConfig& value) { SetEdgeConfig(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithEdgeConfig(EdgeConfig&& value) { SetEdgeConfig(std::move(value)); return *this;}
    ///@}

    ///@{
    /**
     * <p>An object that contains the latest status details for an edge agent's
     * recorder and uploader jobs. Use this information to determine the current health
     * of an edge agent.</p>
     */
    inline const EdgeAgentStatus& GetEdgeAgentStatus() const{ return m_edgeAgentStatus; }
    inline void SetEdgeAgentStatus(const EdgeAgentStatus& value) { m_edgeAgentStatus = value; }
    inline void SetEdgeAgentStatus(EdgeAgentStatus&& value) { m_edgeAgentStatus = std::move(value); }
    inline DescribeEdgeConfigurationResult& WithEdgeAgentStatus(const EdgeAgentStatus& value) { SetEdgeAgentStatus(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithEdgeAgentStatus(EdgeAgentStatus&& value) { SetEdgeAgentStatus(std::move(value)); return *this;}
    ///@}

    ///@{
    
    inline const Aws::String& GetRequestId() const{ return m_requestId; }
    inline void SetRequestId(const Aws::String& value) { m_requestId = value; }
    inline void SetRequestId(Aws::String&& value) { m_requestId = std::move(value); }
    inline void SetRequestId(const char* value) { m_requestId.assign(value); }
    inline DescribeEdgeConfigurationResult& WithRequestId(const Aws::String& value) { SetRequestId(value); return *this;}
    inline DescribeEdgeConfigurationResult& WithRequestId(Aws::String&& value) { SetRequestId(std::move(value)); return *this;}
    inline DescribeEdgeConfigurationResult& WithRequestId(const char* value) { SetRequestId(value); return *this;}
    ///@}
  private:

    Aws::String m_streamName;

    Aws::String m_streamARN;

    Aws::Utils::DateTime m_creationTime;

    Aws::Utils::DateTime m_lastUpdatedTime;

    SyncStatus m_syncStatus;

    Aws::String m_failedStatusDetails;

    EdgeConfig m_edgeConfig;

    EdgeAgentStatus m_edgeAgentStatus;

    Aws::String m_requestId;
  };

} // namespace Model
} // namespace KinesisVideo
} // namespace Aws
