﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/s3control/S3Control_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <utility>

namespace Aws
{
namespace Utils
{
namespace Xml
{
  class XmlNode;
} // namespace Xml
} // namespace Utils
namespace S3Control
{
namespace Model
{

  /**
   * <p>Contains the information required to locate a manifest object. Manifests
   * can't be imported from directory buckets. For more information, see <a
   * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">Directory
   * buckets</a>.</p><p><h3>See Also:</h3>   <a
   * href="http://docs.aws.amazon.com/goto/WebAPI/s3control-2018-08-20/JobManifestLocation">AWS
   * API Reference</a></p>
   */
  class JobManifestLocation
  {
  public:
    AWS_S3CONTROL_API JobManifestLocation();
    AWS_S3CONTROL_API JobManifestLocation(const Aws::Utils::Xml::XmlNode& xmlNode);
    AWS_S3CONTROL_API JobManifestLocation& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

    AWS_S3CONTROL_API void AddToNode(Aws::Utils::Xml::XmlNode& parentNode) const;


    ///@{
    /**
     * <p>The Amazon Resource Name (ARN) for a manifest object.</p>  <p>When
     * you're using XML requests, you must replace special characters (such as carriage
     * returns) in object keys with their equivalent XML entity codes. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-keys.html#object-key-xml-related-constraints">
     * XML-related object key constraints</a> in the <i>Amazon S3 User Guide</i>.</p>
     * 
     */
    inline const Aws::String& GetObjectArn() const{ return m_objectArn; }
    inline bool ObjectArnHasBeenSet() const { return m_objectArnHasBeenSet; }
    inline void SetObjectArn(const Aws::String& value) { m_objectArnHasBeenSet = true; m_objectArn = value; }
    inline void SetObjectArn(Aws::String&& value) { m_objectArnHasBeenSet = true; m_objectArn = std::move(value); }
    inline void SetObjectArn(const char* value) { m_objectArnHasBeenSet = true; m_objectArn.assign(value); }
    inline JobManifestLocation& WithObjectArn(const Aws::String& value) { SetObjectArn(value); return *this;}
    inline JobManifestLocation& WithObjectArn(Aws::String&& value) { SetObjectArn(std::move(value)); return *this;}
    inline JobManifestLocation& WithObjectArn(const char* value) { SetObjectArn(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The optional version ID to identify a specific version of the manifest
     * object.</p>
     */
    inline const Aws::String& GetObjectVersionId() const{ return m_objectVersionId; }
    inline bool ObjectVersionIdHasBeenSet() const { return m_objectVersionIdHasBeenSet; }
    inline void SetObjectVersionId(const Aws::String& value) { m_objectVersionIdHasBeenSet = true; m_objectVersionId = value; }
    inline void SetObjectVersionId(Aws::String&& value) { m_objectVersionIdHasBeenSet = true; m_objectVersionId = std::move(value); }
    inline void SetObjectVersionId(const char* value) { m_objectVersionIdHasBeenSet = true; m_objectVersionId.assign(value); }
    inline JobManifestLocation& WithObjectVersionId(const Aws::String& value) { SetObjectVersionId(value); return *this;}
    inline JobManifestLocation& WithObjectVersionId(Aws::String&& value) { SetObjectVersionId(std::move(value)); return *this;}
    inline JobManifestLocation& WithObjectVersionId(const char* value) { SetObjectVersionId(value); return *this;}
    ///@}

    ///@{
    /**
     * <p>The ETag for the specified manifest object.</p>
     */
    inline const Aws::String& GetETag() const{ return m_eTag; }
    inline bool ETagHasBeenSet() const { return m_eTagHasBeenSet; }
    inline void SetETag(const Aws::String& value) { m_eTagHasBeenSet = true; m_eTag = value; }
    inline void SetETag(Aws::String&& value) { m_eTagHasBeenSet = true; m_eTag = std::move(value); }
    inline void SetETag(const char* value) { m_eTagHasBeenSet = true; m_eTag.assign(value); }
    inline JobManifestLocation& WithETag(const Aws::String& value) { SetETag(value); return *this;}
    inline JobManifestLocation& WithETag(Aws::String&& value) { SetETag(std::move(value)); return *this;}
    inline JobManifestLocation& WithETag(const char* value) { SetETag(value); return *this;}
    ///@}
  private:

    Aws::String m_objectArn;
    bool m_objectArnHasBeenSet = false;

    Aws::String m_objectVersionId;
    bool m_objectVersionIdHasBeenSet = false;

    Aws::String m_eTag;
    bool m_eTagHasBeenSet = false;
  };

} // namespace Model
} // namespace S3Control
} // namespace Aws
