"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConstantBackoff = void 0;
class ConstantBackoff {
    /**
     * Backoff that returns a constant interval.
     */
    constructor(interval) {
        this.interval = interval;
    }
    /**
     * @inheritdoc
     */
    next() {
        return instance(this.interval);
    }
}
exports.ConstantBackoff = ConstantBackoff;
const instance = (interval) => ({
    duration: interval,
    next() {
        return this;
    },
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/2901c5ac6db8a986a5666c3af51ff804d05af0d4/node_modules/cockatiel/dist/backoff/ConstantBackoff.js.map