"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsecutiveBreaker = void 0;
class ConsecutiveBreaker {
    /**
     * ConsecutiveBreaker breaks if more than `threshold` exceptions are received
     * over a time period.
     */
    constructor(threshold) {
        this.threshold = threshold;
        /**
         * @inheritdoc
         */
        this.state = 0;
    }
    /**
     * @inheritdoc
     */
    success() {
        this.state = 0;
    }
    /**
     * @inheritdoc
     */
    failure() {
        return ++this.state >= this.threshold;
    }
}
exports.ConsecutiveBreaker = ConsecutiveBreaker;//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/6f17636121051a53c88d3e605c491d22af2ba755/node_modules/cockatiel/dist/breaker/ConsecutiveBreaker.js.map