"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("node:fs/promises"));
const constants_1 = require("./constants");
const download_1 = require("./download");
const signature_manifest_1 = require("./signature-manifest");
const zip_1 = require("./zip");
const errors_1 = require("./errors");
jest.setTimeout(40000);
describe("signatureManifestTest", () => {
    it("generates a signature manifest file", async () => {
        const extensionDestination = await (0, download_1.download)("https://ms-python.gallerycdn.vsassets.io/extensions/ms-python/python/2024.7.11511013/1717064437177/Microsoft.VisualStudio.Services.VSIXPackage", { filename: "extension.vsix" });
        const signatureArchivePath = await (0, download_1.download)("https://ms-python.gallerycdn.vsassets.io/extensions/ms-python/python/2024.7.11511013/1717064437177/Microsoft.VisualStudio.Services.VsixSignature", { filename: "signature.sigzip" });
        const expectedSignatureManifest = JSON.parse((await (0, zip_1.extractFileAsBufferUsingStreams)(signatureArchivePath, constants_1.SIGNATURE_MANIFEST_FILE_NAME)).toString("utf-8"));
        const generatedManifest = await (0, signature_manifest_1.generateManifest)(extensionDestination);
        expect(generatedManifest).toEqual(expectedSignatureManifest);
        expect((0, signature_manifest_1.verifyManifest)(generatedManifest, extensionDestination)).resolves.toBe(true);
        // Clean up
        await fs.unlink(extensionDestination);
        await fs.unlink(signatureArchivePath);
    });
    it("properly validates an invalid manifest", async () => {
        const extensionDestination = await (0, download_1.download)("https://ms-python.gallerycdn.vsassets.io/extensions/ms-python/python/2024.8.0/1717626840538/Microsoft.VisualStudio.Services.VSIXPackage", { filename: "extension.vsix" });
        const signatureArchivePath = await (0, download_1.download)("https://ms-python.gallerycdn.vsassets.io/extensions/ms-python/python/2024.7.11511013/1717064437177/Microsoft.VisualStudio.Services.VsixSignature", { filename: "signature.sigzip" });
        const incorrectSignatureManifest = JSON.parse((await (0, zip_1.extractFileAsBufferUsingStreams)(signatureArchivePath, constants_1.SIGNATURE_MANIFEST_FILE_NAME)).toString("utf-8"));
        expect((0, signature_manifest_1.verifyManifest)(incorrectSignatureManifest, extensionDestination)).resolves.toBe(false);
        // Clean up
        await fs.unlink(extensionDestination);
        await fs.unlink(signatureArchivePath);
    });
    it("detects a malformed manifest", async () => {
        const extensionDestination = await (0, download_1.download)("https://ms-python.gallerycdn.vsassets.io/extensions/ms-python/python/2024.8.0/1717626840538/Microsoft.VisualStudio.Services.VSIXPackage", { filename: "extension.vsix" });
        await expect((0, signature_manifest_1.verifyManifest)({ allSignatures: "totallyValid" }, extensionDestination)).rejects.toThrow(errors_1.ExtensionSignatureVerificationError);
        // Clean up
        await fs.unlink(extensionDestination);
    });
});//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/03c265b1adee71ac88f833e065f7bb956b60550a/node_modules/node-ovsx-sign/lib/utils/signature-manifest.test.js.map