const searchData = {"envversion": {"sphinx.domains.c": 2, "sphinx.domains.changeset": 1, "sphinx.domains.citation": 1, "sphinx.domains.cpp": 5, "sphinx.domains.index": 1, "sphinx.domains.javascript": 2, "sphinx.domains.math": 2, "sphinx.domains.python": 3, "sphinx.domains.rst": 2, "sphinx.domains.std": 2, "sphinx.ext.intersphinx": 1, "repo_docs.ext.toctree": 2, "repo_docs.ext.mermaid": 1, "repo_docs.ext.enhanced_search": 2, "sphinx": 56}, "data": [{"id": 0, "doc_id": 0, "filename": "api/data-structures.html", "domain_name": "std", "name": "api/data-structures", "display_name": "Data Structures", "type": "doc", "display_type": "Page", "docname": "api/data-structures", "anchor": "", "priority": -1, "content": "CUPTI::PcSamplingUtil::BufferInfo   BufferInfo will be stored in the file for every buffer i.e for every call of UtilDumpPcSamplingBufferInFile() API. CUPTI::PcSamplingUtil::CUptiUtil_GetBufferInfoParams  Params for CuptiUtilGetBufferInfo . CUPTI::PcSamplingUtil::CUptiUtil_GetHeaderDataParams  Params for CuptiUtilGetHeaderData . CUPTI::PcSamplingUtil::CUptiUtil_GetPcSampDataParams  Params for CuptiUtilGetPcSampData . CUPTI::PcSamplingUtil::CUptiUtil_MergePcSampDataParams  Params for CuptiUtilMergePcSampData . CUPTI::PcSamplingUtil::CUptiUtil_PutPcSampDataParams  Params for CuptiUtilPutPcSampData . CUPTI::PcSamplingUtil::Header   Header info will be stored in file. CUPTI::PcSamplingUtil::PcSamplingStallReasons  All available stall reasons name and respective indexes will be stored in it. CUpti_Activity  The base activity record. CUpti_ActivityAPI  The activity record for a driver or runtime API invocation. CUpti_ActivityAutoBoostState  Device auto boost state structure. CUpti_ActivityBranch  The activity record for source level result branch. CUpti_ActivityBranch2  The activity record for source level result branch. CUpti_ActivityCdpKernel  The activity record for CDP (CUDA Dynamic Parallelism) kernel. CUpti_ActivityConfidentialComputeRotation  Event related to confidential compute encryption rotation. CUpti_ActivityContext  The activity record for a context. CUpti_ActivityContext2  The activity record for a context. CUpti_ActivityContext3  The activity record for a context. CUpti_ActivityCudaEvent  The activity record for CUDA event. CUpti_ActivityCudaEvent2  The activity record for CUDA event. CUpti_ActivityDevice  The activity record for a device. CUpti_ActivityDevice2  The activity record for a device. CUpti_ActivityDevice3  The activity record for a device. CUpti_ActivityDevice4  The activity record for a device. CUpti_ActivityDevice5  The activity record for a device. CUpti_ActivityDeviceAttribute  The activity record for a device attribute. CUpti_ActivityDeviceGraphTrace  The activity record for trace of device graph execution. CUpti_ActivityEnvironment  The activity record for CUPTI environmental data. CUpti_ActivityEvent  The activity record for a CUPTI event. CUpti_ActivityEventInstance  The activity record for a CUPTI event with instance information. CUpti_ActivityExternalCorrelation  The activity record for correlation with external records. CUpti_ActivityFunction  The activity record for global/device functions. CUpti_ActivityGlobalAccess  The activity record for source-level global access. CUpti_ActivityGlobalAccess2  The activity record for source-level global access. CUpti_ActivityGlobalAccess3  The activity record for source-level global access. CUpti_ActivityGraphTrace  The activity record for trace of graph execution. CUpti_ActivityGraphTrace2  The activity record for trace of graph execution. CUpti_ActivityInstantaneousEvent  The activity record for an instantaneous CUPTI event. CUpti_ActivityInstantaneousEventInstance  The activity record for an instantaneous CUPTI event with event domain instance information. CUpti_ActivityInstantaneousMetric  The activity record for an instantaneous CUPTI metric. CUpti_ActivityInstantaneousMetricInstance  The instantaneous activity record for a CUPTI metric with instance information. CUpti_ActivityInstructionCorrelation  The activity record for source-level sass/source line-by-line correlation. CUpti_ActivityInstructionExecution  The activity record for source-level instruction execution. CUpti_ActivityJit  The activity record for JIT operations. CUpti_ActivityJit2  The activity record for JIT operations. CUpti_ActivityKernel  The activity record for kernel. CUpti_ActivityKernel2  The activity record for kernel. CUpti_ActivityKernel3  The activity record for a kernel (CUDA 6.5(with sm_52 support) onwards). CUpti_ActivityKernel4  The activity record for a kernel (CUDA 9.0(with sm_70 support) onwards). CUpti_ActivityKernel5  The activity record for a kernel (CUDA 11.0(with sm_80 support) onwards). CUpti_ActivityKernel6  The activity record for kernel. CUpti_ActivityKernel7  The activity record for kernel. CUpti_ActivityKernel8  The activity record for kernel. CUpti_ActivityKernel9  The activity record for kernel. CUpti_ActivityMarker  The activity record providing a marker which is an instantaneous point in time. CUpti_ActivityMarker2  The activity record providing a marker which is an instantaneous point in time. CUpti_ActivityMarkerData  The activity record providing detailed information for a marker. CUpti_ActivityMemDecompress  The activity record for trace of decompression operations. CUpti_ActivityMemcpy  The activity record for memory copies. CUpti_ActivityMemcpy3  The activity record for memory copies. CUpti_ActivityMemcpy4  The activity record for memory copies. CUpti_ActivityMemcpy5  The activity record for memory copies. CUpti_ActivityMemcpy6  The activity record for memory copies. CUpti_ActivityMemcpyPtoP  The activity record for peer-to-peer memory copies. CUpti_ActivityMemcpyPtoP2  The activity record for peer-to-peer memory copies. CUpti_ActivityMemcpyPtoP3  The activity record for peer-to-peer memory copies. CUpti_ActivityMemcpyPtoP4  The activity record for peer-to-peer memory copies. CUpti_ActivityMemory  The activity record for memory. CUpti_ActivityMemory2  The activity record for memory. CUpti_ActivityMemory3  The activity record for memory. CUpti_ActivityMemory4  The activity record for memory. CUpti_ActivityMemoryPool  The activity record for memory pool. CUpti_ActivityMemoryPool2  The activity record for memory pool. CUpti_ActivityMemset  The activity record for memset. CUpti_ActivityMemset2  The activity record for memset. CUpti_ActivityMemset3  The activity record for memset. CUpti_ActivityMemset4  The activity record for memset. CUpti_ActivityMetric  The activity record for a CUPTI metric. CUpti_ActivityMetricInstance  The activity record for a CUPTI metric with instance information. CUpti_ActivityModule  The activity record for a CUDA module. CUpti_ActivityName  The activity record providing a name. CUpti_ActivityNvLink  NVLink information. CUpti_ActivityNvLink2  NVLink information. CUpti_ActivityNvLink3  NVLink information. CUpti_ActivityNvLink4  NVLink information. CUpti_ActivityObjectKindId  Identifiers for object kinds as specified by CUpti_ActivityObjectKind. CUpti_ActivityOpenAcc  The base activity record for OpenAcc records. CUpti_ActivityOpenAccData  The activity record for OpenACC data. CUpti_ActivityOpenAccLaunch  The activity record for OpenACC launch. CUpti_ActivityOpenAccOther  The activity record for OpenACC other. CUpti_ActivityOpenMp  The base activity record for OpenMp records. CUpti_ActivityOverhead  The kinds of activity records. CUpti_ActivityOverhead2  The activity record for CUPTI and driver overheads. CUpti_ActivityOverhead3  The activity record for CUPTI and driver overheads. CUpti_ActivityOverheadCommandBufferFullData  The structure to provide additional data for CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL. CUpti_ActivityPCSampling  The activity record for PC sampling. CUpti_ActivityPCSampling2  The activity record for PC sampling. CUpti_ActivityPCSampling3  The activity record for PC sampling. CUpti_ActivityPCSamplingConfig  PC sampling configuration structure. CUpti_ActivityPCSamplingRecordInfo  The activity record for record status for PC sampling. CUpti_ActivityPcie  PCI devices information required to construct topology. CUpti_ActivityPreemption  The activity record for a preemption of a CDP kernel. CUpti_ActivitySharedAccess  The activity record for source-level shared access. CUpti_ActivitySourceLocator  The activity record for source locator. CUpti_ActivityStream  The activity record for CUDA stream. CUpti_ActivitySynchronization  The activity record for synchronization management. CUpti_ActivitySynchronization2  The activity record for synchronization management. CUpti_ActivityUnifiedMemoryCounter  The activity record for Unified Memory counters (deprecated in CUDA 7.0) CUpti_ActivityUnifiedMemoryCounter2  The activity record for Unified Memory counters (deprecated in 12.8) CUpti_ActivityUnifiedMemoryCounter3  The activity record for Unified Memory counters (CUDA 7.0 and beyond) CUpti_ActivityUnifiedMemoryCounterConfig  Unified Memory counters configuration structure. CUpti_CallbackData  Data passed into a runtime or driver API callback function. CUpti_EventGroupSet  A set of event groups. CUpti_EventGroupSets  A set of event group sets. CUpti_GetCubinCrcParams  Params for cuptiGetCubinCrc. CUpti_GetSassToSourceCorrelationParams  Params for cuptiGetSassToSourceCorrelation. CUpti_GraphData  CUDA graphs data passed into a resource callback function. CUpti_MetricValue  A metric value. CUpti_ModuleResourceData  Module data passed into a resource callback function. CUpti_NvtxData  Data passed into a NVTX callback function. CUpti_PCSamplingConfigurationInfo  PC sampling configuration information structure. CUpti_PCSamplingConfigurationInfoParams  PC sampling configuration structure. CUpti_PCSamplingData  Collected PC Sampling data. CUpti_PCSamplingDisableParams  Params for cuptiPCSamplingDisable. CUpti_PCSamplingEnableParams  Params for cuptiPCSamplingEnable. CUpti_PCSamplingGetDataParams  Params for cuptiPCSamplingEnable. CUpti_PCSamplingGetNumStallReasonsParams  Params for cuptiPCSamplingGetNumStallReasons. CUpti_PCSamplingGetStallReasonsParams  Params for cuptiPCSamplingGetStallReasons. CUpti_PCSamplingPCData  PC Sampling data. CUpti_PCSamplingStallReason  PC Sampling stall reasons. CUpti_PCSamplingStartParams  Params for cuptiPCSamplingStart. CUpti_PCSamplingStopParams  Params for cuptiPCSamplingStop. CUpti_PmSampling_CounterDataImage_Initialize_Params  Params for cuptiPmSamplingCounterDataImageInitialize. CUpti_PmSampling_CounterData_GetSampleInfo_Params  Params for cuptiPmSamplingCounterDataGetSampleInfo. CUpti_PmSampling_DecodeData_Params  Params for cuptiPmSamplingDecodeData. CUpti_PmSampling_Disable_Params  Params for cuptiPmSamplingDisable. CUpti_PmSampling_Enable_Params  Params for cuptiPmSamplingEnable. CUpti_PmSampling_GetCounterAvailability_Params  Params for cuptiPmSamplingGetCounterData. CUpti_PmSampling_GetCounterDataInfo_Params  Params for cuptiPmSamplingGetCounterDataInfo. CUpti_PmSampling_GetCounterDataSize_Params  Params for cuptiPmSamplingGetCounterDataSize. CUpti_PmSampling_SetConfig_Params  Params for cuptiPmSamplingSetConfig. CUpti_PmSampling_Start_Params  Params for cuptiPmSamplingStart. CUpti_PmSampling_Stop_Params  Params for cuptiPmSamplingStop. CUpti_Profiler_BeginPass_Params  Params for cuptiProfilerBeginPass. CUpti_Profiler_BeginSession_Params  Params for cuptiProfilerBeginSession. CUpti_Profiler_CounterDataImageOptions  Input parameter to define the counterDataImage. CUpti_Profiler_CounterDataImage_CalculateScratchBufferSize_Params  Params for cuptiProfilerCounterDataImageCalculateScratchBufferSize. CUpti_Profiler_CounterDataImage_CalculateSize_Params  Params for cuptiProfilerCounterDataImageCalculateSize. CUpti_Profiler_CounterDataImage_InitializeScratchBuffer_Params  Params for cuptiProfilerCounterDataImageInitializeScratchBuffer. CUpti_Profiler_CounterDataImage_Initialize_Params  Params for cuptiProfilerCounterDataImageInitialize. CUpti_Profiler_DeInitialize_Params  Default parameter for cuptiProfilerDeInitialize. CUpti_Profiler_DeviceSupported_Params  Params for cuptiProfilerDeviceSupported. CUpti_Profiler_DisableProfiling_Params  Params for cuptiProfilerDisableProfiling. CUpti_Profiler_EnableProfiling_Params  Params for cuptiProfilerEnableProfiling. CUpti_Profiler_EndPass_Params  Params for cuptiProfilerEndPass. CUpti_Profiler_EndSession_Params  Params for cuptiProfilerEndSession. CUpti_Profiler_FlushCounterData_Params  Params for cuptiProfilerFlushCounterData. CUpti_Profiler_GetCounterAvailability_Params  Params for cuptiProfilerGetCounterAvailability. CUpti_Profiler_Host_ConfigAddMetrics_Params  Params for cuptiProfilerHostConfigAddMetrics. CUpti_Profiler_Host_Deinitialize_Params  Params for cuptiProfilerHostDeinitialize. CUpti_Profiler_Host_EvaluateToGpuValues_Params  Params for cuptiProfilerHostEvaluateToGpuValues. CUpti_Profiler_Host_GetBaseMetrics_Params  Params for cuptiProfilerHostGetSupportedMetrics. CUpti_Profiler_Host_GetConfigImageSize_Params  Params for cuptiProfilerHostGetConfigImageSize. CUpti_Profiler_Host_GetConfigImage_Params  Params for cuptiProfilerHostGetConfigImage. CUpti_Profiler_Host_GetMaxNumHardwareMetricsPerPass_Params  Params for cuptiProfilerHostGetMaxNumHardwareMetricsPerPass. CUpti_Profiler_Host_GetMetricProperties_Params  Params for cuptiProfilerHostGetMetricProperties. CUpti_Profiler_Host_GetNumOfPasses_Params  Params for cuptiProfilerHostGetNumOfPasses. CUpti_Profiler_Host_GetRangeName_Params  Params for cuptiProfilerHostGetRangeName. CUpti_Profiler_Host_GetSubMetrics_Params  Params for cuptiProfilerHostGetSubMetrics. CUpti_Profiler_Host_GetSupportedChips_Params  Params for cuptiProfilerHostGetSupportedChips. CUpti_Profiler_Host_Initialize_Params  Params for cuptiProfilerHostInitialize. CUpti_Profiler_Initialize_Params  Default parameter for cuptiProfilerInitialize. CUpti_Profiler_IsPassCollected_Params  Params for cuptiProfilerIsPassCollected. CUpti_Profiler_PopRange_Params   CUpti_Profiler_PushRange_Params   CUpti_Profiler_SetConfig_Params  Params for cuptiProfilerSetConfig. CUpti_Profiler_UnsetConfig_Params  Params for cuptiProfilerUnsetConfig. CUpti_RangeProfiler_CounterDataImage_Initialize_Params  Params for cuptiRangeProfilerCounterDataImageInitialize. CUpti_RangeProfiler_CounterData_GetRangeInfo_Params  Params for cuptiRangeProfilerCounterDataGetRangeInfo. CUpti_RangeProfiler_DecodeData_Params  Params for cuptiRangeProfilerDecodeData. CUpti_RangeProfiler_Disable_Params  Params for cuptiRangeProfilerDisable. CUpti_RangeProfiler_Enable_Params  Params for cuptiRangeProfilerEnable. CUpti_RangeProfiler_GetCounterDataInfo_Params  Params for cuptiRangeProfilerGetCounterDataInfo. CUpti_RangeProfiler_GetCounterDataSize_Params  Params for cuptiRangeProfilerGetCounterDataSize. CUpti_RangeProfiler_PopRange_Params  Params for cuptiRangeProfilerPopRange. CUpti_RangeProfiler_PushRange_Params  Params for cuptiRangeProfilerPushRange. CUpti_RangeProfiler_SetConfig_Params  Params for cuptiRangeProfilerSetConfig. CUpti_RangeProfiler_Start_Params  Params for cuptiRangeProfilerStart. CUpti_RangeProfiler_Stop_Params  Params for cuptiRangeProfilerStop. CUpti_ResourceData  Data passed into a resource callback function. CUpti_SassMetricsDisable_Params  Params for cuptiSassMetricsDisable. CUpti_SassMetricsEnable_Params  Params for cuptiSassMetricsEnable. CUpti_SassMetricsFlushData_Params  Params for cuptiSassMetricsFlushData. CUpti_SassMetricsGetDataProperties_Params  Params for cuptiSassMetricsGetDataProperties. CUpti_SassMetricsSetConfig_Params  Params for cuptiSassMetricsSetConfig. CUpti_SassMetricsUnsetConfig_Params  Params for cuptiSassMetricsUnsetConfig. CUpti_SassMetrics_Config   CUpti_SassMetrics_Data   CUpti_SassMetrics_GetMetrics_Params  Params for cuptiSassMetricsGetMetrics. CUpti_SassMetrics_GetNumOfMetrics_Params  Params for cuptiSassMetricsGetNumOfMetrics. CUpti_SassMetrics_GetProperties_Params  Params for cuptiSassMetricsGetProperties. CUpti_SassMetrics_InstanceValue   CUpti_SassMetrics_MetricDetails   CUpti_StateData  Data passed into a State callback function. CUpti_StreamAttrData  Stream attribute data passed into a resource callback function for CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED callback. CUpti_SynchronizeData  Data passed into a synchronize callback function. NV::Cupti::Checkpoint::CUpti_Checkpoint  Configuration and handle for a CUPTI Checkpoint.", "keywords": []}, {"id": 1, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_AUTO_BOOST_INVALID_CLIENT_PID", "display_name": "CUPTI_AUTO_BOOST_INVALID_CLIENT_PID", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_AUTO_BOOST_INVALID_CLIENT_PID", "priority": 1, "content": "CUPTI_AUTO_BOOST_INVALID_CLIENT_PID An invalid/unknown process id.", "keywords": []}, {"id": 2, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_CORRELATION_ID_UNKNOWN", "display_name": "CUPTI_CORRELATION_ID_UNKNOWN", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_CORRELATION_ID_UNKNOWN", "priority": 1, "content": "CUPTI_CORRELATION_ID_UNKNOWN An invalid/unknown correlation ID. A correlation ID of this value indicates that there is no correlation for the activity record.", "keywords": []}, {"id": 3, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_DECOMPRESSED_BYTES_UNKNOWN", "display_name": "CUPTI_DECOMPRESSED_BYTES_UNKNOWN", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_DECOMPRESSED_BYTES_UNKNOWN", "priority": 1, "content": "CUPTI_DECOMPRESSED_BYTES_UNKNOWN An invalid/unknown value for decompressed bytes.", "keywords": []}, {"id": 4, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_FUNCTION_INDEX_ID_INVALID", "display_name": "CUPTI_FUNCTION_INDEX_ID_INVALID", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_FUNCTION_INDEX_ID_INVALID", "priority": 1, "content": "CUPTI_FUNCTION_INDEX_ID_INVALID An invalid function index ID.", "keywords": []}, {"id": 5, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_GRID_ID_UNKNOWN", "display_name": "CUPTI_GRID_ID_UNKNOWN", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_GRID_ID_UNKNOWN", "priority": 1, "content": "CUPTI_GRID_ID_UNKNOWN An invalid/unknown grid ID.", "keywords": []}, {"id": 6, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_MAX_GPUS", "display_name": "CUPTI_MAX_GPUS", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_MAX_GPUS", "priority": 1, "content": "CUPTI_MAX_GPUS", "keywords": []}, {"id": 7, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_MAX_NVLINK_PORTS", "display_name": "CUPTI_MAX_NVLINK_PORTS", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_MAX_NVLINK_PORTS", "priority": 1, "content": "CUPTI_MAX_NVLINK_PORTS Maximum NVLink port numbers.", "keywords": []}, {"id": 8, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_NVLINK_INVALID_PORT", "display_name": "CUPTI_NVLINK_INVALID_PORT", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_NVLINK_INVALID_PORT", "priority": 1, "content": "CUPTI_NVLINK_INVALID_PORT Invalid/unknown NVLink port number.", "keywords": []}, {"id": 9, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_SOURCE_LOCATOR_ID_UNKNOWN", "display_name": "CUPTI_SOURCE_LOCATOR_ID_UNKNOWN", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_SOURCE_LOCATOR_ID_UNKNOWN", "priority": 1, "content": "CUPTI_SOURCE_LOCATOR_ID_UNKNOWN The source-locator ID that indicates an unknown source location. There is not an actual CUpti_ActivitySourceLocator object corresponding to this value.", "keywords": []}, {"id": 10, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_SYNCHRONIZATION_INVALID_VALUE", "display_name": "CUPTI_SYNCHRONIZATION_INVALID_VALUE", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_SYNCHRONIZATION_INVALID_VALUE", "priority": 1, "content": "CUPTI_SYNCHRONIZATION_INVALID_VALUE An invalid/unknown value.", "keywords": []}, {"id": 11, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "c", "name": "CUPTI_TIMESTAMP_UNKNOWN", "display_name": "CUPTI_TIMESTAMP_UNKNOWN", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "c.CUPTI_TIMESTAMP_UNKNOWN", "priority": 1, "content": "CUPTI_TIMESTAMP_UNKNOWN An invalid/unknown timestamp for a start, end, queued, submitted, or completed time.", "keywords": []}, {"id": 12, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute43CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "keywords": []}, {"id": 13, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute44CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT The maximum number of device memory buffers per context. The value is a size_t. For an application with high rate of kernel launches, memcopies and memsets having a bigger pool limit helps in timestamp collection for all these activities at the expense of a larger memory footprint. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE for more details. Setting this value will not modify the number of memory buffers currently stored. Set this value before initializing CUDA to ensure the limit is not exceeded. The default value is 250.", "keywords": []}, {"id": 14, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute52CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE Number of device buffers to pre-allocate for a context during the initialization phase. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE for details. This value must be less than the maximum number of device buffers set using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT Set this value before initializing CUDA or before creating a context to ensure it is considered by the CUPTI. The default value is set to 3 to ping pong between these buffers (if possible).", "keywords": []}, {"id": 15, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute38CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE The device memory size (in bytes) reserved for storing profiling data for concurrent kernels (activity kind CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL ), memcopies and memsets for each buffer on a context. The value is a size_t. There is a limit on how many device buffers can be allocated per context. User can query and set this limit using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT . CUPTI doesn\u2019t pre-allocate all the buffers, it pre-allocates only those many buffers as set by the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE . When all of the data in a buffer is consumed, it is added in the reuse pool, and CUPTI picks a buffer from this pool when a new buffer is needed. Thus memory footprint does not scale with the kernel count. Applications with the high density of kernels, memcopies and memsets might result in having CUPTI to allocate more device buffers. CUPTI allocates another buffer only when it runs out of the buffers in the reuse pool. Since buffer allocation happens in the main application thread, this might result in stalls in the critical path. CUPTI pre-allocates 3 buffers of the same size to mitigate this issue. User can query and set the pre-allocation limit using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE . Having larger buffer size leaves less device memory for the application. Having smaller buffer size increases the risk of dropping timestamps for records if too many kernels or memcopies or memsets are launched at one time. This value only applies to new buffer allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 3200000 (~3MB) which can accommodate profiling data up to 100,000 kernels, memcopies and memsets combined. Note: Starting with the CUDA 12.0 Update 1 release, CUPTI allocates profiling buffer in the device memory by default as this might help in improving the performance of the tracing run. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED for more details. Size of the memory and maximum number of pools are still controlled by the attributes CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE and CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT . Note: The actual amount of device memory per buffer reserved by CUPTI might be larger.", "keywords": []}, {"id": 16, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute42CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP The device memory size (in bytes) reserved for storing profiling data for CDP operations for each buffer on a context. The value is a size_t. Having larger buffer size means less flush operations but consumes more device memory. This value only applies to new allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 8388608 (8MB). Note: The actual amount of device memory per context reserved by CUPTI might be larger.", "keywords": []}, {"id": 17, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS", "display_name": "CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute52CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS The device memory size (in bytes) reserved for storing profiling data for device graph operations for each buffer on a context. The value is a size_t. Having larger buffer size means less flush operations but consumes more device memory. This value only applies to new allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 16777216 (16MB). Note: The actual amount of device memory per context reserved by CUPTI might be larger.", "keywords": []}, {"id": 18, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED", "display_name": "CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute51CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED Allocate page-locked (pinned) host memory for storing profiling data for concurrent kernels, memcopies and memsets for each buffer on a context. The value is a uint8_t. Starting with the CUDA 11.2 release, CUPTI allocates profiling buffer in the pinned host memory by default as this might help in improving the performance of the tracing run. Allocating excessive amounts of pinned memory may degrade system performance, since it reduces the amount of memory available to the system for paging. For this reason user might want to change the location from pinned host memory to device memory by setting value of this attribute to 0. Using page-locked (pinned) host memory buffers is not supported on confidential computing devices. On setting this attribute to 1, CUPTI will return CUPTI_ERROR_NOT_SUPPORTED. The default value is 1.", "keywords": []}, {"id": 19, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER", "display_name": "CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute46CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER Request activity buffers per-thread to store CUPTI activity records in the activity buffer on per-thread basis. The value is a uint8_t. The attribute should be set before registering the buffer callbacks using cuptiActivityRegisterCallbacks API and before any of the CUPTI activity kinds are enabled. This makes sure that all the records are stored in activity buffers allocated per-thread. Changing this attribute in the middle of the profiling session will result in undefined behavior. The default value is 0.", "keywords": []}, {"id": 20, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT", "display_name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute50CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. The maximum number of profiling semaphore pools per context. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE for more details. Set this value before initializing CUDA to ensure the limit is not exceeded. The default value is 250.", "keywords": []}, {"id": 21, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE", "display_name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute49CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. There is a limit on how many semaphore pools can be allocated per context. User can query and set this limit using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT . CUPTI doesn\u2019t pre-allocate all the semaphore pools, it pre-allocates only those many semaphore pools as set by the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE . When all of the data in a semaphore pool is consumed, it is added in the reuse pool, and CUPTI picks a semaphore pool from the reuse pool when a new semaphore pool is needed. Thus memory footprint does not scale with the kernel count. Applications with the high density of kernels might result in having CUPTI to allocate more semaphore pools. CUPTI allocates another semaphore pool only when it runs out of the semaphore pools in the reuse pool. Since semaphore pool allocation happens in the main application thread, this might result in stalls in the critical path. CUPTI pre-allocates 3 semaphore pools of the same size to mitigate this issue. User can query and set the pre-allocation limit using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE . Having larger semaphore pool size leaves less device memory for the application. Having smaller semaphore pool size increases the risk of dropping timestamps for kernel records if too many kernels are issued/launched at one time. This value only applies to new semaphore pool allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 25000 which can accommodate profiling data for upto 25,000 kernels.", "keywords": []}, {"id": 22, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE", "display_name": "CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute58CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. Number of profiling semaphore pools to pre-allocate for a context during the initialization phase. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE for details. This value must be less than the maximum number of profiling semaphore pools set using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT Set this value before initializing CUDA or before creating a context to ensure it is considered by the CUPTI. The default value is set to 3 to ping pong between these pools (if possible).", "keywords": []}, {"id": 23, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER", "display_name": "CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute46CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER The flag to indicate whether user should provide activity buffer of zero value. The value is a uint8_t. If the value of this attribute is non-zero, user should provide a zero value buffer in the CUpti_BuffersCallbackRequestFunc . If the user does not provide a zero value buffer after setting this to non-zero, the activity buffer may contain some uninitialized values when CUPTI returns it in CUpti_BuffersCallbackCompleteFunc If the value of this attribute is zero, CUPTI will initialize the user buffer received in the CUpti_BuffersCallbackRequestFunc to zero before filling it. If the user sets this to zero, a few stalls may appear in critical path because CUPTI will zero out the buffer in the main thread. Set this value before returning from CUpti_BuffersCallbackRequestFunc to ensure it is considered for all the subsequent user buffers. The default value is 0.", "keywords": []}, {"id": 24, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_COMPUTE_API_CUDA", "display_name": "CUPTI_ACTIVITY_COMPUTE_API_CUDA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind31CUPTI_ACTIVITY_COMPUTE_API_CUDAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_CUDA The compute APIs are for CUDA.", "keywords": []}, {"id": 25, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS", "display_name": "CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind35CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS The compute APIs are for CUDA running in MPS (Multi-Process Service) environment.", "keywords": []}, {"id": 26, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "display_name": "CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind36CUPTI_ACTIVITY_COMPUTE_API_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "keywords": []}, {"id": 27, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN", "display_name": "CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind34CUPTI_ACTIVITY_COMPUTE_API_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN The compute API is not known.", "keywords": []}, {"id": 28, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_COOLING", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_COOLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind34CUPTI_ACTIVITY_ENVIRONMENT_COOLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_COOLING The environment data is related to cooling.", "keywords": []}, {"id": 29, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "keywords": []}, {"id": 30, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind41CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "keywords": []}, {"id": 31, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_POWER", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_POWER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_POWERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_POWER The environment data is related to power.", "keywords": []}, {"id": 32, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_SPEED", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_SPEED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_SPEEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_SPEED The environment data is related to speed.", "keywords": []}, {"id": 33, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind38CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE The environment data is related to temperature.", "keywords": []}, {"id": 34, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN", "display_name": "CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind34CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN Unknown data.", "keywords": []}, {"id": 35, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE", "display_name": "CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE Indicates if the activity represents a CUdevice_attribute value or a CUpti_DeviceAttribute value. Valid for CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE.", "keywords": []}, {"id": 36, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS", "display_name": "CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS Indicates the activity represents a device that supports concurrent kernel execution. Valid for CUPTI_ACTIVITY_KIND_DEVICE.", "keywords": []}, {"id": 37, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_FLUSH_FORCED", "display_name": "CUPTI_ACTIVITY_FLAG_FLUSH_FORCED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_FLUSH_FORCEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_FLUSH_FORCED When calling cuptiActivityFlushAll, this flag can be set to force CUPTI to flush all records in the buffer, whether finished or not.", "keywords": []}, {"id": 38, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_FORCE_INT", "display_name": "CUPTI_ACTIVITY_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag29CUPTI_ACTIVITY_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_FORCE_INT", "keywords": []}, {"id": 39, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED", "display_name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED If this bit in flag is set, the load access was cached else it is uncached. Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 40, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD", "display_name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag43CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD If bit in this flag is set, the access was load, else it is a store access. Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 41, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK", "display_name": "CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag48CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK The number of bytes requested by each thread Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 42, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK", "display_name": "CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag42CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK The mask for the instruction class, CUpti_ActivityInstructionClass Valid for CUpti_ActivityInstructionExecution and CUpti_ActivityInstructionCorrelation .", "keywords": []}, {"id": 43, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID", "display_name": "CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID If this bit in flag is set, the source level metric value couldn\u2019t be calculated. This occurs when a value(s) required to calculate the source level metric cannot be evaluated. Valid for CUpti_ActivityInstructionExecution .", "keywords": []}, {"id": 44, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGBE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB Indicates the activity represents a marker that specifies a color in alpha-red-green-blue format. Valid for CUPTI_ACTIVITY_KIND_MARKER_DATA.", "keywords": []}, {"id": 45, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE Indicates the activity represents a marker that does not specify a color. Valid for CUPTI_ACTIVITY_KIND_MARKER_DATA.", "keywords": []}, {"id": 46, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_END", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag30CUPTI_ACTIVITY_FLAG_MARKER_ENDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_END Indicates the activity represents a region end marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 47, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag40CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS Indicates the activity represents an instantaneous marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 48, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_START", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_START", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MARKER_STARTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_START Indicates the activity represents a region start marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 49, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag39CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE Indicates the activity represents an attempt to acquire a user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 50, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag46CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED Indicates the activity represents failure in acquiring the user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 51, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag47CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS Indicates the activity represents success in acquiring the user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 52, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE", "display_name": "CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag39CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE Indicates the activity represents releasing a reservation on user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 53, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC", "display_name": "CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC Indicates the activity represents an asynchronous memcpy operation. Valid for CUPTI_ACTIVITY_KIND_MEMCPY.", "keywords": []}, {"id": 54, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC", "display_name": "CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MEMSET_ASYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC Indicates the activity represents an asynchronous memset operation. Valid for CUPTI_ACTIVITY_KIND_MEMSET.", "keywords": []}, {"id": 55, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED", "display_name": "CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED If this bit in flag is set, the metric value overflowed. Valid for CUpti_ActivityMetric and CUpti_ActivityMetricInstance .", "keywords": []}, {"id": 56, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID", "display_name": "CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag40CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID If this bit in flag is set, the metric value couldn\u2019t be calculated. This occurs when a value(s) required to calculate the metric is missing. Valid for CUpti_ActivityMetric and CUpti_ActivityMetricInstance .", "keywords": []}, {"id": 57, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_NONE", "display_name": "CUPTI_ACTIVITY_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag24CUPTI_ACTIVITY_FLAG_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_NONE Indicates the activity record has no flags.", "keywords": []}, {"id": 58, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD", "display_name": "CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag43CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD If bit in this flag is set, the access was load, else it is a store access. Valid for CUpti_ActivitySharedAccess .", "keywords": []}, {"id": 59, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK", "display_name": "CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag48CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK The number of bytes requested by each thread Valid for CUpti_ActivitySharedAccess .", "keywords": []}, {"id": 60, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU", "display_name": "CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag36CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPUE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU Indicates the activity represents thrashing in CPU. Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING in CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "keywords": []}, {"id": 61, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU", "display_name": "CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPUE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU Indicates the activity represents page throttling in CPU. Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING in CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "keywords": []}, {"id": 62, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER Represents a barrier instruction.", "keywords": []}, {"id": 63, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION Represents a bit conversion operation.", "keywords": []}, {"id": 64, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass41CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT Represents a constant load instruction.", "keywords": []}, {"id": 65, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass45CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOWE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW Represents a control flow instruction.", "keywords": []}, {"id": 66, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16 Represents a 16 bit floating point operation.", "keywords": []}, {"id": 67, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32 Represents a 32 bit floating point operation.", "keywords": []}, {"id": 68, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64 Represents a 64 bit floating point operation.", "keywords": []}, {"id": 69, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC Represents a generic load-store instruction.", "keywords": []}, {"id": 70, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass39CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL Represents a global load-store instruction.", "keywords": []}, {"id": 71, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC Represents a global atomic instruction.", "keywords": []}, {"id": 72, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER Represents an integer operation.", "keywords": []}, {"id": 73, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass59CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION Represents a inter-thread communication instruction.", "keywords": []}, {"id": 74, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "keywords": []}, {"id": 75, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL Represents a local load-store instruction.", "keywords": []}, {"id": 76, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS Represents some miscellaneous instructions which do not fit in the above classification.", "keywords": []}, {"id": 77, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass39CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHAREDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED Represents a shared load-store instruction.", "keywords": []}, {"id": 78, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC Represents a shared atomic instruction.", "keywords": []}, {"id": 79, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE Represents a surface load-store instruction.", "keywords": []}, {"id": 80, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC Represents a surface atomic instruction.", "keywords": []}, {"id": 81, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE Represents a texture load-store instruction.", "keywords": []}, {"id": 82, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM Represents uniform instruction.", "keywords": []}, {"id": 83, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN", "display_name": "CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN The instruction class is not known.", "keywords": []}, {"id": 84, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "display_name": "CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType32CUPTI_ACTIVITY_JIT_ENTRY_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "keywords": []}, {"id": 85, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX", "display_name": "CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType39CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTXE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX NVVM-IR to PTX.", "keywords": []}, {"id": 86, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN", "display_name": "CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType37CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBINE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN PTX to CUBIN.", "keywords": []}, {"id": 87, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType39CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "keywords": []}, {"id": 88, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD", "display_name": "CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType39CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD Loaded from the compute cache.", "keywords": []}, {"id": 89, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE", "display_name": "CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType40CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STOREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE Stored in the compute cache.", "keywords": []}, {"id": 90, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_OPERATION_COMPILE", "display_name": "CUPTI_ACTIVITY_JIT_OPERATION_COMPILE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType36CUPTI_ACTIVITY_JIT_OPERATION_COMPILEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_COMPILE JIT compilation.", "keywords": []}, {"id": 91, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "display_name": "CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType36CUPTI_ACTIVITY_JIT_OPERATION_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "keywords": []}, {"id": 92, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType43CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 93, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_BRANCH", "display_name": "CUPTI_ACTIVITY_KIND_BRANCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_BRANCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_BRANCH Results for source-level branch. The corresponding activity record structure is CUpti_ActivityBranch2 . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 94, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_CDP_KERNEL", "display_name": "CUPTI_ACTIVITY_KIND_CDP_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_CDP_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CDP_KERNEL A CDP (CUDA Dynamic Parallel) kernel executing on the GPU. The corresponding activity record structure is CUpti_ActivityCdpKernel . This activity cannot be directly enabled or disabled. It is enabled and disabled through concurrent kernel activity i.e. _CONCURRENT_KERNEL.", "keywords": []}, {"id": 95, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL", "display_name": "CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind37CUPTI_ACTIVITY_KIND_CONCURRENT_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL A kernel executing on the GPU. This activity kind doesn\u2019t break kernel concurrency. The corresponding activity record structure is CUpti_ActivityKernel9 .", "keywords": []}, {"id": 96, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION", "display_name": "CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind49CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION Tracing new overheads introduced on some hardware due when confidential computing is enabled. The corresponding activity record structure is CUpti_ActivityConfidentialComputeRotation .", "keywords": []}, {"id": 97, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_CONTEXT", "display_name": "CUPTI_ACTIVITY_KIND_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONTEXT Information about a CUDA context. The corresponding activity record structure is CUpti_ActivityContext3 .", "keywords": []}, {"id": 98, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_COUNT", "display_name": "CUPTI_ACTIVITY_KIND_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind25CUPTI_ACTIVITY_KIND_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_COUNT Count of supported activity kinds.", "keywords": []}, {"id": 99, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_CUDA_EVENT", "display_name": "CUPTI_ACTIVITY_KIND_CUDA_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_CUDA_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CUDA_EVENT Information about a CUDA event (cudaEvent). The corresponding activity record structure is CUpti_ActivityCudaEvent2 .", "keywords": []}, {"id": 100, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_DEVICE", "display_name": "CUPTI_ACTIVITY_KIND_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE Information about a CUDA device. The corresponding activity record structure is CUpti_ActivityDevice5 .", "keywords": []}, {"id": 101, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE", "display_name": "CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind36CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE A device attribute value. The corresponding activity record structure is CUpti_ActivityDeviceAttribute . This activity cannot be directly enabled or disabled. Information collected using attributes CUpti_DeviceAttribute or CUdevice_attribute can be stored in the corresponding activity record.", "keywords": []}, {"id": 102, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE", "display_name": "CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind38CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE This activity can not be directly enabled or disabled. It is enabled when CUPTI_ACTIVITY_KIND_GRAPH_TRACE is enabled and device graph trace is enabled through API cuptiActivityEnableDeviceGraph() . The corresponding activity record structure is CUpti_ActivityDeviceGraphTrace .", "keywords": []}, {"id": 103, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_DRIVER", "display_name": "CUPTI_ACTIVITY_KIND_DRIVER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_DRIVERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DRIVER A CUDA driver API function execution. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 104, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_ENVIRONMENT", "display_name": "CUPTI_ACTIVITY_KIND_ENVIRONMENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_ENVIRONMENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_ENVIRONMENT Environment activity records indicating power, clock, thermal, etc. levels of the GPU. The corresponding activity record structure is CUpti_ActivityEnvironment .", "keywords": []}, {"id": 105, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_EVENT", "display_name": "CUPTI_ACTIVITY_KIND_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind25CUPTI_ACTIVITY_KIND_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EVENT A performance counter (aka event) value. The corresponding activity record structure is CUpti_ActivityEvent . This activity cannot be directly enabled or disabled. Information collected using the Event API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 106, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_EVENT_INSTANCE", "display_name": "CUPTI_ACTIVITY_KIND_EVENT_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_EVENT_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EVENT_INSTANCE An performance counter value associated with a specific event domain instance. The corresponding activity record structure is CUpti_ActivityEventInstance . This activity cannot be directly enabled or disabled. Information collected using the Event API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 107, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION", "display_name": "CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind40CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION Records for correlation of different programming APIs. The corresponding activity record structure is CUpti_ActivityExternalCorrelation .", "keywords": []}, {"id": 108, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind29CUPTI_ACTIVITY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_FORCE_INT", "keywords": []}, {"id": 109, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_FUNCTION", "display_name": "CUPTI_ACTIVITY_KIND_FUNCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind28CUPTI_ACTIVITY_KIND_FUNCTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_FUNCTION Device global/function record. The corresponding activity record structure is CUpti_ActivityFunction .", "keywords": []}, {"id": 110, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS", "display_name": "CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_GLOBAL_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS Results for source-level global access. The corresponding activity record structure is CUpti_ActivityGlobalAccess3 . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 111, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_GRAPH_TRACE", "display_name": "CUPTI_ACTIVITY_KIND_GRAPH_TRACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_GRAPH_TRACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_GRAPH_TRACE Activity record for graph-level information. The corresponding activity record structure is CUpti_ActivityGraphTrace2 .", "keywords": []}, {"id": 112, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT", "display_name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind39CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT Instantaneous Event information. The corresponding activity record structure is CUpti_ActivityInstantaneousEvent . This activity can not be directly enabled or disabled. Information collected using the Event API can be stored in the corresponding activity record.", "keywords": []}, {"id": 113, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE", "display_name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind48CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE Instantaneous Event information for a specific event domain instance. The corresponding activity record structure is CUpti_ActivityInstantaneousEventInstance . This activity can not be directly enabled or disabled. Information collected using the Event API can be stored in the corresponding activity record.", "keywords": []}, {"id": 114, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC", "display_name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind40CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC Instantaneous Metric information The corresponding activity record structure is CUpti_ActivityInstantaneousMetric . This activity cannot be directly enabled or disabled. Information collected using the Metric API can be stored in the corresponding activity record.", "keywords": []}, {"id": 115, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE", "display_name": "CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind49CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE Instantaneous Metric information for a specific metric domain instance. The corresponding activity record structure is CUpti_ActivityInstantaneousMetricInstance . This activity cannot be directly enabled or disabled. Information collected using the Metric API can be stored in the corresponding activity record.", "keywords": []}, {"id": 116, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION", "display_name": "CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind43CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION SASS/Source line-by-line correlation record. This will generate sass/source correlation for functions that have source level analysis or pc sampling results. The records will be generated only when either of source level analysis or pc sampling activity is enabled. The corresponding activity record structure is CUpti_ActivityInstructionCorrelation . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 117, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION", "display_name": "CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind41CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION Results for source-level instruction execution. The corresponding activity record structure is CUpti_ActivityInstructionExecution . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 118, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API", "display_name": "CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind39CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_APIE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API A CUDA driver kernel launch occurring outside of any public API function execution. Tools can handle these like records for driver API launch functions, although the cbid field is not used here. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 119, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_INVALID", "display_name": "CUPTI_ACTIVITY_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INVALID The activity record is invalid.", "keywords": []}, {"id": 120, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_JIT", "display_name": "CUPTI_ACTIVITY_KIND_JIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind23CUPTI_ACTIVITY_KIND_JITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_JIT JIT (Just-in-time) operation tracking. The corresponding activity record structure is CUpti_ActivityJit .", "keywords": []}, {"id": 121, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_KERNEL", "display_name": "CUPTI_ACTIVITY_KIND_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_KERNEL A kernel executing on the GPU. This activity kind may significantly change the overall performance characteristics of the application because all kernel executions are serialized on the GPU. Other activity kind for kernel CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL doesn\u2019t break kernel concurrency. The corresponding activity record structure is CUpti_ActivityKernel9 .", "keywords": []}, {"id": 122, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MARKER", "display_name": "CUPTI_ACTIVITY_KIND_MARKER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MARKERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MARKER Instantaneous, start, or end NVTX marker. The corresponding activity record structure is CUpti_ActivityMarker2 .", "keywords": []}, {"id": 123, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MARKER_DATA", "display_name": "CUPTI_ACTIVITY_KIND_MARKER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_MARKER_DATAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MARKER_DATA Extended, optional, data about a NVTX marker. User must enable CUPTI_ACTIVITY_KIND_MARKER as well to get records for marker data. The corresponding activity record structure is CUpti_ActivityMarkerData .", "keywords": []}, {"id": 124, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMCPY", "display_name": "CUPTI_ACTIVITY_KIND_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMCPYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMCPY A host&lt;-&gt;host, host&lt;-&gt;device, or device&lt;-&gt;device memory copy. For peer to peer memory copy, use the kind CUPTI_ACTIVITY_KIND_MEMCPY2. The corresponding activity record structure is CUpti_ActivityMemcpy6 .", "keywords": []}, {"id": 125, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMCPY2", "display_name": "CUPTI_ACTIVITY_KIND_MEMCPY2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_MEMCPY2E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMCPY2 A peer to peer memory copy. The corresponding activity record structure is CUpti_ActivityMemcpyPtoP4 .", "keywords": []}, {"id": 126, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMORY", "display_name": "CUPTI_ACTIVITY_KIND_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY Memory activity tracking allocation and freeing of the memory The corresponding activity record structure is CUpti_ActivityMemory .", "keywords": []}, {"id": 127, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMORY2", "display_name": "CUPTI_ACTIVITY_KIND_MEMORY2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_MEMORY2E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY2 Memory activity tracking allocation and freeing of the memory The corresponding activity record structure is CUpti_ActivityMemory4 .", "keywords": []}, {"id": 128, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMORY_POOL", "display_name": "CUPTI_ACTIVITY_KIND_MEMORY_POOL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_MEMORY_POOLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY_POOL Memory pool activity tracking creation, destruction and trimming of the memory pool. The corresponding activity record structure is CUpti_ActivityMemoryPool2 .", "keywords": []}, {"id": 129, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEMSET", "display_name": "CUPTI_ACTIVITY_KIND_MEMSET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMSETE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMSET A memory set executing on the GPU. The corresponding activity record structure is CUpti_ActivityMemset4 .", "keywords": []}, {"id": 130, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS", "display_name": "CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_MEM_DECOMPRESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS Tracing batches of copies that are to be decompressed. The corresponding activity record structure is CUpti_ActivityMemDecompress .", "keywords": []}, {"id": 131, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_METRIC", "display_name": "CUPTI_ACTIVITY_KIND_METRIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_METRICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_METRIC A performance metric value. The corresponding activity record structure is CUpti_ActivityMetric . This activity cannot be directly enabled or disabled. Information collected using the Metric API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 132, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_METRIC_INSTANCE", "display_name": "CUPTI_ACTIVITY_KIND_METRIC_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind35CUPTI_ACTIVITY_KIND_METRIC_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_METRIC_INSTANCE A performance metric value associated with a specific metric domain instance. The corresponding activity record structure is CUpti_ActivityMetricInstance . This activity cannot be directly enabled or disabled. Information collected using the Metric API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 133, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_MODULE", "display_name": "CUPTI_ACTIVITY_KIND_MODULE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MODULEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MODULE CUDA Module record. The corresponding activity record structure is CUpti_ActivityModule . This activity cannot be directly enabled or disabled. Information collected using the module callback can be be stored in the corresponding activity record.", "keywords": []}, {"id": 134, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_NAME", "display_name": "CUPTI_ACTIVITY_KIND_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind24CUPTI_ACTIVITY_KIND_NAMEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_NAME Resource naming done via NVTX APIs for thread, device, context, etc. The corresponding activity record structure is CUpti_ActivityName .", "keywords": []}, {"id": 135, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_NVLINK", "display_name": "CUPTI_ACTIVITY_KIND_NVLINK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_NVLINKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_NVLINK NVLink topology information. The corresponding activity record structure is CUpti_ActivityNvLink4 .", "keywords": []}, {"id": 136, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_OPENACC_DATA", "display_name": "CUPTI_ACTIVITY_KIND_OPENACC_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind32CUPTI_ACTIVITY_KIND_OPENACC_DATAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_DATA OpenACC data events. The corresponding activity record structure is CUpti_ActivityOpenAccData .", "keywords": []}, {"id": 137, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH", "display_name": "CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_OPENACC_LAUNCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH OpenACC launch events. The corresponding activity record structure is CUpti_ActivityOpenAccLaunch .", "keywords": []}, {"id": 138, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_OPENACC_OTHER", "display_name": "CUPTI_ACTIVITY_KIND_OPENACC_OTHER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_OPENACC_OTHERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_OTHER OpenACC other events. The corresponding activity record structure is CUpti_ActivityOpenAccOther .", "keywords": []}, {"id": 139, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_OPENMP", "display_name": "CUPTI_ACTIVITY_KIND_OPENMP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_OPENMPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENMP OpenMP parallel events. The corresponding activity record structure is CUpti_ActivityOpenMp .", "keywords": []}, {"id": 140, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_OVERHEAD", "display_name": "CUPTI_ACTIVITY_KIND_OVERHEAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind28CUPTI_ACTIVITY_KIND_OVERHEADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OVERHEAD Overhead added by CUPTI, Compiler, CUDA driver etc. The corresponding activity record structure is CUpti_ActivityOverhead3 .", "keywords": []}, {"id": 141, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_PCIE", "display_name": "CUPTI_ACTIVITY_KIND_PCIE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind24CUPTI_ACTIVITY_KIND_PCIEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PCIE PCI devices information used for PCI topology. The corresponding activity record structure is CUpti_ActivityPcie .", "keywords": []}, {"id": 142, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_PC_SAMPLING", "display_name": "CUPTI_ACTIVITY_KIND_PC_SAMPLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_PC_SAMPLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PC_SAMPLING PC sampling information for kernels. This will serialize kernels. The corresponding activity record structure is CUpti_ActivityPCSampling3 . In CUDA 12.5, this kind is deprecated for Volta and later GPU architectures in favor of PC Sampling APIs from the header cupti_pcsampling.h which allows concurrent kernel execution.", "keywords": []}, {"id": 143, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO", "display_name": "CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind43CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFOE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO Summary information about PC sampling records. The corresponding activity record structure is CUpti_ActivityPCSamplingRecordInfo . In CUDA 12.5, this kind is deprecated for Volta and later GPU architectures in favor of PC Sampling APIs from the header cupti_pcsampling.h .", "keywords": []}, {"id": 144, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_PREEMPTION", "display_name": "CUPTI_ACTIVITY_KIND_PREEMPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_PREEMPTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PREEMPTION Preemption activity record indicating a preemption of a CDP (CUDA Dynamic Parallel) kernel executing on the GPU. The corresponding activity record structure is CUpti_ActivityPreemption .", "keywords": []}, {"id": 145, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_RUNTIME", "display_name": "CUPTI_ACTIVITY_KIND_RUNTIME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_RUNTIMEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_RUNTIME A CUDA runtime API function execution. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 146, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_SHARED_ACCESS", "display_name": "CUPTI_ACTIVITY_KIND_SHARED_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_SHARED_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SHARED_ACCESS Results for source-level shared access. The corresponding activity record structure is CUpti_ActivitySharedAccess . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 147, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR", "display_name": "CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_SOURCE_LOCATORE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR Source information about source level result. The corresponding activity record structure is CUpti_ActivitySourceLocator . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 148, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_STREAM", "display_name": "CUPTI_ACTIVITY_KIND_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_STREAME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_STREAM Information about a CUDA stream. The corresponding activity record structure is CUpti_ActivityStream .", "keywords": []}, {"id": 149, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_SYNCHRONIZATION", "display_name": "CUPTI_ACTIVITY_KIND_SYNCHRONIZATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind35CUPTI_ACTIVITY_KIND_SYNCHRONIZATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SYNCHRONIZATION Records for CUDA synchronization primitives. The corresponding activity record structure is CUpti_ActivitySynchronization2 .", "keywords": []}, {"id": 150, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "display_name": "CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind42CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER Unified Memory counter record. The corresponding activity record structure is CUpti_ActivityUnifiedMemoryCounter3 .", "keywords": []}, {"id": 151, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST", "display_name": "CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType42CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLISTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST The kernel was launched as a CBL commandlist.", "keywords": []}, {"id": 152, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE", "display_name": "CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType51CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE The kernel was launched via API cudaLaunchCooperativeKernelMultiDevice() or cuLaunchCooperativeKernelMultiDevice()", "keywords": []}, {"id": 153, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE", "display_name": "CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType52CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE The kernel was launched via API cudaLaunchCooperativeKernel() or cuLaunchCooperativeKernel()", "keywords": []}, {"id": 154, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR", "display_name": "CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType34CUPTI_ACTIVITY_LAUNCH_TYPE_REGULARE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR The kernel was launched via a regular kernel call.", "keywords": []}, {"id": 155, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOA", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOA A device array to device array memory copy.", "keywords": []}, {"id": 156, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOD", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOD A device array to device memory copy.", "keywords": []}, {"id": 157, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOH", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_ATOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOH A device array to host memory copy.", "keywords": []}, {"id": 158, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOA", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOA A device to device array memory copy.", "keywords": []}, {"id": 159, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOD", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOD A device to device memory copy on the same device.", "keywords": []}, {"id": 160, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOH", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_DTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOH A device to host memory copy.", "keywords": []}, {"id": 161, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind36CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "keywords": []}, {"id": 162, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOA", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOA A host to device array memory copy.", "keywords": []}, {"id": 163, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOD", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOD A host to device memory copy.", "keywords": []}, {"id": 164, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOH", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_HTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOH A host to host memory copy.", "keywords": []}, {"id": 165, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_PTOP", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_PTOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_PTOPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_PTOP A peer to peer memory copy across different devices.", "keywords": []}, {"id": 166, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN", "display_name": "CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind34CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN The memory copy kind is not known.", "keywords": []}, {"id": 167, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_ARRAY", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_ARRAY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind32CUPTI_ACTIVITY_MEMORY_KIND_ARRAYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_ARRAY The memory is an array.", "keywords": []}, {"id": 168, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_DEVICE", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind33CUPTI_ACTIVITY_MEMORY_KIND_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE The memory is on the device.", "keywords": []}, {"id": 169, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind40CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC The memory is device static.", "keywords": []}, {"id": 170, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind36CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "keywords": []}, {"id": 171, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_MANAGED", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_MANAGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind34CUPTI_ACTIVITY_MEMORY_KIND_MANAGEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED The memory is managed.", "keywords": []}, {"id": 172, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind41CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC The memory is managed static.", "keywords": []}, {"id": 173, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind35CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE The memory is pageable.", "keywords": []}, {"id": 174, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_PINNED", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind33CUPTI_ACTIVITY_MEMORY_KIND_PINNEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_PINNED The memory is pinned.", "keywords": []}, {"id": 175, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN", "display_name": "CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind34CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN The memory kind is unknown.", "keywords": []}, {"id": 176, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION", "display_name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType47CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION Memory is allocated.", "keywords": []}, {"id": 177, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType46CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 178, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID", "display_name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType44CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 179, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE", "display_name": "CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType44CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE Memory is released.", "keywords": []}, {"id": 180, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED Memory pool is created.", "keywords": []}, {"id": 181, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType51CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED Memory pool is destroyed.", "keywords": []}, {"id": 182, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType51CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 183, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 184, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED Memory pool is trimmed.", "keywords": []}, {"id": 185, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType41CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "keywords": []}, {"id": 186, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType40CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED Memory pool is imported by the process.", "keywords": []}, {"id": 187, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType39CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 188, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL", "display_name": "CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType37CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL Memory pool is local to the process.", "keywords": []}, {"id": 189, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_CONTEXT", "display_name": "CUPTI_ACTIVITY_OBJECT_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_CONTEXT A context.", "keywords": []}, {"id": 190, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_DEVICE", "display_name": "CUPTI_ACTIVITY_OBJECT_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_DEVICE A device.", "keywords": []}, {"id": 191, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_FORCE_INT", "display_name": "CUPTI_ACTIVITY_OBJECT_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind31CUPTI_ACTIVITY_OBJECT_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_FORCE_INT", "keywords": []}, {"id": 192, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_PROCESS", "display_name": "CUPTI_ACTIVITY_OBJECT_PROCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_PROCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_PROCESS A process.", "keywords": []}, {"id": 193, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_STREAM", "display_name": "CUPTI_ACTIVITY_OBJECT_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_STREAME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_STREAM A stream.", "keywords": []}, {"id": 194, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_THREAD", "display_name": "CUPTI_ACTIVITY_OBJECT_THREAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_THREADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_THREAD A thread.", "keywords": []}, {"id": 195, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OBJECT_UNKNOWN", "display_name": "CUPTI_ACTIVITY_OBJECT_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_UNKNOWN The object kind is not known.", "keywords": []}, {"id": 196, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST", "display_name": "CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind47CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUESTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST Overhead due to activity buffer request.", "keywords": []}, {"id": 197, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL", "display_name": "CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind43CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL Overhead due to lack of command buffer space. Refer CUpti_ActivityOverheadCommandBufferFullData for more details.", "keywords": []}, {"id": 198, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH", "display_name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind42CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH Activity buffer flush overhead.", "keywords": []}, {"id": 199, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION", "display_name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind45CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION CUPTI instrumentation overhead.", "keywords": []}, {"id": 200, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE", "display_name": "CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind38CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE CUPTI resource creation and destruction overhead.", "keywords": []}, {"id": 201, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER", "display_name": "CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind39CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER Compiler overhead.", "keywords": []}, {"id": 202, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "display_name": "CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind33CUPTI_ACTIVITY_OVERHEAD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "keywords": []}, {"id": 203, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING", "display_name": "CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind45CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING Lazy function loading overhead.", "keywords": []}, {"id": 204, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING", "display_name": "CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind56CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING CUDA Runtime triggered module loading overhead.", "keywords": []}, {"id": 205, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_UNKNOWN", "display_name": "CUPTI_ACTIVITY_OVERHEAD_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind31CUPTI_ACTIVITY_OVERHEAD_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_UNKNOWN The overhead kind is not known.", "keywords": []}, {"id": 206, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT", "display_name": "CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind41CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT Overhead due to UVM activity initialization.", "keywords": []}, {"id": 207, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "display_name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig56CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "keywords": []}, {"id": 208, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED", "display_name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig60CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED Partitioned global cache not supported.", "keywords": []}, {"id": 209, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF", "display_name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig50CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFFE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF Partitioned global cache config off.", "keywords": []}, {"id": 210, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON", "display_name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig49CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON Partitioned global cache config on.", "keywords": []}, {"id": 211, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN", "display_name": "CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig54CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN Partitioned global cache config unknown.", "keywords": []}, {"id": 212, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod43CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "keywords": []}, {"id": 213, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod38CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH Sampling period in higher range.", "keywords": []}, {"id": 214, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod41CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID The PC sampling period is not set.", "keywords": []}, {"id": 215, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOWE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW Sampling period in lower range.", "keywords": []}, {"id": 216, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAXE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX Maximum sampling period available on the device.", "keywords": []}, {"id": 217, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID Medium sampling period.", "keywords": []}, {"id": 218, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MINE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN Minimum sampling period available on the device.", "keywords": []}, {"id": 219, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason59CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY Warp is blocked waiting for constant memory and immediate memory access to complete.", "keywords": []}, {"id": 220, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason48CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY Instruction is waiting on an arithmetic dependency.", "keywords": []}, {"id": 221, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason42CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "keywords": []}, {"id": 222, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason43CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH Warp is blocked because next instruction is not yet available, because of instruction cache miss, or because of branching effects.", "keywords": []}, {"id": 223, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason40CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID Invalid reason.", "keywords": []}, {"id": 224, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason50CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY Warp is blocked because it is waiting for a memory access to complete.", "keywords": []}, {"id": 225, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason48CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE Warp is blocked because there are too many pending memory operations. In Kepler architecture it often indicates high number of memory replays.", "keywords": []}, {"id": 226, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason37CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE No stall, instruction is selected for issue.", "keywords": []}, {"id": 227, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason45CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED Warp was ready to issue, but some other warp issued instead.", "keywords": []}, {"id": 228, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason38CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER Miscellaneous reasons.", "keywords": []}, {"id": 229, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason42CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY Compute operation cannot be performed due to the required resources not being available.", "keywords": []}, {"id": 230, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason41CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING Sleeping.", "keywords": []}, {"id": 231, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason37CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC Warp is blocked as it is waiting at __syncthreads() or at memory barrier.", "keywords": []}, {"id": 232, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE", "display_name": "CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason40CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE Texture sub-system is fully utilized or has too many outstanding requests.", "keywords": []}, {"id": 233, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind40CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "keywords": []}, {"id": 234, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE", "display_name": "CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind38CUPTI_ACTIVITY_PREEMPTION_KIND_RESTOREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE Preemption to restore CDP block.", "keywords": []}, {"id": 235, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE", "display_name": "CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind35CUPTI_ACTIVITY_PREEMPTION_KIND_SAVEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE Preemption to save CDP block.", "keywords": []}, {"id": 236, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN", "display_name": "CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind38CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN The preemption kind is not known.", "keywords": []}, {"id": 237, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag41CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT Default stream.", "keywords": []}, {"id": 238, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag43CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "keywords": []}, {"id": 239, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag46CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING Non-blocking stream.", "keywords": []}, {"id": 240, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag38CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL Null stream.", "keywords": []}, {"id": 241, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag41CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN Unknown data.", "keywords": []}, {"id": 242, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_STREAM_CREATE_MASK", "display_name": "CUPTI_ACTIVITY_STREAM_CREATE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag33CUPTI_ACTIVITY_STREAM_CREATE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_MASK Stream create Mask.", "keywords": []}, {"id": 243, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType55CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE Context synchronize API.", "keywords": []}, {"id": 244, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType53CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE Event synchronize API.", "keywords": []}, {"id": 245, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType45CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "keywords": []}, {"id": 246, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType54CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE Stream synchronize API.", "keywords": []}, {"id": 247, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType53CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT Stream wait event API.", "keywords": []}, {"id": 248, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN", "display_name": "CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType43CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN Unknown data.", "keywords": []}, {"id": 249, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT", "display_name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType37CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT Default type Windows uses API GetCurrentThreadId() Linux/Mac/Android/QNX use POSIX pthread API pthread_self()", "keywords": []}, {"id": 250, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType39CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "keywords": []}, {"id": 251, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE", "display_name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType34CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE Add new enums before this field.", "keywords": []}, {"id": 252, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM", "display_name": "CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType36CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM This type is based on the system API available on the underlying platform and thread-id obtained is supposed to be unique for the process lifetime. Windows uses API GetCurrentThreadId() Linux uses syscall SYS_gettid Mac uses syscall SYS_thread_selfid Android/QNX use gettid()", "keywords": []}, {"id": 253, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType48CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC The page fault was triggered by atomic memory instruction.", "keywords": []}, {"id": 254, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType50CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH The page fault was triggered by memory prefetch operation.", "keywords": []}, {"id": 255, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType46CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ The page fault was triggered by read memory instruction.", "keywords": []}, {"id": 256, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType49CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN The unified memory access type is not known.", "keywords": []}, {"id": 257, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType47CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE The page fault was triggered by write memory instruction.", "keywords": []}, {"id": 258, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD Number of bytes transferred from one device to another device. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 259, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH Number of bytes transferred from device to host.", "keywords": []}, {"id": 260, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD Number of bytes transferred from host to device.", "keywords": []}, {"id": 261, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind48CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "keywords": []}, {"id": 262, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind63CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT Number of CPU page faults, this is only supported on 64 bit Linux and Mac platforms.", "keywords": []}, {"id": 263, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind52CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "keywords": []}, {"id": 264, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind57CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT Number of GPU page faults, this is only supported on devices with compute capability 6.0 and higher and 64 bit Linux platforms.", "keywords": []}, {"id": 265, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP In case throttling does not help, the driver tries to pin the memory to a processor for a specific period of time. One of the contending processors will have slow access to the memory, while the other will have fast access. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 266, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind52CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING Thrashing occurs when data is frequently accessed by multiple processors and has to be constantly migrated around to achieve data locality. In this case the overhead of migration may exceed the benefits of locality. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 267, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING Throttling is a prevention technique used by the driver to avoid further thrashing. Here, the driver doesn\u2019t service the fault for one of the contending processors for a specific period of time, so that the other processor can run at full-speed. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 268, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind50CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN The unified memory counter kind is not known.", "keywords": []}, {"id": 269, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope49CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "keywords": []}, {"id": 270, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "keywords": []}, {"id": 271, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope63CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICESE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES Collect unified memory counter for single process across all devices.", "keywords": []}, {"id": 272, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope65CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE Collect unified memory counter for single process on one device.", "keywords": []}, {"id": 273, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope51CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN The unified memory counter scope is not known.", "keywords": []}, {"id": 274, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause61CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS The unified memory migrated to another processor because of access counter notifications. Only frequently accessed pages are migrated between CPU and GPU, or between peer GPUs.", "keywords": []}, {"id": 275, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause55CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE The unified memory migrated to guarantee data coherence e.g. CPU/GPU faults on Pascal+ and kernel launch on pre-Pascal GPUs", "keywords": []}, {"id": 276, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION The unified memory migrated to the CPU because it was evicted to make room for another block of memory on the GPU.", "keywords": []}, {"id": 277, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH The unified memory was speculatively migrated by the UVM driver before being accessed by the destination processor to improve performance.", "keywords": []}, {"id": 278, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause53CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN The unified memory migration cause is not known.", "keywords": []}, {"id": 279, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause50CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER The unified memory migrated due to an explicit call from the user e.g. cudaMemPrefetchAsync", "keywords": []}, {"id": 280, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause56CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE Mapping to remote memory was added to maintain data coherence.", "keywords": []}, {"id": 281, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause55CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION Mapping to remote memory was added after the memory was evicted to make room for another block of memory on the GPU.", "keywords": []}, {"id": 282, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause60CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY Mapping to remote memory was added because there is no more memory available on the processor and eviction was not possible.", "keywords": []}, {"id": 283, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause53CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY Mapping to remote memory was added to enforce the hints specified by the programmer or by performance heuristics of the UVM driver.", "keywords": []}, {"id": 284, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause56CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING Mapping to remote memory was added to prevent further thrashing.", "keywords": []}, {"id": 285, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN", "display_name": "CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN The cause of mapping to remote memory was unknown.", "keywords": []}, {"id": 286, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY", "display_name": "CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType31CUPTI_CHANNEL_TYPE_ASYNC_MEMCPYE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY Channel is used by an asynchronous copy engine For confidential compute configurations, work launch and completion are done using the copy engines.", "keywords": []}, {"id": 287, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CHANNEL_TYPE_COMPUTE", "display_name": "CUPTI_CHANNEL_TYPE_COMPUTE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType26CUPTI_CHANNEL_TYPE_COMPUTEE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_COMPUTE Channel is used for standard work launch and tracking.", "keywords": []}, {"id": 288, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CHANNEL_TYPE_DECOMP", "display_name": "CUPTI_CHANNEL_TYPE_DECOMP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType25CUPTI_CHANNEL_TYPE_DECOMPE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_DECOMP Channel is used for memory decompression operations.", "keywords": []}, {"id": 289, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CHANNEL_TYPE_FORCE_INT", "display_name": "CUPTI_CHANNEL_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType28CUPTI_CHANNEL_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_FORCE_INT", "keywords": []}, {"id": 290, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CHANNEL_TYPE_INVALID", "display_name": "CUPTI_CHANNEL_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType26CUPTI_CHANNEL_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_INVALID", "keywords": []}, {"id": 291, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason38CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "keywords": []}, {"id": 292, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason37CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLEE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE Nothing is running on the GPU and the clocks are dropping to idle state.", "keywords": []}, {"id": 293, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason40CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWNE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN Hardware slowdown to reduce the clock by a factor of two or more is engaged. This is an indicator of one of the following: 1) Temperature is too high, 2) External power brake assertion is being triggered (e.g. by the system power supply), 3) Change in power state.", "keywords": []}, {"id": 294, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_NONE", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason33CUPTI_CLOCKS_THROTTLE_REASON_NONEE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_NONE No clock throttling.", "keywords": []}, {"id": 295, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason41CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAPE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP A software power scaling algorithm is reducing the clocks below requested clocks.", "keywords": []}, {"id": 296, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason36CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN Some unspecified factor is reducing the clocks.", "keywords": []}, {"id": 297, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason40CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTEDE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED Throttle reason is not supported for this GPU.", "keywords": []}, {"id": 298, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS", "display_name": "CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason48CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKSE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS The GPU clocks are limited by a user specified limit.", "keywords": []}, {"id": 299, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "display_name": "CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType47CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "keywords": []}, {"id": 300, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "display_name": "CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType49CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENTE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "keywords": []}, {"id": 301, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED", "display_name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType55CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED This channel has been blocked from accepting new CUDA work so a key rotation can be done.", "keywords": []}, {"id": 302, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED", "display_name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType55CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED This channel remains blocked and all queued CUDA work has completed. Other clients or channels may cause delays in starting the key rotation.", "keywords": []}, {"id": 303, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED", "display_name": "CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType57CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED Key rotations have completed and this channel is unblocked.", "keywords": []}, {"id": 304, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONTEXT_CIG_MODE_CIG", "display_name": "CUPTI_CONTEXT_CIG_MODE_CIG", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode26CUPTI_CONTEXT_CIG_MODE_CIGE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_CIG CIG mode.", "keywords": []}, {"id": 305, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK", "display_name": "CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode35CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACKE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK CIG fallback mode.", "keywords": []}, {"id": 306, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "display_name": "CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode32CUPTI_CONTEXT_CIG_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "keywords": []}, {"id": 307, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_CONTEXT_CIG_MODE_NONE", "display_name": "CUPTI_CONTEXT_CIG_MODE_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode27CUPTI_CONTEXT_CIG_MODE_NONEE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_NONE Regular (non-CIG) mode.", "keywords": []}, {"id": 308, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "display_name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode46CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGETE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "keywords": []}, {"id": 309, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "display_name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode57CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLINGE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "keywords": []}, {"id": 310, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "display_name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode38CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "keywords": []}, {"id": 311, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "display_name": "CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode35CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAILE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "keywords": []}, {"id": 312, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "display_name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode42CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "keywords": []}, {"id": 313, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE", "display_name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode37CUPTI_DEVICE_VIRTUALIZATION_MODE_NONEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE No virtualization mode is associated with the device i.e. it\u2019s a baremetal GPU", "keywords": []}, {"id": 314, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH", "display_name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode45CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH The device is associated with the pass-through GPU. In this mode, an entire physical GPU is directly assigned to one virtual machine (VM).", "keywords": []}, {"id": 315, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU", "display_name": "CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode44CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPUE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU The device is associated with the virtual GPU (vGPU). In this mode multiple virtual machines (VMs) have simultaneous, direct access to a single physical GPU.", "keywords": []}, {"id": 316, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEV_TYPE_FORCE_INT", "display_name": "CUPTI_DEV_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType24CUPTI_DEV_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_FORCE_INT", "keywords": []}, {"id": 317, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEV_TYPE_GPU", "display_name": "CUPTI_DEV_TYPE_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType18CUPTI_DEV_TYPE_GPUE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_GPU The device type is GPU.", "keywords": []}, {"id": 318, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEV_TYPE_INVALID", "display_name": "CUPTI_DEV_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType22CUPTI_DEV_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_INVALID", "keywords": []}, {"id": 319, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_DEV_TYPE_NPU", "display_name": "CUPTI_DEV_TYPE_NPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType18CUPTI_DEV_TYPE_NPUE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_NPU The device type is NVLink processing unit in CPU.", "keywords": []}, {"id": 320, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0 The external API is custom0.", "keywords": []}, {"id": 321, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1 The external API is custom1.", "keywords": []}, {"id": 322, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2 The external API is custom2.", "keywords": []}, {"id": 323, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind41CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "keywords": []}, {"id": 324, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "keywords": []}, {"id": 325, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_OPENACCE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC The external API is OpenACC.", "keywords": []}, {"id": 326, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_SIZE", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind36CUPTI_EXTERNAL_CORRELATION_KIND_SIZEE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_SIZE Add new kinds before this line.", "keywords": []}, {"id": 327, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN", "display_name": "CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN The external API is unknown to CUPTI.", "keywords": []}, {"id": 328, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_FUNC_SHMEM_LIMIT_DEFAULT", "display_name": "CUPTI_FUNC_SHMEM_LIMIT_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig30CUPTI_FUNC_SHMEM_LIMIT_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_DEFAULT The shared memory limit config is default.", "keywords": []}, {"id": 329, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "display_name": "CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig32CUPTI_FUNC_SHMEM_LIMIT_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "keywords": []}, {"id": 330, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_FUNC_SHMEM_LIMIT_OPTIN", "display_name": "CUPTI_FUNC_SHMEM_LIMIT_OPTIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig28CUPTI_FUNC_SHMEM_LIMIT_OPTINE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_OPTIN User has opted for a higher dynamic shared memory limit using function attribute \u2018cudaFuncAttributeMaxDynamicSharedMemorySize\u2019 for runtime API or CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES for driver API.", "keywords": []}, {"id": 331, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_FORCE_INT", "display_name": "CUPTI_LINK_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag25CUPTI_LINK_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_FORCE_INT", "keywords": []}, {"id": 332, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_INVALID", "display_name": "CUPTI_LINK_FLAG_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag23CUPTI_LINK_FLAG_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_INVALID The flag is invalid.", "keywords": []}, {"id": 333, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_PEER_ACCESS", "display_name": "CUPTI_LINK_FLAG_PEER_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag27CUPTI_LINK_FLAG_PEER_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_PEER_ACCESS Is peer to peer access supported by this link.", "keywords": []}, {"id": 334, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_PEER_ATOMICS", "display_name": "CUPTI_LINK_FLAG_PEER_ATOMICS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag28CUPTI_LINK_FLAG_PEER_ATOMICSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_PEER_ATOMICS Is peer atomic access supported by this link.", "keywords": []}, {"id": 335, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_SYSMEM_ACCESS", "display_name": "CUPTI_LINK_FLAG_SYSMEM_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag29CUPTI_LINK_FLAG_SYSMEM_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_SYSMEM_ACCESS Is system memory access supported by this link.", "keywords": []}, {"id": 336, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_LINK_FLAG_SYSMEM_ATOMICS", "display_name": "CUPTI_LINK_FLAG_SYSMEM_ATOMICS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag30CUPTI_LINK_FLAG_SYSMEM_ATOMICSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_SYSMEM_ATOMICS Is system memory atomic access supported by this link.", "keywords": []}, {"id": 337, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind35CUPTI_OPENACC_CONSTRUCT_KIND_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "keywords": []}, {"id": 338, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "keywords": []}, {"id": 339, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_DECLAREE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "keywords": []}, {"id": 340, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind39CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "keywords": []}, {"id": 341, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "keywords": []}, {"id": 342, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "keywords": []}, {"id": 343, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "keywords": []}, {"id": 344, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_INITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "keywords": []}, {"id": 345, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_KERNELSE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "keywords": []}, {"id": 346, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_LOOPE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "keywords": []}, {"id": 347, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind37CUPTI_OPENACC_CONSTRUCT_KIND_PARALLELE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "keywords": []}, {"id": 348, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "keywords": []}, {"id": 349, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind40CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_APIE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "keywords": []}, {"id": 350, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_SET", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_SET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind32CUPTI_OPENACC_CONSTRUCT_KIND_SETE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_SET", "keywords": []}, {"id": 351, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind37CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "keywords": []}, {"id": 352, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "keywords": []}, {"id": 353, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind35CUPTI_OPENACC_CONSTRUCT_KIND_UPDATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "keywords": []}, {"id": 354, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "display_name": "CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "keywords": []}, {"id": 355, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_ALLOC", "display_name": "CUPTI_OPENACC_EVENT_KIND_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind30CUPTI_OPENACC_EVENT_KIND_ALLOCE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ALLOC", "keywords": []}, {"id": 356, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "display_name": "CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind42CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "keywords": []}, {"id": 357, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_CREATE", "display_name": "CUPTI_OPENACC_EVENT_KIND_CREATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_CREATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_CREATE", "keywords": []}, {"id": 358, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_DELETE", "display_name": "CUPTI_OPENACC_EVENT_KIND_DELETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_DELETEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DELETE", "keywords": []}, {"id": 359, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "display_name": "CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind36CUPTI_OPENACC_EVENT_KIND_DEVICE_INITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "keywords": []}, {"id": 360, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "display_name": "CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind40CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "keywords": []}, {"id": 361, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "display_name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind41CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOADE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "keywords": []}, {"id": 362, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "display_name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind39CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCHE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "keywords": []}, {"id": 363, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "display_name": "CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind39CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOADE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "keywords": []}, {"id": 364, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "display_name": "CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind35CUPTI_OPENACC_EVENT_KIND_ENTER_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "keywords": []}, {"id": 365, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "display_name": "CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind34CUPTI_OPENACC_EVENT_KIND_EXIT_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "keywords": []}, {"id": 366, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "display_name": "CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind34CUPTI_OPENACC_EVENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "keywords": []}, {"id": 367, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_FREE", "display_name": "CUPTI_OPENACC_EVENT_KIND_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind29CUPTI_OPENACC_EVENT_KIND_FREEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_FREE", "keywords": []}, {"id": 368, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "display_name": "CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind38CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "keywords": []}, {"id": 369, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_INVALID", "display_name": "CUPTI_OPENACC_EVENT_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind32CUPTI_OPENACC_EVENT_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_INVALID", "keywords": []}, {"id": 370, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "display_name": "CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind41CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "keywords": []}, {"id": 371, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_UPDATE", "display_name": "CUPTI_OPENACC_EVENT_KIND_UPDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_UPDATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_UPDATE", "keywords": []}, {"id": 372, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENACC_EVENT_KIND_WAIT", "display_name": "CUPTI_OPENACC_EVENT_KIND_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind29CUPTI_OPENACC_EVENT_KIND_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_WAIT", "keywords": []}, {"id": 373, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "display_name": "CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind33CUPTI_OPENMP_EVENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "keywords": []}, {"id": 374, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_IDLE", "display_name": "CUPTI_OPENMP_EVENT_KIND_IDLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind28CUPTI_OPENMP_EVENT_KIND_IDLEE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_IDLE", "keywords": []}, {"id": 375, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_INVALID", "display_name": "CUPTI_OPENMP_EVENT_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind31CUPTI_OPENMP_EVENT_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_INVALID", "keywords": []}, {"id": 376, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_PARALLEL", "display_name": "CUPTI_OPENMP_EVENT_KIND_PARALLEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind32CUPTI_OPENMP_EVENT_KIND_PARALLELE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_PARALLEL", "keywords": []}, {"id": 377, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_TASK", "display_name": "CUPTI_OPENMP_EVENT_KIND_TASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind28CUPTI_OPENMP_EVENT_KIND_TASKE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_TASK", "keywords": []}, {"id": 378, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_THREAD", "display_name": "CUPTI_OPENMP_EVENT_KIND_THREAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind30CUPTI_OPENMP_EVENT_KIND_THREADE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_THREAD", "keywords": []}, {"id": 379, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "display_name": "CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind36CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIERE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "keywords": []}, {"id": 380, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "display_name": "CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind37CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAITE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "keywords": []}, {"id": 381, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_DEVICE_TYPE_BRIDGE", "display_name": "CUPTI_PCIE_DEVICE_TYPE_BRIDGE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType29CUPTI_PCIE_DEVICE_TYPE_BRIDGEE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_BRIDGE PCIE Bridge record.", "keywords": []}, {"id": 382, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "display_name": "CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType32CUPTI_PCIE_DEVICE_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "keywords": []}, {"id": 383, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_DEVICE_TYPE_GPU", "display_name": "CUPTI_PCIE_DEVICE_TYPE_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType26CUPTI_PCIE_DEVICE_TYPE_GPUE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_GPU PCIE GPU record.", "keywords": []}, {"id": 384, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_FORCE_INT", "display_name": "CUPTI_PCIE_GEN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen24CUPTI_PCIE_GEN_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_FORCE_INT", "keywords": []}, {"id": 385, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN1", "display_name": "CUPTI_PCIE_GEN_GEN1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN1E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN1 PCIE Generation 1.", "keywords": []}, {"id": 386, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN2", "display_name": "CUPTI_PCIE_GEN_GEN2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN2E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN2 PCIE Generation 2.", "keywords": []}, {"id": 387, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN3", "display_name": "CUPTI_PCIE_GEN_GEN3", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN3E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN3 PCIE Generation 3.", "keywords": []}, {"id": 388, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN4", "display_name": "CUPTI_PCIE_GEN_GEN4", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN4E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN4 PCIE Generation 4.", "keywords": []}, {"id": 389, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN5", "display_name": "CUPTI_PCIE_GEN_GEN5", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN5E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN5 PCIE Generation 5.", "keywords": []}, {"id": 390, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUPTI_PCIE_GEN_GEN6", "display_name": "CUPTI_PCIE_GEN_GEN6", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN6E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN6 PCIE Generation 6.", "keywords": []}, {"id": 391, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute", "display_name": "CUpti_ActivityAttribute", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv423CUpti_ActivityAttribute", "priority": 1, "content": "enum  CUpti_ActivityAttribute Activity attributes. These attributes are used to control the behavior of the activity API. Values:", "keywords": []}, {"id": 392, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute43CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_FORCE_INT", "keywords": []}, {"id": 393, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute44CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT The maximum number of device memory buffers per context. The value is a size_t. For an application with high rate of kernel launches, memcopies and memsets having a bigger pool limit helps in timestamp collection for all these activities at the expense of a larger memory footprint. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE for more details. Setting this value will not modify the number of memory buffers currently stored. Set this value before initializing CUDA to ensure the limit is not exceeded. The default value is 250.", "keywords": []}, {"id": 394, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute52CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE Number of device buffers to pre-allocate for a context during the initialization phase. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE for details. This value must be less than the maximum number of device buffers set using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT Set this value before initializing CUDA or before creating a context to ensure it is considered by the CUPTI. The default value is set to 3 to ping pong between these buffers (if possible).", "keywords": []}, {"id": 395, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute38CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE The device memory size (in bytes) reserved for storing profiling data for concurrent kernels (activity kind CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL ), memcopies and memsets for each buffer on a context. The value is a size_t. There is a limit on how many device buffers can be allocated per context. User can query and set this limit using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT . CUPTI doesn\u2019t pre-allocate all the buffers, it pre-allocates only those many buffers as set by the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE . When all of the data in a buffer is consumed, it is added in the reuse pool, and CUPTI picks a buffer from this pool when a new buffer is needed. Thus memory footprint does not scale with the kernel count. Applications with the high density of kernels, memcopies and memsets might result in having CUPTI to allocate more device buffers. CUPTI allocates another buffer only when it runs out of the buffers in the reuse pool. Since buffer allocation happens in the main application thread, this might result in stalls in the critical path. CUPTI pre-allocates 3 buffers of the same size to mitigate this issue. User can query and set the pre-allocation limit using the attribute CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_PRE_ALLOCATE_VALUE . Having larger buffer size leaves less device memory for the application. Having smaller buffer size increases the risk of dropping timestamps for records if too many kernels or memcopies or memsets are launched at one time. This value only applies to new buffer allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 3200000 (~3MB) which can accommodate profiling data up to 100,000 kernels, memcopies and memsets combined. Note: Starting with the CUDA 12.0 Update 1 release, CUPTI allocates profiling buffer in the device memory by default as this might help in improving the performance of the tracing run. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED for more details. Size of the memory and maximum number of pools are still controlled by the attributes CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE and CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_POOL_LIMIT . Note: The actual amount of device memory per buffer reserved by CUPTI might be larger.", "keywords": []}, {"id": 396, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute42CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP The device memory size (in bytes) reserved for storing profiling data for CDP operations for each buffer on a context. The value is a size_t. Having larger buffer size means less flush operations but consumes more device memory. This value only applies to new allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 8388608 (8MB). Note: The actual amount of device memory per context reserved by CUPTI might be larger.", "keywords": []}, {"id": 397, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute52CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_DEVICE_GRAPHS The device memory size (in bytes) reserved for storing profiling data for device graph operations for each buffer on a context. The value is a size_t. Having larger buffer size means less flush operations but consumes more device memory. This value only applies to new allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 16777216 (16MB). Note: The actual amount of device memory per context reserved by CUPTI might be larger.", "keywords": []}, {"id": 398, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute51CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_MEM_ALLOCATION_TYPE_HOST_PINNED Allocate page-locked (pinned) host memory for storing profiling data for concurrent kernels, memcopies and memsets for each buffer on a context. The value is a uint8_t. Starting with the CUDA 11.2 release, CUPTI allocates profiling buffer in the pinned host memory by default as this might help in improving the performance of the tracing run. Allocating excessive amounts of pinned memory may degrade system performance, since it reduces the amount of memory available to the system for paging. For this reason user might want to change the location from pinned host memory to device memory by setting value of this attribute to 0. Using page-locked (pinned) host memory buffers is not supported on confidential computing devices. On setting this attribute to 1, CUPTI will return CUPTI_ERROR_NOT_SUPPORTED. The default value is 1.", "keywords": []}, {"id": 399, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute46CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PER_THREAD_ACTIVITY_BUFFER Request activity buffers per-thread to store CUPTI activity records in the activity buffer on per-thread basis. The value is a uint8_t. The attribute should be set before registering the buffer callbacks using cuptiActivityRegisterCallbacks API and before any of the CUPTI activity kinds are enabled. This makes sure that all the records are stored in activity buffers allocated per-thread. Changing this attribute in the middle of the profiling session will result in undefined behavior. The default value is 0.", "keywords": []}, {"id": 400, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute50CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. The maximum number of profiling semaphore pools per context. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE for more details. Set this value before initializing CUDA to ensure the limit is not exceeded. The default value is 250.", "keywords": []}, {"id": 401, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute49CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. There is a limit on how many semaphore pools can be allocated per context. User can query and set this limit using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT . CUPTI doesn\u2019t pre-allocate all the semaphore pools, it pre-allocates only those many semaphore pools as set by the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE . When all of the data in a semaphore pool is consumed, it is added in the reuse pool, and CUPTI picks a semaphore pool from the reuse pool when a new semaphore pool is needed. Thus memory footprint does not scale with the kernel count. Applications with the high density of kernels might result in having CUPTI to allocate more semaphore pools. CUPTI allocates another semaphore pool only when it runs out of the semaphore pools in the reuse pool. Since semaphore pool allocation happens in the main application thread, this might result in stalls in the critical path. CUPTI pre-allocates 3 semaphore pools of the same size to mitigate this issue. User can query and set the pre-allocation limit using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE . Having larger semaphore pool size leaves less device memory for the application. Having smaller semaphore pool size increases the risk of dropping timestamps for kernel records if too many kernels are issued/launched at one time. This value only applies to new semaphore pool allocations. Set this value before initializing CUDA or before creating a context to ensure it is considered for the following allocations. The default value is 25000 which can accommodate profiling data for upto 25,000 kernels.", "keywords": []}, {"id": 402, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute58CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_PRE_ALLOCATE_VALUE This attribute is not supported starting with CUDA 12.3 CUPTI no longer uses profiling semaphore pool to store profiling data. Number of profiling semaphore pools to pre-allocate for a context during the initialization phase. The value is a size_t. Refer to the description of the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_SIZE for details. This value must be less than the maximum number of profiling semaphore pools set using the attribute CUPTI_ACTIVITY_ATTR_PROFILING_SEMAPHORE_POOL_LIMIT Set this value before initializing CUDA or before creating a context to ensure it is considered by the CUPTI. The default value is set to 3 to ping pong between these pools (if possible).", "keywords": []}, {"id": 403, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER", "display_name": "CUpti_ActivityAttribute::CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N23CUpti_ActivityAttribute46CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ATTR_ZEROED_OUT_ACTIVITY_BUFFER The flag to indicate whether user should provide activity buffer of zero value. The value is a uint8_t. If the value of this attribute is non-zero, user should provide a zero value buffer in the CUpti_BuffersCallbackRequestFunc . If the user does not provide a zero value buffer after setting this to non-zero, the activity buffer may contain some uninitialized values when CUPTI returns it in CUpti_BuffersCallbackCompleteFunc If the value of this attribute is zero, CUPTI will initialize the user buffer received in the CUpti_BuffersCallbackRequestFunc to zero before filling it. If the user sets this to zero, a few stalls may appear in critical path because CUPTI will zero out the buffer in the main thread. Set this value before returning from CUpti_BuffersCallbackRequestFunc to ensure it is considered for all the subsequent user buffers. The default value is 0.", "keywords": []}, {"id": 404, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityComputeApiKind", "display_name": "CUpti_ActivityComputeApiKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428CUpti_ActivityComputeApiKind", "priority": 1, "content": "enum  CUpti_ActivityComputeApiKind The kind of a compute API. Values:", "keywords": []}, {"id": 405, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_CUDA", "display_name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_CUDA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind31CUPTI_ACTIVITY_COMPUTE_API_CUDAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_CUDA The compute APIs are for CUDA.", "keywords": []}, {"id": 406, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS", "display_name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind35CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_CUDA_MPS The compute APIs are for CUDA running in MPS (Multi-Process Service) environment.", "keywords": []}, {"id": 407, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "display_name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind36CUPTI_ACTIVITY_COMPUTE_API_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_FORCE_INT", "keywords": []}, {"id": 408, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN", "display_name": "CUpti_ActivityComputeApiKind::CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityComputeApiKind34CUPTI_ACTIVITY_COMPUTE_API_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_COMPUTE_API_UNKNOWN The compute API is not known.", "keywords": []}, {"id": 409, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind", "display_name": "CUpti_ActivityEnvironmentKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429CUpti_ActivityEnvironmentKind", "priority": 1, "content": "enum  CUpti_ActivityEnvironmentKind The kind of environment data. Used to indicate what type of data is being reported by an environment activity record. Values:", "keywords": []}, {"id": 410, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_COOLING", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_COOLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind34CUPTI_ACTIVITY_ENVIRONMENT_COOLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_COOLING The environment data is related to cooling.", "keywords": []}, {"id": 411, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_COUNT", "keywords": []}, {"id": 412, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind41CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_KIND_FORCE_INT", "keywords": []}, {"id": 413, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_POWER", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_POWER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_POWERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_POWER The environment data is related to power.", "keywords": []}, {"id": 414, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_SPEED", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_SPEED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind32CUPTI_ACTIVITY_ENVIRONMENT_SPEEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_SPEED The environment data is related to speed.", "keywords": []}, {"id": 415, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind38CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_TEMPERATURE The environment data is related to temperature.", "keywords": []}, {"id": 416, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN", "display_name": "CUpti_ActivityEnvironmentKind::CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ActivityEnvironmentKind34CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_ENVIRONMENT_UNKNOWN Unknown data.", "keywords": []}, {"id": 417, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag", "display_name": "CUpti_ActivityFlag", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418CUpti_ActivityFlag", "priority": 1, "content": "enum  CUpti_ActivityFlag Flags associated with activity records. Activity record flags. Flags can be combined by bitwise OR to associated multiple flags with an activity record. Each flag is specific to a certain activity kind, as noted below. Values:", "keywords": []}, {"id": 418, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_DEVICE_ATTRIBUTE_CUDEVICE Indicates if the activity represents a CUdevice_attribute value or a CUpti_DeviceAttribute value. Valid for CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE.", "keywords": []}, {"id": 419, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_DEVICE_CONCURRENT_KERNELS Indicates the activity represents a device that supports concurrent kernel execution. Valid for CUPTI_ACTIVITY_KIND_DEVICE.", "keywords": []}, {"id": 420, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_FLUSH_FORCED", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_FLUSH_FORCED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_FLUSH_FORCEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_FLUSH_FORCED When calling cuptiActivityFlushAll, this flag can be set to force CUPTI to flush all records in the buffer, whether finished or not.", "keywords": []}, {"id": 421, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_FORCE_INT", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag29CUPTI_ACTIVITY_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_FORCE_INT", "keywords": []}, {"id": 422, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_CACHED If this bit in flag is set, the load access was cached else it is uncached. Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 423, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag43CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_LOAD If bit in this flag is set, the access was load, else it is a store access. Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 424, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag48CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_GLOBAL_ACCESS_KIND_SIZE_MASK The number of bytes requested by each thread Valid for CUpti_ActivityGlobalAccess3 .", "keywords": []}, {"id": 425, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag42CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_INSTRUCTION_CLASS_MASK The mask for the instruction class, CUpti_ActivityInstructionClass Valid for CUpti_ActivityInstructionExecution and CUpti_ActivityInstructionCorrelation .", "keywords": []}, {"id": 426, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag45CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_INSTRUCTION_VALUE_INVALID If this bit in flag is set, the source level metric value couldn\u2019t be calculated. This occurs when a value(s) required to calculate the source level metric cannot be evaluated. Valid for CUpti_ActivityInstructionExecution .", "keywords": []}, {"id": 427, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGBE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_ARGB Indicates the activity represents a marker that specifies a color in alpha-red-green-blue format. Valid for CUPTI_ACTIVITY_KIND_MARKER_DATA.", "keywords": []}, {"id": 428, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_COLOR_NONE Indicates the activity represents a marker that does not specify a color. Valid for CUPTI_ACTIVITY_KIND_MARKER_DATA.", "keywords": []}, {"id": 429, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_END", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_END", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag30CUPTI_ACTIVITY_FLAG_MARKER_ENDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_END Indicates the activity represents a region end marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 430, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag40CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_INSTANTANEOUS Indicates the activity represents an instantaneous marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 431, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_START", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_START", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MARKER_STARTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_START Indicates the activity represents a region start marker. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 432, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag39CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE Indicates the activity represents an attempt to acquire a user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 433, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag46CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_FAILED Indicates the activity represents failure in acquiring the user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 434, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag47CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_ACQUIRE_SUCCESS Indicates the activity represents success in acquiring the user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 435, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag39CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MARKER_SYNC_RELEASE Indicates the activity represents releasing a reservation on user defined synchronization object. Valid for CUPTI_ACTIVITY_KIND_MARKER.", "keywords": []}, {"id": 436, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MEMCPY_ASYNC Indicates the activity represents an asynchronous memcpy operation. Valid for CUPTI_ACTIVITY_KIND_MEMCPY.", "keywords": []}, {"id": 437, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag32CUPTI_ACTIVITY_FLAG_MEMSET_ASYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_MEMSET_ASYNC Indicates the activity represents an asynchronous memset operation. Valid for CUPTI_ACTIVITY_KIND_MEMSET.", "keywords": []}, {"id": 438, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_METRIC_OVERFLOWED If this bit in flag is set, the metric value overflowed. Valid for CUpti_ActivityMetric and CUpti_ActivityMetricInstance .", "keywords": []}, {"id": 439, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag40CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_METRIC_VALUE_INVALID If this bit in flag is set, the metric value couldn\u2019t be calculated. This occurs when a value(s) required to calculate the metric is missing. Valid for CUpti_ActivityMetric and CUpti_ActivityMetricInstance .", "keywords": []}, {"id": 440, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_NONE", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag24CUPTI_ACTIVITY_FLAG_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_NONE Indicates the activity record has no flags.", "keywords": []}, {"id": 441, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag43CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_LOAD If bit in this flag is set, the access was load, else it is a store access. Valid for CUpti_ActivitySharedAccess .", "keywords": []}, {"id": 442, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag48CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_SHARED_ACCESS_KIND_SIZE_MASK The number of bytes requested by each thread Valid for CUpti_ActivitySharedAccess .", "keywords": []}, {"id": 443, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag36CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPUE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_THRASHING_IN_CPU Indicates the activity represents thrashing in CPU. Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING in CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "keywords": []}, {"id": 444, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU", "display_name": "CUpti_ActivityFlag::CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityFlag37CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPUE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_FLAG_THROTTLING_IN_CPU Indicates the activity represents page throttling in CPU. Valid for counter of kind CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING in CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "keywords": []}, {"id": 445, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass", "display_name": "CUpti_ActivityInstructionClass", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430CUpti_ActivityInstructionClass", "priority": 1, "content": "enum  CUpti_ActivityInstructionClass SASS instruction classification. The sass instruction are broadly divided into different class. Each enum represents a classification. Values:", "keywords": []}, {"id": 446, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BARRIER Represents a barrier instruction.", "keywords": []}, {"id": 447, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_BIT_CONVERSION Represents a bit conversion operation.", "keywords": []}, {"id": 448, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass41CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONSTANT Represents a constant load instruction.", "keywords": []}, {"id": 449, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass45CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOWE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_CONTROL_FLOW Represents a control flow instruction.", "keywords": []}, {"id": 450, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_16 Represents a 16 bit floating point operation.", "keywords": []}, {"id": 451, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_32 Represents a 32 bit floating point operation.", "keywords": []}, {"id": 452, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_FP_64 Represents a 64 bit floating point operation.", "keywords": []}, {"id": 453, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GENERIC Represents a generic load-store instruction.", "keywords": []}, {"id": 454, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass39CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL Represents a global load-store instruction.", "keywords": []}, {"id": 455, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_GLOBAL_ATOMIC Represents a global atomic instruction.", "keywords": []}, {"id": 456, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTEGER Represents an integer operation.", "keywords": []}, {"id": 457, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass59CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_INTER_THREAD_COMMUNICATION Represents a inter-thread communication instruction.", "keywords": []}, {"id": 458, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_KIND_FORCE_INT", "keywords": []}, {"id": 459, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass38CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_LOCAL Represents a local load-store instruction.", "keywords": []}, {"id": 460, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_MISCELLANEOUS Represents some miscellaneous instructions which do not fit in the above classification.", "keywords": []}, {"id": 461, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass39CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHAREDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED Represents a shared load-store instruction.", "keywords": []}, {"id": 462, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass46CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SHARED_ATOMIC Represents a shared atomic instruction.", "keywords": []}, {"id": 463, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE Represents a surface load-store instruction.", "keywords": []}, {"id": 464, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass47CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_SURFACE_ATOMIC Represents a surface atomic instruction.", "keywords": []}, {"id": 465, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_TEXTURE Represents a texture load-store instruction.", "keywords": []}, {"id": 466, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNIFORM Represents uniform instruction.", "keywords": []}, {"id": 467, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN", "display_name": "CUpti_ActivityInstructionClass::CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityInstructionClass40CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_INSTRUCTION_CLASS_UNKNOWN The instruction class is not known.", "keywords": []}, {"id": 468, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitEntryType", "display_name": "CUpti_ActivityJitEntryType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426CUpti_ActivityJitEntryType", "priority": 1, "content": "enum  CUpti_ActivityJitEntryType The types of JIT entry. To be used in CUpti_ActivityJit . Values:", "keywords": []}, {"id": 469, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "display_name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType32CUPTI_ACTIVITY_JIT_ENTRY_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_INVALID", "keywords": []}, {"id": 470, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX", "display_name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType39CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTXE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_NVVM_IR_TO_PTX NVVM-IR to PTX.", "keywords": []}, {"id": 471, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN", "display_name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType37CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBINE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_PTX_TO_CUBIN PTX to CUBIN.", "keywords": []}, {"id": 472, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "display_name": "CUpti_ActivityJitEntryType::CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityJitEntryType39CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_ENTRY_TYPE_FORCE_INT", "keywords": []}, {"id": 473, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType", "display_name": "CUpti_ActivityJitOperationType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430CUpti_ActivityJitOperationType", "priority": 1, "content": "enum  CUpti_ActivityJitOperationType The types of JIT compilation operations. To be used in CUpti_ActivityJit . Values:", "keywords": []}, {"id": 474, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD", "display_name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType39CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_LOAD Loaded from the compute cache.", "keywords": []}, {"id": 475, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE", "display_name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType40CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STOREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_CACHE_STORE Stored in the compute cache.", "keywords": []}, {"id": 476, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_COMPILE", "display_name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_COMPILE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType36CUPTI_ACTIVITY_JIT_OPERATION_COMPILEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_COMPILE JIT compilation.", "keywords": []}, {"id": 477, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "display_name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType36CUPTI_ACTIVITY_JIT_OPERATION_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_INVALID", "keywords": []}, {"id": 478, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "display_name": "CUpti_ActivityJitOperationType::CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityJitOperationType43CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_JIT_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 479, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind", "display_name": "CUpti_ActivityKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418CUpti_ActivityKind", "priority": 1, "content": "enum  CUpti_ActivityKind The kinds of activity records. Each activity record kind represents information about a GPU or an activity occurring on a CPU or GPU. Each kind is associated with a activity record structure that holds the information associated with the kind. CUpti_Activity  CUpti_ActivityAPI  CUpti_ActivityContext  CUpti_ActivityContext2  CUpti_ActivityContext3  CUpti_ActivityDevice  CUpti_ActivityDevice2  CUpti_ActivityDevice3  CUpti_ActivityDevice4  CUpti_ActivityDeviceAttribute  CUpti_ActivityEvent  CUpti_ActivityEventInstance  CUpti_ActivityKernel  CUpti_ActivityKernel2  CUpti_ActivityKernel3  CUpti_ActivityKernel4  CUpti_ActivityKernel5  CUpti_ActivityKernel6  CUpti_ActivityKernel7  CUpti_ActivityKernel8  CUpti_ActivityKernel9  CUpti_ActivityCdpKernel  CUpti_ActivityPreemption  CUpti_ActivityMemcpy  CUpti_ActivityMemcpy3  CUpti_ActivityMemcpy4  CUpti_ActivityMemcpy5  CUpti_ActivityMemcpy6  CUpti_ActivityMemcpyPtoP  CUpti_ActivityMemcpyPtoP2  CUpti_ActivityMemcpyPtoP3  CUpti_ActivityMemcpyPtoP4  CUpti_ActivityMemset  CUpti_ActivityMemset2  CUpti_ActivityMemset3  CUpti_ActivityMemset4  CUpti_ActivityMemory  CUpti_ActivityMemory2  CUpti_ActivityMemory3  CUpti_ActivityMemory4  CUpti_ActivityMemoryPool  CUpti_ActivityMemoryPool2  CUpti_ActivityMetric  CUpti_ActivityMetricInstance  CUpti_ActivityName  CUpti_ActivityMarker  CUpti_ActivityMarker2  CUpti_ActivityMarkerData  CUpti_ActivitySourceLocator  CUpti_ActivityGlobalAccess  CUpti_ActivityGlobalAccess2  CUpti_ActivityGlobalAccess3  CUpti_ActivityBranch  CUpti_ActivityBranch2  CUpti_ActivityOverhead3  CUpti_ActivityEnvironment  CUpti_ActivityInstructionExecution  CUpti_ActivityUnifiedMemoryCounter  CUpti_ActivityFunction  CUpti_ActivityModule  CUpti_ActivitySharedAccess  CUpti_ActivityPCSampling  CUpti_ActivityPCSampling2  CUpti_ActivityPCSampling3  CUpti_ActivityPCSamplingRecordInfo  CUpti_ActivityCudaEvent2  CUpti_ActivityStream  CUpti_ActivitySynchronization2  CUpti_ActivityInstructionCorrelation  CUpti_ActivityExternalCorrelation  CUpti_ActivityUnifiedMemoryCounter3  CUpti_ActivityOpenAccData  CUpti_ActivityOpenAccLaunch  CUpti_ActivityOpenAccOther  CUpti_ActivityOpenMp  CUpti_ActivityNvLink  CUpti_ActivityNvLink2  CUpti_ActivityNvLink3  CUpti_ActivityNvLink4  CUpti_ActivityPcie  CUpti_ActivityConfidentialComputeRotation  Values:", "keywords": []}, {"id": 480, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_BRANCH", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_BRANCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_BRANCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_BRANCH Results for source-level branch. The corresponding activity record structure is CUpti_ActivityBranch2 . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 481, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CDP_KERNEL", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CDP_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_CDP_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CDP_KERNEL A CDP (CUDA Dynamic Parallel) kernel executing on the GPU. The corresponding activity record structure is CUpti_ActivityCdpKernel . This activity cannot be directly enabled or disabled. It is enabled and disabled through concurrent kernel activity i.e. _CONCURRENT_KERNEL.", "keywords": []}, {"id": 482, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind37CUPTI_ACTIVITY_KIND_CONCURRENT_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL A kernel executing on the GPU. This activity kind doesn\u2019t break kernel concurrency. The corresponding activity record structure is CUpti_ActivityKernel9 .", "keywords": []}, {"id": 483, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind49CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONFIDENTIAL_COMPUTE_ROTATION Tracing new overheads introduced on some hardware due when confidential computing is enabled. The corresponding activity record structure is CUpti_ActivityConfidentialComputeRotation .", "keywords": []}, {"id": 484, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONTEXT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CONTEXT Information about a CUDA context. The corresponding activity record structure is CUpti_ActivityContext3 .", "keywords": []}, {"id": 485, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_COUNT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind25CUPTI_ACTIVITY_KIND_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_COUNT Count of supported activity kinds.", "keywords": []}, {"id": 486, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CUDA_EVENT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_CUDA_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_CUDA_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_CUDA_EVENT Information about a CUDA event (cudaEvent). The corresponding activity record structure is CUpti_ActivityCudaEvent2 .", "keywords": []}, {"id": 487, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE Information about a CUDA device. The corresponding activity record structure is CUpti_ActivityDevice5 .", "keywords": []}, {"id": 488, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind36CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE_ATTRIBUTE A device attribute value. The corresponding activity record structure is CUpti_ActivityDeviceAttribute . This activity cannot be directly enabled or disabled. Information collected using attributes CUpti_DeviceAttribute or CUdevice_attribute can be stored in the corresponding activity record.", "keywords": []}, {"id": 489, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind38CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DEVICE_GRAPH_TRACE This activity can not be directly enabled or disabled. It is enabled when CUPTI_ACTIVITY_KIND_GRAPH_TRACE is enabled and device graph trace is enabled through API cuptiActivityEnableDeviceGraph() . The corresponding activity record structure is CUpti_ActivityDeviceGraphTrace .", "keywords": []}, {"id": 490, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DRIVER", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_DRIVER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_DRIVERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_DRIVER A CUDA driver API function execution. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 491, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_ENVIRONMENT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_ENVIRONMENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_ENVIRONMENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_ENVIRONMENT Environment activity records indicating power, clock, thermal, etc. levels of the GPU. The corresponding activity record structure is CUpti_ActivityEnvironment .", "keywords": []}, {"id": 492, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EVENT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind25CUPTI_ACTIVITY_KIND_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EVENT A performance counter (aka event) value. The corresponding activity record structure is CUpti_ActivityEvent . This activity cannot be directly enabled or disabled. Information collected using the Event API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 493, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EVENT_INSTANCE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EVENT_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_EVENT_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EVENT_INSTANCE An performance counter value associated with a specific event domain instance. The corresponding activity record structure is CUpti_ActivityEventInstance . This activity cannot be directly enabled or disabled. Information collected using the Event API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 494, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind40CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION Records for correlation of different programming APIs. The corresponding activity record structure is CUpti_ActivityExternalCorrelation .", "keywords": []}, {"id": 495, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_FORCE_INT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind29CUPTI_ACTIVITY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_FORCE_INT", "keywords": []}, {"id": 496, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_FUNCTION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_FUNCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind28CUPTI_ACTIVITY_KIND_FUNCTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_FUNCTION Device global/function record. The corresponding activity record structure is CUpti_ActivityFunction .", "keywords": []}, {"id": 497, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_GLOBAL_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_GLOBAL_ACCESS Results for source-level global access. The corresponding activity record structure is CUpti_ActivityGlobalAccess3 . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 498, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_GRAPH_TRACE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_GRAPH_TRACE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_GRAPH_TRACEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_GRAPH_TRACE Activity record for graph-level information. The corresponding activity record structure is CUpti_ActivityGraphTrace2 .", "keywords": []}, {"id": 499, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind39CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT Instantaneous Event information. The corresponding activity record structure is CUpti_ActivityInstantaneousEvent . This activity can not be directly enabled or disabled. Information collected using the Event API can be stored in the corresponding activity record.", "keywords": []}, {"id": 500, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind48CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_EVENT_INSTANCE Instantaneous Event information for a specific event domain instance. The corresponding activity record structure is CUpti_ActivityInstantaneousEventInstance . This activity can not be directly enabled or disabled. Information collected using the Event API can be stored in the corresponding activity record.", "keywords": []}, {"id": 501, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind40CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC Instantaneous Metric information The corresponding activity record structure is CUpti_ActivityInstantaneousMetric . This activity cannot be directly enabled or disabled. Information collected using the Metric API can be stored in the corresponding activity record.", "keywords": []}, {"id": 502, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind49CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTANTANEOUS_METRIC_INSTANCE Instantaneous Metric information for a specific metric domain instance. The corresponding activity record structure is CUpti_ActivityInstantaneousMetricInstance . This activity cannot be directly enabled or disabled. Information collected using the Metric API can be stored in the corresponding activity record.", "keywords": []}, {"id": 503, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind43CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTRUCTION_CORRELATION SASS/Source line-by-line correlation record. This will generate sass/source correlation for functions that have source level analysis or pc sampling results. The records will be generated only when either of source level analysis or pc sampling activity is enabled. The corresponding activity record structure is CUpti_ActivityInstructionCorrelation . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 504, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind41CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INSTRUCTION_EXECUTION Results for source-level instruction execution. The corresponding activity record structure is CUpti_ActivityInstructionExecution . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 505, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind39CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_APIE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INTERNAL_LAUNCH_API A CUDA driver kernel launch occurring outside of any public API function execution. Tools can handle these like records for driver API launch functions, although the cbid field is not used here. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 506, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INVALID", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_INVALID The activity record is invalid.", "keywords": []}, {"id": 507, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_JIT", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_JIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind23CUPTI_ACTIVITY_KIND_JITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_JIT JIT (Just-in-time) operation tracking. The corresponding activity record structure is CUpti_ActivityJit .", "keywords": []}, {"id": 508, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_KERNEL", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_KERNELE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_KERNEL A kernel executing on the GPU. This activity kind may significantly change the overall performance characteristics of the application because all kernel executions are serialized on the GPU. Other activity kind for kernel CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL doesn\u2019t break kernel concurrency. The corresponding activity record structure is CUpti_ActivityKernel9 .", "keywords": []}, {"id": 509, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MARKER", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MARKER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MARKERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MARKER Instantaneous, start, or end NVTX marker. The corresponding activity record structure is CUpti_ActivityMarker2 .", "keywords": []}, {"id": 510, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MARKER_DATA", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MARKER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_MARKER_DATAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MARKER_DATA Extended, optional, data about a NVTX marker. User must enable CUPTI_ACTIVITY_KIND_MARKER as well to get records for marker data. The corresponding activity record structure is CUpti_ActivityMarkerData .", "keywords": []}, {"id": 511, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMCPY", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMCPYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMCPY A host&lt;-&gt;host, host&lt;-&gt;device, or device&lt;-&gt;device memory copy. For peer to peer memory copy, use the kind CUPTI_ACTIVITY_KIND_MEMCPY2. The corresponding activity record structure is CUpti_ActivityMemcpy6 .", "keywords": []}, {"id": 512, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMCPY2", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMCPY2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_MEMCPY2E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMCPY2 A peer to peer memory copy. The corresponding activity record structure is CUpti_ActivityMemcpyPtoP4 .", "keywords": []}, {"id": 513, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY Memory activity tracking allocation and freeing of the memory The corresponding activity record structure is CUpti_ActivityMemory .", "keywords": []}, {"id": 514, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY2", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_MEMORY2E", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY2 Memory activity tracking allocation and freeing of the memory The corresponding activity record structure is CUpti_ActivityMemory4 .", "keywords": []}, {"id": 515, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY_POOL", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMORY_POOL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_MEMORY_POOLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMORY_POOL Memory pool activity tracking creation, destruction and trimming of the memory pool. The corresponding activity record structure is CUpti_ActivityMemoryPool2 .", "keywords": []}, {"id": 516, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMSET", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEMSET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MEMSETE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEMSET A memory set executing on the GPU. The corresponding activity record structure is CUpti_ActivityMemset4 .", "keywords": []}, {"id": 517, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_MEM_DECOMPRESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MEM_DECOMPRESS Tracing batches of copies that are to be decompressed. The corresponding activity record structure is CUpti_ActivityMemDecompress .", "keywords": []}, {"id": 518, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_METRIC", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_METRIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_METRICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_METRIC A performance metric value. The corresponding activity record structure is CUpti_ActivityMetric . This activity cannot be directly enabled or disabled. Information collected using the Metric API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 519, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_METRIC_INSTANCE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_METRIC_INSTANCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind35CUPTI_ACTIVITY_KIND_METRIC_INSTANCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_METRIC_INSTANCE A performance metric value associated with a specific metric domain instance. The corresponding activity record structure is CUpti_ActivityMetricInstance . This activity cannot be directly enabled or disabled. Information collected using the Metric API. can be stored in the corresponding activity record.", "keywords": []}, {"id": 520, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MODULE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_MODULE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_MODULEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_MODULE CUDA Module record. The corresponding activity record structure is CUpti_ActivityModule . This activity cannot be directly enabled or disabled. Information collected using the module callback can be be stored in the corresponding activity record.", "keywords": []}, {"id": 521, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_NAME", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind24CUPTI_ACTIVITY_KIND_NAMEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_NAME Resource naming done via NVTX APIs for thread, device, context, etc. The corresponding activity record structure is CUpti_ActivityName .", "keywords": []}, {"id": 522, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_NVLINK", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_NVLINK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_NVLINKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_NVLINK NVLink topology information. The corresponding activity record structure is CUpti_ActivityNvLink4 .", "keywords": []}, {"id": 523, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_DATA", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind32CUPTI_ACTIVITY_KIND_OPENACC_DATAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_DATA OpenACC data events. The corresponding activity record structure is CUpti_ActivityOpenAccData .", "keywords": []}, {"id": 524, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_OPENACC_LAUNCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_LAUNCH OpenACC launch events. The corresponding activity record structure is CUpti_ActivityOpenAccLaunch .", "keywords": []}, {"id": 525, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_OTHER", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENACC_OTHER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_OPENACC_OTHERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENACC_OTHER OpenACC other events. The corresponding activity record structure is CUpti_ActivityOpenAccOther .", "keywords": []}, {"id": 526, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENMP", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OPENMP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_OPENMPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OPENMP OpenMP parallel events. The corresponding activity record structure is CUpti_ActivityOpenMp .", "keywords": []}, {"id": 527, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OVERHEAD", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_OVERHEAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind28CUPTI_ACTIVITY_KIND_OVERHEADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_OVERHEAD Overhead added by CUPTI, Compiler, CUDA driver etc. The corresponding activity record structure is CUpti_ActivityOverhead3 .", "keywords": []}, {"id": 528, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PCIE", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PCIE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind24CUPTI_ACTIVITY_KIND_PCIEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PCIE PCI devices information used for PCI topology. The corresponding activity record structure is CUpti_ActivityPcie .", "keywords": []}, {"id": 529, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PC_SAMPLING", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PC_SAMPLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind31CUPTI_ACTIVITY_KIND_PC_SAMPLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PC_SAMPLING PC sampling information for kernels. This will serialize kernels. The corresponding activity record structure is CUpti_ActivityPCSampling3 . In CUDA 12.5, this kind is deprecated for Volta and later GPU architectures in favor of PC Sampling APIs from the header cupti_pcsampling.h which allows concurrent kernel execution.", "keywords": []}, {"id": 530, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind43CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFOE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PC_SAMPLING_RECORD_INFO Summary information about PC sampling records. The corresponding activity record structure is CUpti_ActivityPCSamplingRecordInfo . In CUDA 12.5, this kind is deprecated for Volta and later GPU architectures in favor of PC Sampling APIs from the header cupti_pcsampling.h .", "keywords": []}, {"id": 531, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PREEMPTION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_PREEMPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind30CUPTI_ACTIVITY_KIND_PREEMPTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_PREEMPTION Preemption activity record indicating a preemption of a CDP (CUDA Dynamic Parallel) kernel executing on the GPU. The corresponding activity record structure is CUpti_ActivityPreemption .", "keywords": []}, {"id": 532, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_RUNTIME", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_RUNTIME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind27CUPTI_ACTIVITY_KIND_RUNTIMEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_RUNTIME A CUDA runtime API function execution. The corresponding activity record structure is CUpti_ActivityAPI .", "keywords": []}, {"id": 533, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SHARED_ACCESS", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SHARED_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind33CUPTI_ACTIVITY_KIND_SHARED_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SHARED_ACCESS Results for source-level shared access. The corresponding activity record structure is CUpti_ActivitySharedAccess . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 534, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind34CUPTI_ACTIVITY_KIND_SOURCE_LOCATORE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SOURCE_LOCATOR Source information about source level result. The corresponding activity record structure is CUpti_ActivitySourceLocator . In CUDA 12.6, this kind is deprecated for Volta and later GPU architectures in favor of SASS Metric APIs from the header cupti_sass_metrics.h .", "keywords": []}, {"id": 535, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_STREAM", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind26CUPTI_ACTIVITY_KIND_STREAME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_STREAM Information about a CUDA stream. The corresponding activity record structure is CUpti_ActivityStream .", "keywords": []}, {"id": 536, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SYNCHRONIZATION", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_SYNCHRONIZATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind35CUPTI_ACTIVITY_KIND_SYNCHRONIZATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_SYNCHRONIZATION Records for CUDA synchronization primitives. The corresponding activity record structure is CUpti_ActivitySynchronization2 .", "keywords": []}, {"id": 537, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "display_name": "CUpti_ActivityKind::CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N18CUpti_ActivityKind42CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER Unified Memory counter record. The corresponding activity record structure is CUpti_ActivityUnifiedMemoryCounter3 .", "keywords": []}, {"id": 538, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityLaunchType", "display_name": "CUpti_ActivityLaunchType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424CUpti_ActivityLaunchType", "priority": 1, "content": "enum  CUpti_ActivityLaunchType The type of the CUDA kernel launch. Values:", "keywords": []}, {"id": 539, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST", "display_name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType42CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLISTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_CBL_COMMANDLIST The kernel was launched as a CBL commandlist.", "keywords": []}, {"id": 540, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE", "display_name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType51CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_MULTI_DEVICE The kernel was launched via API cudaLaunchCooperativeKernelMultiDevice() or cuLaunchCooperativeKernelMultiDevice()", "keywords": []}, {"id": 541, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE", "display_name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType52CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_COOPERATIVE_SINGLE_DEVICE The kernel was launched via API cudaLaunchCooperativeKernel() or cuLaunchCooperativeKernel()", "keywords": []}, {"id": 542, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR", "display_name": "CUpti_ActivityLaunchType::CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityLaunchType34CUPTI_ACTIVITY_LAUNCH_TYPE_REGULARE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_LAUNCH_TYPE_REGULAR The kernel was launched via a regular kernel call.", "keywords": []}, {"id": 543, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind", "display_name": "CUpti_ActivityMemcpyKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424CUpti_ActivityMemcpyKind", "priority": 1, "content": "enum  CUpti_ActivityMemcpyKind The kind of a memory copy, indicating the source and destination targets of the copy. Each kind represents the source and destination targets of a memory copy. Targets are host, device, and array. Values:", "keywords": []}, {"id": 544, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOA", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOA A device array to device array memory copy.", "keywords": []}, {"id": 545, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOD", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOD A device array to device memory copy.", "keywords": []}, {"id": 546, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOH", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_ATOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_ATOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_ATOH A device array to host memory copy.", "keywords": []}, {"id": 547, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOA", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOA A device to device array memory copy.", "keywords": []}, {"id": 548, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOD", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOD A device to device memory copy on the same device.", "keywords": []}, {"id": 549, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOH", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_DTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_DTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_DTOH A device to host memory copy.", "keywords": []}, {"id": 550, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind36CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_FORCE_INT", "keywords": []}, {"id": 551, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOA", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTOAE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOA A host to device array memory copy.", "keywords": []}, {"id": 552, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOD", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOD A host to device memory copy.", "keywords": []}, {"id": 553, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOH", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_HTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_HTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_HTOH A host to host memory copy.", "keywords": []}, {"id": 554, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_PTOP", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_PTOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind31CUPTI_ACTIVITY_MEMCPY_KIND_PTOPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_PTOP A peer to peer memory copy across different devices.", "keywords": []}, {"id": 555, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN", "display_name": "CUpti_ActivityMemcpyKind::CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemcpyKind34CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMCPY_KIND_UNKNOWN The memory copy kind is not known.", "keywords": []}, {"id": 556, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind", "display_name": "CUpti_ActivityMemoryKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424CUpti_ActivityMemoryKind", "priority": 1, "content": "enum  CUpti_ActivityMemoryKind The kinds of memory accessed by a memory operation/copy. Each kind represents the type of the memory accessed by a memory operation/copy. Values:", "keywords": []}, {"id": 557, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_ARRAY", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_ARRAY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind32CUPTI_ACTIVITY_MEMORY_KIND_ARRAYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_ARRAY The memory is an array.", "keywords": []}, {"id": 558, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_DEVICE", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind33CUPTI_ACTIVITY_MEMORY_KIND_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE The memory is on the device.", "keywords": []}, {"id": 559, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind40CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_DEVICE_STATIC The memory is device static.", "keywords": []}, {"id": 560, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind36CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_FORCE_INT", "keywords": []}, {"id": 561, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_MANAGED", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_MANAGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind34CUPTI_ACTIVITY_MEMORY_KIND_MANAGEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED The memory is managed.", "keywords": []}, {"id": 562, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind41CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_MANAGED_STATIC The memory is managed static.", "keywords": []}, {"id": 563, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind35CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_PAGEABLE The memory is pageable.", "keywords": []}, {"id": 564, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_PINNED", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_PINNED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind33CUPTI_ACTIVITY_MEMORY_KIND_PINNEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_PINNED The memory is pinned.", "keywords": []}, {"id": 565, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN", "display_name": "CUpti_ActivityMemoryKind::CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityMemoryKind34CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_KIND_UNKNOWN The memory kind is unknown.", "keywords": []}, {"id": 566, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryOperationType", "display_name": "CUpti_ActivityMemoryOperationType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433CUpti_ActivityMemoryOperationType", "priority": 1, "content": "enum  CUpti_ActivityMemoryOperationType Memory operation types. Describes the type of memory operation, to be used with CUpti_ActivityMemory4 . Values:", "keywords": []}, {"id": 567, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION", "display_name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType47CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_ALLOCATION Memory is allocated.", "keywords": []}, {"id": 568, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "display_name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType46CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 569, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID", "display_name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType44CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 570, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE", "display_name": "CUpti_ActivityMemoryOperationType::CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivityMemoryOperationType44CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_OPERATION_TYPE_RELEASE Memory is released.", "keywords": []}, {"id": 571, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType", "display_name": "CUpti_ActivityMemoryPoolOperationType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437CUpti_ActivityMemoryPoolOperationType", "priority": 1, "content": "enum  CUpti_ActivityMemoryPoolOperationType Memory pool operation types. Describes the type of memory pool operation, to be used with CUpti_ActivityMemoryPool2 . Values:", "keywords": []}, {"id": 572, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED", "display_name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_CREATED Memory pool is created.", "keywords": []}, {"id": 573, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED", "display_name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType51CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_DESTROYED Memory pool is destroyed.", "keywords": []}, {"id": 574, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "display_name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType51CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_FORCE_INT", "keywords": []}, {"id": 575, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID", "display_name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 576, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED", "display_name": "CUpti_ActivityMemoryPoolOperationType::CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityMemoryPoolOperationType49CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_OPERATION_TYPE_TRIMMED Memory pool is trimmed.", "keywords": []}, {"id": 577, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolType", "display_name": "CUpti_ActivityMemoryPoolType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428CUpti_ActivityMemoryPoolType", "priority": 1, "content": "enum  CUpti_ActivityMemoryPoolType Memory pool types. Describes the type of memory pool, to be used with CUpti_ActivityMemory4 . Values:", "keywords": []}, {"id": 578, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "display_name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType41CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_FORCE_INT", "keywords": []}, {"id": 579, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED", "display_name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType40CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_IMPORTED Memory pool is imported by the process.", "keywords": []}, {"id": 580, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID", "display_name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType39CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_INVALID The operation is invalid.", "keywords": []}, {"id": 581, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL", "display_name": "CUpti_ActivityMemoryPoolType::CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityMemoryPoolType37CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCALE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_MEMORY_POOL_TYPE_LOCAL Memory pool is local to the process.", "keywords": []}, {"id": 582, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind", "display_name": "CUpti_ActivityObjectKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424CUpti_ActivityObjectKind", "priority": 1, "content": "enum  CUpti_ActivityObjectKind The kinds of activity objects. CUpti_ActivityObjectKindId  Values:", "keywords": []}, {"id": 583, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_CONTEXT", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_CONTEXT A context.", "keywords": []}, {"id": 584, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_DEVICE", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_DEVICE A device.", "keywords": []}, {"id": 585, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_FORCE_INT", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind31CUPTI_ACTIVITY_OBJECT_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_FORCE_INT", "keywords": []}, {"id": 586, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_PROCESS", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_PROCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_PROCESSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_PROCESS A process.", "keywords": []}, {"id": 587, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_STREAM", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_STREAM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_STREAME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_STREAM A stream.", "keywords": []}, {"id": 588, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_THREAD", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_THREAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind28CUPTI_ACTIVITY_OBJECT_THREADE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_THREAD A thread.", "keywords": []}, {"id": 589, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_UNKNOWN", "display_name": "CUpti_ActivityObjectKind::CUPTI_ACTIVITY_OBJECT_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityObjectKind29CUPTI_ACTIVITY_OBJECT_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OBJECT_UNKNOWN The object kind is not known.", "keywords": []}, {"id": 590, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind", "display_name": "CUpti_ActivityOverheadKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426CUpti_ActivityOverheadKind", "priority": 1, "content": "enum  CUpti_ActivityOverheadKind The kinds of activity overhead. Values:", "keywords": []}, {"id": 591, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind47CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUESTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_ACTIVITY_BUFFER_REQUEST Overhead due to activity buffer request.", "keywords": []}, {"id": 592, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind43CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL Overhead due to lack of command buffer space. Refer CUpti_ActivityOverheadCommandBufferFullData for more details.", "keywords": []}, {"id": 593, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind42CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_BUFFER_FLUSH Activity buffer flush overhead.", "keywords": []}, {"id": 594, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind45CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_INSTRUMENTATION CUPTI instrumentation overhead.", "keywords": []}, {"id": 595, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind38CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_CUPTI_RESOURCE CUPTI resource creation and destruction overhead.", "keywords": []}, {"id": 596, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind39CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_DRIVER_COMPILER Compiler overhead.", "keywords": []}, {"id": 597, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind33CUPTI_ACTIVITY_OVERHEAD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_FORCE_INT", "keywords": []}, {"id": 598, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind45CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_LAZY_FUNCTION_LOADING Lazy function loading overhead.", "keywords": []}, {"id": 599, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind56CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_RUNTIME_TRIGGERED_MODULE_LOADING CUDA Runtime triggered module loading overhead.", "keywords": []}, {"id": 600, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_UNKNOWN", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind31CUPTI_ACTIVITY_OVERHEAD_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_UNKNOWN The overhead kind is not known.", "keywords": []}, {"id": 601, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT", "display_name": "CUpti_ActivityOverheadKind::CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityOverheadKind41CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INITE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_OVERHEAD_UVM_ACTIVITY_INIT Overhead due to UVM activity initialization.", "keywords": []}, {"id": 602, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod", "display_name": "CUpti_ActivityPCSamplingPeriod", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430CUpti_ActivityPCSamplingPeriod", "priority": 1, "content": "enum  CUpti_ActivityPCSamplingPeriod Sampling period for PC sampling method. Sampling period can be set using cuptiActivityConfigurePCSampling  Values:", "keywords": []}, {"id": 603, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod43CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_FORCE_INT", "keywords": []}, {"id": 604, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod38CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_HIGH Sampling period in higher range.", "keywords": []}, {"id": 605, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod41CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_INVALID The PC sampling period is not set.", "keywords": []}, {"id": 606, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOWE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_LOW Sampling period in lower range.", "keywords": []}, {"id": 607, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAXE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MAX Maximum sampling period available on the device.", "keywords": []}, {"id": 608, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MID Medium sampling period.", "keywords": []}, {"id": 609, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN", "display_name": "CUpti_ActivityPCSamplingPeriod::CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_ActivityPCSamplingPeriod37CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MINE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_PERIOD_MIN Minimum sampling period available on the device.", "keywords": []}, {"id": 610, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason", "display_name": "CUpti_ActivityPCSamplingStallReason", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv435CUpti_ActivityPCSamplingStallReason", "priority": 1, "content": "enum  CUpti_ActivityPCSamplingStallReason The stall reason for PC sampling activity. Values:", "keywords": []}, {"id": 611, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason59CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_CONSTANT_MEMORY_DEPENDENCY Warp is blocked waiting for constant memory and immediate memory access to complete.", "keywords": []}, {"id": 612, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason48CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_EXEC_DEPENDENCY Instruction is waiting on an arithmetic dependency.", "keywords": []}, {"id": 613, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason42CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_FORCE_INT", "keywords": []}, {"id": 614, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason43CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INST_FETCH Warp is blocked because next instruction is not yet available, because of instruction cache miss, or because of branching effects.", "keywords": []}, {"id": 615, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason40CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_INVALID Invalid reason.", "keywords": []}, {"id": 616, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason50CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_DEPENDENCY Warp is blocked because it is waiting for a memory access to complete.", "keywords": []}, {"id": 617, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason48CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_MEMORY_THROTTLE Warp is blocked because there are too many pending memory operations. In Kepler architecture it often indicates high number of memory replays.", "keywords": []}, {"id": 618, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason37CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NONE No stall, instruction is selected for issue.", "keywords": []}, {"id": 619, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason45CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_NOT_SELECTED Warp was ready to issue, but some other warp issued instead.", "keywords": []}, {"id": 620, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason38CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_OTHER Miscellaneous reasons.", "keywords": []}, {"id": 621, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason42CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_PIPE_BUSY Compute operation cannot be performed due to the required resources not being available.", "keywords": []}, {"id": 622, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason41CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SLEEPING Sleeping.", "keywords": []}, {"id": 623, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason37CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNCE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_SYNC Warp is blocked as it is waiting at __syncthreads() or at memory barrier.", "keywords": []}, {"id": 624, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE", "display_name": "CUpti_ActivityPCSamplingStallReason::CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N35CUpti_ActivityPCSamplingStallReason40CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTUREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PC_SAMPLING_STALL_TEXTURE Texture sub-system is fully utilized or has too many outstanding requests.", "keywords": []}, {"id": 625, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv442CUpti_ActivityPartitionedGlobalCacheConfig", "priority": 1, "content": "enum  CUpti_ActivityPartitionedGlobalCacheConfig Partitioned global caching option. Values:", "keywords": []}, {"id": 626, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig56CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_FORCE_INT", "keywords": []}, {"id": 627, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig60CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTEDE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_NOT_SUPPORTED Partitioned global cache not supported.", "keywords": []}, {"id": 628, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig50CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFFE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_OFF Partitioned global cache config off.", "keywords": []}, {"id": 629, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig49CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_ON Partitioned global cache config on.", "keywords": []}, {"id": 630, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN", "display_name": "CUpti_ActivityPartitionedGlobalCacheConfig::CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ActivityPartitionedGlobalCacheConfig54CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PARTITIONED_GLOBAL_CACHE_CONFIG_UNKNOWN Partitioned global cache config unknown.", "keywords": []}, {"id": 631, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPreemptionKind", "display_name": "CUpti_ActivityPreemptionKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428CUpti_ActivityPreemptionKind", "priority": 1, "content": "enum  CUpti_ActivityPreemptionKind The kind of a preemption activity. Values:", "keywords": []}, {"id": 632, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "display_name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind40CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_FORCE_INT", "keywords": []}, {"id": 633, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE", "display_name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind38CUPTI_ACTIVITY_PREEMPTION_KIND_RESTOREE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_RESTORE Preemption to restore CDP block.", "keywords": []}, {"id": 634, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE", "display_name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind35CUPTI_ACTIVITY_PREEMPTION_KIND_SAVEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_SAVE Preemption to save CDP block.", "keywords": []}, {"id": 635, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN", "display_name": "CUpti_ActivityPreemptionKind::CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N28CUpti_ActivityPreemptionKind38CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_PREEMPTION_KIND_UNKNOWN The preemption kind is not known.", "keywords": []}, {"id": 636, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag", "display_name": "CUpti_ActivityStreamFlag", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424CUpti_ActivityStreamFlag", "priority": 1, "content": "enum  CUpti_ActivityStreamFlag stream type. The types of stream to be used with CUpti_ActivityStream . Values:", "keywords": []}, {"id": 637, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag41CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_DEFAULT Default stream.", "keywords": []}, {"id": 638, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag43CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_FORCE_INT", "keywords": []}, {"id": 639, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag46CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NON_BLOCKING Non-blocking stream.", "keywords": []}, {"id": 640, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag38CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULLE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_NULL Null stream.", "keywords": []}, {"id": 641, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag41CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_FLAG_UNKNOWN Unknown data.", "keywords": []}, {"id": 642, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_MASK", "display_name": "CUpti_ActivityStreamFlag::CUPTI_ACTIVITY_STREAM_CREATE_MASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N24CUpti_ActivityStreamFlag33CUPTI_ACTIVITY_STREAM_CREATE_MASKE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_STREAM_CREATE_MASK Stream create Mask.", "keywords": []}, {"id": 643, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType", "display_name": "CUpti_ActivitySynchronizationType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433CUpti_ActivitySynchronizationType", "priority": 1, "content": "enum  CUpti_ActivitySynchronizationType Synchronization type. The types of synchronization to be used with CUpti_ActivitySynchronization2 . Values:", "keywords": []}, {"id": 644, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType55CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_CONTEXT_SYNCHRONIZE Context synchronize API.", "keywords": []}, {"id": 645, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType53CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_EVENT_SYNCHRONIZE Event synchronize API.", "keywords": []}, {"id": 646, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType45CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_FORCE_INT", "keywords": []}, {"id": 647, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType54CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_SYNCHRONIZE Stream synchronize API.", "keywords": []}, {"id": 648, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType53CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_STREAM_WAIT_EVENT Stream wait event API.", "keywords": []}, {"id": 649, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN", "display_name": "CUpti_ActivitySynchronizationType::CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N33CUpti_ActivitySynchronizationType43CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_SYNCHRONIZATION_TYPE_UNKNOWN Unknown data.", "keywords": []}, {"id": 650, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityThreadIdType", "display_name": "CUpti_ActivityThreadIdType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426CUpti_ActivityThreadIdType", "priority": 1, "content": "enum  CUpti_ActivityThreadIdType Thread-Id types. CUPTI uses different methods to obtain the thread-id depending on the support and the underlying platform. This enum documents these methods for each type. APIs cuptiSetThreadIdType and cuptiGetThreadIdType can be used to set and get the thread-id type. Values:", "keywords": []}, {"id": 651, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT", "display_name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType37CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_DEFAULT Default type Windows uses API GetCurrentThreadId() Linux/Mac/Android/QNX use POSIX pthread API pthread_self()", "keywords": []}, {"id": 652, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "display_name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType39CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_FORCE_INT", "keywords": []}, {"id": 653, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE", "display_name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType34CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_SIZE Add new enums before this field.", "keywords": []}, {"id": 654, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM", "display_name": "CUpti_ActivityThreadIdType::CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_ActivityThreadIdType36CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEME", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_THREAD_ID_TYPE_SYSTEM This type is based on the system API available on the underlying platform and thread-id obtained is supposed to be unique for the process lifetime. Windows uses API GetCurrentThreadId() Linux uses syscall SYS_gettid Mac uses syscall SYS_thread_selfid Android/QNX use gettid()", "keywords": []}, {"id": 655, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType", "display_name": "CUpti_ActivityUnifiedMemoryAccessType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437CUpti_ActivityUnifiedMemoryAccessType", "priority": 1, "content": "enum  CUpti_ActivityUnifiedMemoryAccessType Memory access type for unified memory page faults. This is valid for CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT and CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT  Values:", "keywords": []}, {"id": 656, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC", "display_name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType48CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_ATOMIC The page fault was triggered by atomic memory instruction.", "keywords": []}, {"id": 657, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH", "display_name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType50CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_PREFETCH The page fault was triggered by memory prefetch operation.", "keywords": []}, {"id": 658, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ", "display_name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType46CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_READ The page fault was triggered by read memory instruction.", "keywords": []}, {"id": 659, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN", "display_name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType49CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_UNKNOWN The unified memory access type is not known.", "keywords": []}, {"id": 660, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE", "display_name": "CUpti_ActivityUnifiedMemoryAccessType::CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_ActivityUnifiedMemoryAccessType47CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_ACCESS_TYPE_WRITE The page fault was triggered by write memory instruction.", "keywords": []}, {"id": 661, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438CUpti_ActivityUnifiedMemoryCounterKind", "priority": 1, "content": "enum  CUpti_ActivityUnifiedMemoryCounterKind Kind of the Unified Memory counter. Many activities are associated with Unified Memory mechanism; among them are transfers from host to device, device to host, page fault at host side. Values:", "keywords": []}, {"id": 662, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOD Number of bytes transferred from one device to another device. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 663, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH Number of bytes transferred from device to host.", "keywords": []}, {"id": 664, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind62CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTODE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD Number of bytes transferred from host to device.", "keywords": []}, {"id": 665, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind48CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_COUNT", "keywords": []}, {"id": 666, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind63CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_CPU_PAGE_FAULT_COUNT Number of CPU page faults, this is only supported on 64 bit Linux and Mac platforms.", "keywords": []}, {"id": 667, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind52CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_FORCE_INT", "keywords": []}, {"id": 668, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind57CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_GPU_PAGE_FAULT Number of GPU page faults, this is only supported on devices with compute capability 6.0 and higher and 64 bit Linux platforms.", "keywords": []}, {"id": 669, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAPE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP In case throttling does not help, the driver tries to pin the memory to a processor for a specific period of time. One of the contending processors will have slow access to the memory, while the other will have fast access. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 670, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind52CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THRASHING Thrashing occurs when data is frequently accessed by multiple processors and has to be constantly migrated around to achieve data locality. In this case the overhead of migration may exceed the benefits of locality. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 671, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_THROTTLING Throttling is a prevention technique used by the driver to avoid further thrashing. Here, the driver doesn\u2019t service the fault for one of the contending processors for a specific period of time, so that the other processor can run at full-speed. This is only supported on 64 bit Linux platforms.", "keywords": []}, {"id": 672, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN", "display_name": "CUpti_ActivityUnifiedMemoryCounterKind::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N38CUpti_ActivityUnifiedMemoryCounterKind50CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_UNKNOWN The unified memory counter kind is not known.", "keywords": []}, {"id": 673, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv439CUpti_ActivityUnifiedMemoryCounterScope", "priority": 1, "content": "enum  CUpti_ActivityUnifiedMemoryCounterScope Scope of the unified memory counter (deprecated in CUDA 7.0) Values:", "keywords": []}, {"id": 674, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope49CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_COUNT", "keywords": []}, {"id": 675, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope53CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_FORCE_INT", "keywords": []}, {"id": 676, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope63CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICESE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_ALL_DEVICES Collect unified memory counter for single process across all devices.", "keywords": []}, {"id": 677, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope65CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_PROCESS_SINGLE_DEVICE Collect unified memory counter for single process on one device.", "keywords": []}, {"id": 678, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN", "display_name": "CUpti_ActivityUnifiedMemoryCounterScope::CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N39CUpti_ActivityUnifiedMemoryCounterScope51CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_SCOPE_UNKNOWN The unified memory counter scope is not known.", "keywords": []}, {"id": 679, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv441CUpti_ActivityUnifiedMemoryMigrationCause", "priority": 1, "content": "enum  CUpti_ActivityUnifiedMemoryMigrationCause Migration cause of the Unified Memory counter. This is valid for CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_HTOD and CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_BYTES_TRANSFER_DTOH  Values:", "keywords": []}, {"id": 680, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause61CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERSE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_ACCESS_COUNTERS The unified memory migrated to another processor because of access counter notifications. Only frequently accessed pages are migrated between CPU and GPU, or between peer GPUs.", "keywords": []}, {"id": 681, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause55CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_COHERENCE The unified memory migrated to guarantee data coherence e.g. CPU/GPU faults on Pascal+ and kernel launch on pre-Pascal GPUs", "keywords": []}, {"id": 682, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_EVICTION The unified memory migrated to the CPU because it was evicted to make room for another block of memory on the GPU.", "keywords": []}, {"id": 683, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCHE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_PREFETCH The unified memory was speculatively migrated by the UVM driver before being accessed by the destination processor to improve performance.", "keywords": []}, {"id": 684, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause53CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_UNKNOWN The unified memory migration cause is not known.", "keywords": []}, {"id": 685, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER", "display_name": "CUpti_ActivityUnifiedMemoryMigrationCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryMigrationCause50CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USERE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_MIGRATION_CAUSE_USER The unified memory migrated due to an explicit call from the user e.g. cudaMemPrefetchAsync", "keywords": []}, {"id": 686, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv441CUpti_ActivityUnifiedMemoryRemoteMapCause", "priority": 1, "content": "enum  CUpti_ActivityUnifiedMemoryRemoteMapCause Remote memory map cause of the Unified Memory counter. This is valid for CUPTI_ACTIVITY_UNIFIED_MEMORY_COUNTER_KIND_REMOTE_MAP  Values:", "keywords": []}, {"id": 687, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause56CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCEE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_COHERENCE Mapping to remote memory was added to maintain data coherence.", "keywords": []}, {"id": 688, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause55CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTIONE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_EVICTION Mapping to remote memory was added after the memory was evicted to make room for another block of memory on the GPU.", "keywords": []}, {"id": 689, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause60CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_OUT_OF_MEMORY Mapping to remote memory was added because there is no more memory available on the processor and eviction was not possible.", "keywords": []}, {"id": 690, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause53CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICYE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_POLICY Mapping to remote memory was added to enforce the hints specified by the programmer or by performance heuristics of the UVM driver.", "keywords": []}, {"id": 691, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause56CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHINGE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_THRASHING Mapping to remote memory was added to prevent further thrashing.", "keywords": []}, {"id": 692, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN", "display_name": "CUpti_ActivityUnifiedMemoryRemoteMapCause::CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N41CUpti_ActivityUnifiedMemoryRemoteMapCause54CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_ACTIVITY_UNIFIED_MEMORY_REMOTE_MAP_CAUSE_UNKNOWN The cause of mapping to remote memory was unknown.", "keywords": []}, {"id": 693, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_BuffersCallbackCompleteFunc", "display_name": "CUpti_BuffersCallbackCompleteFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433CUpti_BuffersCallbackCompleteFunc", "priority": 1, "content": "typedef  void  ( * CUpti_BuffersCallbackCompleteFunc ) ( CUcontext  context ,  uint32_t  streamId ,  uint8_t  * buffer ,  size_t  size ,  size_t  validSize ) Function type for callback used by CUPTI to return a buffer of activity records. This callback function returns to the CUPTI client a buffer containing activity records. The buffer contains validSize bytes of activity records which should be read using cuptiActivityGetNextRecord. The number of dropped records can be read using cuptiActivityGetNumDroppedRecords. After this call CUPTI relinquished ownership of the buffer and will not use it anymore. The client may return the buffer to CUPTI using the CUpti_BuffersCallbackRequestFunc callback. Note: CUDA 6.0 onwards, all buffers returned by this callback are global buffers i.e. there is no context/stream specific buffer. User needs to parse the global buffer to extract the context/stream specific activity records. Param context The context this buffer is associated with. If NULL, the buffer is associated with the global activities. This field is deprecated as of CUDA 6.0 and will always be NULL. Param streamId The stream id this buffer is associated with. This field is deprecated as of CUDA 6.0 and will always be NULL. Param buffer The activity record buffer. Param size The total size of the buffer in bytes as set in CUpti_BuffersCallbackRequestFunc. Param validSize The number of valid bytes in the buffer.", "keywords": []}, {"id": 694, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_BuffersCallbackRequestFunc", "display_name": "CUpti_BuffersCallbackRequestFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv432CUpti_BuffersCallbackRequestFunc", "priority": 1, "content": "typedef  void  ( * CUpti_BuffersCallbackRequestFunc ) ( uint8_t  * * buffer ,  size_t  * size ,  size_t  * maxNumRecords ) Function type for callback used by CUPTI to request an empty buffer for storing activity records. This callback function signals the CUPTI client that an activity buffer is needed by CUPTI. The activity buffer is used by CUPTI to store activity records. The callback function can decline the request by setting *buffer to NULL. In this case CUPTI may drop activity records. Param buffer Returns the new buffer. If set to NULL then no buffer is returned. Param size Returns the size of the returned buffer. Param maxNumRecords Returns the maximum number of records that should be placed in the buffer. If 0 then the buffer is filled with as many records as possible. If &gt; 0 the buffer is filled with at most that many records before it is returned.", "keywords": []}, {"id": 695, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType", "display_name": "CUpti_ChannelType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417CUpti_ChannelType", "priority": 1, "content": "enum  CUpti_ChannelType Values:", "keywords": []}, {"id": 696, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY", "display_name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType31CUPTI_CHANNEL_TYPE_ASYNC_MEMCPYE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_ASYNC_MEMCPY Channel is used by an asynchronous copy engine For confidential compute configurations, work launch and completion are done using the copy engines.", "keywords": []}, {"id": 697, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_COMPUTE", "display_name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_COMPUTE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType26CUPTI_CHANNEL_TYPE_COMPUTEE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_COMPUTE Channel is used for standard work launch and tracking.", "keywords": []}, {"id": 698, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_DECOMP", "display_name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_DECOMP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType25CUPTI_CHANNEL_TYPE_DECOMPE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_DECOMP Channel is used for memory decompression operations.", "keywords": []}, {"id": 699, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_FORCE_INT", "display_name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType28CUPTI_CHANNEL_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_FORCE_INT", "keywords": []}, {"id": 700, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_INVALID", "display_name": "CUpti_ChannelType::CUPTI_CHANNEL_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N17CUpti_ChannelType26CUPTI_CHANNEL_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CHANNEL_TYPE_INVALID", "keywords": []}, {"id": 701, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType", "display_name": "CUpti_ConfidentialComputeRotationEventType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv442CUpti_ConfidentialComputeRotationEventType", "priority": 1, "content": "enum  CUpti_ConfidentialComputeRotationEventType Values:", "keywords": []}, {"id": 702, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "display_name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType47CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_EVENT_TYPE_FORCE_INT", "keywords": []}, {"id": 703, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "display_name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType49CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENTE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_INVALID_ROTATION_EVENT", "keywords": []}, {"id": 704, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED", "display_name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType55CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_BLOCKED This channel has been blocked from accepting new CUDA work so a key rotation can be done.", "keywords": []}, {"id": 705, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED", "display_name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType55CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_DRAINED This channel remains blocked and all queued CUDA work has completed. Other clients or channels may cause delays in starting the key rotation.", "keywords": []}, {"id": 706, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED", "display_name": "CUpti_ConfidentialComputeRotationEventType::CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N42CUpti_ConfidentialComputeRotationEventType57CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKEDE", "priority": 1, "content": "enumerator  CUPTI_CONFIDENTIAL_COMPUTE_KEY_ROTATION_CHANNEL_UNBLOCKED Key rotations have completed and this channel is unblocked.", "keywords": []}, {"id": 707, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ContextCigMode", "display_name": "CUpti_ContextCigMode", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420CUpti_ContextCigMode", "priority": 1, "content": "enum  CUpti_ContextCigMode CIG (CUDA in Graphics) Modes. Describes the CIG modes associated with the CUDA context. Values:", "keywords": []}, {"id": 708, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_CIG", "display_name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_CIG", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode26CUPTI_CONTEXT_CIG_MODE_CIGE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_CIG CIG mode.", "keywords": []}, {"id": 709, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK", "display_name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode35CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACKE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_CIG_FALLBACK CIG fallback mode.", "keywords": []}, {"id": 710, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "display_name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode32CUPTI_CONTEXT_CIG_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_FORCE_INT", "keywords": []}, {"id": 711, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_NONE", "display_name": "CUpti_ContextCigMode::CUPTI_CONTEXT_CIG_MODE_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_ContextCigMode27CUPTI_CONTEXT_CIG_MODE_NONEE", "priority": 1, "content": "enumerator  CUPTI_CONTEXT_CIG_MODE_NONE Regular (non-CIG) mode.", "keywords": []}, {"id": 712, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DevType", "display_name": "CUpti_DevType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv413CUpti_DevType", "priority": 1, "content": "enum  CUpti_DevType The device type for device connected to NVLink. Values:", "keywords": []}, {"id": 713, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DevType::CUPTI_DEV_TYPE_FORCE_INT", "display_name": "CUpti_DevType::CUPTI_DEV_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType24CUPTI_DEV_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_FORCE_INT", "keywords": []}, {"id": 714, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DevType::CUPTI_DEV_TYPE_GPU", "display_name": "CUpti_DevType::CUPTI_DEV_TYPE_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType18CUPTI_DEV_TYPE_GPUE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_GPU The device type is GPU.", "keywords": []}, {"id": 715, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DevType::CUPTI_DEV_TYPE_INVALID", "display_name": "CUpti_DevType::CUPTI_DEV_TYPE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType22CUPTI_DEV_TYPE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_INVALID", "keywords": []}, {"id": 716, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DevType::CUPTI_DEV_TYPE_NPU", "display_name": "CUpti_DevType::CUPTI_DEV_TYPE_NPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_DevType18CUPTI_DEV_TYPE_NPUE", "priority": 1, "content": "enumerator  CUPTI_DEV_TYPE_NPU The device type is NVLink processing unit in CPU.", "keywords": []}, {"id": 717, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceGraphLaunchMode", "display_name": "CUpti_DeviceGraphLaunchMode", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv427CUpti_DeviceGraphLaunchMode", "priority": 1, "content": "enum  CUpti_DeviceGraphLaunchMode The launch mode for device graph execution. Values:", "keywords": []}, {"id": 718, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "display_name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode46CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGETE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET", "keywords": []}, {"id": 719, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "display_name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode57CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLINGE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_FIRE_AND_FORGET_AS_SIBLING", "keywords": []}, {"id": 720, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "display_name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode38CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_INVALID", "keywords": []}, {"id": 721, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "display_name": "CUpti_DeviceGraphLaunchMode::CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N27CUpti_DeviceGraphLaunchMode35CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAILE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_GRAPH_LAUNCH_MODE_TAIL", "keywords": []}, {"id": 722, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceVirtualizationMode", "display_name": "CUpti_DeviceVirtualizationMode", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430CUpti_DeviceVirtualizationMode", "priority": 1, "content": "enum  CUpti_DeviceVirtualizationMode This indicates the virtualization mode in which CUDA device is running. Values:", "keywords": []}, {"id": 723, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "display_name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode42CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_FORCE_INT", "keywords": []}, {"id": 724, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE", "display_name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode37CUPTI_DEVICE_VIRTUALIZATION_MODE_NONEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_NONE No virtualization mode is associated with the device i.e. it\u2019s a baremetal GPU", "keywords": []}, {"id": 725, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH", "display_name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode45CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_PASS_THROUGH The device is associated with the pass-through GPU. In this mode, an entire physical GPU is directly assigned to one virtual machine (VM).", "keywords": []}, {"id": 726, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU", "display_name": "CUpti_DeviceVirtualizationMode::CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N30CUpti_DeviceVirtualizationMode44CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPUE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_VIRTUALIZATION_MODE_VIRTUAL_GPU The device is associated with the virtual GPU (vGPU). In this mode multiple virtual machines (VMs) have simultaneous, direct access to a single physical GPU.", "keywords": []}, {"id": 727, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason", "display_name": "CUpti_EnvironmentClocksThrottleReason", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437CUpti_EnvironmentClocksThrottleReason", "priority": 1, "content": "enum  CUpti_EnvironmentClocksThrottleReason Reasons for clock throttling. The possible reasons that a clock can be throttled. There can be more than one reason that a clock is being throttled so these types can be combined by bitwise OR. These are used in the clocksThrottleReason field in the Environment Activity Record. Values:", "keywords": []}, {"id": 728, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason38CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_FORCE_INT", "keywords": []}, {"id": 729, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason37CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLEE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_GPU_IDLE Nothing is running on the GPU and the clocks are dropping to idle state.", "keywords": []}, {"id": 730, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason40CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWNE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_HW_SLOWDOWN Hardware slowdown to reduce the clock by a factor of two or more is engaged. This is an indicator of one of the following: 1) Temperature is too high, 2) External power brake assertion is being triggered (e.g. by the system power supply), 3) Change in power state.", "keywords": []}, {"id": 731, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_NONE", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason33CUPTI_CLOCKS_THROTTLE_REASON_NONEE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_NONE No clock throttling.", "keywords": []}, {"id": 732, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason41CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAPE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_SW_POWER_CAP A software power scaling algorithm is reducing the clocks below requested clocks.", "keywords": []}, {"id": 733, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason36CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_UNKNOWN Some unspecified factor is reducing the clocks.", "keywords": []}, {"id": 734, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason40CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTEDE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_UNSUPPORTED Throttle reason is not supported for this GPU.", "keywords": []}, {"id": 735, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS", "display_name": "CUpti_EnvironmentClocksThrottleReason::CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N37CUpti_EnvironmentClocksThrottleReason48CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKSE", "priority": 1, "content": "enumerator  CUPTI_CLOCKS_THROTTLE_REASON_USER_DEFINED_CLOCKS The GPU clocks are limited by a user specified limit.", "keywords": []}, {"id": 736, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind", "display_name": "CUpti_ExternalCorrelationKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429CUpti_ExternalCorrelationKind", "priority": 1, "content": "enum  CUpti_ExternalCorrelationKind The kind of external APIs supported for correlation. Custom correlation kinds are reserved for usage in external tools. CUpti_ActivityExternalCorrelation  Values:", "keywords": []}, {"id": 737, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM0 The external API is custom0.", "keywords": []}, {"id": 738, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM1 The external API is custom1.", "keywords": []}, {"id": 739, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2E", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_CUSTOM2 The external API is custom2.", "keywords": []}, {"id": 740, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind41CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_FORCE_INT", "keywords": []}, {"id": 741, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_INVALID", "keywords": []}, {"id": 742, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_OPENACCE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_OPENACC The external API is OpenACC.", "keywords": []}, {"id": 743, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_SIZE", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind36CUPTI_EXTERNAL_CORRELATION_KIND_SIZEE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_SIZE Add new kinds before this line.", "keywords": []}, {"id": 744, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN", "display_name": "CUpti_ExternalCorrelationKind::CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N29CUpti_ExternalCorrelationKind39CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_EXTERNAL_CORRELATION_KIND_UNKNOWN The external API is unknown to CUPTI.", "keywords": []}, {"id": 745, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_FuncShmemLimitConfig", "display_name": "CUpti_FuncShmemLimitConfig", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426CUpti_FuncShmemLimitConfig", "priority": 1, "content": "enum  CUpti_FuncShmemLimitConfig The shared memory limit per block config for a kernel This should be used to set \u2018cudaOccFuncShmemConfig\u2019 field in occupancy calculator API. Values:", "keywords": []}, {"id": 746, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_DEFAULT", "display_name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_DEFAULT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig30CUPTI_FUNC_SHMEM_LIMIT_DEFAULTE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_DEFAULT The shared memory limit config is default.", "keywords": []}, {"id": 747, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "display_name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig32CUPTI_FUNC_SHMEM_LIMIT_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_FORCE_INT", "keywords": []}, {"id": 748, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_OPTIN", "display_name": "CUpti_FuncShmemLimitConfig::CUPTI_FUNC_SHMEM_LIMIT_OPTIN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_FuncShmemLimitConfig28CUPTI_FUNC_SHMEM_LIMIT_OPTINE", "priority": 1, "content": "enumerator  CUPTI_FUNC_SHMEM_LIMIT_OPTIN User has opted for a higher dynamic shared memory limit using function attribute \u2018cudaFuncAttributeMaxDynamicSharedMemorySize\u2019 for runtime API or CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES for driver API.", "keywords": []}, {"id": 749, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag", "display_name": "CUpti_LinkFlag", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv414CUpti_LinkFlag", "priority": 1, "content": "enum  CUpti_LinkFlag Link flags. Describes link properties, to be used with CUpti_ActivityNvLink . Values:", "keywords": []}, {"id": 750, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_FORCE_INT", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag25CUPTI_LINK_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_FORCE_INT", "keywords": []}, {"id": 751, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_INVALID", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag23CUPTI_LINK_FLAG_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_INVALID The flag is invalid.", "keywords": []}, {"id": 752, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_PEER_ACCESS", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_PEER_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag27CUPTI_LINK_FLAG_PEER_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_PEER_ACCESS Is peer to peer access supported by this link.", "keywords": []}, {"id": 753, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_PEER_ATOMICS", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_PEER_ATOMICS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag28CUPTI_LINK_FLAG_PEER_ATOMICSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_PEER_ATOMICS Is peer atomic access supported by this link.", "keywords": []}, {"id": 754, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_SYSMEM_ACCESS", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_SYSMEM_ACCESS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag29CUPTI_LINK_FLAG_SYSMEM_ACCESSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_SYSMEM_ACCESS Is system memory access supported by this link.", "keywords": []}, {"id": 755, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_SYSMEM_ATOMICS", "display_name": "CUpti_LinkFlag::CUPTI_LINK_FLAG_SYSMEM_ATOMICS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N14CUpti_LinkFlag30CUPTI_LINK_FLAG_SYSMEM_ATOMICSE", "priority": 1, "content": "enumerator  CUPTI_LINK_FLAG_SYSMEM_ATOMICS Is system memory atomic access supported by this link.", "keywords": []}, {"id": 756, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind", "display_name": "CUpti_OpenAccConstructKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426CUpti_OpenAccConstructKind", "priority": 1, "content": "enum  CUpti_OpenAccConstructKind The OpenAcc parent construct kind for OpenAcc activity records. Values:", "keywords": []}, {"id": 757, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind35CUPTI_OPENACC_CONSTRUCT_KIND_ATOMICE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ATOMIC", "keywords": []}, {"id": 758, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_DATA", "keywords": []}, {"id": 759, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_DECLAREE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_DECLARE", "keywords": []}, {"id": 760, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind39CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ENTER_DATA", "keywords": []}, {"id": 761, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_EXIT_DATA", "keywords": []}, {"id": 762, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_FORCE_INT", "keywords": []}, {"id": 763, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind38CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_HOST_DATA", "keywords": []}, {"id": 764, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_INITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_INIT", "keywords": []}, {"id": 765, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_KERNELSE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_KERNELS", "keywords": []}, {"id": 766, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_LOOPE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_LOOP", "keywords": []}, {"id": 767, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind37CUPTI_OPENACC_CONSTRUCT_KIND_PARALLELE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_PARALLEL", "keywords": []}, {"id": 768, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_ROUTINE", "keywords": []}, {"id": 769, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind40CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_APIE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_RUNTIME_API", "keywords": []}, {"id": 770, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_SET", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_SET", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind32CUPTI_OPENACC_CONSTRUCT_KIND_SETE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_SET", "keywords": []}, {"id": 771, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind37CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_SHUTDOWN", "keywords": []}, {"id": 772, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind36CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_UNKNOWN", "keywords": []}, {"id": 773, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind35CUPTI_OPENACC_CONSTRUCT_KIND_UPDATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_UPDATE", "keywords": []}, {"id": 774, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "display_name": "CUpti_OpenAccConstructKind::CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N26CUpti_OpenAccConstructKind33CUPTI_OPENACC_CONSTRUCT_KIND_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_CONSTRUCT_KIND_WAIT", "keywords": []}, {"id": 775, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind", "display_name": "CUpti_OpenAccEventKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv422CUpti_OpenAccEventKind", "priority": 1, "content": "enum  CUpti_OpenAccEventKind The OpenAcc event kind for OpenAcc activity records. CUpti_ActivityKindOpenAcc Values:", "keywords": []}, {"id": 776, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ALLOC", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ALLOC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind30CUPTI_OPENACC_EVENT_KIND_ALLOCE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ALLOC", "keywords": []}, {"id": 777, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind42CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_COMPUTE_CONSTRUCT", "keywords": []}, {"id": 778, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_CREATE", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_CREATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_CREATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_CREATE", "keywords": []}, {"id": 779, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DELETE", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DELETE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_DELETEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DELETE", "keywords": []}, {"id": 780, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind36CUPTI_OPENACC_EVENT_KIND_DEVICE_INITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DEVICE_INIT", "keywords": []}, {"id": 781, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind40CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_DEVICE_SHUTDOWN", "keywords": []}, {"id": 782, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind41CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOADE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_DOWNLOAD", "keywords": []}, {"id": 783, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind39CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCHE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_LAUNCH", "keywords": []}, {"id": 784, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind39CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOADE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENQUEUE_UPLOAD", "keywords": []}, {"id": 785, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind35CUPTI_OPENACC_EVENT_KIND_ENTER_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_ENTER_DATA", "keywords": []}, {"id": 786, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind34CUPTI_OPENACC_EVENT_KIND_EXIT_DATAE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_EXIT_DATA", "keywords": []}, {"id": 787, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind34CUPTI_OPENACC_EVENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_FORCE_INT", "keywords": []}, {"id": 788, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_FREE", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_FREE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind29CUPTI_OPENACC_EVENT_KIND_FREEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_FREE", "keywords": []}, {"id": 789, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind38CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_IMPLICIT_WAIT", "keywords": []}, {"id": 790, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_INVALID", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind32CUPTI_OPENACC_EVENT_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_INVALID", "keywords": []}, {"id": 791, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind41CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWNE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_RUNTIME_SHUTDOWN", "keywords": []}, {"id": 792, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_UPDATE", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_UPDATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind31CUPTI_OPENACC_EVENT_KIND_UPDATEE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_UPDATE", "keywords": []}, {"id": 793, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_WAIT", "display_name": "CUpti_OpenAccEventKind::CUPTI_OPENACC_EVENT_KIND_WAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N22CUpti_OpenAccEventKind29CUPTI_OPENACC_EVENT_KIND_WAITE", "priority": 1, "content": "enumerator  CUPTI_OPENACC_EVENT_KIND_WAIT", "keywords": []}, {"id": 794, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind", "display_name": "CUpti_OpenMpEventKind", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv421CUpti_OpenMpEventKind", "priority": 1, "content": "enum  CUpti_OpenMpEventKind Values:", "keywords": []}, {"id": 795, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind33CUPTI_OPENMP_EVENT_KIND_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_FORCE_INT", "keywords": []}, {"id": 796, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_IDLE", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_IDLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind28CUPTI_OPENMP_EVENT_KIND_IDLEE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_IDLE", "keywords": []}, {"id": 797, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_INVALID", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind31CUPTI_OPENMP_EVENT_KIND_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_INVALID", "keywords": []}, {"id": 798, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_PARALLEL", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_PARALLEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind32CUPTI_OPENMP_EVENT_KIND_PARALLELE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_PARALLEL", "keywords": []}, {"id": 799, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_TASK", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_TASK", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind28CUPTI_OPENMP_EVENT_KIND_TASKE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_TASK", "keywords": []}, {"id": 800, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_THREAD", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_THREAD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind30CUPTI_OPENMP_EVENT_KIND_THREADE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_THREAD", "keywords": []}, {"id": 801, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind36CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIERE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_WAIT_BARRIER", "keywords": []}, {"id": 802, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "display_name": "CUpti_OpenMpEventKind::CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N21CUpti_OpenMpEventKind37CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAITE", "priority": 1, "content": "enumerator  CUPTI_OPENMP_EVENT_KIND_WAIT_TASKWAIT", "keywords": []}, {"id": 803, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieDeviceType", "display_name": "CUpti_PcieDeviceType", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420CUpti_PcieDeviceType", "priority": 1, "content": "enum  CUpti_PcieDeviceType Field to differentiate whether PCIE Activity record is of a GPU or a PCI Bridge. Values:", "keywords": []}, {"id": 804, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_BRIDGE", "display_name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_BRIDGE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType29CUPTI_PCIE_DEVICE_TYPE_BRIDGEE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_BRIDGE PCIE Bridge record.", "keywords": []}, {"id": 805, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "display_name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType32CUPTI_PCIE_DEVICE_TYPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_FORCE_INT", "keywords": []}, {"id": 806, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_GPU", "display_name": "CUpti_PcieDeviceType::CUPTI_PCIE_DEVICE_TYPE_GPU", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N20CUpti_PcieDeviceType26CUPTI_PCIE_DEVICE_TYPE_GPUE", "priority": 1, "content": "enumerator  CUPTI_PCIE_DEVICE_TYPE_GPU PCIE GPU record.", "keywords": []}, {"id": 807, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen", "display_name": "CUpti_PcieGen", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv413CUpti_PcieGen", "priority": 1, "content": "enum  CUpti_PcieGen PCIE Generation. Enumeration of PCIE Generation for pcie activity attribute pcieGeneration Values:", "keywords": []}, {"id": 808, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_FORCE_INT", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen24CUPTI_PCIE_GEN_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_FORCE_INT", "keywords": []}, {"id": 809, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN1", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN1E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN1 PCIE Generation 1.", "keywords": []}, {"id": 810, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN2", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN2", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN2E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN2 PCIE Generation 2.", "keywords": []}, {"id": 811, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN3", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN3", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN3E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN3 PCIE Generation 3.", "keywords": []}, {"id": 812, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN4", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN4", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN4E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN4 PCIE Generation 4.", "keywords": []}, {"id": 813, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN5", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN5", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN5E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN5 PCIE Generation 5.", "keywords": []}, {"id": 814, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN6", "display_name": "CUpti_PcieGen::CUPTI_PCIE_GEN_GEN6", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv4N13CUpti_PcieGen19CUPTI_PCIE_GEN_GEN6E", "priority": 1, "content": "enumerator  CUPTI_PCIE_GEN_GEN6 PCIE Generation 6.", "keywords": []}, {"id": 815, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "CUpti_TimestampCallbackFunc", "display_name": "CUpti_TimestampCallbackFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv427CUpti_TimestampCallbackFunc", "priority": 1, "content": "typedef  uint64_t  ( * CUpti_TimestampCallbackFunc ) ( void ) Function type for callback used by CUPTI to request a timestamp to be used in activity records. This callback function signals the CUPTI client that a timestamp needs to be returned. This timestamp would be treated as normalized timestamp to be used for various purposes in CUPTI. For example to store start and end timestamps reported in the CUPTI activity records. The returned timestamp must be in nanoseconds. cuptiActivityRegisterTimestampCallback", "keywords": []}, {"id": 816, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigurePCSampling", "display_name": "cuptiActivityConfigurePCSampling", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv432cuptiActivityConfigurePCSampling9CUcontextP30CUpti_ActivityPCSamplingConfig", "priority": 1, "content": "CUptiResult  cuptiActivityConfigurePCSampling CUcontext  ctx CUpti_ActivityPCSamplingConfig  * config Set PC sampling configuration. For Pascal and older GPU architectures this API must be called before enabling activity kind CUPTI_ACTIVITY_KIND_PC_SAMPLING. There is no such requirement for Volta and newer GPU architectures. For Volta and newer GPU architectures if this API is called in the middle of execution, PC sampling configuration will be updated for subsequent kernel launches. Parameters ctx \u2013 The context config \u2013 A pointer to CUpti_ActivityPCSamplingConfig structure containing PC sampling configuration. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if this api is called while some valid event collection method is set. CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the system/device does not support the unified memory counters", "keywords": []}, {"id": 817, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigurePCSampling::config", "display_name": "cuptiActivityConfigurePCSampling::config", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv432cuptiActivityConfigurePCSampling9CUcontextP30CUpti_ActivityPCSamplingConfig", "priority": 1, "content": "CUptiResult  cuptiActivityConfigurePCSampling CUcontext  ctx CUpti_ActivityPCSamplingConfig  * config Set PC sampling configuration. For Pascal and older GPU architectures this API must be called before enabling activity kind CUPTI_ACTIVITY_KIND_PC_SAMPLING. There is no such requirement for Volta and newer GPU architectures. For Volta and newer GPU architectures if this API is called in the middle of execution, PC sampling configuration will be updated for subsequent kernel launches. Parameters ctx \u2013 The context config \u2013 A pointer to CUpti_ActivityPCSamplingConfig structure containing PC sampling configuration. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if this api is called while some valid event collection method is set. CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the system/device does not support the unified memory counters", "keywords": []}, {"id": 818, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigurePCSampling::ctx", "display_name": "cuptiActivityConfigurePCSampling::ctx", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv432cuptiActivityConfigurePCSampling9CUcontextP30CUpti_ActivityPCSamplingConfig", "priority": 1, "content": "CUptiResult  cuptiActivityConfigurePCSampling CUcontext  ctx CUpti_ActivityPCSamplingConfig  * config Set PC sampling configuration. For Pascal and older GPU architectures this API must be called before enabling activity kind CUPTI_ACTIVITY_KIND_PC_SAMPLING. There is no such requirement for Volta and newer GPU architectures. For Volta and newer GPU architectures if this API is called in the middle of execution, PC sampling configuration will be updated for subsequent kernel launches. Parameters ctx \u2013 The context config \u2013 A pointer to CUpti_ActivityPCSamplingConfig structure containing PC sampling configuration. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if this api is called while some valid event collection method is set. CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the system/device does not support the unified memory counters", "keywords": []}, {"id": 819, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigureUnifiedMemoryCounter", "display_name": "cuptiActivityConfigureUnifiedMemoryCounter", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv442cuptiActivityConfigureUnifiedMemoryCounterP40CUpti_ActivityUnifiedMemoryCounterConfig8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityConfigureUnifiedMemoryCounter CUpti_ActivityUnifiedMemoryCounterConfig  * config uint32_t  count Set Unified Memory Counter configuration. Set the configuration before enabling the corresponding activity kind CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER. The API should be called after CUDA driver initialization. Parameters config \u2013 A pointer to CUpti_ActivityUnifiedMemoryCounterConfig structures containing Unified Memory counter configuration. count \u2013 Number of Unified Memory counter configuration structures Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED \u2013 One potential reason is that platform (OS/arch) does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_DEVICE \u2013 Indicates that the device does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_NON_P2P_DEVICES \u2013 Indicates that multi-GPU configuration without P2P support between any pair of devices does not support the unified memory counters", "keywords": []}, {"id": 820, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigureUnifiedMemoryCounter::config", "display_name": "cuptiActivityConfigureUnifiedMemoryCounter::config", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv442cuptiActivityConfigureUnifiedMemoryCounterP40CUpti_ActivityUnifiedMemoryCounterConfig8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityConfigureUnifiedMemoryCounter CUpti_ActivityUnifiedMemoryCounterConfig  * config uint32_t  count Set Unified Memory Counter configuration. Set the configuration before enabling the corresponding activity kind CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER. The API should be called after CUDA driver initialization. Parameters config \u2013 A pointer to CUpti_ActivityUnifiedMemoryCounterConfig structures containing Unified Memory counter configuration. count \u2013 Number of Unified Memory counter configuration structures Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED \u2013 One potential reason is that platform (OS/arch) does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_DEVICE \u2013 Indicates that the device does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_NON_P2P_DEVICES \u2013 Indicates that multi-GPU configuration without P2P support between any pair of devices does not support the unified memory counters", "keywords": []}, {"id": 821, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityConfigureUnifiedMemoryCounter::count", "display_name": "cuptiActivityConfigureUnifiedMemoryCounter::count", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv442cuptiActivityConfigureUnifiedMemoryCounterP40CUpti_ActivityUnifiedMemoryCounterConfig8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityConfigureUnifiedMemoryCounter CUpti_ActivityUnifiedMemoryCounterConfig  * config uint32_t  count Set Unified Memory Counter configuration. Set the configuration before enabling the corresponding activity kind CUPTI_ACTIVITY_KIND_UNIFIED_MEMORY_COUNTER. The API should be called after CUDA driver initialization. Parameters config \u2013 A pointer to CUpti_ActivityUnifiedMemoryCounterConfig structures containing Unified Memory counter configuration. count \u2013 Number of Unified Memory counter configuration structures Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if config is NULL or any parameter in the config structures is not a valid value CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED \u2013 One potential reason is that platform (OS/arch) does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_DEVICE \u2013 Indicates that the device does not support the unified memory counters CUPTI_ERROR_UM_PROFILING_NOT_SUPPORTED_ON_NON_P2P_DEVICES \u2013 Indicates that multi-GPU configuration without P2P support between any pair of devices does not support the unified memory counters", "keywords": []}, {"id": 822, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityDisable", "display_name": "cuptiActivityDisable", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiActivityDisable18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityDisable CUpti_ActivityKind  kind Disable collection of a specific kind of activity record. Disable collection of a specific kind of activity record. Multiple kinds can be disabled by calling this function multiple times. By default all activity kinds are disabled for collection. Parameters kind \u2013 The kind of activity record to stop collecting Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 823, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityDisable::kind", "display_name": "cuptiActivityDisable::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiActivityDisable18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityDisable CUpti_ActivityKind  kind Disable collection of a specific kind of activity record. Disable collection of a specific kind of activity record. Multiple kinds can be disabled by calling this function multiple times. By default all activity kinds are disabled for collection. Parameters kind \u2013 The kind of activity record to stop collecting Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 824, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityDisableContext", "display_name": "cuptiActivityDisableContext", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv427cuptiActivityDisableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityDisableContext CUcontext  context CUpti_ActivityKind  kind Disable collection of a specific kind of activity record for a context. Disable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records. Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be disabled kind \u2013 The kind of activity record to stop collecting Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 825, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityDisableContext::context", "display_name": "cuptiActivityDisableContext::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv427cuptiActivityDisableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityDisableContext CUcontext  context CUpti_ActivityKind  kind Disable collection of a specific kind of activity record for a context. Disable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records. Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be disabled kind \u2013 The kind of activity record to stop collecting Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 826, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityDisableContext::kind", "display_name": "cuptiActivityDisableContext::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv427cuptiActivityDisableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityDisableContext CUcontext  context CUpti_ActivityKind  kind Disable collection of a specific kind of activity record for a context. Disable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records. Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be disabled kind \u2013 The kind of activity record to stop collecting Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 827, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnable", "display_name": "cuptiActivityEnable", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiActivityEnable18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnable CUpti_ActivityKind  kind Enable collection of a specific kind of activity record. Enable collection of a specific kind of activity record. Multiple kinds can be enabled by calling this function multiple times. By default all activity kinds are disabled for collection. Parameters kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 828, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnable::kind", "display_name": "cuptiActivityEnable::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiActivityEnable18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnable CUpti_ActivityKind  kind Enable collection of a specific kind of activity record. Enable collection of a specific kind of activity record. Multiple kinds can be enabled by calling this function multiple times. By default all activity kinds are disabled for collection. Parameters kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 829, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAllSyncRecords", "display_name": "cuptiActivityEnableAllSyncRecords", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityEnableAllSyncRecords7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAllSyncRecords uint8_t  enable Enables collecting records for all synchronization operations. CUPTI provides CUDA event query and stream query records via CUPTI_ACTIVITY_KIND_SYNCHRONIZATION. Using this API, CUPTI client can disable to record CUDA event query and stream query records for queries for which the operations have not yet been completed on the CUDA event/stream. By default, the record is generated for all CUDA events and stream irrespective of whether the operations have been completed on the CUDA event/stream. Parameters enable \u2013 is a boolean, denoting whether to enable or disable the collection of all CUDA event query and stream query records Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 830, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAllSyncRecords::enable", "display_name": "cuptiActivityEnableAllSyncRecords::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityEnableAllSyncRecords7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAllSyncRecords uint8_t  enable Enables collecting records for all synchronization operations. CUPTI provides CUDA event query and stream query records via CUPTI_ACTIVITY_KIND_SYNCHRONIZATION. Using this API, CUPTI client can disable to record CUDA event query and stream query records for queries for which the operations have not yet been completed on the CUDA event/stream. By default, the record is generated for all CUDA events and stream irrespective of whether the operations have been completed on the CUDA event/stream. Parameters enable \u2013 is a boolean, denoting whether to enable or disable the collection of all CUDA event query and stream query records Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 831, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAllocationSource", "display_name": "cuptiActivityEnableAllocationSource", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv435cuptiActivityEnableAllocationSource7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAllocationSource uint8_t  enable Enables tracking the source library for memory allocation requests. This API is used to control whether or not we track the source library of memory allocation requests. Default value is 0, i.e. it is not tracked. The activity kind CUPTI_ACTIVITY_KIND_MEMORY2 needs to be enabled, and if this flag is set, we get the full path of the shared object responsible for the GPU memory allocation request in the member source in the CUpti_ActivityMemory4 records. Also note that this feature adds runtime overhead. Parameters enable \u2013 is a boolean, denoting whether the source library of the memory allocation request needs to be tracked Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 832, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAllocationSource::enable", "display_name": "cuptiActivityEnableAllocationSource::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv435cuptiActivityEnableAllocationSource7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAllocationSource uint8_t  enable Enables tracking the source library for memory allocation requests. This API is used to control whether or not we track the source library of memory allocation requests. Default value is 0, i.e. it is not tracked. The activity kind CUPTI_ACTIVITY_KIND_MEMORY2 needs to be enabled, and if this flag is set, we get the full path of the shared object responsible for the GPU memory allocation request in the member source in the CUpti_ActivityMemory4 records. Also note that this feature adds runtime overhead. Parameters enable \u2013 is a boolean, denoting whether the source library of the memory allocation request needs to be tracked Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 833, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAndDump", "display_name": "cuptiActivityEnableAndDump", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableAndDump18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAndDump CUpti_ActivityKind  kind Enable collection of a specific kind of activity record. For certain activity kinds it dumps existing records. In general, the behavior of this API is similar to the API cuptiActivityEnable i.e. it enables the collection of a specific kind of activity record. Additionally, this API can help in dumping the records for activities which happened in the past before enabling the corresponding activity kind. The API allows to get records for the current resource allocations done in CUDA For CUPTI_ACTIVITY_KIND_DEVICE, existing device records are dumped For CUPTI_ACTIVITY_KIND_CONTEXT, existing context records are dumped For CUPTI_ACTIVITY_KIND_STREAM, existing stream records are dumped For CUPTI_ACTIVITY_KIND_ NVLINK, existing NVLINK records are dumped For CUPTI_ACTIVITY_KIND_PCIE, existing PCIE records are dumped For other activities, the behavior is similar to the API cuptiActivityEnable Device records are emitted in CUPTI on CUDA driver initialization. Those records can only be retrieved by the user if CUPTI is attached before CUDA initialization. Context and stream records are emitted on context and stream creation. The use case of the API is to provide the records for CUDA resources (contexts/streams/devices) that are currently active if user late attaches CUPTI. Before calling this function, the user must register buffer callbacks to get the activity records by calling cuptiActivityRegisterCallbacks . If the user does not register the buffers and calls API cuptiActivityEnableAndDump , then CUPTI will enable the activity kind but not provide any records for that activity kind. Parameters kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_UNKNOWN \u2013 if buffer is not initialized. CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 834, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableAndDump::kind", "display_name": "cuptiActivityEnableAndDump::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableAndDump18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnableAndDump CUpti_ActivityKind  kind Enable collection of a specific kind of activity record. For certain activity kinds it dumps existing records. In general, the behavior of this API is similar to the API cuptiActivityEnable i.e. it enables the collection of a specific kind of activity record. Additionally, this API can help in dumping the records for activities which happened in the past before enabling the corresponding activity kind. The API allows to get records for the current resource allocations done in CUDA For CUPTI_ACTIVITY_KIND_DEVICE, existing device records are dumped For CUPTI_ACTIVITY_KIND_CONTEXT, existing context records are dumped For CUPTI_ACTIVITY_KIND_STREAM, existing stream records are dumped For CUPTI_ACTIVITY_KIND_ NVLINK, existing NVLINK records are dumped For CUPTI_ACTIVITY_KIND_PCIE, existing PCIE records are dumped For other activities, the behavior is similar to the API cuptiActivityEnable Device records are emitted in CUPTI on CUDA driver initialization. Those records can only be retrieved by the user if CUPTI is attached before CUDA initialization. Context and stream records are emitted on context and stream creation. The use case of the API is to provide the records for CUDA resources (contexts/streams/devices) that are currently active if user late attaches CUPTI. Before calling this function, the user must register buffer callbacks to get the activity records by calling cuptiActivityRegisterCallbacks . If the user does not register the buffers and calls API cuptiActivityEnableAndDump , then CUPTI will enable the activity kind but not provide any records for that activity kind. Parameters kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_UNKNOWN \u2013 if buffer is not initialized. CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 835, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableContext", "display_name": "cuptiActivityEnableContext", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnableContext CUcontext  context CUpti_ActivityKind  kind Enable collection of a specific kind of activity record for a context. Enable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records enabled by cuptiActivityEnable . Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be enabled kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 836, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableContext::context", "display_name": "cuptiActivityEnableContext::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnableContext CUcontext  context CUpti_ActivityKind  kind Enable collection of a specific kind of activity record for a context. Enable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records enabled by cuptiActivityEnable . Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be enabled kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 837, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableContext::kind", "display_name": "cuptiActivityEnableContext::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableContext9CUcontext18CUpti_ActivityKind", "priority": 1, "content": "CUptiResult  cuptiActivityEnableContext CUcontext  context CUpti_ActivityKind  kind Enable collection of a specific kind of activity record for a context. Enable collection of a specific kind of activity record for a context. This setting done by this API will supersede the global settings for activity records enabled by cuptiActivityEnable . Multiple kinds can be enabled by calling this function multiple times. Parameters context \u2013 The context for which activity is to be enabled kind \u2013 The kind of activity record to collect Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_NOT_COMPATIBLE \u2013 if the activity kind cannot be enabled CUPTI_ERROR_INVALID_KIND \u2013 if the activity kind is not supported", "keywords": []}, {"id": 838, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableDeviceGraph", "display_name": "cuptiActivityEnableDeviceGraph", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430cuptiActivityEnableDeviceGraph7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableDeviceGraph uint8_t  enable Controls the collection of records for device launched graphs. This API is used to control the collection of records for device launched graphs. Default value is 0, i.e. these records are not collected. This API needs to be called before initialization of CUDA and this setting should not be changed during the profiling session. Parameters enable \u2013 is a boolean, denoting whether these records should be collected Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 839, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableDeviceGraph::enable", "display_name": "cuptiActivityEnableDeviceGraph::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430cuptiActivityEnableDeviceGraph7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableDeviceGraph uint8_t  enable Controls the collection of records for device launched graphs. This API is used to control the collection of records for device launched graphs. Default value is 0, i.e. these records are not collected. This API needs to be called before initialization of CUDA and this setting should not be changed during the profiling session. Parameters enable \u2013 is a boolean, denoting whether these records should be collected Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 840, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableDriverApi", "display_name": "cuptiActivityEnableDriverApi", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428cuptiActivityEnableDriverApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableDriverApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Driver APIs. Activity kind CUPTI_ACTIVITY_KIND_DRIVER controls the collection of either all CUDA Driver APIs or none. API cuptiActivityEnableDriverApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Driver APIs. To disable collection of a small set of CUDA Driver APIs, user can first enable the collection of all Driver APIs using the activity kind CUPTI_ACTIVITY_KIND_DRIVER and call this API to disable specific Driver APIs. And to enable the collection of a small set of CUDA Driver APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_DRIVER. Note: Activity kind CUPTI_ACTIVITY_KIND_DRIVER overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Driver API. This can be found in the header cupti_driver_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 841, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableDriverApi::cbid", "display_name": "cuptiActivityEnableDriverApi::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428cuptiActivityEnableDriverApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableDriverApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Driver APIs. Activity kind CUPTI_ACTIVITY_KIND_DRIVER controls the collection of either all CUDA Driver APIs or none. API cuptiActivityEnableDriverApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Driver APIs. To disable collection of a small set of CUDA Driver APIs, user can first enable the collection of all Driver APIs using the activity kind CUPTI_ACTIVITY_KIND_DRIVER and call this API to disable specific Driver APIs. And to enable the collection of a small set of CUDA Driver APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_DRIVER. Note: Activity kind CUPTI_ACTIVITY_KIND_DRIVER overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Driver API. This can be found in the header cupti_driver_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 842, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableDriverApi::enable", "display_name": "cuptiActivityEnableDriverApi::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv428cuptiActivityEnableDriverApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableDriverApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Driver APIs. Activity kind CUPTI_ACTIVITY_KIND_DRIVER controls the collection of either all CUDA Driver APIs or none. API cuptiActivityEnableDriverApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Driver APIs. To disable collection of a small set of CUDA Driver APIs, user can first enable the collection of all Driver APIs using the activity kind CUPTI_ACTIVITY_KIND_DRIVER and call this API to disable specific Driver APIs. And to enable the collection of a small set of CUDA Driver APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_DRIVER. Note: Activity kind CUPTI_ACTIVITY_KIND_DRIVER overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Driver API. This can be found in the header cupti_driver_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 843, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableHWTrace", "display_name": "cuptiActivityEnableHWTrace", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableHWTrace7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableHWTrace uint8_t  enable Enables the collection of CUDA kernel timestamps through Hardware Event System(HES). This API enables the collection of CUDA kernel timestamps through HW events instead of the traditional SW instrumentation and semaphore based approach. This option is only available on Blackwell architecture. This API should be called after driver is initialized. Parameters enable \u2013 is a boolean, denoting whether to enable or disable the collection through HW events Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 if CUPTI is not initialized or the CUDA driver is not initialized CUPTI_ERROR_NOT_SUPPORTED \u2013 if HW trace cannot be enabled on the current platform CUPTI_ERROR_VIRTUALIZED_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_CONFIDENTIAL_COMPUTING_NOT_SUPPORTED \u2013 CUPTI_ERROR_CMP_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_MIG_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_SLI_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_WSL_DEVICE_NOT_SUPPORTED \u2013", "keywords": []}, {"id": 844, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableHWTrace::enable", "display_name": "cuptiActivityEnableHWTrace::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityEnableHWTrace7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableHWTrace uint8_t  enable Enables the collection of CUDA kernel timestamps through Hardware Event System(HES). This API enables the collection of CUDA kernel timestamps through HW events instead of the traditional SW instrumentation and semaphore based approach. This option is only available on Blackwell architecture. This API should be called after driver is initialized. Parameters enable \u2013 is a boolean, denoting whether to enable or disable the collection through HW events Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 if CUPTI is not initialized or the CUDA driver is not initialized CUPTI_ERROR_NOT_SUPPORTED \u2013 if HW trace cannot be enabled on the current platform CUPTI_ERROR_VIRTUALIZED_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_CONFIDENTIAL_COMPUTING_NOT_SUPPORTED \u2013 CUPTI_ERROR_CMP_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_MIG_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_SLI_DEVICE_NOT_SUPPORTED \u2013 CUPTI_ERROR_WSL_DEVICE_NOT_SUPPORTED \u2013", "keywords": []}, {"id": 845, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableLatencyTimestamps", "display_name": "cuptiActivityEnableLatencyTimestamps", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv436cuptiActivityEnableLatencyTimestamps7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableLatencyTimestamps uint8_t  enable Controls the collection of queued and submitted timestamps for kernels. This API is used to control the collection of queued and submitted timestamps for kernels whose records are provided through the struct CUpti_ActivityKernel9 . Default value is 0, i.e. these timestamps are not collected. This API needs to be called before initialization of CUDA and this setting should not be changed during the profiling session. This API is not supported if the HW trace is enabled through the API cuptiActivityEnableHWTrace . Parameters enable \u2013 is a boolean, denoting whether these timestamps should be collected Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 846, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableLatencyTimestamps::enable", "display_name": "cuptiActivityEnableLatencyTimestamps::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv436cuptiActivityEnableLatencyTimestamps7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableLatencyTimestamps uint8_t  enable Controls the collection of queued and submitted timestamps for kernels. This API is used to control the collection of queued and submitted timestamps for kernels whose records are provided through the struct CUpti_ActivityKernel9 . Default value is 0, i.e. these timestamps are not collected. This API needs to be called before initialization of CUDA and this setting should not be changed during the profiling session. This API is not supported if the HW trace is enabled through the API cuptiActivityEnableHWTrace . Parameters enable \u2013 is a boolean, denoting whether these timestamps should be collected Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 847, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableLaunchAttributes", "display_name": "cuptiActivityEnableLaunchAttributes", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv435cuptiActivityEnableLaunchAttributes7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableLaunchAttributes uint8_t  enable Controls the collection of launch attributes for kernels. This API is used to control the collection of launch attributes for kernels whose records are provided through the struct CUpti_ActivityKernel9 . Default value is 0, i.e. these attributes are not collected. Parameters enable \u2013 is a boolean denoting whether these launch attributes should be collected", "keywords": []}, {"id": 848, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableLaunchAttributes::enable", "display_name": "cuptiActivityEnableLaunchAttributes::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv435cuptiActivityEnableLaunchAttributes7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableLaunchAttributes uint8_t  enable Controls the collection of launch attributes for kernels. This API is used to control the collection of launch attributes for kernels whose records are provided through the struct CUpti_ActivityKernel9 . Default value is 0, i.e. these attributes are not collected. Parameters enable \u2013 is a boolean denoting whether these launch attributes should be collected", "keywords": []}, {"id": 849, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableRuntimeApi", "display_name": "cuptiActivityEnableRuntimeApi", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiActivityEnableRuntimeApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableRuntimeApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Runtime APIs. Activity kind CUPTI_ACTIVITY_KIND_RUNTIME controls the collection of either all CUDA Runtime APIs or none. API cuptiActivityEnableRuntimeApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Runtime APIs. To disable collection of a small set of CUDA Runtime APIs, user can first enable the collection of all Runtime APIs using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME and call this API to disable specific Runtime APIs. And to enable the collection of a small set of CUDA Runtime APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME. Note: Activity kind CUPTI_ACTIVITY_KIND_RUNTIME overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Runtime API. This can be found in the header cupti_runtime_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 850, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableRuntimeApi::cbid", "display_name": "cuptiActivityEnableRuntimeApi::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiActivityEnableRuntimeApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableRuntimeApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Runtime APIs. Activity kind CUPTI_ACTIVITY_KIND_RUNTIME controls the collection of either all CUDA Runtime APIs or none. API cuptiActivityEnableRuntimeApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Runtime APIs. To disable collection of a small set of CUDA Runtime APIs, user can first enable the collection of all Runtime APIs using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME and call this API to disable specific Runtime APIs. And to enable the collection of a small set of CUDA Runtime APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME. Note: Activity kind CUPTI_ACTIVITY_KIND_RUNTIME overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Runtime API. This can be found in the header cupti_runtime_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 851, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityEnableRuntimeApi::enable", "display_name": "cuptiActivityEnableRuntimeApi::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiActivityEnableRuntimeApi16CUpti_CallbackId7uint8_t", "priority": 1, "content": "CUptiResult  cuptiActivityEnableRuntimeApi CUpti_CallbackId  cbid uint8_t  enable Controls the collection of activity records for specific CUDA Runtime APIs. Activity kind CUPTI_ACTIVITY_KIND_RUNTIME controls the collection of either all CUDA Runtime APIs or none. API cuptiActivityEnableRuntimeApi can be used for fine-grained control, it allows enabling/disabling tracing of a specific set of CUDA Runtime APIs. To disable collection of a small set of CUDA Runtime APIs, user can first enable the collection of all Runtime APIs using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME and call this API to disable specific Runtime APIs. And to enable the collection of a small set of CUDA Runtime APIs, user can call this API without using the activity kind CUPTI_ACTIVITY_KIND_RUNTIME. Note: Activity kind CUPTI_ACTIVITY_KIND_RUNTIME overrides the settings done by this API if it is called after the API. Parameters cbid \u2013 callback id of the CUDA Runtime API. This can be found in the header cupti_runtime_cbid.h. enable \u2013 is a boolean, denoting whether to enable or disable the collection Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 852, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlush", "display_name": "cuptiActivityFlush", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiActivityFlush9CUcontext8uint32_t8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlush CUcontext  context uint32_t  streamId uint32_t  flag Wait for all activity records to be delivered via the completion callback. This function does not return until all activity records associated with the specified context/stream are returned to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. To ensure that all activity records are complete, the requested stream(s), if any, are synchronized. If context is NULL, the global activity records (i.e. those not associated with a particular stream) are flushed (in this case no streams are synchronized). If context is a valid CUcontext and streamId is 0, the buffers of all streams of this context are flushed. Otherwise, the buffers of the specified stream in this context is flushed. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. DEPRECATED This method is deprecated CONTEXT and STREAMID will be ignored. Use cuptiActivityFlushAll to flush all data. Parameters context \u2013 A valid CUcontext or NULL. streamId \u2013 The stream ID. flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 853, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlush::context", "display_name": "cuptiActivityFlush::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiActivityFlush9CUcontext8uint32_t8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlush CUcontext  context uint32_t  streamId uint32_t  flag Wait for all activity records to be delivered via the completion callback. This function does not return until all activity records associated with the specified context/stream are returned to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. To ensure that all activity records are complete, the requested stream(s), if any, are synchronized. If context is NULL, the global activity records (i.e. those not associated with a particular stream) are flushed (in this case no streams are synchronized). If context is a valid CUcontext and streamId is 0, the buffers of all streams of this context are flushed. Otherwise, the buffers of the specified stream in this context is flushed. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. DEPRECATED This method is deprecated CONTEXT and STREAMID will be ignored. Use cuptiActivityFlushAll to flush all data. Parameters context \u2013 A valid CUcontext or NULL. streamId \u2013 The stream ID. flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 854, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlush::flag", "display_name": "cuptiActivityFlush::flag", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiActivityFlush9CUcontext8uint32_t8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlush CUcontext  context uint32_t  streamId uint32_t  flag Wait for all activity records to be delivered via the completion callback. This function does not return until all activity records associated with the specified context/stream are returned to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. To ensure that all activity records are complete, the requested stream(s), if any, are synchronized. If context is NULL, the global activity records (i.e. those not associated with a particular stream) are flushed (in this case no streams are synchronized). If context is a valid CUcontext and streamId is 0, the buffers of all streams of this context are flushed. Otherwise, the buffers of the specified stream in this context is flushed. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. DEPRECATED This method is deprecated CONTEXT and STREAMID will be ignored. Use cuptiActivityFlushAll to flush all data. Parameters context \u2013 A valid CUcontext or NULL. streamId \u2013 The stream ID. flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 855, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlush::streamId", "display_name": "cuptiActivityFlush::streamId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiActivityFlush9CUcontext8uint32_t8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlush CUcontext  context uint32_t  streamId uint32_t  flag Wait for all activity records to be delivered via the completion callback. This function does not return until all activity records associated with the specified context/stream are returned to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. To ensure that all activity records are complete, the requested stream(s), if any, are synchronized. If context is NULL, the global activity records (i.e. those not associated with a particular stream) are flushed (in this case no streams are synchronized). If context is a valid CUcontext and streamId is 0, the buffers of all streams of this context are flushed. Otherwise, the buffers of the specified stream in this context is flushed. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. DEPRECATED This method is deprecated CONTEXT and STREAMID will be ignored. Use cuptiActivityFlushAll to flush all data. Parameters context \u2013 A valid CUcontext or NULL. streamId \u2013 The stream ID. flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 856, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlushAll", "display_name": "cuptiActivityFlushAll", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv421cuptiActivityFlushAll8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlushAll uint32_t  flag Request to deliver activity records via the buffer completion callback. This function returns the activity records associated with all contexts/streams (and the global buffers not associated with any stream) to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. This is a blocking call but it doesn\u2019t issue any CUDA synchronization calls implicitly thus it\u2019s not guaranteed that all activities are completed on the underlying devices. Activity record is considered as completed if it has all the information filled up including the timestamps if any. It is the client\u2019s responsibility to issue necessary CUDA synchronization calls before calling this function if all activity records with complete information are expected to be delivered. Behavior of the function based on the input flag: (-) ::For default flush i.e. when flag is set as 0, it returns all the activity buffers which have all the activity records completed, buffers need not to be full though. It doesn\u2019t return buffers which have one or more incomplete records. Default flush can be done at a regular interval in a separate thread. (-) ::For forced flush i.e. when flag CUPTI_ACTIVITY_FLAG_FLUSH_FORCED is passed to the function, it returns all the activity buffers including the ones which have one or more incomplete activity records. It\u2019s suggested for clients to do the force flush before the termination of the profiling session to allow remaining buffers to be delivered. In general, it can be done in the at-exit handler. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. cuptiActivityFlushPeriod  Parameters flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 857, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlushAll::flag", "display_name": "cuptiActivityFlushAll::flag", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv421cuptiActivityFlushAll8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlushAll uint32_t  flag Request to deliver activity records via the buffer completion callback. This function returns the activity records associated with all contexts/streams (and the global buffers not associated with any stream) to the CUPTI client using the callback registered in cuptiActivityRegisterCallbacks. This is a blocking call but it doesn\u2019t issue any CUDA synchronization calls implicitly thus it\u2019s not guaranteed that all activities are completed on the underlying devices. Activity record is considered as completed if it has all the information filled up including the timestamps if any. It is the client\u2019s responsibility to issue necessary CUDA synchronization calls before calling this function if all activity records with complete information are expected to be delivered. Behavior of the function based on the input flag: (-) ::For default flush i.e. when flag is set as 0, it returns all the activity buffers which have all the activity records completed, buffers need not to be full though. It doesn\u2019t return buffers which have one or more incomplete records. Default flush can be done at a regular interval in a separate thread. (-) ::For forced flush i.e. when flag CUPTI_ACTIVITY_FLAG_FLUSH_FORCED is passed to the function, it returns all the activity buffers including the ones which have one or more incomplete activity records. It\u2019s suggested for clients to do the force flush before the termination of the profiling session to allow remaining buffers to be delivered. In general, it can be done in the at-exit handler. Before calling this function, the buffer handling callback api must be activated by calling cuptiActivityRegisterCallbacks. cuptiActivityFlushPeriod  Parameters flag \u2013 The flag can be set to indicate a forced flush. See CUpti_ActivityFlag Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if not preceded by a successful call to cuptiActivityRegisterCallbacks CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 858, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlushPeriod", "display_name": "cuptiActivityFlushPeriod", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424cuptiActivityFlushPeriod8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlushPeriod uint32_t  time Sets the flush period for the worker thread. CUPTI creates a worker thread to minimize the perturbance for the application created threads. CUPTI offloads certain operations from the application threads to the worker thread, this includes synchronization of profiling resources between host and device, delivery of the activity buffers to the client using the callback registered in cuptiActivityRegisterCallbacks. For performance reasons, CUPTI wakes up the worker thread based on certain heuristics. This API is used to control the flush period of the worker thread. This setting will override the CUPTI heuristics. Setting time to zero disables the periodic flush and restores the default behavior. Periodic flush can return only those activity buffers which are full and have all the activity records completed. It\u2019s allowed to use the API cuptiActivityFlushAll to flush the data on-demand, even when client sets the periodic flush. cuptiActivityFlushAll  Parameters time \u2013 flush period in milliseconds (ms) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 859, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityFlushPeriod::time", "display_name": "cuptiActivityFlushPeriod::time", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv424cuptiActivityFlushPeriod8uint32_t", "priority": 1, "content": "CUptiResult  cuptiActivityFlushPeriod uint32_t  time Sets the flush period for the worker thread. CUPTI creates a worker thread to minimize the perturbance for the application created threads. CUPTI offloads certain operations from the application threads to the worker thread, this includes synchronization of profiling resources between host and device, delivery of the activity buffers to the client using the callback registered in cuptiActivityRegisterCallbacks. For performance reasons, CUPTI wakes up the worker thread based on certain heuristics. This API is used to control the flush period of the worker thread. This setting will override the CUPTI heuristics. Setting time to zero disables the periodic flush and restores the default behavior. Periodic flush can return only those activity buffers which are full and have all the activity records completed. It\u2019s allowed to use the API cuptiActivityFlushAll to flush the data on-demand, even when client sets the periodic flush. cuptiActivityFlushAll  Parameters time \u2013 flush period in milliseconds (ms) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 860, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetAttribute", "display_name": "cuptiActivityGetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivityGetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivityGetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Read an activity API attribute. Read an activity API attribute and return it in *value . Parameters attr \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 861, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetAttribute::attr", "display_name": "cuptiActivityGetAttribute::attr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivityGetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivityGetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Read an activity API attribute. Read an activity API attribute and return it in *value . Parameters attr \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 862, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetAttribute::value", "display_name": "cuptiActivityGetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivityGetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivityGetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Read an activity API attribute. Read an activity API attribute and return it in *value . Parameters attr \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 863, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetAttribute::valueSize", "display_name": "cuptiActivityGetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivityGetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivityGetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Read an activity API attribute. Read an activity API attribute and return it in *value . Parameters attr \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 864, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNextRecord", "display_name": "cuptiActivityGetNextRecord", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityGetNextRecordP7uint8_t6size_tPP14CUpti_Activity", "priority": 1, "content": "CUptiResult  cuptiActivityGetNextRecord uint8_t  * buffer size_t  validBufferSizeBytes CUpti_Activity  * * record Iterate over the activity records in a buffer. This is a helper function to iterate over the activity records in a buffer. A buffer of activity records is typically obtained by receiving a CUpti_BuffersCallbackCompleteFunc callback. Stop iterating the buffer when an error occurs. An example of typical usage: CUpti_Activity  *record  =  NULL;  CUptiResult  status  =  CUPTI_SUCCESS;    do  {       status  =  cuptiActivityGetNextRecord(buffer,  validSize,  &amp;record);       if(status  ==  CUPTI_SUCCESS)  {            //  Use  record  here...       }       else  if  (status  ==  CUPTI_ERROR_MAX_LIMIT_REACHED)           break;       else  if  (status  ==  CUPTI_ERROR_INVALID_KIND)           break;       else  {           goto  Error;       }     }  while  (1); Parameters buffer \u2013 The buffer containing activity records record \u2013 Inputs the previous record returned by cuptiActivityGetNextRecord and returns the next activity record from the buffer. If input value is NULL, returns the first activity record in the buffer. Records of certain kinds like CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL may contain invalid (0) timestamps, indicating that no timing information could be collected for lack of device memory. validBufferSizeBytes \u2013 The number of valid bytes in the buffer. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if no more records in the buffer CUPTI_ERROR_INVALID_PARAMETER \u2013 if buffer is NULL. CUPTI_ERROR_INVALID_KIND \u2013 if activity record is either incomplete or invalid", "keywords": []}, {"id": 865, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNextRecord::buffer", "display_name": "cuptiActivityGetNextRecord::buffer", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityGetNextRecordP7uint8_t6size_tPP14CUpti_Activity", "priority": 1, "content": "CUptiResult  cuptiActivityGetNextRecord uint8_t  * buffer size_t  validBufferSizeBytes CUpti_Activity  * * record Iterate over the activity records in a buffer. This is a helper function to iterate over the activity records in a buffer. A buffer of activity records is typically obtained by receiving a CUpti_BuffersCallbackCompleteFunc callback. Stop iterating the buffer when an error occurs. An example of typical usage: CUpti_Activity  *record  =  NULL;  CUptiResult  status  =  CUPTI_SUCCESS;    do  {       status  =  cuptiActivityGetNextRecord(buffer,  validSize,  &amp;record);       if(status  ==  CUPTI_SUCCESS)  {            //  Use  record  here...       }       else  if  (status  ==  CUPTI_ERROR_MAX_LIMIT_REACHED)           break;       else  if  (status  ==  CUPTI_ERROR_INVALID_KIND)           break;       else  {           goto  Error;       }     }  while  (1); Parameters buffer \u2013 The buffer containing activity records record \u2013 Inputs the previous record returned by cuptiActivityGetNextRecord and returns the next activity record from the buffer. If input value is NULL, returns the first activity record in the buffer. Records of certain kinds like CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL may contain invalid (0) timestamps, indicating that no timing information could be collected for lack of device memory. validBufferSizeBytes \u2013 The number of valid bytes in the buffer. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if no more records in the buffer CUPTI_ERROR_INVALID_PARAMETER \u2013 if buffer is NULL. CUPTI_ERROR_INVALID_KIND \u2013 if activity record is either incomplete or invalid", "keywords": []}, {"id": 866, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNextRecord::record", "display_name": "cuptiActivityGetNextRecord::record", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityGetNextRecordP7uint8_t6size_tPP14CUpti_Activity", "priority": 1, "content": "CUptiResult  cuptiActivityGetNextRecord uint8_t  * buffer size_t  validBufferSizeBytes CUpti_Activity  * * record Iterate over the activity records in a buffer. This is a helper function to iterate over the activity records in a buffer. A buffer of activity records is typically obtained by receiving a CUpti_BuffersCallbackCompleteFunc callback. Stop iterating the buffer when an error occurs. An example of typical usage: CUpti_Activity  *record  =  NULL;  CUptiResult  status  =  CUPTI_SUCCESS;    do  {       status  =  cuptiActivityGetNextRecord(buffer,  validSize,  &amp;record);       if(status  ==  CUPTI_SUCCESS)  {            //  Use  record  here...       }       else  if  (status  ==  CUPTI_ERROR_MAX_LIMIT_REACHED)           break;       else  if  (status  ==  CUPTI_ERROR_INVALID_KIND)           break;       else  {           goto  Error;       }     }  while  (1); Parameters buffer \u2013 The buffer containing activity records record \u2013 Inputs the previous record returned by cuptiActivityGetNextRecord and returns the next activity record from the buffer. If input value is NULL, returns the first activity record in the buffer. Records of certain kinds like CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL may contain invalid (0) timestamps, indicating that no timing information could be collected for lack of device memory. validBufferSizeBytes \u2013 The number of valid bytes in the buffer. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if no more records in the buffer CUPTI_ERROR_INVALID_PARAMETER \u2013 if buffer is NULL. CUPTI_ERROR_INVALID_KIND \u2013 if activity record is either incomplete or invalid", "keywords": []}, {"id": 867, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNextRecord::validBufferSizeBytes", "display_name": "cuptiActivityGetNextRecord::validBufferSizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv426cuptiActivityGetNextRecordP7uint8_t6size_tPP14CUpti_Activity", "priority": 1, "content": "CUptiResult  cuptiActivityGetNextRecord uint8_t  * buffer size_t  validBufferSizeBytes CUpti_Activity  * * record Iterate over the activity records in a buffer. This is a helper function to iterate over the activity records in a buffer. A buffer of activity records is typically obtained by receiving a CUpti_BuffersCallbackCompleteFunc callback. Stop iterating the buffer when an error occurs. An example of typical usage: CUpti_Activity  *record  =  NULL;  CUptiResult  status  =  CUPTI_SUCCESS;    do  {       status  =  cuptiActivityGetNextRecord(buffer,  validSize,  &amp;record);       if(status  ==  CUPTI_SUCCESS)  {            //  Use  record  here...       }       else  if  (status  ==  CUPTI_ERROR_MAX_LIMIT_REACHED)           break;       else  if  (status  ==  CUPTI_ERROR_INVALID_KIND)           break;       else  {           goto  Error;       }     }  while  (1); Parameters buffer \u2013 The buffer containing activity records record \u2013 Inputs the previous record returned by cuptiActivityGetNextRecord and returns the next activity record from the buffer. If input value is NULL, returns the first activity record in the buffer. Records of certain kinds like CUPTI_ACTIVITY_KIND_CONCURRENT_KERNEL may contain invalid (0) timestamps, indicating that no timing information could be collected for lack of device memory. validBufferSizeBytes \u2013 The number of valid bytes in the buffer. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if no more records in the buffer CUPTI_ERROR_INVALID_PARAMETER \u2013 if buffer is NULL. CUPTI_ERROR_INVALID_KIND \u2013 if activity record is either incomplete or invalid", "keywords": []}, {"id": 868, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNumDroppedRecords", "display_name": "cuptiActivityGetNumDroppedRecords", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityGetNumDroppedRecords9CUcontext8uint32_tP6size_t", "priority": 1, "content": "CUptiResult  cuptiActivityGetNumDroppedRecords CUcontext  context uint32_t  streamId size_t  * dropped Get the number of activity records that were dropped of insufficient buffer space. Get the number of records that were dropped because of insufficient buffer space. The dropped count includes records that could not be recorded because CUPTI did not have activity buffer space available for the record (because the CUpti_BuffersCallbackRequestFunc callback did not return an empty buffer of sufficient size) and also CDP records that could not be record because the device-size buffer was full (size is controlled by the CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP attribute). The dropped count maintained for the queue is reset to zero when this function is called. Parameters context \u2013 The context, or NULL to get dropped count from global queue streamId \u2013 The stream ID dropped \u2013 The number of records that were dropped since the last call to this function. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if dropped is NULL", "keywords": []}, {"id": 869, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNumDroppedRecords::context", "display_name": "cuptiActivityGetNumDroppedRecords::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityGetNumDroppedRecords9CUcontext8uint32_tP6size_t", "priority": 1, "content": "CUptiResult  cuptiActivityGetNumDroppedRecords CUcontext  context uint32_t  streamId size_t  * dropped Get the number of activity records that were dropped of insufficient buffer space. Get the number of records that were dropped because of insufficient buffer space. The dropped count includes records that could not be recorded because CUPTI did not have activity buffer space available for the record (because the CUpti_BuffersCallbackRequestFunc callback did not return an empty buffer of sufficient size) and also CDP records that could not be record because the device-size buffer was full (size is controlled by the CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP attribute). The dropped count maintained for the queue is reset to zero when this function is called. Parameters context \u2013 The context, or NULL to get dropped count from global queue streamId \u2013 The stream ID dropped \u2013 The number of records that were dropped since the last call to this function. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if dropped is NULL", "keywords": []}, {"id": 870, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNumDroppedRecords::dropped", "display_name": "cuptiActivityGetNumDroppedRecords::dropped", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityGetNumDroppedRecords9CUcontext8uint32_tP6size_t", "priority": 1, "content": "CUptiResult  cuptiActivityGetNumDroppedRecords CUcontext  context uint32_t  streamId size_t  * dropped Get the number of activity records that were dropped of insufficient buffer space. Get the number of records that were dropped because of insufficient buffer space. The dropped count includes records that could not be recorded because CUPTI did not have activity buffer space available for the record (because the CUpti_BuffersCallbackRequestFunc callback did not return an empty buffer of sufficient size) and also CDP records that could not be record because the device-size buffer was full (size is controlled by the CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP attribute). The dropped count maintained for the queue is reset to zero when this function is called. Parameters context \u2013 The context, or NULL to get dropped count from global queue streamId \u2013 The stream ID dropped \u2013 The number of records that were dropped since the last call to this function. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if dropped is NULL", "keywords": []}, {"id": 871, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityGetNumDroppedRecords::streamId", "display_name": "cuptiActivityGetNumDroppedRecords::streamId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv433cuptiActivityGetNumDroppedRecords9CUcontext8uint32_tP6size_t", "priority": 1, "content": "CUptiResult  cuptiActivityGetNumDroppedRecords CUcontext  context uint32_t  streamId size_t  * dropped Get the number of activity records that were dropped of insufficient buffer space. Get the number of records that were dropped because of insufficient buffer space. The dropped count includes records that could not be recorded because CUPTI did not have activity buffer space available for the record (because the CUpti_BuffersCallbackRequestFunc callback did not return an empty buffer of sufficient size) and also CDP records that could not be record because the device-size buffer was full (size is controlled by the CUPTI_ACTIVITY_ATTR_DEVICE_BUFFER_SIZE_CDP attribute). The dropped count maintained for the queue is reset to zero when this function is called. Parameters context \u2013 The context, or NULL to get dropped count from global queue streamId \u2013 The stream ID dropped \u2013 The number of records that were dropped since the last call to this function. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if dropped is NULL", "keywords": []}, {"id": 872, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPopExternalCorrelationId", "display_name": "cuptiActivityPopExternalCorrelationId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437cuptiActivityPopExternalCorrelationId29CUpti_ExternalCorrelationKindP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPopExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  * lastId Pop an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is leaving an external API region. Parameters kind \u2013 The kind of external API activities should be correlated with. lastId \u2013 If the function returns successful, contains the last external correlation id for this kind , can be NULL. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid. CUPTI_ERROR_QUEUE_EMPTY \u2013 No external id is currently associated with kind .", "keywords": []}, {"id": 873, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPopExternalCorrelationId::kind", "display_name": "cuptiActivityPopExternalCorrelationId::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437cuptiActivityPopExternalCorrelationId29CUpti_ExternalCorrelationKindP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPopExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  * lastId Pop an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is leaving an external API region. Parameters kind \u2013 The kind of external API activities should be correlated with. lastId \u2013 If the function returns successful, contains the last external correlation id for this kind , can be NULL. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid. CUPTI_ERROR_QUEUE_EMPTY \u2013 No external id is currently associated with kind .", "keywords": []}, {"id": 874, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPopExternalCorrelationId::lastId", "display_name": "cuptiActivityPopExternalCorrelationId::lastId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv437cuptiActivityPopExternalCorrelationId29CUpti_ExternalCorrelationKindP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPopExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  * lastId Pop an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is leaving an external API region. Parameters kind \u2013 The kind of external API activities should be correlated with. lastId \u2013 If the function returns successful, contains the last external correlation id for this kind , can be NULL. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid. CUPTI_ERROR_QUEUE_EMPTY \u2013 No external id is currently associated with kind .", "keywords": []}, {"id": 875, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPushExternalCorrelationId", "display_name": "cuptiActivityPushExternalCorrelationId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438cuptiActivityPushExternalCorrelationId29CUpti_ExternalCorrelationKind8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPushExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  id Push an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is entering an external API region. When a CUPTI activity API record is created while within an external API region and CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION is enabled, the activity API record will be preceded by a CUpti_ActivityExternalCorrelation record for each CUpti_ExternalCorrelationKind . Parameters kind \u2013 The kind of external API activities should be correlated with. id \u2013 External correlation id. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid", "keywords": []}, {"id": 876, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPushExternalCorrelationId::id", "display_name": "cuptiActivityPushExternalCorrelationId::id", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438cuptiActivityPushExternalCorrelationId29CUpti_ExternalCorrelationKind8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPushExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  id Push an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is entering an external API region. When a CUPTI activity API record is created while within an external API region and CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION is enabled, the activity API record will be preceded by a CUpti_ActivityExternalCorrelation record for each CUpti_ExternalCorrelationKind . Parameters kind \u2013 The kind of external API activities should be correlated with. id \u2013 External correlation id. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid", "keywords": []}, {"id": 877, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityPushExternalCorrelationId::kind", "display_name": "cuptiActivityPushExternalCorrelationId::kind", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438cuptiActivityPushExternalCorrelationId29CUpti_ExternalCorrelationKind8uint64_t", "priority": 1, "content": "CUptiResult  cuptiActivityPushExternalCorrelationId CUpti_ExternalCorrelationKind  kind uint64_t  id Push an external correlation id for the calling thread. This function notifies CUPTI that the calling thread is entering an external API region. When a CUPTI activity API record is created while within an external API region and CUPTI_ACTIVITY_KIND_EXTERNAL_CORRELATION is enabled, the activity API record will be preceded by a CUpti_ActivityExternalCorrelation record for each CUpti_ExternalCorrelationKind . Parameters kind \u2013 The kind of external API activities should be correlated with. id \u2013 External correlation id. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 The external API kind is invalid", "keywords": []}, {"id": 878, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityRegisterCallbacks", "display_name": "cuptiActivityRegisterCallbacks", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430cuptiActivityRegisterCallbacks32CUpti_BuffersCallbackRequestFunc33CUpti_BuffersCallbackCompleteFunc", "priority": 1, "content": "CUptiResult  cuptiActivityRegisterCallbacks CUpti_BuffersCallbackRequestFunc  funcBufferRequested CUpti_BuffersCallbackCompleteFunc  funcBufferCompleted Registers callback functions with CUPTI for activity buffer handling. This function registers two callback functions to be used in asynchronous buffer handling. If registered, activity record buffers are handled using asynchronous requested/completed callbacks from CUPTI. Registering these callbacks prevents the client from using CUPTI\u2019s blocking enqueue/dequeue functions. Parameters funcBufferRequested \u2013 callback which is invoked when an empty buffer is requested by CUPTI funcBufferCompleted \u2013 callback which is invoked when a buffer containing activity records is available from CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if either funcBufferRequested or funcBufferCompleted is NULL", "keywords": []}, {"id": 879, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityRegisterCallbacks::funcBufferCompleted", "display_name": "cuptiActivityRegisterCallbacks::funcBufferCompleted", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430cuptiActivityRegisterCallbacks32CUpti_BuffersCallbackRequestFunc33CUpti_BuffersCallbackCompleteFunc", "priority": 1, "content": "CUptiResult  cuptiActivityRegisterCallbacks CUpti_BuffersCallbackRequestFunc  funcBufferRequested CUpti_BuffersCallbackCompleteFunc  funcBufferCompleted Registers callback functions with CUPTI for activity buffer handling. This function registers two callback functions to be used in asynchronous buffer handling. If registered, activity record buffers are handled using asynchronous requested/completed callbacks from CUPTI. Registering these callbacks prevents the client from using CUPTI\u2019s blocking enqueue/dequeue functions. Parameters funcBufferRequested \u2013 callback which is invoked when an empty buffer is requested by CUPTI funcBufferCompleted \u2013 callback which is invoked when a buffer containing activity records is available from CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if either funcBufferRequested or funcBufferCompleted is NULL", "keywords": []}, {"id": 880, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityRegisterCallbacks::funcBufferRequested", "display_name": "cuptiActivityRegisterCallbacks::funcBufferRequested", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv430cuptiActivityRegisterCallbacks32CUpti_BuffersCallbackRequestFunc33CUpti_BuffersCallbackCompleteFunc", "priority": 1, "content": "CUptiResult  cuptiActivityRegisterCallbacks CUpti_BuffersCallbackRequestFunc  funcBufferRequested CUpti_BuffersCallbackCompleteFunc  funcBufferCompleted Registers callback functions with CUPTI for activity buffer handling. This function registers two callback functions to be used in asynchronous buffer handling. If registered, activity record buffers are handled using asynchronous requested/completed callbacks from CUPTI. Registering these callbacks prevents the client from using CUPTI\u2019s blocking enqueue/dequeue functions. Parameters funcBufferRequested \u2013 callback which is invoked when an empty buffer is requested by CUPTI funcBufferCompleted \u2013 callback which is invoked when a buffer containing activity records is available from CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if either funcBufferRequested or funcBufferCompleted is NULL", "keywords": []}, {"id": 881, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityRegisterTimestampCallback", "display_name": "cuptiActivityRegisterTimestampCallback", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438cuptiActivityRegisterTimestampCallback27CUpti_TimestampCallbackFunc", "priority": 1, "content": "CUptiResult  cuptiActivityRegisterTimestampCallback CUpti_TimestampCallbackFunc  funcTimestamp Registers callback function with CUPTI for providing timestamp. This function registers a callback function to obtain timestamp of user\u2019s choice instead of using CUPTI provided timestamp. By default CUPTI uses different methods, based on the underlying platform, to retrieve the timestamp Linux and Android use clock_gettime(CLOCK_REALTIME, ..) Windows uses QueryPerformanceCounter() QNX uses ClockCycles() Timestamps retrieved using these methods are converted to nanosecond if needed before usage. Timestamps for GPU activities such as kernels, memory copies and memset operations are recorded directly on the GPU. To provide a unified and normalized view of these timestamps in relation to CPU time, CUPTI performs a linear interpolation to convert GPU timestamps into CPU timestamps during post-processing. For activities where timestamps are captured on the GPU, the timestamp callback is invoked during the post-processing phase, while converting GPU timestamps into CPU timestamps. For activities for which timestamps are captured directly on the CPU, the timestamp callback is invoked immediately at the time of the activity. The registration of timestamp callback should be done before any of the CUPTI activity kinds are enabled to make sure that all the records report the timestamp using the callback function registered through cuptiActivityRegisterTimestampCallback API. Changing the timestamp callback function in CUPTI through cuptiActivityRegisterTimestampCallback API in the middle of the profiling session can cause records generated prior to the change to report timestamps through previous timestamp method. Parameters funcTimestamp \u2013 callback which is invoked when a timestamp is needed by CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if funcTimestamp is NULL CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 882, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivityRegisterTimestampCallback::funcTimestamp", "display_name": "cuptiActivityRegisterTimestampCallback::funcTimestamp", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv438cuptiActivityRegisterTimestampCallback27CUpti_TimestampCallbackFunc", "priority": 1, "content": "CUptiResult  cuptiActivityRegisterTimestampCallback CUpti_TimestampCallbackFunc  funcTimestamp Registers callback function with CUPTI for providing timestamp. This function registers a callback function to obtain timestamp of user\u2019s choice instead of using CUPTI provided timestamp. By default CUPTI uses different methods, based on the underlying platform, to retrieve the timestamp Linux and Android use clock_gettime(CLOCK_REALTIME, ..) Windows uses QueryPerformanceCounter() QNX uses ClockCycles() Timestamps retrieved using these methods are converted to nanosecond if needed before usage. Timestamps for GPU activities such as kernels, memory copies and memset operations are recorded directly on the GPU. To provide a unified and normalized view of these timestamps in relation to CPU time, CUPTI performs a linear interpolation to convert GPU timestamps into CPU timestamps during post-processing. For activities where timestamps are captured on the GPU, the timestamp callback is invoked during the post-processing phase, while converting GPU timestamps into CPU timestamps. For activities for which timestamps are captured directly on the CPU, the timestamp callback is invoked immediately at the time of the activity. The registration of timestamp callback should be done before any of the CUPTI activity kinds are enabled to make sure that all the records report the timestamp using the callback function registered through cuptiActivityRegisterTimestampCallback API. Changing the timestamp callback function in CUPTI through cuptiActivityRegisterTimestampCallback API in the middle of the profiling session can cause records generated prior to the change to report timestamps through previous timestamp method. Parameters funcTimestamp \u2013 callback which is invoked when a timestamp is needed by CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if funcTimestamp is NULL CUPTI_ERROR_NOT_INITIALIZED \u2013", "keywords": []}, {"id": 883, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivitySetAttribute", "display_name": "cuptiActivitySetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivitySetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivitySetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Write an activity API attribute. Write an activity API attribute. Parameters attr \u2013 The attribute to write valueSize \u2013 The size, in bytes, of the value value \u2013 The attribute value to write Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 884, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivitySetAttribute::attr", "display_name": "cuptiActivitySetAttribute::attr", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivitySetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivitySetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Write an activity API attribute. Write an activity API attribute. Parameters attr \u2013 The attribute to write valueSize \u2013 The size, in bytes, of the value value \u2013 The attribute value to write Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 885, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivitySetAttribute::value", "display_name": "cuptiActivitySetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivitySetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivitySetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Write an activity API attribute. Write an activity API attribute. Parameters attr \u2013 The attribute to write valueSize \u2013 The size, in bytes, of the value value \u2013 The attribute value to write Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 886, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiActivitySetAttribute::valueSize", "display_name": "cuptiActivitySetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv425cuptiActivitySetAttribute23CUpti_ActivityAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiActivitySetAttribute CUpti_ActivityAttribute  attr size_t  * valueSize void  * value Write an activity API attribute. Write an activity API attribute. Parameters attr \u2013 The attribute to write valueSize \u2013 The size, in bytes, of the value value \u2013 The attribute value to write Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attr is not an activity attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 Indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 887, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiComputeCapabilitySupported", "display_name": "cuptiComputeCapabilitySupported", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv431cuptiComputeCapabilitySupportediiPi", "priority": 1, "content": "CUptiResult  cuptiComputeCapabilitySupported int  major int  minor int  * support Check support for a compute capability. This function is used to check the support for a device based on it\u2019s compute capability. It sets the support when the compute capability is supported by the current version of CUPTI, and clears it otherwise. This version of CUPTI might not support all GPUs sharing the same compute capability. It is suggested to use API cuptiDeviceSupported which provides correct information. cuptiDeviceSupported  Parameters major \u2013 The major revision number of the compute capability minor \u2013 The minor revision number of the compute capability support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL", "keywords": []}, {"id": 888, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiComputeCapabilitySupported::major", "display_name": "cuptiComputeCapabilitySupported::major", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv431cuptiComputeCapabilitySupportediiPi", "priority": 1, "content": "CUptiResult  cuptiComputeCapabilitySupported int  major int  minor int  * support Check support for a compute capability. This function is used to check the support for a device based on it\u2019s compute capability. It sets the support when the compute capability is supported by the current version of CUPTI, and clears it otherwise. This version of CUPTI might not support all GPUs sharing the same compute capability. It is suggested to use API cuptiDeviceSupported which provides correct information. cuptiDeviceSupported  Parameters major \u2013 The major revision number of the compute capability minor \u2013 The minor revision number of the compute capability support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL", "keywords": []}, {"id": 889, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiComputeCapabilitySupported::minor", "display_name": "cuptiComputeCapabilitySupported::minor", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv431cuptiComputeCapabilitySupportediiPi", "priority": 1, "content": "CUptiResult  cuptiComputeCapabilitySupported int  major int  minor int  * support Check support for a compute capability. This function is used to check the support for a device based on it\u2019s compute capability. It sets the support when the compute capability is supported by the current version of CUPTI, and clears it otherwise. This version of CUPTI might not support all GPUs sharing the same compute capability. It is suggested to use API cuptiDeviceSupported which provides correct information. cuptiDeviceSupported  Parameters major \u2013 The major revision number of the compute capability minor \u2013 The minor revision number of the compute capability support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL", "keywords": []}, {"id": 890, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiComputeCapabilitySupported::support", "display_name": "cuptiComputeCapabilitySupported::support", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv431cuptiComputeCapabilitySupportediiPi", "priority": 1, "content": "CUptiResult  cuptiComputeCapabilitySupported int  major int  minor int  * support Check support for a compute capability. This function is used to check the support for a device based on it\u2019s compute capability. It sets the support when the compute capability is supported by the current version of CUPTI, and clears it otherwise. This version of CUPTI might not support all GPUs sharing the same compute capability. It is suggested to use API cuptiDeviceSupported which provides correct information. cuptiDeviceSupported  Parameters major \u2013 The major revision number of the compute capability minor \u2013 The minor revision number of the compute capability support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL", "keywords": []}, {"id": 891, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceSupported", "display_name": "cuptiDeviceSupported", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiDeviceSupported8CUdevicePi", "priority": 1, "content": "CUptiResult  cuptiDeviceSupported CUdevice  dev int  * support Check support for a compute device. This function is used to check the support for a compute device. It sets the support when the device is supported by the current version of CUPTI, and clears it otherwise. cuptiComputeCapabilitySupported  Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device", "keywords": []}, {"id": 892, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceSupported::dev", "display_name": "cuptiDeviceSupported::dev", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiDeviceSupported8CUdevicePi", "priority": 1, "content": "CUptiResult  cuptiDeviceSupported CUdevice  dev int  * support Check support for a compute device. This function is used to check the support for a compute device. It sets the support when the device is supported by the current version of CUPTI, and clears it otherwise. cuptiComputeCapabilitySupported  Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device", "keywords": []}, {"id": 893, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceSupported::support", "display_name": "cuptiDeviceSupported::support", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiDeviceSupported8CUdevicePi", "priority": 1, "content": "CUptiResult  cuptiDeviceSupported CUdevice  dev int  * support Check support for a compute device. This function is used to check the support for a compute device. It sets the support when the device is supported by the current version of CUPTI, and clears it otherwise. cuptiComputeCapabilitySupported  Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet support \u2013 Pointer to an integer to return the support status Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if support is NULL CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device", "keywords": []}, {"id": 894, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceVirtualizationMode", "display_name": "cuptiDeviceVirtualizationMode", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiDeviceVirtualizationMode8CUdeviceP30CUpti_DeviceVirtualizationMode", "priority": 1, "content": "CUptiResult  cuptiDeviceVirtualizationMode CUdevice  dev CUpti_DeviceVirtualizationMode  * mode Query the virtualization mode of the device. This function is used to query the virtualization mode of the CUDA device. Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet mode \u2013 Pointer to an CUpti_DeviceVirtualizationMode to return the virtualization mode Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device CUPTI_ERROR_INVALID_PARAMETER \u2013 if mode is NULL", "keywords": []}, {"id": 895, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceVirtualizationMode::dev", "display_name": "cuptiDeviceVirtualizationMode::dev", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiDeviceVirtualizationMode8CUdeviceP30CUpti_DeviceVirtualizationMode", "priority": 1, "content": "CUptiResult  cuptiDeviceVirtualizationMode CUdevice  dev CUpti_DeviceVirtualizationMode  * mode Query the virtualization mode of the device. This function is used to query the virtualization mode of the CUDA device. Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet mode \u2013 Pointer to an CUpti_DeviceVirtualizationMode to return the virtualization mode Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device CUPTI_ERROR_INVALID_PARAMETER \u2013 if mode is NULL", "keywords": []}, {"id": 896, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiDeviceVirtualizationMode::mode", "display_name": "cuptiDeviceVirtualizationMode::mode", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv429cuptiDeviceVirtualizationMode8CUdeviceP30CUpti_DeviceVirtualizationMode", "priority": 1, "content": "CUptiResult  cuptiDeviceVirtualizationMode CUdevice  dev CUpti_DeviceVirtualizationMode  * mode Query the virtualization mode of the device. This function is used to query the virtualization mode of the CUDA device. Parameters dev \u2013 The device handle returned by CUDA Driver API cuDeviceGet mode \u2013 Pointer to an CUpti_DeviceVirtualizationMode to return the virtualization mode Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if dev is not a valid device CUPTI_ERROR_INVALID_PARAMETER \u2013 if mode is NULL", "keywords": []}, {"id": 897, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiFinalize", "display_name": "cuptiFinalize", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv413cuptiFinalizev", "priority": 1, "content": "CUptiResult  cuptiFinalize void Detach CUPTI from the running process. This API detaches the CUPTI from the running process. It destroys and cleans up all the resources associated with CUPTI in the current process. After CUPTI detaches from the process, the process will keep on running with no CUPTI attached to it. For safe operation of the API, it is recommended this API is invoked from the exit callsite of any of the CUDA Driver or Runtime API. Otherwise CUPTI client needs to make sure that required CUDA synchronization and CUPTI activity buffer flush is done before calling the API. Sample code showing the usage of the API in the cupti callback handler code: void  CUPTIAPI  cuptiCallbackHandler(void  *userdata,  CUpti_CallbackDomain  domain,      CUpti_CallbackId  cbid,  void  *cbdata)  {    const  CUpti_CallbackData  *cbInfo  =  (CUpti_CallbackData  *)cbdata;     //  Take  this  code  path  when  CUPTI  detach  is  requested    if  (detachCupti)  {      switch(domain)      {        case  CUPTI_CB_DOMAIN_RUNTIME_API:        case  CUPTI_CB_DOMAIN_DRIVER_API:          if  (cbInfo-&gt;callbackSite  ==  CUPTI_API_EXIT)  {              //  call  the  CUPTI  detach  API              cuptiFinalize();          }          break;        default:          break;      }    }  }", "keywords": []}, {"id": 898, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetAutoBoostState", "display_name": "cuptiGetAutoBoostState", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv422cuptiGetAutoBoostState9CUcontextP28CUpti_ActivityAutoBoostState", "priority": 1, "content": "CUptiResult  cuptiGetAutoBoostState CUcontext  context CUpti_ActivityAutoBoostState  * state Get auto boost state. The profiling results can be inconsistent in case auto boost is enabled. CUPTI tries to disable auto boost while profiling. It can fail to disable in cases where user does not have the permissions or CUDA_AUTO_BOOST env variable is set. The function can be used to query whether auto boost is enabled. Parameters context \u2013 A valid CUcontext. state \u2013 A pointer to CUpti_ActivityAutoBoostState structure which contains the current state and the id of the process that has requested the current state Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if CUcontext or state is NULL CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the device does not support auto boost CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 899, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetAutoBoostState::context", "display_name": "cuptiGetAutoBoostState::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv422cuptiGetAutoBoostState9CUcontextP28CUpti_ActivityAutoBoostState", "priority": 1, "content": "CUptiResult  cuptiGetAutoBoostState CUcontext  context CUpti_ActivityAutoBoostState  * state Get auto boost state. The profiling results can be inconsistent in case auto boost is enabled. CUPTI tries to disable auto boost while profiling. It can fail to disable in cases where user does not have the permissions or CUDA_AUTO_BOOST env variable is set. The function can be used to query whether auto boost is enabled. Parameters context \u2013 A valid CUcontext. state \u2013 A pointer to CUpti_ActivityAutoBoostState structure which contains the current state and the id of the process that has requested the current state Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if CUcontext or state is NULL CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the device does not support auto boost CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 900, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetAutoBoostState::state", "display_name": "cuptiGetAutoBoostState::state", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv422cuptiGetAutoBoostState9CUcontextP28CUpti_ActivityAutoBoostState", "priority": 1, "content": "CUptiResult  cuptiGetAutoBoostState CUcontext  context CUpti_ActivityAutoBoostState  * state Get auto boost state. The profiling results can be inconsistent in case auto boost is enabled. CUPTI tries to disable auto boost while profiling. It can fail to disable in cases where user does not have the permissions or CUDA_AUTO_BOOST env variable is set. The function can be used to query whether auto boost is enabled. Parameters context \u2013 A valid CUcontext. state \u2013 A pointer to CUpti_ActivityAutoBoostState structure which contains the current state and the id of the process that has requested the current state Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if CUcontext or state is NULL CUPTI_ERROR_NOT_SUPPORTED \u2013 Indicates that the device does not support auto boost CUPTI_ERROR_UNKNOWN \u2013 an internal error occurred", "keywords": []}, {"id": 901, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetContextId", "display_name": "cuptiGetContextId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetContextId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetContextId CUcontext  context uint32_t  * contextId Get the ID of a context. Get the ID of a context. Parameters context \u2013 The context contextId \u2013 Returns a process-unique ID for the context Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 The context is NULL or not valid. CUPTI_ERROR_INVALID_PARAMETER \u2013 if contextId is NULL", "keywords": []}, {"id": 902, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetContextId::context", "display_name": "cuptiGetContextId::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetContextId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetContextId CUcontext  context uint32_t  * contextId Get the ID of a context. Get the ID of a context. Parameters context \u2013 The context contextId \u2013 Returns a process-unique ID for the context Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 The context is NULL or not valid. CUPTI_ERROR_INVALID_PARAMETER \u2013 if contextId is NULL", "keywords": []}, {"id": 903, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetContextId::contextId", "display_name": "cuptiGetContextId::contextId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetContextId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetContextId CUcontext  context uint32_t  * contextId Get the ID of a context. Get the ID of a context. Parameters context \u2013 The context contextId \u2013 Returns a process-unique ID for the context Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 The context is NULL or not valid. CUPTI_ERROR_INVALID_PARAMETER \u2013 if contextId is NULL", "keywords": []}, {"id": 904, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetDeviceId", "display_name": "cuptiGetDeviceId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetDeviceId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetDeviceId CUcontext  context uint32_t  * deviceId Get the ID of a device. If context is NULL, returns the ID of the device that contains the currently active context. If context is non-NULL, returns the ID of the device which contains that context. Operates in a similar manner to cudaGetDevice() or cuCtxGetDevice() but may be called from within callback functions. Parameters context \u2013 The context, or NULL to indicate the current context. deviceId \u2013 Returns the ID of the device that is current for the calling thread. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if unable to get device ID CUPTI_ERROR_INVALID_PARAMETER \u2013 if deviceId is NULL", "keywords": []}, {"id": 905, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetDeviceId::context", "display_name": "cuptiGetDeviceId::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetDeviceId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetDeviceId CUcontext  context uint32_t  * deviceId Get the ID of a device. If context is NULL, returns the ID of the device that contains the currently active context. If context is non-NULL, returns the ID of the device which contains that context. Operates in a similar manner to cudaGetDevice() or cuCtxGetDevice() but may be called from within callback functions. Parameters context \u2013 The context, or NULL to indicate the current context. deviceId \u2013 Returns the ID of the device that is current for the calling thread. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if unable to get device ID CUPTI_ERROR_INVALID_PARAMETER \u2013 if deviceId is NULL", "keywords": []}, {"id": 906, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetDeviceId::deviceId", "display_name": "cuptiGetDeviceId::deviceId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetDeviceId9CUcontextP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetDeviceId CUcontext  context uint32_t  * deviceId Get the ID of a device. If context is NULL, returns the ID of the device that contains the currently active context. If context is non-NULL, returns the ID of the device which contains that context. Operates in a similar manner to cudaGetDevice() or cuCtxGetDevice() but may be called from within callback functions. Parameters context \u2013 The context, or NULL to indicate the current context. deviceId \u2013 Returns the ID of the device that is current for the calling thread. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 if unable to get device ID CUPTI_ERROR_INVALID_PARAMETER \u2013 if deviceId is NULL", "keywords": []}, {"id": 907, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphExecId", "display_name": "cuptiGetGraphExecId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphExecId11CUgraphExecP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphExecId CUgraphExec  graphExec uint32_t  * pId Get the unique ID of executable graph. Returns the unique ID of executable CUDA graph. Parameters graphExec \u2013 The executable graph. pId \u2013 Returns the unique ID of the executable graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 908, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphExecId::graphExec", "display_name": "cuptiGetGraphExecId::graphExec", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphExecId11CUgraphExecP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphExecId CUgraphExec  graphExec uint32_t  * pId Get the unique ID of executable graph. Returns the unique ID of executable CUDA graph. Parameters graphExec \u2013 The executable graph. pId \u2013 Returns the unique ID of the executable graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 909, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphExecId::pId", "display_name": "cuptiGetGraphExecId::pId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphExecId11CUgraphExecP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphExecId CUgraphExec  graphExec uint32_t  * pId Get the unique ID of executable graph. Returns the unique ID of executable CUDA graph. Parameters graphExec \u2013 The executable graph. pId \u2013 Returns the unique ID of the executable graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 910, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphId", "display_name": "cuptiGetGraphId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv415cuptiGetGraphId7CUgraphP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphId CUgraph  graph uint32_t  * pId Get the unique ID of graph. Returns the unique ID of CUDA graph. Parameters graph \u2013 The graph. pId \u2013 Returns the unique ID of the graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 911, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphId::graph", "display_name": "cuptiGetGraphId::graph", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv415cuptiGetGraphId7CUgraphP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphId CUgraph  graph uint32_t  * pId Get the unique ID of graph. Returns the unique ID of CUDA graph. Parameters graph \u2013 The graph. pId \u2013 Returns the unique ID of the graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 912, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphId::pId", "display_name": "cuptiGetGraphId::pId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv415cuptiGetGraphId7CUgraphP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphId CUgraph  graph uint32_t  * pId Get the unique ID of graph. Returns the unique ID of CUDA graph. Parameters graph \u2013 The graph. pId \u2013 Returns the unique ID of the graph Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if graph is NULL", "keywords": []}, {"id": 913, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphNodeId", "display_name": "cuptiGetGraphNodeId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphNodeId11CUgraphNodeP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphNodeId CUgraphNode  node uint64_t  * nodeId Get the unique ID of a graph node. Returns the unique ID of the CUDA graph node. Parameters node \u2013 The graph node. nodeId \u2013 Returns the unique ID of the node Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if node is NULL", "keywords": []}, {"id": 914, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphNodeId::node", "display_name": "cuptiGetGraphNodeId::node", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphNodeId11CUgraphNodeP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphNodeId CUgraphNode  node uint64_t  * nodeId Get the unique ID of a graph node. Returns the unique ID of the CUDA graph node. Parameters node \u2013 The graph node. nodeId \u2013 Returns the unique ID of the node Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if node is NULL", "keywords": []}, {"id": 915, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetGraphNodeId::nodeId", "display_name": "cuptiGetGraphNodeId::nodeId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv419cuptiGetGraphNodeId11CUgraphNodeP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiGetGraphNodeId CUgraphNode  node uint64_t  * nodeId Get the unique ID of a graph node. Returns the unique ID of the CUDA graph node. Parameters node \u2013 The graph node. nodeId \u2013 Returns the unique ID of the node Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if node is NULL", "keywords": []}, {"id": 916, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetLastError", "display_name": "cuptiGetLastError", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetLastErrorv", "priority": 1, "content": "CUptiResult  cuptiGetLastError void Returns the last error from a cupti call or callback. Returns the last error that has been produced by any of the cupti api calls or the callback in the same host thread and resets it to CUPTI_SUCCESS.", "keywords": []}, {"id": 917, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamId", "display_name": "cuptiGetStreamId", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetStreamId9CUcontext8CUstreamP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamId CUcontext  context CUstream  stream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). DEPRECATED This method is deprecated as of CUDA 8.0. Use method cuptiGetStreamIdEx instead. Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 918, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamId::context", "display_name": "cuptiGetStreamId::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetStreamId9CUcontext8CUstreamP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamId CUcontext  context CUstream  stream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). DEPRECATED This method is deprecated as of CUDA 8.0. Use method cuptiGetStreamIdEx instead. Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 919, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamId::stream", "display_name": "cuptiGetStreamId::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetStreamId9CUcontext8CUstreamP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamId CUcontext  context CUstream  stream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). DEPRECATED This method is deprecated as of CUDA 8.0. Use method cuptiGetStreamIdEx instead. Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 920, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamId::streamId", "display_name": "cuptiGetStreamId::streamId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv416cuptiGetStreamId9CUcontext8CUstreamP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamId CUcontext  context CUstream  stream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). DEPRECATED This method is deprecated as of CUDA 8.0. Use method cuptiGetStreamIdEx instead. Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 921, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamIdEx", "display_name": "cuptiGetStreamIdEx", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiGetStreamIdEx9CUcontext8CUstream7uint8_tP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamIdEx CUcontext  context CUstream  stream uint8_t  perThreadStream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream perThreadStream \u2013 Flag to indicate if program is compiled for per-thread streams streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 922, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamIdEx::context", "display_name": "cuptiGetStreamIdEx::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiGetStreamIdEx9CUcontext8CUstream7uint8_tP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamIdEx CUcontext  context CUstream  stream uint8_t  perThreadStream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream perThreadStream \u2013 Flag to indicate if program is compiled for per-thread streams streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 923, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamIdEx::perThreadStream", "display_name": "cuptiGetStreamIdEx::perThreadStream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiGetStreamIdEx9CUcontext8CUstream7uint8_tP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamIdEx CUcontext  context CUstream  stream uint8_t  perThreadStream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream perThreadStream \u2013 Flag to indicate if program is compiled for per-thread streams streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 924, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamIdEx::stream", "display_name": "cuptiGetStreamIdEx::stream", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiGetStreamIdEx9CUcontext8CUstream7uint8_tP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamIdEx CUcontext  context CUstream  stream uint8_t  perThreadStream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream perThreadStream \u2013 Flag to indicate if program is compiled for per-thread streams streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 925, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetStreamIdEx::streamId", "display_name": "cuptiGetStreamIdEx::streamId", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv418cuptiGetStreamIdEx9CUcontext8CUstream7uint8_tP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiGetStreamIdEx CUcontext  context CUstream  stream uint8_t  perThreadStream uint32_t  * streamId Get the ID of a stream. Get the ID of a stream. The stream ID is unique within a context (i.e. all streams within a context will have unique stream IDs). Parameters context \u2013 If non-NULL then the stream is checked to ensure that it belongs to this context. Typically this parameter should be null. stream \u2013 The stream perThreadStream \u2013 Flag to indicate if program is compiled for per-thread streams streamId \u2013 Returns a context-unique ID for the stream Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_STREAM \u2013 if unable to get stream ID, or if context is non-NULL and stream does not belong to the context CUPTI_ERROR_INVALID_PARAMETER \u2013 if streamId is NULL", "keywords": []}, {"id": 926, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetThreadIdType", "display_name": "cuptiGetThreadIdType", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiGetThreadIdTypeP26CUpti_ActivityThreadIdType", "priority": 1, "content": "CUptiResult  cuptiGetThreadIdType CUpti_ActivityThreadIdType  * type Get the thread-id type. Returns the thread-id type used in CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if type is NULL", "keywords": []}, {"id": 927, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetThreadIdType::type", "display_name": "cuptiGetThreadIdType::type", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiGetThreadIdTypeP26CUpti_ActivityThreadIdType", "priority": 1, "content": "CUptiResult  cuptiGetThreadIdType CUpti_ActivityThreadIdType  * type Get the thread-id type. Returns the thread-id type used in CUPTI Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if type is NULL", "keywords": []}, {"id": 928, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetTimestamp", "display_name": "cuptiGetTimestamp", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetTimestampP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiGetTimestamp uint64_t  * timestamp Get the CUPTI timestamp. Returns a timestamp normalized to correspond with the start and end timestamps reported in the CUPTI activity records. The timestamp is reported in nanoseconds. Parameters timestamp \u2013 Returns the CUPTI timestamp Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if timestamp is NULL", "keywords": []}, {"id": 929, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiGetTimestamp::timestamp", "display_name": "cuptiGetTimestamp::timestamp", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv417cuptiGetTimestampP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiGetTimestamp uint64_t  * timestamp Get the CUPTI timestamp. Returns a timestamp normalized to correspond with the start and end timestamps reported in the CUPTI activity records. The timestamp is reported in nanoseconds. Parameters timestamp \u2013 Returns the CUPTI timestamp Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if timestamp is NULL", "keywords": []}, {"id": 930, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiSetThreadIdType", "display_name": "cuptiSetThreadIdType", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiSetThreadIdType26CUpti_ActivityThreadIdType", "priority": 1, "content": "CUptiResult  cuptiSetThreadIdType CUpti_ActivityThreadIdType  type Set the thread-id type. CUPTI uses the method corresponding to set type to generate the thread-id. See enum CUpti_ActivityThreadIdType for the list of methods. Activity records having thread-id field contain the same value. Thread id type must not be changed during the profiling session to avoid thread-id value mismatch across activity records. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_SUPPORTED \u2013 if type is not supported on the platform", "keywords": []}, {"id": 931, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "cpp", "name": "cuptiSetThreadIdType::type", "display_name": "cuptiSetThreadIdType::type", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "_CPPv420cuptiSetThreadIdType26CUpti_ActivityThreadIdType", "priority": 1, "content": "CUptiResult  cuptiSetThreadIdType CUpti_ActivityThreadIdType  type Set the thread-id type. CUPTI uses the method corresponding to set type to generate the thread-id. See enum CUpti_ActivityThreadIdType for the list of methods. Activity records having thread-id field contain the same value. Thread id type must not be changed during the profiling session to avoid thread-id value mismatch across activity records. Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_SUPPORTED \u2013 if type is not supported on the platform", "keywords": []}, {"id": 932, "doc_id": 932, "filename": "api/group__CUPTI__ACTIVITY__API.html", "domain_name": "std", "name": "api/group__CUPTI__ACTIVITY__API", "display_name": "CUPTI Activity API", "type": "doc", "display_type": "Page", "docname": "api/group__CUPTI__ACTIVITY__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the CUPTI Activity API. Data Structures CUpti_Activity  The base activity record. CUpti_ActivityAPI  The activity record for a driver or runtime API invocation. CUpti_ActivityAutoBoostState  Device auto boost state structure. CUpti_ActivityBranch2  The activity record for source level result branch. CUpti_ActivityCdpKernel  The activity record for CDP (CUDA Dynamic Parallelism) kernel. CUpti_ActivityConfidentialComputeRotation  Event related to confidential compute encryption rotation. CUpti_ActivityContext3  The activity record for a context. CUpti_ActivityCudaEvent2  The activity record for CUDA event. CUpti_ActivityDevice5  The activity record for a device. CUpti_ActivityDeviceAttribute  The activity record for a device attribute. CUpti_ActivityDeviceGraphTrace  The activity record for trace of device graph execution. CUpti_ActivityEnvironment  The activity record for CUPTI environmental data. CUpti_ActivityEvent  The activity record for a CUPTI event. CUpti_ActivityEventInstance  The activity record for a CUPTI event with instance information. CUpti_ActivityExternalCorrelation  The activity record for correlation with external records. CUpti_ActivityFunction  The activity record for global/device functions. CUpti_ActivityGlobalAccess3  The activity record for source-level global access. CUpti_ActivityGraphTrace2  The activity record for trace of graph execution. CUpti_ActivityInstantaneousEvent  The activity record for an instantaneous CUPTI event. CUpti_ActivityInstantaneousEventInstance  The activity record for an instantaneous CUPTI event with event domain instance information. CUpti_ActivityInstantaneousMetric  The activity record for an instantaneous CUPTI metric. CUpti_ActivityInstantaneousMetricInstance  The instantaneous activity record for a CUPTI metric with instance information. CUpti_ActivityInstructionCorrelation  The activity record for source-level sass/source line-by-line correlation. CUpti_ActivityInstructionExecution  The activity record for source-level instruction execution. CUpti_ActivityJit2  The activity record for JIT operations. CUpti_ActivityKernel9  The activity record for kernel. CUpti_ActivityMarker2  The activity record providing a marker which is an instantaneous point in time. CUpti_ActivityMarkerData  The activity record providing detailed information for a marker. CUpti_ActivityMemDecompress  The activity record for trace of decompression operations. CUpti_ActivityMemcpy6  The activity record for memory copies. CUpti_ActivityMemcpyPtoP4  The activity record for peer-to-peer memory copies. CUpti_ActivityMemory  The activity record for memory. CUpti_ActivityMemory4  The activity record for memory. CUpti_ActivityMemoryPool2  The activity record for memory pool. CUpti_ActivityMemset4  The activity record for memset. CUpti_ActivityMetric  The activity record for a CUPTI metric. CUpti_ActivityMetricInstance  The activity record for a CUPTI metric with instance information. CUpti_ActivityModule  The activity record for a CUDA module. CUpti_ActivityName  The activity record providing a name. CUpti_ActivityNvLink4  NVLink information. CUpti_ActivityObjectKindId  Identifiers for object kinds as specified by CUpti_ActivityObjectKind. CUpti_ActivityOpenAcc  The base activity record for OpenAcc records. CUpti_ActivityOpenAccData  The activity record for OpenACC data. CUpti_ActivityOpenAccLaunch  The activity record for OpenACC launch. CUpti_ActivityOpenAccOther  The activity record for OpenACC other. CUpti_ActivityOpenMp  The base activity record for OpenMp records. CUpti_ActivityOverhead3  The activity record for CUPTI and driver overheads. CUpti_ActivityOverheadCommandBufferFullData  The structure to provide additional data for CUPTI_ACTIVITY_OVERHEAD_COMMAND_BUFFER_FULL. CUpti_ActivityPCSampling3  The activity record for PC sampling. CUpti_ActivityPCSamplingConfig  PC sampling configuration structure. CUpti_ActivityPCSamplingRecordInfo  The activity record for record status for PC sampling. CUpti_ActivityPcie  PCI devices information required to construct topology. CUpti_ActivityPreemption  The activity record for a preemption of a CDP kernel. CUpti_ActivitySharedAccess  The activity record for source-level shared access. CUpti_ActivitySourceLocator  The activity record for source locator. CUpti_ActivityStream  The activity record for CUDA stream. CUpti_ActivitySynchronization2  The activity record for synchronization management. CUpti_ActivityUnifiedMemoryCounter3  The activity record for Unified Memory counters (CUDA 7.0 and beyond) CUpti_ActivityUnifiedMemoryCounterConfig  Unified Memory counters configuration structure. Macros CUPTI_AUTO_BOOST_INVALID_CLIENT_PID  An invalid/unknown process id. CUPTI_CORRELATION_ID_UNKNOWN  An invalid/unknown correlation ID. CUPTI_DECOMPRESSED_BYTES_UNKNOWN  An invalid/unknown value for decompressed bytes. CUPTI_FUNCTION_INDEX_ID_INVALID  An invalid function index ID. CUPTI_GRID_ID_UNKNOWN  An invalid/unknown grid ID. CUPTI_MAX_GPUS   CUPTI_MAX_NVLINK_PORTS  Maximum NVLink port numbers. CUPTI_NVLINK_INVALID_PORT  Invalid/unknown NVLink port number. CUPTI_SOURCE_LOCATOR_ID_UNKNOWN  The source-locator ID that indicates an unknown source location. CUPTI_SYNCHRONIZATION_INVALID_VALUE  An invalid/unknown value. CUPTI_TIMESTAMP_UNKNOWN  An invalid/unknown timestamp for a start, end, queued, submitted, or completed time. Enumerations CUpti_ActivityAttribute  Activity attributes. CUpti_ActivityComputeApiKind  The kind of a compute API. CUpti_ActivityEnvironmentKind  The kind of environment data. CUpti_ActivityFlag  Flags associated with activity records. CUpti_ActivityInstructionClass  SASS instruction classification. CUpti_ActivityJitEntryType  The types of JIT entry. CUpti_ActivityJitOperationType  The types of JIT compilation operations. CUpti_ActivityKind  The kinds of activity records. CUpti_ActivityLaunchType  The type of the CUDA kernel launch. CUpti_ActivityMemcpyKind  The kind of a memory copy, indicating the source and destination targets of the copy. CUpti_ActivityMemoryKind  The kinds of memory accessed by a memory operation/copy. CUpti_ActivityMemoryOperationType  Memory operation types. CUpti_ActivityMemoryPoolOperationType  Memory pool operation types. CUpti_ActivityMemoryPoolType  Memory pool types. CUpti_ActivityObjectKind  The kinds of activity objects. CUpti_ActivityOverheadKind  The kinds of activity overhead. CUpti_ActivityPCSamplingPeriod  Sampling period for PC sampling method. CUpti_ActivityPCSamplingStallReason  The stall reason for PC sampling activity. CUpti_ActivityPartitionedGlobalCacheConfig  Partitioned global caching option. CUpti_ActivityPreemptionKind  The kind of a preemption activity. CUpti_ActivityStreamFlag  stream type. CUpti_ActivitySynchronizationType  Synchronization type. CUpti_ActivityThreadIdType  Thread-Id types. CUpti_ActivityUnifiedMemoryAccessType  Memory access type for unified memory page faults. CUpti_ActivityUnifiedMemoryCounterKind  Kind of the Unified Memory counter. CUpti_ActivityUnifiedMemoryCounterScope  Scope of the unified memory counter (deprecated in CUDA 7.0) CUpti_ActivityUnifiedMemoryMigrationCause  Migration cause of the Unified Memory counter. CUpti_ActivityUnifiedMemoryRemoteMapCause  Remote memory map cause of the Unified Memory counter. CUpti_ChannelType   CUpti_ConfidentialComputeRotationEventType   CUpti_ContextCigMode  CIG (CUDA in Graphics) Modes. CUpti_DevType  The device type for device connected to NVLink. CUpti_DeviceGraphLaunchMode  The launch mode for device graph execution. CUpti_DeviceVirtualizationMode  This indicates the virtualization mode in which CUDA device is running. CUpti_EnvironmentClocksThrottleReason  Reasons for clock throttling. CUpti_ExternalCorrelationKind  The kind of external APIs supported for correlation. CUpti_FuncShmemLimitConfig  The shared memory limit per block config for a kernel This should be used to set &#x27;cudaOccFuncShmemConfig&#x27; field in occupancy calculator API. CUpti_LinkFlag  Link flags. CUpti_OpenAccConstructKind  The OpenAcc parent construct kind for OpenAcc activity records. CUpti_OpenAccEventKind  The OpenAcc event kind for OpenAcc activity records. CUpti_OpenMpEventKind   CUpti_PcieDeviceType  Field to differentiate whether PCIE Activity record is of a GPU or a PCI Bridge. CUpti_PcieGen  PCIE Generation. Functions CUptiResult  cuptiActivityConfigurePCSampling (CUcontext ctx, CUpti_ActivityPCSamplingConfig *config) Set PC sampling configuration. CUptiResult  cuptiActivityConfigureUnifiedMemoryCounter (CUpti_ActivityUnifiedMemoryCounterConfig *config, uint32_t count) Set Unified Memory Counter configuration. CUptiResult  cuptiActivityDisable (CUpti_ActivityKind kind) Disable collection of a specific kind of activity record. CUptiResult  cuptiActivityDisableContext (CUcontext context, CUpti_ActivityKind kind) Disable collection of a specific kind of activity record for a context. CUptiResult  cuptiActivityEnable (CUpti_ActivityKind kind) Enable collection of a specific kind of activity record. CUptiResult  cuptiActivityEnableAllSyncRecords (uint8_t enable) Enables collecting records for all synchronization operations. CUptiResult  cuptiActivityEnableAllocationSource (uint8_t enable) Enables tracking the source library for memory allocation requests. CUptiResult  cuptiActivityEnableAndDump (CUpti_ActivityKind kind) Enable collection of a specific kind of activity record. CUptiResult  cuptiActivityEnableContext (CUcontext context, CUpti_ActivityKind kind) Enable collection of a specific kind of activity record for a context. CUptiResult  cuptiActivityEnableDeviceGraph (uint8_t enable) Controls the collection of records for device launched graphs. CUptiResult  cuptiActivityEnableDriverApi (CUpti_CallbackId cbid, uint8_t enable) Controls the collection of activity records for specific CUDA Driver APIs. CUptiResult  cuptiActivityEnableHWTrace (uint8_t enable) Enables the collection of CUDA kernel timestamps through Hardware Event System(HES). CUptiResult  cuptiActivityEnableLatencyTimestamps (uint8_t enable) Controls the collection of queued and submitted timestamps for kernels. CUptiResult  cuptiActivityEnableLaunchAttributes (uint8_t enable) Controls the collection of launch attributes for kernels. CUptiResult  cuptiActivityEnableRuntimeApi (CUpti_CallbackId cbid, uint8_t enable) Controls the collection of activity records for specific CUDA Runtime APIs. CUptiResult  cuptiActivityFlush (CUcontext context, uint32_t streamId, uint32_t flag) Wait for all activity records to be delivered via the completion callback. CUptiResult  cuptiActivityFlushAll (uint32_t flag) Request to deliver activity records via the buffer completion callback. CUptiResult  cuptiActivityFlushPeriod (uint32_t time) Sets the flush period for the worker thread. CUptiResult  cuptiActivityGetAttribute (CUpti_ActivityAttribute attr, size_t *valueSize, void *value) Read an activity API attribute. CUptiResult  cuptiActivityGetNextRecord (uint8_t *buffer, size_t validBufferSizeBytes, CUpti_Activity **record) Iterate over the activity records in a buffer. CUptiResult  cuptiActivityGetNumDroppedRecords (CUcontext context, uint32_t streamId, size_t *dropped) Get the number of activity records that were dropped of insufficient buffer space. CUptiResult  cuptiActivityPopExternalCorrelationId (CUpti_ExternalCorrelationKind kind, uint64_t *lastId) Pop an external correlation id for the calling thread. CUptiResult  cuptiActivityPushExternalCorrelationId (CUpti_ExternalCorrelationKind kind, uint64_t id) Push an external correlation id for the calling thread. CUptiResult  cuptiActivityRegisterCallbacks (CUpti_BuffersCallbackRequestFunc funcBufferRequested, CUpti_BuffersCallbackCompleteFunc funcBufferCompleted) Registers callback functions with CUPTI for activity buffer handling. CUptiResult  cuptiActivityRegisterTimestampCallback (CUpti_TimestampCallbackFunc funcTimestamp) Registers callback function with CUPTI for providing timestamp. CUptiResult  cuptiActivitySetAttribute (CUpti_ActivityAttribute attr, size_t *valueSize, void *value) Write an activity API attribute. CUptiResult  cuptiComputeCapabilitySupported (int major, int minor, int *support) Check support for a compute capability. CUptiResult  cuptiDeviceSupported (CUdevice dev, int *support) Check support for a compute device. CUptiResult  cuptiDeviceVirtualizationMode (CUdevice dev, CUpti_DeviceVirtualizationMode *mode) Query the virtualization mode of the device. CUptiResult  cuptiFinalize (void) Detach CUPTI from the running process. CUptiResult  cuptiGetAutoBoostState (CUcontext context, CUpti_ActivityAutoBoostState *state) Get auto boost state. CUptiResult  cuptiGetContextId (CUcontext context, uint32_t *contextId) Get the ID of a context. CUptiResult  cuptiGetDeviceId (CUcontext context, uint32_t *deviceId) Get the ID of a device. CUptiResult  cuptiGetGraphExecId (CUgraphExec graphExec, uint32_t *pId) Get the unique ID of executable graph. CUptiResult  cuptiGetGraphId (CUgraph graph, uint32_t *pId) Get the unique ID of graph. CUptiResult  cuptiGetGraphNodeId (CUgraphNode node, uint64_t *nodeId) Get the unique ID of a graph node. CUptiResult  cuptiGetLastError (void) Returns the last error from a cupti call or callback. CUptiResult  cuptiGetStreamId (CUcontext context, CUstream stream, uint32_t *streamId) Get the ID of a stream. CUptiResult  cuptiGetStreamIdEx (CUcontext context, CUstream stream, uint8_t perThreadStream, uint32_t *streamId) Get the ID of a stream. CUptiResult  cuptiGetThreadIdType (CUpti_ActivityThreadIdType *type) Get the thread-id type. CUptiResult  cuptiGetTimestamp (uint64_t *timestamp) Get the CUPTI timestamp. CUptiResult  cuptiSetThreadIdType (CUpti_ActivityThreadIdType type) Set the thread-id type. Typedefs CUpti_BuffersCallbackCompleteFunc  Function type for callback used by CUPTI to return a buffer of activity records. CUpti_BuffersCallbackRequestFunc  Function type for callback used by CUPTI to request an empty buffer for storing activity records. CUpti_TimestampCallbackFunc  Function type for callback used by CUPTI to request a timestamp to be used in activity records.", "keywords": []}, {"id": 933, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_API_CBSITE_FORCE_INT", "display_name": "CUPTI_API_CBSITE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite26CUPTI_API_CBSITE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_API_CBSITE_FORCE_INT", "keywords": []}, {"id": 934, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_API_ENTER", "display_name": "CUPTI_API_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite15CUPTI_API_ENTERE", "priority": 1, "content": "enumerator  CUPTI_API_ENTER The callback is at the entry of the API call.", "keywords": []}, {"id": 935, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_API_EXIT", "display_name": "CUPTI_API_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite14CUPTI_API_EXITE", "priority": 1, "content": "enumerator  CUPTI_API_EXIT The callback is at the exit of the API call.", "keywords": []}, {"id": 936, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_CONTEXT_CREATED", "display_name": "CUPTI_CBID_RESOURCE_CONTEXT_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource35CUPTI_CBID_RESOURCE_CONTEXT_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CONTEXT_CREATED A new context has been created.", "keywords": []}, {"id": 937, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource44CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING A context is about to be destroyed.", "keywords": []}, {"id": 938, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_CU_INIT_FINISHED", "display_name": "CUPTI_CBID_RESOURCE_CU_INIT_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource36CUPTI_CBID_RESOURCE_CU_INIT_FINISHEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CU_INIT_FINISHED The driver has finished initializing.", "keywords": []}, {"id": 939, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_FORCE_INT", "display_name": "CUPTI_CBID_RESOURCE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource29CUPTI_CBID_RESOURCE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_FORCE_INT", "keywords": []}, {"id": 940, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED", "display_name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource37CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED An executable CUDA graph is created.", "keywords": []}, {"id": 941, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource45CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING An executable CUDA graph is about to be created.", "keywords": []}, {"id": 942, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource46CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING An executable CUDA graph is about to be destroyed.", "keywords": []}, {"id": 943, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource36CUPTI_CBID_RESOURCE_GRAPHNODE_CLONEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED CUDA graph node is cloned.", "keywords": []}, {"id": 944, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource37CUPTI_CBID_RESOURCE_GRAPHNODE_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED CUDA graph node is created.", "keywords": []}, {"id": 945, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource45CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING CUDA graph node is about to be created.", "keywords": []}, {"id": 946, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource48CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED Dependency on a CUDA graph node is created.", "keywords": []}, {"id": 947, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource57CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING Dependency on a CUDA graph node is destroyed.", "keywords": []}, {"id": 948, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource46CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING CUDA graph node is about to be destroyed.", "keywords": []}, {"id": 949, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPH_CLONED", "display_name": "CUPTI_CBID_RESOURCE_GRAPH_CLONED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource32CUPTI_CBID_RESOURCE_GRAPH_CLONEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_CLONED CUDA graph is cloned.", "keywords": []}, {"id": 950, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPH_CREATED", "display_name": "CUPTI_CBID_RESOURCE_GRAPH_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource33CUPTI_CBID_RESOURCE_GRAPH_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_CREATED CUDA graph has been created.", "keywords": []}, {"id": 951, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource42CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING CUDA graph is about to be destroyed.", "keywords": []}, {"id": 952, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_INVALID", "display_name": "CUPTI_CBID_RESOURCE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource27CUPTI_CBID_RESOURCE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_INVALID Invalid resource callback ID.", "keywords": []}, {"id": 953, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_MODULE_LOADED", "display_name": "CUPTI_CBID_RESOURCE_MODULE_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource33CUPTI_CBID_RESOURCE_MODULE_LOADEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_LOADED A module has been loaded.", "keywords": []}, {"id": 954, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_MODULE_PROFILED", "display_name": "CUPTI_CBID_RESOURCE_MODULE_PROFILED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource35CUPTI_CBID_RESOURCE_MODULE_PROFILEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_PROFILED The current module which is being profiled.", "keywords": []}, {"id": 955, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "display_name": "CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource42CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING A module is about to be unloaded.", "keywords": []}, {"id": 956, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_SIZE", "display_name": "CUPTI_CBID_RESOURCE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource24CUPTI_CBID_RESOURCE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_SIZE", "keywords": []}, {"id": 957, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED", "display_name": "CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource44CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED CUDA stream attribute is changed.", "keywords": []}, {"id": 958, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_STREAM_CREATED", "display_name": "CUPTI_CBID_RESOURCE_STREAM_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource34CUPTI_CBID_RESOURCE_STREAM_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_CREATED A new stream has been created.", "keywords": []}, {"id": 959, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING", "display_name": "CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource43CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING A stream is about to be destroyed.", "keywords": []}, {"id": 960, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_ERROR", "display_name": "CUPTI_CBID_STATE_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState22CUPTI_CBID_STATE_ERRORE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_ERROR Notification of non fatal errors - high impact, but recoverable This notification is not issued in the current release.", "keywords": []}, {"id": 961, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_FATAL_ERROR", "display_name": "CUPTI_CBID_STATE_FATAL_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState28CUPTI_CBID_STATE_FATAL_ERRORE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_FATAL_ERROR Notification of fatal errors - high impact, non-recoverable When encountered, CUPTI automatically invokes cuptiFinalize() User can control behavior of the application in future from receiving this callback - such as continuing without profiling, or terminating the whole application.", "keywords": []}, {"id": 962, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_FORCE_INT", "display_name": "CUPTI_CBID_STATE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState26CUPTI_CBID_STATE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_FORCE_INT", "keywords": []}, {"id": 963, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_INVALID", "display_name": "CUPTI_CBID_STATE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState24CUPTI_CBID_STATE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_INVALID Invalid state callback ID.", "keywords": []}, {"id": 964, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_SIZE", "display_name": "CUPTI_CBID_STATE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState21CUPTI_CBID_STATE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_SIZE", "keywords": []}, {"id": 965, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_STATE_WARNING", "display_name": "CUPTI_CBID_STATE_WARNING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState24CUPTI_CBID_STATE_WARNINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_WARNING Notification of warnings - low impact, recoverable.", "keywords": []}, {"id": 966, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "display_name": "CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync43CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED Context synchronization has completed for the context.", "keywords": []}, {"id": 967, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "display_name": "CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync32CUPTI_CBID_SYNCHRONIZE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "keywords": []}, {"id": 968, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_SYNCHRONIZE_INVALID", "display_name": "CUPTI_CBID_SYNCHRONIZE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync30CUPTI_CBID_SYNCHRONIZE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_INVALID Invalid synchronize callback ID.", "keywords": []}, {"id": 969, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_SYNCHRONIZE_SIZE", "display_name": "CUPTI_CBID_SYNCHRONIZE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync27CUPTI_CBID_SYNCHRONIZE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_SIZE", "keywords": []}, {"id": 970, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "display_name": "CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync42CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED Stream synchronization has completed for the stream.", "keywords": []}, {"id": 971, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_DRIVER_API", "display_name": "CUPTI_CB_DOMAIN_DRIVER_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain26CUPTI_CB_DOMAIN_DRIVER_APIE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_DRIVER_API Domain containing callback points for all driver API functions.", "keywords": []}, {"id": 972, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_FORCE_INT", "display_name": "CUPTI_CB_DOMAIN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain25CUPTI_CB_DOMAIN_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_FORCE_INT", "keywords": []}, {"id": 973, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_INVALID", "display_name": "CUPTI_CB_DOMAIN_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain23CUPTI_CB_DOMAIN_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_INVALID Invalid domain.", "keywords": []}, {"id": 974, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_NVTX", "display_name": "CUPTI_CB_DOMAIN_NVTX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain20CUPTI_CB_DOMAIN_NVTXE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_NVTX Domain containing callback points for NVTX API functions.", "keywords": []}, {"id": 975, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_RESOURCE", "display_name": "CUPTI_CB_DOMAIN_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain24CUPTI_CB_DOMAIN_RESOURCEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_RESOURCE Domain containing callback points for CUDA resource tracking.", "keywords": []}, {"id": 976, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_RUNTIME_API", "display_name": "CUPTI_CB_DOMAIN_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain27CUPTI_CB_DOMAIN_RUNTIME_APIE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_RUNTIME_API Domain containing callback points for all runtime API functions.", "keywords": []}, {"id": 977, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_SIZE", "display_name": "CUPTI_CB_DOMAIN_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain20CUPTI_CB_DOMAIN_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_SIZE", "keywords": []}, {"id": 978, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_STATE", "display_name": "CUPTI_CB_DOMAIN_STATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain21CUPTI_CB_DOMAIN_STATEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_STATE Domain containing callback points for various states.", "keywords": []}, {"id": 979, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUPTI_CB_DOMAIN_SYNCHRONIZE", "display_name": "CUPTI_CB_DOMAIN_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain27CUPTI_CB_DOMAIN_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_SYNCHRONIZE Domain containing callback points for CUDA synchronization.", "keywords": []}, {"id": 980, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_ApiCallbackSite", "display_name": "CUpti_ApiCallbackSite", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421CUpti_ApiCallbackSite", "priority": 1, "content": "enum  CUpti_ApiCallbackSite Specifies the point in an API call that a callback is issued. Specifies the point in an API call that a callback is issued. This value is communicated to the callback function via CUpti_CallbackData::callbackSite . Values:", "keywords": []}, {"id": 981, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_ApiCallbackSite::CUPTI_API_CBSITE_FORCE_INT", "display_name": "CUpti_ApiCallbackSite::CUPTI_API_CBSITE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite26CUPTI_API_CBSITE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_API_CBSITE_FORCE_INT", "keywords": []}, {"id": 982, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_ApiCallbackSite::CUPTI_API_ENTER", "display_name": "CUpti_ApiCallbackSite::CUPTI_API_ENTER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite15CUPTI_API_ENTERE", "priority": 1, "content": "enumerator  CUPTI_API_ENTER The callback is at the entry of the API call.", "keywords": []}, {"id": 983, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_ApiCallbackSite::CUPTI_API_EXIT", "display_name": "CUpti_ApiCallbackSite::CUPTI_API_EXIT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_ApiCallbackSite14CUPTI_API_EXITE", "priority": 1, "content": "enumerator  CUPTI_API_EXIT The callback is at the exit of the API call.", "keywords": []}, {"id": 984, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain", "display_name": "CUpti_CallbackDomain", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420CUpti_CallbackDomain", "priority": 1, "content": "enum  CUpti_CallbackDomain Callback domains. Callback domains. Each domain represents callback points for a group of related API functions or CUDA driver activity. Values:", "keywords": []}, {"id": 985, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_DRIVER_API", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_DRIVER_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain26CUPTI_CB_DOMAIN_DRIVER_APIE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_DRIVER_API Domain containing callback points for all driver API functions.", "keywords": []}, {"id": 986, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_FORCE_INT", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain25CUPTI_CB_DOMAIN_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_FORCE_INT", "keywords": []}, {"id": 987, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_INVALID", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain23CUPTI_CB_DOMAIN_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_INVALID Invalid domain.", "keywords": []}, {"id": 988, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_NVTX", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_NVTX", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain20CUPTI_CB_DOMAIN_NVTXE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_NVTX Domain containing callback points for NVTX API functions.", "keywords": []}, {"id": 989, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_RESOURCE", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_RESOURCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain24CUPTI_CB_DOMAIN_RESOURCEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_RESOURCE Domain containing callback points for CUDA resource tracking.", "keywords": []}, {"id": 990, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_RUNTIME_API", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_RUNTIME_API", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain27CUPTI_CB_DOMAIN_RUNTIME_APIE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_RUNTIME_API Domain containing callback points for all runtime API functions.", "keywords": []}, {"id": 991, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_SIZE", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain20CUPTI_CB_DOMAIN_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_SIZE", "keywords": []}, {"id": 992, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_STATE", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_STATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain21CUPTI_CB_DOMAIN_STATEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_STATE Domain containing callback points for various states.", "keywords": []}, {"id": 993, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_SYNCHRONIZE", "display_name": "CUpti_CallbackDomain::CUPTI_CB_DOMAIN_SYNCHRONIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackDomain27CUPTI_CB_DOMAIN_SYNCHRONIZEE", "priority": 1, "content": "enumerator  CUPTI_CB_DOMAIN_SYNCHRONIZE Domain containing callback points for CUDA synchronization.", "keywords": []}, {"id": 994, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackFunc", "display_name": "CUpti_CallbackFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv418CUpti_CallbackFunc", "priority": 1, "content": "typedef  void  ( * CUpti_CallbackFunc ) ( void  * userdata ,  CUpti_CallbackDomain  domain ,  CUpti_CallbackId  cbid ,  const  void  * cbdata ) Function type for a callback. Function type for a callback. The type of the data passed to the callback in cbdata depends on the domain . If domain is CUPTI_CB_DOMAIN_DRIVER_API or CUPTI_CB_DOMAIN_RUNTIME_API the type of cbdata will be CUpti_CallbackData . If domain is CUPTI_CB_DOMAIN_RESOURCE the type of cbdata will be CUpti_ResourceData . If domain is CUPTI_CB_DOMAIN_SYNCHRONIZE the type of cbdata will be CUpti_SynchronizeData . If domain is CUPTI_CB_DOMAIN_NVTX the type of cbdata will be CUpti_NvtxData . Param userdata User data supplied at subscription of the callback Param domain The domain of the callback Param cbid The ID of the callback Param cbdata Data passed to the callback.", "keywords": []}, {"id": 995, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackId", "display_name": "CUpti_CallbackId", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv416CUpti_CallbackId", "priority": 1, "content": "typedef  uint32_t  CUpti_CallbackId An ID for a driver API, runtime API, resource or synchronization callback. An ID for a driver API, runtime API, resource or synchronization callback. Within a driver API callback this should be interpreted as a CUpti_driver_api_trace_cbid value (these values are defined in cupti_driver_cbid.h). Within a runtime API callback this should be interpreted as a CUpti_runtime_api_trace_cbid value (these values are defined in cupti_runtime_cbid.h). Within a resource API callback this should be interpreted as a CUpti_CallbackIdResource value. Within a synchronize API callback this should be interpreted as a CUpti_CallbackIdSync value.", "keywords": []}, {"id": 996, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource", "display_name": "CUpti_CallbackIdResource", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv424CUpti_CallbackIdResource", "priority": 1, "content": "enum  CUpti_CallbackIdResource Callback IDs for resource domain. Callback IDs for resource domain, CUPTI_CB_DOMAIN_RESOURCE. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 997, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CONTEXT_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CONTEXT_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource35CUPTI_CBID_RESOURCE_CONTEXT_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CONTEXT_CREATED A new context has been created.", "keywords": []}, {"id": 998, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource44CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CONTEXT_DESTROY_STARTING A context is about to be destroyed.", "keywords": []}, {"id": 999, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CU_INIT_FINISHED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_CU_INIT_FINISHED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource36CUPTI_CBID_RESOURCE_CU_INIT_FINISHEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_CU_INIT_FINISHED The driver has finished initializing.", "keywords": []}, {"id": 1000, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_FORCE_INT", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource29CUPTI_CBID_RESOURCE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_FORCE_INT", "keywords": []}, {"id": 1001, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource37CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATED An executable CUDA graph is created.", "keywords": []}, {"id": 1002, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource45CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_CREATE_STARTING An executable CUDA graph is about to be created.", "keywords": []}, {"id": 1003, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource46CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHEXEC_DESTROY_STARTING An executable CUDA graph is about to be destroyed.", "keywords": []}, {"id": 1004, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource36CUPTI_CBID_RESOURCE_GRAPHNODE_CLONEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CLONED CUDA graph node is cloned.", "keywords": []}, {"id": 1005, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource37CUPTI_CBID_RESOURCE_GRAPHNODE_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATED CUDA graph node is created.", "keywords": []}, {"id": 1006, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource45CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_CREATE_STARTING CUDA graph node is about to be created.", "keywords": []}, {"id": 1007, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource48CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_CREATED Dependency on a CUDA graph node is created.", "keywords": []}, {"id": 1008, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource57CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DEPENDENCY_DESTROY_STARTING Dependency on a CUDA graph node is destroyed.", "keywords": []}, {"id": 1009, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource46CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPHNODE_DESTROY_STARTING CUDA graph node is about to be destroyed.", "keywords": []}, {"id": 1010, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_CLONED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_CLONED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource32CUPTI_CBID_RESOURCE_GRAPH_CLONEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_CLONED CUDA graph is cloned.", "keywords": []}, {"id": 1011, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource33CUPTI_CBID_RESOURCE_GRAPH_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_CREATED CUDA graph has been created.", "keywords": []}, {"id": 1012, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource42CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_GRAPH_DESTROY_STARTING CUDA graph is about to be destroyed.", "keywords": []}, {"id": 1013, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_INVALID", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource27CUPTI_CBID_RESOURCE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_INVALID Invalid resource callback ID.", "keywords": []}, {"id": 1014, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_LOADED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_LOADED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource33CUPTI_CBID_RESOURCE_MODULE_LOADEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_LOADED A module has been loaded.", "keywords": []}, {"id": 1015, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_PROFILED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_PROFILED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource35CUPTI_CBID_RESOURCE_MODULE_PROFILEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_PROFILED The current module which is being profiled.", "keywords": []}, {"id": 1016, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource42CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_MODULE_UNLOAD_STARTING A module is about to be unloaded.", "keywords": []}, {"id": 1017, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_SIZE", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource24CUPTI_CBID_RESOURCE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_SIZE", "keywords": []}, {"id": 1018, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource44CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED CUDA stream attribute is changed.", "keywords": []}, {"id": 1019, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_CREATED", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_CREATED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource34CUPTI_CBID_RESOURCE_STREAM_CREATEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_CREATED A new stream has been created.", "keywords": []}, {"id": 1020, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING", "display_name": "CUpti_CallbackIdResource::CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N24CUpti_CallbackIdResource43CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_RESOURCE_STREAM_DESTROY_STARTING A stream is about to be destroyed.", "keywords": []}, {"id": 1021, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState", "display_name": "CUpti_CallbackIdState", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421CUpti_CallbackIdState", "priority": 1, "content": "enum  CUpti_CallbackIdState Callback IDs for state domain. Callback IDs for state domain, CUPTI_CB_DOMAIN_STATE. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 1022, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_ERROR", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState22CUPTI_CBID_STATE_ERRORE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_ERROR Notification of non fatal errors - high impact, but recoverable This notification is not issued in the current release.", "keywords": []}, {"id": 1023, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_FATAL_ERROR", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_FATAL_ERROR", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState28CUPTI_CBID_STATE_FATAL_ERRORE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_FATAL_ERROR Notification of fatal errors - high impact, non-recoverable When encountered, CUPTI automatically invokes cuptiFinalize() User can control behavior of the application in future from receiving this callback - such as continuing without profiling, or terminating the whole application.", "keywords": []}, {"id": 1024, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_FORCE_INT", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState26CUPTI_CBID_STATE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_FORCE_INT", "keywords": []}, {"id": 1025, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_INVALID", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState24CUPTI_CBID_STATE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_INVALID Invalid state callback ID.", "keywords": []}, {"id": 1026, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_SIZE", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState21CUPTI_CBID_STATE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_SIZE", "keywords": []}, {"id": 1027, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_WARNING", "display_name": "CUpti_CallbackIdState::CUPTI_CBID_STATE_WARNING", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N21CUpti_CallbackIdState24CUPTI_CBID_STATE_WARNINGE", "priority": 1, "content": "enumerator  CUPTI_CBID_STATE_WARNING Notification of warnings - low impact, recoverable.", "keywords": []}, {"id": 1028, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync", "display_name": "CUpti_CallbackIdSync", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420CUpti_CallbackIdSync", "priority": 1, "content": "enum  CUpti_CallbackIdSync Callback IDs for synchronization domain. Callback IDs for synchronization domain, CUPTI_CB_DOMAIN_SYNCHRONIZE. This value is communicated to the callback function via the cbid parameter. Values:", "keywords": []}, {"id": 1029, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "display_name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync43CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_CONTEXT_SYNCHRONIZED Context synchronization has completed for the context.", "keywords": []}, {"id": 1030, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "display_name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync32CUPTI_CBID_SYNCHRONIZE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_FORCE_INT", "keywords": []}, {"id": 1031, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_INVALID", "display_name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_INVALID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync30CUPTI_CBID_SYNCHRONIZE_INVALIDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_INVALID Invalid synchronize callback ID.", "keywords": []}, {"id": 1032, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_SIZE", "display_name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_SIZE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync27CUPTI_CBID_SYNCHRONIZE_SIZEE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_SIZE", "keywords": []}, {"id": 1033, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "display_name": "CUpti_CallbackIdSync::CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv4N20CUpti_CallbackIdSync42CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZEDE", "priority": 1, "content": "enumerator  CUPTI_CBID_SYNCHRONIZE_STREAM_SYNCHRONIZED Stream synchronization has completed for the stream.", "keywords": []}, {"id": 1034, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_DomainTable", "display_name": "CUpti_DomainTable", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv417CUpti_DomainTable", "priority": 1, "content": "typedef  CUpti_CallbackDomain  * CUpti_DomainTable Pointer to an array of callback domains.", "keywords": []}, {"id": 1035, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "CUpti_SubscriberHandle", "display_name": "CUpti_SubscriberHandle", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv422CUpti_SubscriberHandle", "priority": 1, "content": "typedef  struct  CUpti_Subscriber_st  * CUpti_SubscriberHandle A callback subscriber.", "keywords": []}, {"id": 1036, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableAllDomains", "display_name": "cuptiEnableAllDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiEnableAllDomains8uint32_t22CUpti_SubscriberHandle", "priority": 1, "content": "CUptiResult  cuptiEnableAllDomains uint32_t  enable CUpti_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, *) and cuptiEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid", "keywords": []}, {"id": 1037, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableAllDomains::enable", "display_name": "cuptiEnableAllDomains::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiEnableAllDomains8uint32_t22CUpti_SubscriberHandle", "priority": 1, "content": "CUptiResult  cuptiEnableAllDomains uint32_t  enable CUpti_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, *) and cuptiEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid", "keywords": []}, {"id": 1038, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableAllDomains::subscriber", "display_name": "cuptiEnableAllDomains::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiEnableAllDomains8uint32_t22CUpti_SubscriberHandle", "priority": 1, "content": "CUptiResult  cuptiEnableAllDomains uint32_t  enable CUpti_SubscriberHandle  subscriber Enable or disable all callbacks in all domains. Enable or disable all callbacks in all domains. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, *) and cuptiEnableAllDomains(sub) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in all domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is invalid", "keywords": []}, {"id": 1039, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableCallback", "display_name": "cuptiEnableCallback", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv419cuptiEnableCallback8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiEnableCallback uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Enable or disabled callbacks for a specific domain and callback ID. Enable or disabled callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1040, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableCallback::cbid", "display_name": "cuptiEnableCallback::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv419cuptiEnableCallback8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiEnableCallback uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Enable or disabled callbacks for a specific domain and callback ID. Enable or disabled callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1041, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableCallback::domain", "display_name": "cuptiEnableCallback::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv419cuptiEnableCallback8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiEnableCallback uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Enable or disabled callbacks for a specific domain and callback ID. Enable or disabled callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1042, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableCallback::enable", "display_name": "cuptiEnableCallback::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv419cuptiEnableCallback8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiEnableCallback uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Enable or disabled callbacks for a specific domain and callback ID. Enable or disabled callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1043, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableCallback::subscriber", "display_name": "cuptiEnableCallback::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv419cuptiEnableCallback8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiEnableCallback uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Enable or disabled callbacks for a specific domain and callback ID. Enable or disabled callbacks for a subscriber for a specific domain and callback ID. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for the callback. Zero disables the callback, non-zero enables the callback. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1044, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableDomain", "display_name": "cuptiEnableDomain", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv417cuptiEnableDomain8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain", "priority": 1, "content": "CUptiResult  cuptiEnableDomain uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain Enable or disabled all callbacks for a specific domain. Enable or disabled all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackEnabled(sub, d, *) and cuptiEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid", "keywords": []}, {"id": 1045, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableDomain::domain", "display_name": "cuptiEnableDomain::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv417cuptiEnableDomain8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain", "priority": 1, "content": "CUptiResult  cuptiEnableDomain uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain Enable or disabled all callbacks for a specific domain. Enable or disabled all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackEnabled(sub, d, *) and cuptiEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid", "keywords": []}, {"id": 1046, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableDomain::enable", "display_name": "cuptiEnableDomain::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv417cuptiEnableDomain8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain", "priority": 1, "content": "CUptiResult  cuptiEnableDomain uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain Enable or disabled all callbacks for a specific domain. Enable or disabled all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackEnabled(sub, d, *) and cuptiEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid", "keywords": []}, {"id": 1047, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiEnableDomain::subscriber", "display_name": "cuptiEnableDomain::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv417cuptiEnableDomain8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain", "priority": 1, "content": "CUptiResult  cuptiEnableDomain uint32_t  enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain Enable or disabled all callbacks for a specific domain. Enable or disabled all callbacks for a specific domain. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackEnabled(sub, d, *) and cuptiEnableDomain(sub, d) are called concurrently, the results are undefined. Parameters enable \u2013 New enable state for all callbacks in the domain. Zero disables all callbacks, non-zero enables all callbacks. subscriber \u2013 - Handle to callback subscription domain \u2013 The domain of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber or domain is invalid", "keywords": []}, {"id": 1048, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackName", "display_name": "cuptiGetCallbackName", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420cuptiGetCallbackName20CUpti_CallbackDomain8uint32_tPPKc", "priority": 1, "content": "CUptiResult  cuptiGetCallbackName CUpti_CallbackDomain  domain uint32_t  cbid const  char  * * name Get the name of a callback for a specific domain and callback ID. Returns a pointer to the name c_string in **name . Names are available only for the DRIVER and RUNTIME domains. Parameters domain \u2013 The domain of the callback cbid \u2013 The ID of the callback name \u2013 Returns pointer to the name string on success, NULL otherwise Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_INVALID_PARAMETER \u2013 if name is NULL, or if domain or cbid is invalid.", "keywords": []}, {"id": 1049, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackName::cbid", "display_name": "cuptiGetCallbackName::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420cuptiGetCallbackName20CUpti_CallbackDomain8uint32_tPPKc", "priority": 1, "content": "CUptiResult  cuptiGetCallbackName CUpti_CallbackDomain  domain uint32_t  cbid const  char  * * name Get the name of a callback for a specific domain and callback ID. Returns a pointer to the name c_string in **name . Names are available only for the DRIVER and RUNTIME domains. Parameters domain \u2013 The domain of the callback cbid \u2013 The ID of the callback name \u2013 Returns pointer to the name string on success, NULL otherwise Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_INVALID_PARAMETER \u2013 if name is NULL, or if domain or cbid is invalid.", "keywords": []}, {"id": 1050, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackName::domain", "display_name": "cuptiGetCallbackName::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420cuptiGetCallbackName20CUpti_CallbackDomain8uint32_tPPKc", "priority": 1, "content": "CUptiResult  cuptiGetCallbackName CUpti_CallbackDomain  domain uint32_t  cbid const  char  * * name Get the name of a callback for a specific domain and callback ID. Returns a pointer to the name c_string in **name . Names are available only for the DRIVER and RUNTIME domains. Parameters domain \u2013 The domain of the callback cbid \u2013 The ID of the callback name \u2013 Returns pointer to the name string on success, NULL otherwise Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_INVALID_PARAMETER \u2013 if name is NULL, or if domain or cbid is invalid.", "keywords": []}, {"id": 1051, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackName::name", "display_name": "cuptiGetCallbackName::name", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv420cuptiGetCallbackName20CUpti_CallbackDomain8uint32_tPPKc", "priority": 1, "content": "CUptiResult  cuptiGetCallbackName CUpti_CallbackDomain  domain uint32_t  cbid const  char  * * name Get the name of a callback for a specific domain and callback ID. Returns a pointer to the name c_string in **name . Names are available only for the DRIVER and RUNTIME domains. Parameters domain \u2013 The domain of the callback cbid \u2013 The ID of the callback name \u2013 Returns pointer to the name string on success, NULL otherwise Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_INVALID_PARAMETER \u2013 if name is NULL, or if domain or cbid is invalid.", "keywords": []}, {"id": 1052, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackState", "display_name": "cuptiGetCallbackState", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiGetCallbackStateP8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiGetCallbackState uint32_t  * enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled subscriber \u2013 Handle to the initialize subscriber domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1053, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackState::cbid", "display_name": "cuptiGetCallbackState::cbid", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiGetCallbackStateP8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiGetCallbackState uint32_t  * enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled subscriber \u2013 Handle to the initialize subscriber domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1054, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackState::domain", "display_name": "cuptiGetCallbackState::domain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiGetCallbackStateP8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiGetCallbackState uint32_t  * enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled subscriber \u2013 Handle to the initialize subscriber domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1055, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackState::enable", "display_name": "cuptiGetCallbackState::enable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiGetCallbackStateP8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiGetCallbackState uint32_t  * enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled subscriber \u2013 Handle to the initialize subscriber domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1056, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiGetCallbackState::subscriber", "display_name": "cuptiGetCallbackState::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiGetCallbackStateP8uint32_t22CUpti_SubscriberHandle20CUpti_CallbackDomain16CUpti_CallbackId", "priority": 1, "content": "CUptiResult  cuptiGetCallbackState uint32_t  * enable CUpti_SubscriberHandle  subscriber CUpti_CallbackDomain  domain CUpti_CallbackId  cbid Get the current enabled/disabled state of a callback for a specific domain and function ID. Returns non-zero in *enable if the callback for a domain and callback ID is enabled, and zero if not enabled. Thread-safety : a subscriber must serialize access to cuptiGetCallbackState, cuptiEnableCallback, cuptiEnableDomain, and cuptiEnableAllDomains. For example, if cuptiGetCallbackState(sub, d, c) and cuptiEnableCallback(sub, d, c) are called concurrently, the results are undefined. Parameters enable \u2013 Returns non-zero if callback enabled, zero if not enabled subscriber \u2013 Handle to the initialize subscriber domain \u2013 The domain of the callback cbid \u2013 The ID of the callback Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if enabled is NULL, or if subscriber , domain or cbid is invalid.", "keywords": []}, {"id": 1057, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSubscribe", "display_name": "cuptiSubscribe", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv414cuptiSubscribeP22CUpti_SubscriberHandle18CUpti_CallbackFuncPv", "priority": 1, "content": "CUptiResult  cuptiSubscribe CUpti_SubscriberHandle  * subscriber CUpti_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initializes a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only a single subscriber can be registered at a time. To ensure that no other CUPTI client interrupts the profiling session, it\u2019s the responsibility of all the CUPTI clients to call this function before starting the profling session. In case profiling session is already started by another CUPTI client, this function returns the error code CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED. Note that this function returns the same error when application is launched using NVIDIA tools like nvprof, Visual Profiler, Nsight Systems, Nsight Compute, cuda-gdb and cuda-memcheck. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber callback \u2013 The callback function userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED \u2013 if there is already a CUPTI subscriber CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL", "keywords": []}, {"id": 1058, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSubscribe::callback", "display_name": "cuptiSubscribe::callback", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv414cuptiSubscribeP22CUpti_SubscriberHandle18CUpti_CallbackFuncPv", "priority": 1, "content": "CUptiResult  cuptiSubscribe CUpti_SubscriberHandle  * subscriber CUpti_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initializes a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only a single subscriber can be registered at a time. To ensure that no other CUPTI client interrupts the profiling session, it\u2019s the responsibility of all the CUPTI clients to call this function before starting the profling session. In case profiling session is already started by another CUPTI client, this function returns the error code CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED. Note that this function returns the same error when application is launched using NVIDIA tools like nvprof, Visual Profiler, Nsight Systems, Nsight Compute, cuda-gdb and cuda-memcheck. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber callback \u2013 The callback function userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED \u2013 if there is already a CUPTI subscriber CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL", "keywords": []}, {"id": 1059, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSubscribe::subscriber", "display_name": "cuptiSubscribe::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv414cuptiSubscribeP22CUpti_SubscriberHandle18CUpti_CallbackFuncPv", "priority": 1, "content": "CUptiResult  cuptiSubscribe CUpti_SubscriberHandle  * subscriber CUpti_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initializes a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only a single subscriber can be registered at a time. To ensure that no other CUPTI client interrupts the profiling session, it\u2019s the responsibility of all the CUPTI clients to call this function before starting the profling session. In case profiling session is already started by another CUPTI client, this function returns the error code CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED. Note that this function returns the same error when application is launched using NVIDIA tools like nvprof, Visual Profiler, Nsight Systems, Nsight Compute, cuda-gdb and cuda-memcheck. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber callback \u2013 The callback function userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED \u2013 if there is already a CUPTI subscriber CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL", "keywords": []}, {"id": 1060, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSubscribe::userdata", "display_name": "cuptiSubscribe::userdata", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv414cuptiSubscribeP22CUpti_SubscriberHandle18CUpti_CallbackFuncPv", "priority": 1, "content": "CUptiResult  cuptiSubscribe CUpti_SubscriberHandle  * subscriber CUpti_CallbackFunc  callback void  * userdata Initialize a callback subscriber with a callback function and user data. Initializes a callback subscriber with a callback function and (optionally) a pointer to user data. The returned subscriber handle can be used to enable and disable the callback for specific domains and callback IDs. Only a single subscriber can be registered at a time. To ensure that no other CUPTI client interrupts the profiling session, it\u2019s the responsibility of all the CUPTI clients to call this function before starting the profling session. In case profiling session is already started by another CUPTI client, this function returns the error code CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED. Note that this function returns the same error when application is launched using NVIDIA tools like nvprof, Visual Profiler, Nsight Systems, Nsight Compute, cuda-gdb and cuda-memcheck. This function does not enable any callbacks. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Returns handle to initialize subscriber callback \u2013 The callback function userdata \u2013 A pointer to user data. This data will be passed to the callback function via the userdata parameter. Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_MULTIPLE_SUBSCRIBERS_NOT_SUPPORTED \u2013 if there is already a CUPTI subscriber CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL", "keywords": []}, {"id": 1061, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSupportedDomains", "display_name": "cuptiSupportedDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiSupportedDomainsP6size_tP17CUpti_DomainTable", "priority": 1, "content": "CUptiResult  cuptiSupportedDomains size_t  * domainCount CUpti_DomainTable  * domainTable Get the available callback domains. Returns in *domainTable an array of size *domainCount of all the available callback domains. Thread-safety : this function is thread safe. Parameters domainCount \u2013 Returns number of callback domains domainTable \u2013 Returns pointer to array of available callback domains Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if domainCount or domainTable are NULL", "keywords": []}, {"id": 1062, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSupportedDomains::domainCount", "display_name": "cuptiSupportedDomains::domainCount", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiSupportedDomainsP6size_tP17CUpti_DomainTable", "priority": 1, "content": "CUptiResult  cuptiSupportedDomains size_t  * domainCount CUpti_DomainTable  * domainTable Get the available callback domains. Returns in *domainTable an array of size *domainCount of all the available callback domains. Thread-safety : this function is thread safe. Parameters domainCount \u2013 Returns number of callback domains domainTable \u2013 Returns pointer to array of available callback domains Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if domainCount or domainTable are NULL", "keywords": []}, {"id": 1063, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiSupportedDomains::domainTable", "display_name": "cuptiSupportedDomains::domainTable", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv421cuptiSupportedDomainsP6size_tP17CUpti_DomainTable", "priority": 1, "content": "CUptiResult  cuptiSupportedDomains size_t  * domainCount CUpti_DomainTable  * domainTable Get the available callback domains. Returns in *domainTable an array of size *domainCount of all the available callback domains. Thread-safety : this function is thread safe. Parameters domainCount \u2013 Returns number of callback domains domainTable \u2013 Returns pointer to array of available callback domains Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialize CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if domainCount or domainTable are NULL", "keywords": []}, {"id": 1064, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiUnsubscribe", "display_name": "cuptiUnsubscribe", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv416cuptiUnsubscribe22CUpti_SubscriberHandle", "priority": 1, "content": "CUptiResult  cuptiUnsubscribe CUpti_SubscriberHandle  subscriber Unregister a callback subscriber. Removes a callback subscriber so that no future callbacks will be issued to that subscriber. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Handle to the initialize subscriber Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL or not initialized", "keywords": []}, {"id": 1065, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "cpp", "name": "cuptiUnsubscribe::subscriber", "display_name": "cuptiUnsubscribe::subscriber", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "_CPPv416cuptiUnsubscribe22CUpti_SubscriberHandle", "priority": 1, "content": "CUptiResult  cuptiUnsubscribe CUpti_SubscriberHandle  subscriber Unregister a callback subscriber. Removes a callback subscriber so that no future callbacks will be issued to that subscriber. Thread-safety : this function is thread safe. Parameters subscriber \u2013 Handle to the initialize subscriber Return values CUPTI_SUCCESS \u2013 on success CUPTI_ERROR_NOT_INITIALIZED \u2013 if unable to initialized CUPTI CUPTI_ERROR_INVALID_PARAMETER \u2013 if subscriber is NULL or not initialized", "keywords": []}, {"id": 1066, "doc_id": 1066, "filename": "api/group__CUPTI__CALLBACK__API.html", "domain_name": "std", "name": "api/group__CUPTI__CALLBACK__API", "display_name": "CUPTI Callback API", "type": "doc", "display_type": "Page", "docname": "api/group__CUPTI__CALLBACK__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the CUPTI Callback API. Data Structures CUpti_CallbackData  Data passed into a runtime or driver API callback function. CUpti_GraphData  CUDA graphs data passed into a resource callback function. CUpti_ModuleResourceData  Module data passed into a resource callback function. CUpti_NvtxData  Data passed into a NVTX callback function. CUpti_ResourceData  Data passed into a resource callback function. CUpti_StateData  Data passed into a State callback function. CUpti_StreamAttrData  Stream attribute data passed into a resource callback function for CUPTI_CBID_RESOURCE_STREAM_ATTRIBUTE_CHANGED callback. CUpti_SynchronizeData  Data passed into a synchronize callback function. Enumerations CUpti_ApiCallbackSite  Specifies the point in an API call that a callback is issued. CUpti_CallbackDomain  Callback domains. CUpti_CallbackIdResource  Callback IDs for resource domain. CUpti_CallbackIdState  Callback IDs for state domain. CUpti_CallbackIdSync  Callback IDs for synchronization domain. Functions CUptiResult  cuptiEnableAllDomains (uint32_t enable, CUpti_SubscriberHandle subscriber) Enable or disable all callbacks in all domains. CUptiResult  cuptiEnableCallback (uint32_t enable, CUpti_SubscriberHandle subscriber, CUpti_CallbackDomain domain, CUpti_CallbackId cbid) Enable or disabled callbacks for a specific domain and callback ID. CUptiResult  cuptiEnableDomain (uint32_t enable, CUpti_SubscriberHandle subscriber, CUpti_CallbackDomain domain) Enable or disabled all callbacks for a specific domain. CUptiResult  cuptiGetCallbackName (CUpti_CallbackDomain domain, uint32_t cbid, const char **name) Get the name of a callback for a specific domain and callback ID. CUptiResult  cuptiGetCallbackState (uint32_t *enable, CUpti_SubscriberHandle subscriber, CUpti_CallbackDomain domain, CUpti_CallbackId cbid) Get the current enabled/disabled state of a callback for a specific domain and function ID. CUptiResult  cuptiSubscribe (CUpti_SubscriberHandle *subscriber, CUpti_CallbackFunc callback, void *userdata) Initialize a callback subscriber with a callback function and user data. CUptiResult  cuptiSupportedDomains (size_t *domainCount, CUpti_DomainTable *domainTable) Get the available callback domains. CUptiResult  cuptiUnsubscribe (CUpti_SubscriberHandle subscriber) Unregister a callback subscriber. Typedefs CUpti_CallbackFunc  Function type for a callback. CUpti_CallbackId  An ID for a driver API, runtime API, resource or synchronization callback. CUpti_DomainTable  Pointer to an array of callback domains. CUpti_SubscriberHandle  A callback subscriber.", "keywords": []}, {"id": 1067, "doc_id": 1068, "filename": "api/group__CUPTI__CHECKPOINT__API.html", "domain_name": "c", "name": "CUpti_Checkpoint_STRUCT_SIZE", "display_name": "CUpti_Checkpoint_STRUCT_SIZE", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__CHECKPOINT__API", "anchor": "c.CUpti_Checkpoint_STRUCT_SIZE", "priority": 1, "content": "CUpti_Checkpoint_STRUCT_SIZE", "keywords": []}, {"id": 1068, "doc_id": 1068, "filename": "api/group__CUPTI__CHECKPOINT__API.html", "domain_name": "std", "name": "api/group__CUPTI__CHECKPOINT__API", "display_name": "CUPTI Checkpoint API", "type": "doc", "display_type": "Page", "docname": "api/group__CUPTI__CHECKPOINT__API", "anchor": "", "priority": -1, "content": "Functions, types, and enums that implement the CUPTI Checkpoint API. Data Structures NV::Cupti::Checkpoint::CUpti_Checkpoint  Configuration and handle for a CUPTI Checkpoint. Macros CUpti_Checkpoint_STRUCT_SIZE   Enumerations NV::Cupti::Checkpoint::CUpti_CheckpointOptimizations  Specifies optimization options for a checkpoint, may be OR&#x27;d together to specify multiple options. Functions CUptiResult  NV::Cupti::Checkpoint::cuptiCheckpointFree (CUpti_Checkpoint *const handle) Free the backing data for a checkpoint. CUptiResult  NV::Cupti::Checkpoint::cuptiCheckpointRestore (CUpti_Checkpoint *const handle) Restore a checkpoint to the device associated with its context. CUptiResult  NV::Cupti::Checkpoint::cuptiCheckpointSave (CUpti_Checkpoint *const handle) Initialize and save a checkpoint of the device state associated with the handle context.", "keywords": []}, {"id": 1069, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "c", "name": "CUPTI_EVENT_INVALID", "display_name": "CUPTI_EVENT_INVALID", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__EVENT__API", "anchor": "c.CUPTI_EVENT_INVALID", "priority": 1, "content": "CUPTI_EVENT_INVALID The value that indicates the event value is invalid.", "keywords": []}, {"id": 1070, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "c", "name": "CUPTI_EVENT_OVERFLOW", "display_name": "CUPTI_EVENT_OVERFLOW", "type": "macro", "display_type": "C macro", "docname": "api/group__CUPTI__EVENT__API", "anchor": "c.CUPTI_EVENT_OVERFLOW", "priority": 1, "content": "CUPTI_EVENT_OVERFLOW The overflow value for a CUPTI event. The CUPTI event value that indicates an overflow.", "keywords": []}, {"id": 1071, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS", "display_name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_DEVICE_CLASSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS Get the class for the device. Value is a CUpti_DeviceAttributeDeviceClass.", "keywords": []}, {"id": 1072, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "display_name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass38CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "keywords": []}, {"id": 1073, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "display_name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass37CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADROE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "keywords": []}, {"id": 1074, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "display_name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass36CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRAE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "keywords": []}, {"id": 1075, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "display_name": "CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass36CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLAE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "keywords": []}, {"id": 1076, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE", "display_name": "CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE Get the peak double precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1077, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE", "display_name": "CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE Get the peak half precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1078, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE", "display_name": "CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE Get the peak single precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1079, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_FORCE_INT", "display_name": "CUPTI_DEVICE_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute27CUPTI_DEVICE_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FORCE_INT", "keywords": []}, {"id": 1080, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH", "display_name": "CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute41CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH Get global memory bandwidth in Kbytes/sec. Value is a uint64_t.", "keywords": []}, {"id": 1081, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW", "display_name": "CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BWE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW Check if Nvlink is present between GPU and CPU. Returns Bandwidth, in Bytes/sec, if Nvlink is present, returns 0 otherwise. Value is a uint64_t.", "keywords": []}, {"id": 1082, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE", "display_name": "CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute39CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE Get theoretical maximum number of instructions per cycle. Value is a uint32_t.", "keywords": []}, {"id": 1083, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION", "display_name": "CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute57CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISIONE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION Get theoretical maximum number of single precision instructions that can be executed per second. Value is a uint64_t.", "keywords": []}, {"id": 1084, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID", "display_name": "CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute37CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_IDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID Number of event domain IDs for a device. Value is a uint32_t.", "keywords": []}, {"id": 1085, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_EVENT_ID", "display_name": "CUPTI_DEVICE_ATTR_MAX_EVENT_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_MAX_EVENT_IDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_EVENT_ID Number of event IDs for a device. Value is a uint32_t.", "keywords": []}, {"id": 1086, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS", "display_name": "CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS Get number of frame buffers for device. Value is a uint64_t.", "keywords": []}, {"id": 1087, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_L2_UNITS", "display_name": "CUPTI_DEVICE_ATTR_MAX_L2_UNITS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_MAX_L2_UNITSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_L2_UNITS Get number of L2 units. Value is a uint64_t.", "keywords": []}, {"id": 1088, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL", "display_name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute61CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUALE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_EQUAL preference. Value is a uint64_t.", "keywords": []}, {"id": 1089, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1", "display_name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute58CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1E", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1 Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_L1 preference. Value is a uint64_t.", "keywords": []}, {"id": 1090, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED", "display_name": "CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute62CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHAREDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_SHARED preference. Value is a uint64_t.", "keywords": []}, {"id": 1091, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_NVLINK_PRESENT", "display_name": "CUPTI_DEVICE_ATTR_NVLINK_PRESENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute32CUPTI_DEVICE_ATTR_NVLINK_PRESENTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_NVLINK_PRESENT Check if Nvlink is connected to device. Returns 1, if at least one Nvlink is connected to the device, returns 0 otherwise. Value is a uint32_t.", "keywords": []}, {"id": 1092, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT", "display_name": "CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute34CUPTI_DEVICE_ATTR_NVSWITCH_PRESENTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT Check if NVSwitch is present in the underlying topology. Returns 1, if present, returns 0 otherwise. Value is a uint32_t.", "keywords": []}, {"id": 1093, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_PCIE_GEN", "display_name": "CUPTI_DEVICE_ATTR_PCIE_GEN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute26CUPTI_DEVICE_ATTR_PCIE_GENE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_GEN Get PCIE generation for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1094, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_PCIE_LINK_RATE", "display_name": "CUPTI_DEVICE_ATTR_PCIE_LINK_RATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute32CUPTI_DEVICE_ATTR_PCIE_LINK_RATEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_LINK_RATE Get PCIE link rate in Mega bits/sec for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1095, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH", "display_name": "CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute33CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH Get PCIE link width for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1096, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_CATEGORY", "display_name": "CUPTI_EVENT_ATTR_CATEGORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute25CUPTI_EVENT_ATTR_CATEGORYE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_CATEGORY Category of event. Value is CUpti_EventCategory.", "keywords": []}, {"id": 1097, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_FORCE_INT", "display_name": "CUPTI_EVENT_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute26CUPTI_EVENT_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_FORCE_INT", "keywords": []}, {"id": 1098, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_LONG_DESCRIPTION", "display_name": "CUPTI_EVENT_ATTR_LONG_DESCRIPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute33CUPTI_EVENT_ATTR_LONG_DESCRIPTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_LONG_DESCRIPTION Long description of event. Value is a null terminated const c-string.", "keywords": []}, {"id": 1099, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_NAME", "display_name": "CUPTI_EVENT_ATTR_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute21CUPTI_EVENT_ATTR_NAMEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_NAME Event name. Value is a null terminated const c-string.", "keywords": []}, {"id": 1100, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_PROFILING_SCOPE", "display_name": "CUPTI_EVENT_ATTR_PROFILING_SCOPE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute32CUPTI_EVENT_ATTR_PROFILING_SCOPEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_PROFILING_SCOPE Profiling scope of the events. It can be either device or context or both. Value is a CUpti_EventProfilingScope .", "keywords": []}, {"id": 1101, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_ATTR_SHORT_DESCRIPTION", "display_name": "CUPTI_EVENT_ATTR_SHORT_DESCRIPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute34CUPTI_EVENT_ATTR_SHORT_DESCRIPTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_SHORT_DESCRIPTION Short description of event. Value is a null terminated const c-string.", "keywords": []}, {"id": 1102, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_CACHE", "display_name": "CUPTI_EVENT_CATEGORY_CACHE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory26CUPTI_EVENT_CATEGORY_CACHEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_CACHE A cache related event.", "keywords": []}, {"id": 1103, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_FORCE_INT", "display_name": "CUPTI_EVENT_CATEGORY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory30CUPTI_EVENT_CATEGORY_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_FORCE_INT", "keywords": []}, {"id": 1104, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_INSTRUCTION", "display_name": "CUPTI_EVENT_CATEGORY_INSTRUCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory32CUPTI_EVENT_CATEGORY_INSTRUCTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_INSTRUCTION An instruction related event.", "keywords": []}, {"id": 1105, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_MEMORY", "display_name": "CUPTI_EVENT_CATEGORY_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory27CUPTI_EVENT_CATEGORY_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_MEMORY A memory related event.", "keywords": []}, {"id": 1106, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER", "display_name": "CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory36CUPTI_EVENT_CATEGORY_PROFILE_TRIGGERE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER A profile-trigger event.", "keywords": []}, {"id": 1107, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_CATEGORY_SYSTEM", "display_name": "CUPTI_EVENT_CATEGORY_SYSTEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory27CUPTI_EVENT_CATEGORY_SYSTEME", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_SYSTEM A system event.", "keywords": []}, {"id": 1108, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "display_name": "CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod39CUPTI_EVENT_COLLECTION_METHOD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "keywords": []}, {"id": 1109, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED", "display_name": "CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod42CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTEDE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED Event is collected using software instrumentation.", "keywords": []}, {"id": 1110, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC", "display_name": "CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod39CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TCE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC Event is collected using NvLink throughput counter method.", "keywords": []}, {"id": 1111, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_METHOD_PM", "display_name": "CUPTI_EVENT_COLLECTION_METHOD_PM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod32CUPTI_EVENT_COLLECTION_METHOD_PME", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_PM Event is collected using a hardware global performance monitor.", "keywords": []}, {"id": 1112, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_METHOD_SM", "display_name": "CUPTI_EVENT_COLLECTION_METHOD_SM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod32CUPTI_EVENT_COLLECTION_METHOD_SME", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_SM Event is collected using a hardware SM performance monitor.", "keywords": []}, {"id": 1113, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS", "display_name": "CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode38CUPTI_EVENT_COLLECTION_MODE_CONTINUOUSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS Events are collected for the entire duration between the cuptiEventGroupEnable and cuptiEventGroupDisable calls. Event values are reset when the events are read. For CUDA toolkit v6.0 and older this was the default mode.", "keywords": []}, {"id": 1114, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "display_name": "CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode37CUPTI_EVENT_COLLECTION_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "keywords": []}, {"id": 1115, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_COLLECTION_MODE_KERNEL", "display_name": "CUPTI_EVENT_COLLECTION_MODE_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode34CUPTI_EVENT_COLLECTION_MODE_KERNELE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_KERNEL Events are collected only for the durations of kernel executions that occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls. Event collection begins when a kernel execution begins, and stops when kernel execution completes. Event values are reset to zero when each kernel execution begins. If multiple kernel executions occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls then the event values must be read after each kernel launch if those events need to be associated with the specific kernel launch. Note that collection in this mode may significantly change the overall performance characteristics of the application because kernel executions that occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls are serialized on the GPU. This is the default mode from CUDA toolkit v6.5", "keywords": []}, {"id": 1116, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD", "display_name": "CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute41CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHODE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD Collection method used for events contained in the event domain. Value is a CUpti_EventCollectionMethod .", "keywords": []}, {"id": 1117, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "display_name": "CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute33CUPTI_EVENT_DOMAIN_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "keywords": []}, {"id": 1118, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT", "display_name": "CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute38CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT Number of instances of the domain for which event counts will be collected. The domain may have additional instances that cannot be profiled (see CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT). Can be read only with cuptiDeviceGetEventDomainAttribute . Value is a uint32_t.", "keywords": []}, {"id": 1119, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_DOMAIN_ATTR_NAME", "display_name": "CUPTI_EVENT_DOMAIN_ATTR_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute28CUPTI_EVENT_DOMAIN_ATTR_NAMEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_NAME Event domain name. Value is a null terminated const c-string.", "keywords": []}, {"id": 1120, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT", "display_name": "CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute44CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT Total number of instances of the domain, including instances that cannot be profiled. Use CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT to get the number of instances that can be profiled. Can be read only with cuptiDeviceGetEventDomainAttribute . Value is a uint32_t.", "keywords": []}, {"id": 1121, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_EVENTS", "display_name": "CUPTI_EVENT_GROUP_ATTR_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute29CUPTI_EVENT_GROUP_ATTR_EVENTSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_EVENTS Enumerates events in the group. Value is a pointer to buffer of size sizeof(CUpti_EventID) * num_of_events in the eventgroup. num_of_events can be queried using CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS.", "keywords": []}, {"id": 1122, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID", "display_name": "CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute38CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_IDE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID The domain to which the event group is bound. This attribute is set when the first event is added to the group. Value is a CUpti_EventDomainID.", "keywords": []}, {"id": 1123, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "display_name": "CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute32CUPTI_EVENT_GROUP_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "keywords": []}, {"id": 1124, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT", "display_name": "CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute37CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT Number of instances of the domain bound to this event group that will be counted. Value is a uint32_t.", "keywords": []}, {"id": 1125, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS", "display_name": "CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute33CUPTI_EVENT_GROUP_ATTR_NUM_EVENTSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS Number of events in the group. Value is a uint32_t.", "keywords": []}, {"id": 1126, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES", "display_name": "CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute51CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCESE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES [rw] Profile all the instances of the domain for this eventgroup. This feature can be used to get load balancing across all instances of a domain. Value is an integer.", "keywords": []}, {"id": 1127, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE", "display_name": "CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute38CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE Event group scope can be set to CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT for an eventGroup, before adding any event. Sets the scope of eventgroup as CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT when the scope of the events that will be added is CUPTI_EVENT_PROFILING_SCOPE_BOTH. If profiling scope of event is either CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT then setting this attribute will not affect the default scope. It is not allowed to add events of different scope to same eventgroup. Value is a uint32_t.", "keywords": []}, {"id": 1128, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_GROUP_ATTR_USER_DATA", "display_name": "CUPTI_EVENT_GROUP_ATTR_USER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute32CUPTI_EVENT_GROUP_ATTR_USER_DATAE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_USER_DATA [rw] Reserved for user data.", "keywords": []}, {"id": 1129, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_PROFILING_SCOPE_BOTH", "display_name": "CUPTI_EVENT_PROFILING_SCOPE_BOTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope32CUPTI_EVENT_PROFILING_SCOPE_BOTHE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_BOTH Event can be collected at device or context scope. The scope can be set using cuptiEventGroupSetAttribute API.", "keywords": []}, {"id": 1130, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_PROFILING_SCOPE_CONTEXT", "display_name": "CUPTI_EVENT_PROFILING_SCOPE_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope35CUPTI_EVENT_PROFILING_SCOPE_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_CONTEXT Event is collected at context scope.", "keywords": []}, {"id": 1131, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_PROFILING_SCOPE_DEVICE", "display_name": "CUPTI_EVENT_PROFILING_SCOPE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope34CUPTI_EVENT_PROFILING_SCOPE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_DEVICE Event is collected at device scope.", "keywords": []}, {"id": 1132, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "display_name": "CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope37CUPTI_EVENT_PROFILING_SCOPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "keywords": []}, {"id": 1133, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_READ_FLAG_FORCE_INT", "display_name": "CUPTI_EVENT_READ_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_ReadEventFlags31CUPTI_EVENT_READ_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_READ_FLAG_FORCE_INT", "keywords": []}, {"id": 1134, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUPTI_EVENT_READ_FLAG_NONE", "display_name": "CUPTI_EVENT_READ_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_ReadEventFlags26CUPTI_EVENT_READ_FLAG_NONEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_READ_FLAG_NONE No flags.", "keywords": []}, {"id": 1135, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute", "display_name": "CUpti_DeviceAttribute", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421CUpti_DeviceAttribute", "priority": 1, "content": "enum  CUpti_DeviceAttribute Device attributes. CUPTI device attributes. These attributes can be read using cuptiDeviceGetAttribute . Values:", "keywords": []}, {"id": 1136, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_DEVICE_CLASS", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_DEVICE_CLASS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_DEVICE_CLASSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS Get the class for the device. Value is a CUpti_DeviceAttributeDeviceClass.", "keywords": []}, {"id": 1137, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_DP_PER_CYCLE Get the peak double precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1138, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_HP_PER_CYCLE Get the peak half precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1139, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FLOP_SP_PER_CYCLE Get the peak single precision flop per cycle. Value is a uint64_t.", "keywords": []}, {"id": 1140, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FORCE_INT", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute27CUPTI_DEVICE_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_FORCE_INT", "keywords": []}, {"id": 1141, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute41CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_GLOBAL_MEMORY_BANDWIDTH Get global memory bandwidth in Kbytes/sec. Value is a uint64_t.", "keywords": []}, {"id": 1142, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BWE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_GPU_CPU_NVLINK_BW Check if Nvlink is present between GPU and CPU. Returns Bandwidth, in Bytes/sec, if Nvlink is present, returns 0 otherwise. Value is a uint64_t.", "keywords": []}, {"id": 1143, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute39CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_INSTRUCTION_PER_CYCLE Get theoretical maximum number of instructions per cycle. Value is a uint32_t.", "keywords": []}, {"id": 1144, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute57CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISIONE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_INSTRUCTION_THROUGHPUT_SINGLE_PRECISION Get theoretical maximum number of single precision instructions that can be executed per second. Value is a uint64_t.", "keywords": []}, {"id": 1145, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute37CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_IDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_EVENT_DOMAIN_ID Number of event domain IDs for a device. Value is a uint32_t.", "keywords": []}, {"id": 1146, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_EVENT_ID", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_EVENT_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_MAX_EVENT_IDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_EVENT_ID Number of event IDs for a device. Value is a uint32_t.", "keywords": []}, {"id": 1147, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute35CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_FRAME_BUFFERS Get number of frame buffers for device. Value is a uint64_t.", "keywords": []}, {"id": 1148, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_L2_UNITS", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_L2_UNITS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute30CUPTI_DEVICE_ATTR_MAX_L2_UNITSE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_L2_UNITS Get number of L2 units. Value is a uint64_t.", "keywords": []}, {"id": 1149, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute61CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUALE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_EQUAL Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_EQUAL preference. Value is a uint64_t.", "keywords": []}, {"id": 1150, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute58CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1E", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_L1 Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_L1 preference. Value is a uint64_t.", "keywords": []}, {"id": 1151, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute62CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHAREDE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_MAX_SHARED_MEMORY_CACHE_CONFIG_PREFER_SHARED Get the maximum shared memory for the CU_FUNC_CACHE_PREFER_SHARED preference. Value is a uint64_t.", "keywords": []}, {"id": 1152, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_NVLINK_PRESENT", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_NVLINK_PRESENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute32CUPTI_DEVICE_ATTR_NVLINK_PRESENTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_NVLINK_PRESENT Check if Nvlink is connected to device. Returns 1, if at least one Nvlink is connected to the device, returns 0 otherwise. Value is a uint32_t.", "keywords": []}, {"id": 1153, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute34CUPTI_DEVICE_ATTR_NVSWITCH_PRESENTE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_NVSWITCH_PRESENT Check if NVSwitch is present in the underlying topology. Returns 1, if present, returns 0 otherwise. Value is a uint32_t.", "keywords": []}, {"id": 1154, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_GEN", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_GEN", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute26CUPTI_DEVICE_ATTR_PCIE_GENE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_GEN Get PCIE generation for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1155, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_LINK_RATE", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_LINK_RATE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute32CUPTI_DEVICE_ATTR_PCIE_LINK_RATEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_LINK_RATE Get PCIE link rate in Mega bits/sec for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1156, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH", "display_name": "CUpti_DeviceAttribute::CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N21CUpti_DeviceAttribute33CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTHE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_PCIE_LINK_WIDTH Get PCIE link width for device. Return 0 if bus-type is non-PCIE. Value is a uint64_t.", "keywords": []}, {"id": 1157, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttributeDeviceClass", "display_name": "CUpti_DeviceAttributeDeviceClass", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv432CUpti_DeviceAttributeDeviceClass", "priority": 1, "content": "enum  CUpti_DeviceAttributeDeviceClass Device class. Enumeration of device classes for device attribute CUPTI_DEVICE_ATTR_DEVICE_CLASS. Values:", "keywords": []}, {"id": 1158, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "display_name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass38CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCEE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_GEFORCE", "keywords": []}, {"id": 1159, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "display_name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass37CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADROE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_QUADRO", "keywords": []}, {"id": 1160, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "display_name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass36CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRAE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TEGRA", "keywords": []}, {"id": 1161, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "display_name": "CUpti_DeviceAttributeDeviceClass::CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N32CUpti_DeviceAttributeDeviceClass36CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLAE", "priority": 1, "content": "enumerator  CUPTI_DEVICE_ATTR_DEVICE_CLASS_TESLA", "keywords": []}, {"id": 1162, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute", "display_name": "CUpti_EventAttribute", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv420CUpti_EventAttribute", "priority": 1, "content": "enum  CUpti_EventAttribute Event attributes. Event attributes. These attributes can be read using cuptiEventGetAttribute . Values:", "keywords": []}, {"id": 1163, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_CATEGORY", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_CATEGORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute25CUPTI_EVENT_ATTR_CATEGORYE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_CATEGORY Category of event. Value is CUpti_EventCategory.", "keywords": []}, {"id": 1164, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_FORCE_INT", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute26CUPTI_EVENT_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_FORCE_INT", "keywords": []}, {"id": 1165, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_LONG_DESCRIPTION", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_LONG_DESCRIPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute33CUPTI_EVENT_ATTR_LONG_DESCRIPTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_LONG_DESCRIPTION Long description of event. Value is a null terminated const c-string.", "keywords": []}, {"id": 1166, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_NAME", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute21CUPTI_EVENT_ATTR_NAMEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_NAME Event name. Value is a null terminated const c-string.", "keywords": []}, {"id": 1167, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_PROFILING_SCOPE", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_PROFILING_SCOPE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute32CUPTI_EVENT_ATTR_PROFILING_SCOPEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_PROFILING_SCOPE Profiling scope of the events. It can be either device or context or both. Value is a CUpti_EventProfilingScope .", "keywords": []}, {"id": 1168, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_SHORT_DESCRIPTION", "display_name": "CUpti_EventAttribute::CUPTI_EVENT_ATTR_SHORT_DESCRIPTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_EventAttribute34CUPTI_EVENT_ATTR_SHORT_DESCRIPTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_ATTR_SHORT_DESCRIPTION Short description of event. Value is a null terminated const c-string.", "keywords": []}, {"id": 1169, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory", "display_name": "CUpti_EventCategory", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv419CUpti_EventCategory", "priority": 1, "content": "enum  CUpti_EventCategory An event category. Each event is assigned to a category that represents the general type of the event. A event\u2019s category is accessed using cuptiEventGetAttribute and the CUPTI_EVENT_ATTR_CATEGORY attribute. Values:", "keywords": []}, {"id": 1170, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_CACHE", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_CACHE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory26CUPTI_EVENT_CATEGORY_CACHEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_CACHE A cache related event.", "keywords": []}, {"id": 1171, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_FORCE_INT", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory30CUPTI_EVENT_CATEGORY_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_FORCE_INT", "keywords": []}, {"id": 1172, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_INSTRUCTION", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_INSTRUCTION", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory32CUPTI_EVENT_CATEGORY_INSTRUCTIONE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_INSTRUCTION An instruction related event.", "keywords": []}, {"id": 1173, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_MEMORY", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_MEMORY", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory27CUPTI_EVENT_CATEGORY_MEMORYE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_MEMORY A memory related event.", "keywords": []}, {"id": 1174, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory36CUPTI_EVENT_CATEGORY_PROFILE_TRIGGERE", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_PROFILE_TRIGGER A profile-trigger event.", "keywords": []}, {"id": 1175, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_SYSTEM", "display_name": "CUpti_EventCategory::CUPTI_EVENT_CATEGORY_SYSTEM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N19CUpti_EventCategory27CUPTI_EVENT_CATEGORY_SYSTEME", "priority": 1, "content": "enumerator  CUPTI_EVENT_CATEGORY_SYSTEM A system event.", "keywords": []}, {"id": 1176, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod", "display_name": "CUpti_EventCollectionMethod", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427CUpti_EventCollectionMethod", "priority": 1, "content": "enum  CUpti_EventCollectionMethod The collection method used for an event. The collection method indicates how an event is collected. Values:", "keywords": []}, {"id": 1177, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "display_name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod39CUPTI_EVENT_COLLECTION_METHOD_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_FORCE_INT", "keywords": []}, {"id": 1178, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED", "display_name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod42CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTEDE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_INSTRUMENTED Event is collected using software instrumentation.", "keywords": []}, {"id": 1179, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC", "display_name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod39CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TCE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_NVLINK_TC Event is collected using NvLink throughput counter method.", "keywords": []}, {"id": 1180, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_PM", "display_name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_PM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod32CUPTI_EVENT_COLLECTION_METHOD_PME", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_PM Event is collected using a hardware global performance monitor.", "keywords": []}, {"id": 1181, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_SM", "display_name": "CUpti_EventCollectionMethod::CUPTI_EVENT_COLLECTION_METHOD_SM", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N27CUpti_EventCollectionMethod32CUPTI_EVENT_COLLECTION_METHOD_SME", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_METHOD_SM Event is collected using a hardware SM performance monitor.", "keywords": []}, {"id": 1182, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMode", "display_name": "CUpti_EventCollectionMode", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv425CUpti_EventCollectionMode", "priority": 1, "content": "enum  CUpti_EventCollectionMode Event collection modes. The event collection mode determines the period over which the events within the enabled event groups will be collected. Values:", "keywords": []}, {"id": 1183, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS", "display_name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode38CUPTI_EVENT_COLLECTION_MODE_CONTINUOUSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_CONTINUOUS Events are collected for the entire duration between the cuptiEventGroupEnable and cuptiEventGroupDisable calls. Event values are reset when the events are read. For CUDA toolkit v6.0 and older this was the default mode.", "keywords": []}, {"id": 1184, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "display_name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode37CUPTI_EVENT_COLLECTION_MODE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_FORCE_INT", "keywords": []}, {"id": 1185, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_KERNEL", "display_name": "CUpti_EventCollectionMode::CUPTI_EVENT_COLLECTION_MODE_KERNEL", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventCollectionMode34CUPTI_EVENT_COLLECTION_MODE_KERNELE", "priority": 1, "content": "enumerator  CUPTI_EVENT_COLLECTION_MODE_KERNEL Events are collected only for the durations of kernel executions that occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls. Event collection begins when a kernel execution begins, and stops when kernel execution completes. Event values are reset to zero when each kernel execution begins. If multiple kernel executions occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls then the event values must be read after each kernel launch if those events need to be associated with the specific kernel launch. Note that collection in this mode may significantly change the overall performance characteristics of the application because kernel executions that occur between the cuptiEventGroupEnable and cuptiEventGroupDisable calls are serialized on the GPU. This is the default mode from CUDA toolkit v6.5", "keywords": []}, {"id": 1186, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute", "display_name": "CUpti_EventDomainAttribute", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv426CUpti_EventDomainAttribute", "priority": 1, "content": "enum  CUpti_EventDomainAttribute Event domain attributes. Event domain attributes. Except where noted, all the attributes can be read using either cuptiDeviceGetEventDomainAttribute or cuptiEventDomainGetAttribute . Values:", "keywords": []}, {"id": 1187, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD", "display_name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute41CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHODE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_COLLECTION_METHOD Collection method used for events contained in the event domain. Value is a CUpti_EventCollectionMethod .", "keywords": []}, {"id": 1188, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "display_name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute33CUPTI_EVENT_DOMAIN_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_FORCE_INT", "keywords": []}, {"id": 1189, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT", "display_name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute38CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT Number of instances of the domain for which event counts will be collected. The domain may have additional instances that cannot be profiled (see CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT). Can be read only with cuptiDeviceGetEventDomainAttribute . Value is a uint32_t.", "keywords": []}, {"id": 1190, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_NAME", "display_name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_NAME", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute28CUPTI_EVENT_DOMAIN_ATTR_NAMEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_NAME Event domain name. Value is a null terminated const c-string.", "keywords": []}, {"id": 1191, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT", "display_name": "CUpti_EventDomainAttribute::CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N26CUpti_EventDomainAttribute44CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_DOMAIN_ATTR_TOTAL_INSTANCE_COUNT Total number of instances of the domain, including instances that cannot be profiled. Use CUPTI_EVENT_DOMAIN_ATTR_INSTANCE_COUNT to get the number of instances that can be profiled. Can be read only with cuptiDeviceGetEventDomainAttribute . Value is a uint32_t.", "keywords": []}, {"id": 1192, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventDomainID", "display_name": "CUpti_EventDomainID", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv419CUpti_EventDomainID", "priority": 1, "content": "typedef  uint32_t  CUpti_EventDomainID ID for an event domain. ID for an event domain. An event domain represents a group of related events. A device may have multiple instances of a domain, indicating that the device can simultaneously record multiple instances of each event within that domain.", "keywords": []}, {"id": 1193, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroup", "display_name": "CUpti_EventGroup", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv416CUpti_EventGroup", "priority": 1, "content": "typedef  void  * CUpti_EventGroup A group of events. An event group is a collection of events that are managed together. All events in an event group must belong to the same domain.", "keywords": []}, {"id": 1194, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute", "display_name": "CUpti_EventGroupAttribute", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv425CUpti_EventGroupAttribute", "priority": 1, "content": "enum  CUpti_EventGroupAttribute Event group attributes. Event group attributes. These attributes can be read using cuptiEventGroupGetAttribute . Attributes marked [rw] can also be written using cuptiEventGroupSetAttribute . Values:", "keywords": []}, {"id": 1195, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_EVENTS", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute29CUPTI_EVENT_GROUP_ATTR_EVENTSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_EVENTS Enumerates events in the group. Value is a pointer to buffer of size sizeof(CUpti_EventID) * num_of_events in the eventgroup. num_of_events can be queried using CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS.", "keywords": []}, {"id": 1196, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute38CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_IDE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_EVENT_DOMAIN_ID The domain to which the event group is bound. This attribute is set when the first event is added to the group. Value is a CUpti_EventDomainID.", "keywords": []}, {"id": 1197, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute32CUPTI_EVENT_GROUP_ATTR_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_FORCE_INT", "keywords": []}, {"id": 1198, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute37CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_INSTANCE_COUNT Number of instances of the domain bound to this event group that will be counted. Value is a uint32_t.", "keywords": []}, {"id": 1199, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute33CUPTI_EVENT_GROUP_ATTR_NUM_EVENTSE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_NUM_EVENTS Number of events in the group. Value is a uint32_t.", "keywords": []}, {"id": 1200, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute51CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCESE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES [rw] Profile all the instances of the domain for this eventgroup. This feature can be used to get load balancing across all instances of a domain. Value is an integer.", "keywords": []}, {"id": 1201, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute38CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_PROFILING_SCOPE Event group scope can be set to CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT for an eventGroup, before adding any event. Sets the scope of eventgroup as CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT when the scope of the events that will be added is CUPTI_EVENT_PROFILING_SCOPE_BOTH. If profiling scope of event is either CUPTI_EVENT_PROFILING_SCOPE_DEVICE or CUPTI_EVENT_PROFILING_SCOPE_CONTEXT then setting this attribute will not affect the default scope. It is not allowed to add events of different scope to same eventgroup. Value is a uint32_t.", "keywords": []}, {"id": 1202, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_USER_DATA", "display_name": "CUpti_EventGroupAttribute::CUPTI_EVENT_GROUP_ATTR_USER_DATA", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventGroupAttribute32CUPTI_EVENT_GROUP_ATTR_USER_DATAE", "priority": 1, "content": "enumerator  CUPTI_EVENT_GROUP_ATTR_USER_DATA [rw] Reserved for user data.", "keywords": []}, {"id": 1203, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventID", "display_name": "CUpti_EventID", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv413CUpti_EventID", "priority": 1, "content": "typedef  uint32_t  CUpti_EventID ID for an event. An event represents a countable activity, action, or occurrence on the device.", "keywords": []}, {"id": 1204, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventProfilingScope", "display_name": "CUpti_EventProfilingScope", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv425CUpti_EventProfilingScope", "priority": 1, "content": "enum  CUpti_EventProfilingScope Profiling scope for event. Profiling scope of event indicates if the event can be collected at context scope or device scope or both i.e. it can be collected at any of context or device scope. Values:", "keywords": []}, {"id": 1205, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_BOTH", "display_name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_BOTH", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope32CUPTI_EVENT_PROFILING_SCOPE_BOTHE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_BOTH Event can be collected at device or context scope. The scope can be set using cuptiEventGroupSetAttribute API.", "keywords": []}, {"id": 1206, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_CONTEXT", "display_name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_CONTEXT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope35CUPTI_EVENT_PROFILING_SCOPE_CONTEXTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_CONTEXT Event is collected at context scope.", "keywords": []}, {"id": 1207, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_DEVICE", "display_name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_DEVICE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope34CUPTI_EVENT_PROFILING_SCOPE_DEVICEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_DEVICE Event is collected at device scope.", "keywords": []}, {"id": 1208, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "display_name": "CUpti_EventProfilingScope::CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N25CUpti_EventProfilingScope37CUPTI_EVENT_PROFILING_SCOPE_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_PROFILING_SCOPE_FORCE_INT", "keywords": []}, {"id": 1209, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_KernelReplayUpdateFunc", "display_name": "CUpti_KernelReplayUpdateFunc", "type": "type", "display_type": "C++ type", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428CUpti_KernelReplayUpdateFunc", "priority": 1, "content": "typedef  void  ( * CUpti_KernelReplayUpdateFunc ) ( const  char  * kernelName ,  int  numReplaysDone ,  void  * customData ) Function type for getting updates on kernel replay. Param kernelName The mangled kernel name Param numReplaysDone Number of replays done so far Param customData Pointer of any custom data passed in when subscribing", "keywords": []}, {"id": 1210, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_ReadEventFlags", "display_name": "CUpti_ReadEventFlags", "type": "enum", "display_type": "C++ enum", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv420CUpti_ReadEventFlags", "priority": 1, "content": "enum  CUpti_ReadEventFlags Flags for cuptiEventGroupReadEvent an cuptiEventGroupReadAllEvents. Flags for cuptiEventGroupReadEvent an cuptiEventGroupReadAllEvents . Values:", "keywords": []}, {"id": 1211, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_ReadEventFlags::CUPTI_EVENT_READ_FLAG_FORCE_INT", "display_name": "CUpti_ReadEventFlags::CUPTI_EVENT_READ_FLAG_FORCE_INT", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_ReadEventFlags31CUPTI_EVENT_READ_FLAG_FORCE_INTE", "priority": 1, "content": "enumerator  CUPTI_EVENT_READ_FLAG_FORCE_INT", "keywords": []}, {"id": 1212, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "CUpti_ReadEventFlags::CUPTI_EVENT_READ_FLAG_NONE", "display_name": "CUpti_ReadEventFlags::CUPTI_EVENT_READ_FLAG_NONE", "type": "enumerator", "display_type": "C++ enumerator", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv4N20CUpti_ReadEventFlags26CUPTI_EVENT_READ_FLAG_NONEE", "priority": 1, "content": "enumerator  CUPTI_EVENT_READ_FLAG_NONE No flags.", "keywords": []}, {"id": 1213, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceEnumEventDomains", "display_name": "cuptiDeviceEnumEventDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiDeviceEnumEventDomains8CUdeviceP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiDeviceEnumEventDomains CUdevice  device size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains for a device. Returns the event domains IDs in domainArray for a device. The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numdomains * sizeof(CUpti_EventDomainID) or else all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns the IDs of the event domains for the device Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1214, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceEnumEventDomains::arraySizeBytes", "display_name": "cuptiDeviceEnumEventDomains::arraySizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiDeviceEnumEventDomains8CUdeviceP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiDeviceEnumEventDomains CUdevice  device size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains for a device. Returns the event domains IDs in domainArray for a device. The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numdomains * sizeof(CUpti_EventDomainID) or else all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns the IDs of the event domains for the device Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1215, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceEnumEventDomains::device", "display_name": "cuptiDeviceEnumEventDomains::device", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiDeviceEnumEventDomains8CUdeviceP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiDeviceEnumEventDomains CUdevice  device size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains for a device. Returns the event domains IDs in domainArray for a device. The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numdomains * sizeof(CUpti_EventDomainID) or else all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns the IDs of the event domains for the device Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1216, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceEnumEventDomains::domainArray", "display_name": "cuptiDeviceEnumEventDomains::domainArray", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiDeviceEnumEventDomains8CUdeviceP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiDeviceEnumEventDomains CUdevice  device size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains for a device. Returns the event domains IDs in domainArray for a device. The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numdomains * sizeof(CUpti_EventDomainID) or else all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns the IDs of the event domains for the device Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1217, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetAttribute", "display_name": "cuptiDeviceGetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiDeviceGetAttribute8CUdevice21CUpti_DeviceAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetAttribute CUdevice  device CUpti_DeviceAttribute  attrib size_t  * valueSize void  * value Read a device attribute. Read a device attribute and return it in *value . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not a device attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1218, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetAttribute::attrib", "display_name": "cuptiDeviceGetAttribute::attrib", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiDeviceGetAttribute8CUdevice21CUpti_DeviceAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetAttribute CUdevice  device CUpti_DeviceAttribute  attrib size_t  * valueSize void  * value Read a device attribute. Read a device attribute and return it in *value . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not a device attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1219, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetAttribute::device", "display_name": "cuptiDeviceGetAttribute::device", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiDeviceGetAttribute8CUdevice21CUpti_DeviceAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetAttribute CUdevice  device CUpti_DeviceAttribute  attrib size_t  * valueSize void  * value Read a device attribute. Read a device attribute and return it in *value . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not a device attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1220, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetAttribute::value", "display_name": "cuptiDeviceGetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiDeviceGetAttribute8CUdevice21CUpti_DeviceAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetAttribute CUdevice  device CUpti_DeviceAttribute  attrib size_t  * valueSize void  * value Read a device attribute. Read a device attribute and return it in *value . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not a device attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1221, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetAttribute::valueSize", "display_name": "cuptiDeviceGetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiDeviceGetAttribute8CUdevice21CUpti_DeviceAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetAttribute CUdevice  device CUpti_DeviceAttribute  attrib size_t  * valueSize void  * value Read a device attribute. Read a device attribute and return it in *value . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not a device attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1222, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute", "display_name": "cuptiDeviceGetEventDomainAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1223, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute::attrib", "display_name": "cuptiDeviceGetEventDomainAttribute::attrib", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1224, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute::device", "display_name": "cuptiDeviceGetEventDomainAttribute::device", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1225, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute::eventDomain", "display_name": "cuptiDeviceGetEventDomainAttribute::eventDomain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1226, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute::value", "display_name": "cuptiDeviceGetEventDomainAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1227, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetEventDomainAttribute::valueSize", "display_name": "cuptiDeviceGetEventDomainAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv434cuptiDeviceGetEventDomainAttribute8CUdevice19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiDeviceGetEventDomainAttribute CUdevice  device CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1228, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetNumEventDomains", "display_name": "cuptiDeviceGetNumEventDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv429cuptiDeviceGetNumEventDomains8CUdeviceP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiDeviceGetNumEventDomains CUdevice  device uint32_t  * numDomains Get the number of domains for a device. Returns the number of domains in numDomains for a device. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device numDomains \u2013 Returns the number of domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numDomains is NULL", "keywords": []}, {"id": 1229, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetNumEventDomains::device", "display_name": "cuptiDeviceGetNumEventDomains::device", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv429cuptiDeviceGetNumEventDomains8CUdeviceP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiDeviceGetNumEventDomains CUdevice  device uint32_t  * numDomains Get the number of domains for a device. Returns the number of domains in numDomains for a device. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device numDomains \u2013 Returns the number of domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numDomains is NULL", "keywords": []}, {"id": 1230, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDeviceGetNumEventDomains::numDomains", "display_name": "cuptiDeviceGetNumEventDomains::numDomains", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv429cuptiDeviceGetNumEventDomains8CUdeviceP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiDeviceGetNumEventDomains CUdevice  device uint32_t  * numDomains Get the number of domains for a device. Returns the number of domains in numDomains for a device. Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device numDomains \u2013 Returns the number of domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numDomains is NULL", "keywords": []}, {"id": 1231, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDisableKernelReplayMode", "display_name": "cuptiDisableKernelReplayMode", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiDisableKernelReplayMode9CUcontext", "priority": 1, "content": "CUptiResult  cuptiDisableKernelReplayMode CUcontext  context Disable kernel replay mode. Set profiling mode for the context to non-replay (default) mode. Event collection mode will be set to CUPTI_EVENT_COLLECTION_MODE_KERNEL. All previously enabled event groups and event group sets will be disabled. Thread-safety : this function is thread safe. Parameters context \u2013 The context Return values CUPTI_SUCCESS \u2013", "keywords": []}, {"id": 1232, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiDisableKernelReplayMode::context", "display_name": "cuptiDisableKernelReplayMode::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiDisableKernelReplayMode9CUcontext", "priority": 1, "content": "CUptiResult  cuptiDisableKernelReplayMode CUcontext  context Disable kernel replay mode. Set profiling mode for the context to non-replay (default) mode. Event collection mode will be set to CUPTI_EVENT_COLLECTION_MODE_KERNEL. All previously enabled event groups and event group sets will be disabled. Thread-safety : this function is thread safe. Parameters context \u2013 The context Return values CUPTI_SUCCESS \u2013", "keywords": []}, {"id": 1233, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEnableKernelReplayMode", "display_name": "cuptiEnableKernelReplayMode", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEnableKernelReplayMode9CUcontext", "priority": 1, "content": "CUptiResult  cuptiEnableKernelReplayMode CUcontext  context Enable kernel replay mode. Set profiling mode for the context to replay mode. In this mode, any number of events can be collected in one run of the kernel. The event collection mode will automatically switch to CUPTI_EVENT_COLLECTION_MODE_KERNEL. In this mode, cuptiSetEventCollectionMode will return CUPTI_ERROR_INVALID_OPERATION. Kernels might take longer to run if many events are enabled. Thread-safety : this function is thread safe. Parameters context \u2013 The context Return values CUPTI_SUCCESS \u2013", "keywords": []}, {"id": 1234, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEnableKernelReplayMode::context", "display_name": "cuptiEnableKernelReplayMode::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEnableKernelReplayMode9CUcontext", "priority": 1, "content": "CUptiResult  cuptiEnableKernelReplayMode CUcontext  context Enable kernel replay mode. Set profiling mode for the context to replay mode. In this mode, any number of events can be collected in one run of the kernel. The event collection mode will automatically switch to CUPTI_EVENT_COLLECTION_MODE_KERNEL. In this mode, cuptiSetEventCollectionMode will return CUPTI_ERROR_INVALID_OPERATION. Kernels might take longer to run if many events are enabled. Thread-safety : this function is thread safe. Parameters context \u2013 The context Return values CUPTI_SUCCESS \u2013", "keywords": []}, {"id": 1235, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEnumEventDomains", "display_name": "cuptiEnumEventDomains", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEnumEventDomainsP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiEnumEventDomains size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains available on any device. Returns all the event domains available on any CUDA-capable device. Event domain IDs are returned in domainArray . The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numDomains * sizeof(CUpti_EventDomainID) or all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns all the event domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1236, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEnumEventDomains::arraySizeBytes", "display_name": "cuptiEnumEventDomains::arraySizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEnumEventDomainsP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiEnumEventDomains size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains available on any device. Returns all the event domains available on any CUDA-capable device. Event domain IDs are returned in domainArray . The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numDomains * sizeof(CUpti_EventDomainID) or all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns all the event domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1237, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEnumEventDomains::domainArray", "display_name": "cuptiEnumEventDomains::domainArray", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEnumEventDomainsP6size_tP19CUpti_EventDomainID", "priority": 1, "content": "CUptiResult  cuptiEnumEventDomains size_t  * arraySizeBytes CUpti_EventDomainID  * domainArray Get the event domains available on any device. Returns all the event domains available on any CUDA-capable device. Event domain IDs are returned in domainArray . The size of the domainArray buffer is given by *arraySizeBytes . The size of the domainArray buffer must be at least numDomains * sizeof(CUpti_EventDomainID) or all domains will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in domainArray . Thread-safety : this function is thread safe. Parameters arraySizeBytes \u2013 The size of domainArray in bytes, and returns the number of bytes written to domainArray  domainArray \u2013 Returns all the event domains Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or domainArray are NULL", "keywords": []}, {"id": 1238, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainEnumEvents", "display_name": "cuptiEventDomainEnumEvents", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv426cuptiEventDomainEnumEvents19CUpti_EventDomainIDP6size_tP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventDomainEnumEvents CUpti_EventDomainID  eventDomain size_t  * arraySizeBytes CUpti_EventID  * eventArray Get the events in a domain. Returns the event IDs in eventArray for a domain. The size of the eventArray buffer is given by *arraySizeBytes . The size of the eventArray buffer must be at least numdomainevents * sizeof(CUpti_EventID) or else all events will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in eventArray . Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain arraySizeBytes \u2013 The size of eventArray in bytes, and returns the number of bytes written to eventArray  eventArray \u2013 Returns the IDs of the events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or eventArray are NULL", "keywords": []}, {"id": 1239, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainEnumEvents::arraySizeBytes", "display_name": "cuptiEventDomainEnumEvents::arraySizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv426cuptiEventDomainEnumEvents19CUpti_EventDomainIDP6size_tP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventDomainEnumEvents CUpti_EventDomainID  eventDomain size_t  * arraySizeBytes CUpti_EventID  * eventArray Get the events in a domain. Returns the event IDs in eventArray for a domain. The size of the eventArray buffer is given by *arraySizeBytes . The size of the eventArray buffer must be at least numdomainevents * sizeof(CUpti_EventID) or else all events will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in eventArray . Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain arraySizeBytes \u2013 The size of eventArray in bytes, and returns the number of bytes written to eventArray  eventArray \u2013 Returns the IDs of the events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or eventArray are NULL", "keywords": []}, {"id": 1240, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainEnumEvents::eventArray", "display_name": "cuptiEventDomainEnumEvents::eventArray", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv426cuptiEventDomainEnumEvents19CUpti_EventDomainIDP6size_tP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventDomainEnumEvents CUpti_EventDomainID  eventDomain size_t  * arraySizeBytes CUpti_EventID  * eventArray Get the events in a domain. Returns the event IDs in eventArray for a domain. The size of the eventArray buffer is given by *arraySizeBytes . The size of the eventArray buffer must be at least numdomainevents * sizeof(CUpti_EventID) or else all events will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in eventArray . Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain arraySizeBytes \u2013 The size of eventArray in bytes, and returns the number of bytes written to eventArray  eventArray \u2013 Returns the IDs of the events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or eventArray are NULL", "keywords": []}, {"id": 1241, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainEnumEvents::eventDomain", "display_name": "cuptiEventDomainEnumEvents::eventDomain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv426cuptiEventDomainEnumEvents19CUpti_EventDomainIDP6size_tP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventDomainEnumEvents CUpti_EventDomainID  eventDomain size_t  * arraySizeBytes CUpti_EventID  * eventArray Get the events in a domain. Returns the event IDs in eventArray for a domain. The size of the eventArray buffer is given by *arraySizeBytes . The size of the eventArray buffer must be at least numdomainevents * sizeof(CUpti_EventID) or else all events will not be returned. The value returned in *arraySizeBytes contains the number of bytes returned in eventArray . Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain arraySizeBytes \u2013 The size of eventArray in bytes, and returns the number of bytes written to eventArray  eventArray \u2013 Returns the IDs of the events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if arraySizeBytes or eventArray are NULL", "keywords": []}, {"id": 1242, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetAttribute", "display_name": "cuptiEventDomainGetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetAttribute19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetAttribute CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1243, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetAttribute::attrib", "display_name": "cuptiEventDomainGetAttribute::attrib", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetAttribute19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetAttribute CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1244, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetAttribute::eventDomain", "display_name": "cuptiEventDomainGetAttribute::eventDomain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetAttribute19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetAttribute CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1245, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetAttribute::value", "display_name": "cuptiEventDomainGetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetAttribute19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetAttribute CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1246, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetAttribute::valueSize", "display_name": "cuptiEventDomainGetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetAttribute19CUpti_EventDomainID26CUpti_EventDomainAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetAttribute CUpti_EventDomainID  eventDomain CUpti_EventDomainAttribute  attrib size_t  * valueSize void  * value Read an event domain attribute. Returns an event domain attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain attrib \u2013 The event domain attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event domain attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1247, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetNumEvents", "display_name": "cuptiEventDomainGetNumEvents", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetNumEvents19CUpti_EventDomainIDP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetNumEvents CUpti_EventDomainID  eventDomain uint32_t  * numEvents Get number of events in a domain. Returns the number of events in numEvents for a domain. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain numEvents \u2013 Returns the number of events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numEvents is NULL", "keywords": []}, {"id": 1248, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetNumEvents::eventDomain", "display_name": "cuptiEventDomainGetNumEvents::eventDomain", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetNumEvents19CUpti_EventDomainIDP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetNumEvents CUpti_EventDomainID  eventDomain uint32_t  * numEvents Get number of events in a domain. Returns the number of events in numEvents for a domain. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain numEvents \u2013 Returns the number of events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numEvents is NULL", "keywords": []}, {"id": 1249, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventDomainGetNumEvents::numEvents", "display_name": "cuptiEventDomainGetNumEvents::numEvents", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventDomainGetNumEvents19CUpti_EventDomainIDP8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventDomainGetNumEvents CUpti_EventDomainID  eventDomain uint32_t  * numEvents Get number of events in a domain. Returns the number of events in numEvents for a domain. Thread-safety : this function is thread safe. Parameters eventDomain \u2013 ID of the event domain numEvents \u2013 Returns the number of events in the domain Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_DOMAIN_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if numEvents is NULL", "keywords": []}, {"id": 1250, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetAttribute", "display_name": "cuptiEventGetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGetAttribute13CUpti_EventID20CUpti_EventAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGetAttribute CUpti_EventID  event CUpti_EventAttribute  attrib size_t  * valueSize void  * value Get an event attribute. Returns an event attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters event \u2013 ID of the event attrib \u2013 The event attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1251, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetAttribute::attrib", "display_name": "cuptiEventGetAttribute::attrib", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGetAttribute13CUpti_EventID20CUpti_EventAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGetAttribute CUpti_EventID  event CUpti_EventAttribute  attrib size_t  * valueSize void  * value Get an event attribute. Returns an event attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters event \u2013 ID of the event attrib \u2013 The event attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1252, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetAttribute::event", "display_name": "cuptiEventGetAttribute::event", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGetAttribute13CUpti_EventID20CUpti_EventAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGetAttribute CUpti_EventID  event CUpti_EventAttribute  attrib size_t  * valueSize void  * value Get an event attribute. Returns an event attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters event \u2013 ID of the event attrib \u2013 The event attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1253, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetAttribute::value", "display_name": "cuptiEventGetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGetAttribute13CUpti_EventID20CUpti_EventAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGetAttribute CUpti_EventID  event CUpti_EventAttribute  attrib size_t  * valueSize void  * value Get an event attribute. Returns an event attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters event \u2013 ID of the event attrib \u2013 The event attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1254, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetAttribute::valueSize", "display_name": "cuptiEventGetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGetAttribute13CUpti_EventID20CUpti_EventAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGetAttribute CUpti_EventID  event CUpti_EventAttribute  attrib size_t  * valueSize void  * value Get an event attribute. Returns an event attribute in *value . The size of the value buffer is given by *valueSize . The value returned in *valueSize contains the number of bytes returned in value . If the attribute value is a c-string that is longer than *valueSize , then only the first *valueSize characters will be returned and there will be no terminating null byte. Thread-safety : this function is thread safe. Parameters event \u2013 ID of the event attrib \u2013 The event attribute to read valueSize \u2013 The size of the value buffer in bytes, and returns the number of bytes written to value  value \u2013 Returns the attribute\u2019s value Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an event attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1255, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetIdFromName", "display_name": "cuptiEventGetIdFromName", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGetIdFromName8CUdevicePKcP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGetIdFromName CUdevice  device const  char  * eventName CUpti_EventID  * event Find an event by name. Find an event by name and return the event ID in *event . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventName \u2013 The name of the event to find event \u2013 Returns the ID of the found event or undefined if unable to find the event Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_NAME \u2013 if unable to find an event with name eventName . In this case *event is undefined CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventName or event are NULL", "keywords": []}, {"id": 1256, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetIdFromName::device", "display_name": "cuptiEventGetIdFromName::device", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGetIdFromName8CUdevicePKcP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGetIdFromName CUdevice  device const  char  * eventName CUpti_EventID  * event Find an event by name. Find an event by name and return the event ID in *event . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventName \u2013 The name of the event to find event \u2013 Returns the ID of the found event or undefined if unable to find the event Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_NAME \u2013 if unable to find an event with name eventName . In this case *event is undefined CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventName or event are NULL", "keywords": []}, {"id": 1257, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetIdFromName::event", "display_name": "cuptiEventGetIdFromName::event", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGetIdFromName8CUdevicePKcP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGetIdFromName CUdevice  device const  char  * eventName CUpti_EventID  * event Find an event by name. Find an event by name and return the event ID in *event . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventName \u2013 The name of the event to find event \u2013 Returns the ID of the found event or undefined if unable to find the event Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_NAME \u2013 if unable to find an event with name eventName . In this case *event is undefined CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventName or event are NULL", "keywords": []}, {"id": 1258, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGetIdFromName::eventName", "display_name": "cuptiEventGetIdFromName::eventName", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGetIdFromName8CUdevicePKcP13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGetIdFromName CUdevice  device const  char  * eventName CUpti_EventID  * event Find an event by name. Find an event by name and return the event ID in *event . Thread-safety : this function is thread safe. Parameters device \u2013 The CUDA device eventName \u2013 The name of the event to find event \u2013 Returns the ID of the found event or undefined if unable to find the event Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_DEVICE \u2013 CUPTI_ERROR_INVALID_EVENT_NAME \u2013 if unable to find an event with name eventName . In this case *event is undefined CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventName or event are NULL", "keywords": []}, {"id": 1259, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupAddEvent", "display_name": "cuptiEventGroupAddEvent", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGroupAddEvent16CUpti_EventGroup13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGroupAddEvent CUpti_EventGroup  eventGroup CUpti_EventID  event Add an event to an event group. Add an event to an event group. The event add can fail for a number of reasons: The event group is enabled The event does not belong to the same event domain as the events that are already in the event group Device limitations on the events that can belong to the same group The event group is full Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group event \u2013 The event to add to the group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is enabled CUPTI_ERROR_NOT_COMPATIBLE \u2013 if event belongs to a different event domain than the events already in eventGroup , or if a device limitation prevents event from being collected at the same time as the events already in eventGroup  CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if eventGroup is full CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1260, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupAddEvent::event", "display_name": "cuptiEventGroupAddEvent::event", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGroupAddEvent16CUpti_EventGroup13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGroupAddEvent CUpti_EventGroup  eventGroup CUpti_EventID  event Add an event to an event group. Add an event to an event group. The event add can fail for a number of reasons: The event group is enabled The event does not belong to the same event domain as the events that are already in the event group Device limitations on the events that can belong to the same group The event group is full Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group event \u2013 The event to add to the group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is enabled CUPTI_ERROR_NOT_COMPATIBLE \u2013 if event belongs to a different event domain than the events already in eventGroup , or if a device limitation prevents event from being collected at the same time as the events already in eventGroup  CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if eventGroup is full CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1261, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupAddEvent::eventGroup", "display_name": "cuptiEventGroupAddEvent::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv423cuptiEventGroupAddEvent16CUpti_EventGroup13CUpti_EventID", "priority": 1, "content": "CUptiResult  cuptiEventGroupAddEvent CUpti_EventGroup  eventGroup CUpti_EventID  event Add an event to an event group. Add an event to an event group. The event add can fail for a number of reasons: The event group is enabled The event does not belong to the same event domain as the events that are already in the event group Device limitations on the events that can belong to the same group The event group is full Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group event \u2013 The event to add to the group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is enabled CUPTI_ERROR_NOT_COMPATIBLE \u2013 if event belongs to a different event domain than the events already in eventGroup , or if a device limitation prevents event from being collected at the same time as the events already in eventGroup  CUPTI_ERROR_MAX_LIMIT_REACHED \u2013 if eventGroup is full CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1262, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupCreate", "display_name": "cuptiEventGroupCreate", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupCreate9CUcontextP16CUpti_EventGroup8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupCreate CUcontext  context CUpti_EventGroup  * eventGroup uint32_t  flags Create a new event group for a context. Creates a new event group for context and returns the new group in *eventGroup . flags are reserved for future use and should be set to zero. Thread-safety : this function is thread safe. Parameters context \u2013 The context for the event group eventGroup \u2013 Returns the new event group flags \u2013 Reserved - must be zero Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1263, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupCreate::context", "display_name": "cuptiEventGroupCreate::context", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupCreate9CUcontextP16CUpti_EventGroup8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupCreate CUcontext  context CUpti_EventGroup  * eventGroup uint32_t  flags Create a new event group for a context. Creates a new event group for context and returns the new group in *eventGroup . flags are reserved for future use and should be set to zero. Thread-safety : this function is thread safe. Parameters context \u2013 The context for the event group eventGroup \u2013 Returns the new event group flags \u2013 Reserved - must be zero Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1264, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupCreate::eventGroup", "display_name": "cuptiEventGroupCreate::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupCreate9CUcontextP16CUpti_EventGroup8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupCreate CUcontext  context CUpti_EventGroup  * eventGroup uint32_t  flags Create a new event group for a context. Creates a new event group for context and returns the new group in *eventGroup . flags are reserved for future use and should be set to zero. Thread-safety : this function is thread safe. Parameters context \u2013 The context for the event group eventGroup \u2013 Returns the new event group flags \u2013 Reserved - must be zero Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1265, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupCreate::flags", "display_name": "cuptiEventGroupCreate::flags", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupCreate9CUcontextP16CUpti_EventGroup8uint32_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupCreate CUcontext  context CUpti_EventGroup  * eventGroup uint32_t  flags Create a new event group for a context. Creates a new event group for context and returns the new group in *eventGroup . flags are reserved for future use and should be set to zero. Thread-safety : this function is thread safe. Parameters context \u2013 The context for the event group eventGroup \u2013 Returns the new event group flags \u2013 Reserved - must be zero Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_CONTEXT \u2013 CUPTI_ERROR_OUT_OF_MEMORY \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1266, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupDestroy", "display_name": "cuptiEventGroupDestroy", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGroupDestroy16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupDestroy CUpti_EventGroup  eventGroup Destroy an event group. Destroy an eventGroup and free its resources. An event group cannot be destroyed if it is enabled. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group to destroy Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if the event group is enabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1267, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupDestroy::eventGroup", "display_name": "cuptiEventGroupDestroy::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGroupDestroy16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupDestroy CUpti_EventGroup  eventGroup Destroy an event group. Destroy an eventGroup and free its resources. An event group cannot be destroyed if it is enabled. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group to destroy Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if the event group is enabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1268, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupDisable", "display_name": "cuptiEventGroupDisable", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGroupDisable16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupDisable CUpti_EventGroup  eventGroup Disable an event group. Disable an event group. Disabling an event group stops collection of events contained in the group. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1269, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupDisable::eventGroup", "display_name": "cuptiEventGroupDisable::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv422cuptiEventGroupDisable16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupDisable CUpti_EventGroup  eventGroup Disable an event group. Disable an event group. Disabling an event group stops collection of events contained in the group. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1270, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupEnable", "display_name": "cuptiEventGroupEnable", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupEnable16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupEnable CUpti_EventGroup  eventGroup Enable an event group. Enable an event group. Enabling an event group zeros the value of all the events in the group and then starts collection of those events. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_NOT_READY \u2013 if eventGroup does not contain any events CUPTI_ERROR_NOT_COMPATIBLE \u2013 if eventGroup cannot be enabled due to other already enabled event groups CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL CUPTI_ERROR_HARDWARE_BUSY \u2013 if another client is profiling and hardware is busy", "keywords": []}, {"id": 1271, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupEnable::eventGroup", "display_name": "cuptiEventGroupEnable::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv421cuptiEventGroupEnable16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupEnable CUpti_EventGroup  eventGroup Enable an event group. Enable an event group. Enabling an event group zeros the value of all the events in the group and then starts collection of those events. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_NOT_READY \u2013 if eventGroup does not contain any events CUPTI_ERROR_NOT_COMPATIBLE \u2013 if eventGroup cannot be enabled due to other already enabled event groups CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL CUPTI_ERROR_HARDWARE_BUSY \u2013 if another client is profiling and hardware is busy", "keywords": []}, {"id": 1272, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupGetAttribute", "display_name": "cuptiEventGroupGetAttribute", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEventGroupGetAttribute16CUpti_EventGroup25CUpti_EventGroupAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGroupGetAttribute CUpti_EventGroup  eventGroup CUpti_EventGroupAttribute  attrib size_t  * valueSize void  * value Read an event group attribute. Read an event group attribute and return it in *value . Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). Parameters eventGroup \u2013 The event group attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an eventgroup attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1273, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupGetAttribute::attrib", "display_name": "cuptiEventGroupGetAttribute::attrib", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEventGroupGetAttribute16CUpti_EventGroup25CUpti_EventGroupAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGroupGetAttribute CUpti_EventGroup  eventGroup CUpti_EventGroupAttribute  attrib size_t  * valueSize void  * value Read an event group attribute. Read an event group attribute and return it in *value . Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). Parameters eventGroup \u2013 The event group attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an eventgroup attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1274, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupGetAttribute::eventGroup", "display_name": "cuptiEventGroupGetAttribute::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEventGroupGetAttribute16CUpti_EventGroup25CUpti_EventGroupAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGroupGetAttribute CUpti_EventGroup  eventGroup CUpti_EventGroupAttribute  attrib size_t  * valueSize void  * value Read an event group attribute. Read an event group attribute and return it in *value . Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). Parameters eventGroup \u2013 The event group attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an eventgroup attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1275, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupGetAttribute::value", "display_name": "cuptiEventGroupGetAttribute::value", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEventGroupGetAttribute16CUpti_EventGroup25CUpti_EventGroupAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGroupGetAttribute CUpti_EventGroup  eventGroup CUpti_EventGroupAttribute  attrib size_t  * valueSize void  * value Read an event group attribute. Read an event group attribute and return it in *value . Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). Parameters eventGroup \u2013 The event group attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an eventgroup attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1276, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupGetAttribute::valueSize", "display_name": "cuptiEventGroupGetAttribute::valueSize", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv427cuptiEventGroupGetAttribute16CUpti_EventGroup25CUpti_EventGroupAttributeP6size_tPv", "priority": 1, "content": "CUptiResult  cuptiEventGroupGetAttribute CUpti_EventGroup  eventGroup CUpti_EventGroupAttribute  attrib size_t  * valueSize void  * value Read an event group attribute. Read an event group attribute and return it in *value . Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). Parameters eventGroup \u2013 The event group attrib \u2013 The attribute to read valueSize \u2013 Size of buffer pointed by the value, and returns the number of bytes written to value  value \u2013 Returns the value of the attribute Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_PARAMETER \u2013 if valueSize or value is NULL, or if attrib is not an eventgroup attribute CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 For non-c-string attribute values, indicates that the value buffer is too small to hold the attribute value.", "keywords": []}, {"id": 1277, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents", "display_name": "cuptiEventGroupReadAllEvents", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1278, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::eventGroup", "display_name": "cuptiEventGroupReadAllEvents::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1279, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::eventIdArray", "display_name": "cuptiEventGroupReadAllEvents::eventIdArray", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1280, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::eventIdArraySizeBytes", "display_name": "cuptiEventGroupReadAllEvents::eventIdArraySizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1281, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::eventValueBuffer", "display_name": "cuptiEventGroupReadAllEvents::eventValueBuffer", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1282, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::eventValueBufferSizeBytes", "display_name": "cuptiEventGroupReadAllEvents::eventValueBufferSizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1283, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::flags", "display_name": "cuptiEventGroupReadAllEvents::flags", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1284, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadAllEvents::numEventIdsRead", "display_name": "cuptiEventGroupReadAllEvents::numEventIdsRead", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv428cuptiEventGroupReadAllEvents16CUpti_EventGroup20CUpti_ReadEventFlagsP6size_tP8uint64_tP6size_tP13CUpti_EventIDP6size_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadAllEvents CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer size_t  * eventIdArraySizeBytes CUpti_EventID  * eventIdArray size_t  * numEventIdsRead Read the values for all the events in an event group. Read the values for all the events in an event group. The event values are returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of eventValueBuffer . The buffer must be at least (sizeof(uint64) * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the events. The buffer must be at least (sizeof(uint64) * number of domain instances * number of events in group) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. The data format returned in eventValueBuffer is: domain instance 0: event0 event1 \u2026 eventN domain instance 1: event0 event1 \u2026 eventN \u2026 domain instance M: event0 event1 \u2026 eventN The event order in eventValueBuffer is returned in eventIdArray . The size of eventIdArray is specified in eventIdArraySizeBytes . The size should be at least (sizeof(CUpti_EventID) * number of events in group). If any instance of any event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading events from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event values eventIdArraySizeBytes \u2013 The size of eventIdArray in bytes, and returns the number of bytes written to eventIdArray  eventIdArray \u2013 Returns the IDs of the events in the same order as the values return in eventValueBuffer. numEventIdsRead \u2013 Returns the number of event IDs returned in eventIdArray  Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes , eventValueBuffer , eventIdArraySizeBytes , eventIdArray or numEventIdsRead is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer or eventIdArray is not sufficient", "keywords": []}, {"id": 1285, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent", "display_name": "cuptiEventGroupReadEvent", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1286, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent::event", "display_name": "cuptiEventGroupReadEvent::event", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1287, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent::eventGroup", "display_name": "cuptiEventGroupReadEvent::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1288, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent::eventValueBuffer", "display_name": "cuptiEventGroupReadEvent::eventValueBuffer", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1289, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent::eventValueBufferSizeBytes", "display_name": "cuptiEventGroupReadEvent::eventValueBufferSizeBytes", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1290, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupReadEvent::flags", "display_name": "cuptiEventGroupReadEvent::flags", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv424cuptiEventGroupReadEvent16CUpti_EventGroup20CUpti_ReadEventFlags13CUpti_EventIDP6size_tP8uint64_t", "priority": 1, "content": "CUptiResult  cuptiEventGroupReadEvent CUpti_EventGroup  eventGroup CUpti_ReadEventFlags  flags CUpti_EventID  event size_t  * eventValueBufferSizeBytes uint64_t  * eventValueBuffer Read the value for an event in an event group. Read the value for an event in an event group. The event value is returned in the eventValueBuffer buffer. eventValueBufferSizeBytes indicates the size of the eventValueBuffer buffer. The buffer must be at least sizeof(uint64) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is not set on the group containing the event. The buffer must be at least (sizeof(uint64) * number of domain instances) if CUPTI_EVENT_GROUP_ATTR_PROFILE_ALL_DOMAIN_INSTANCES is set on the group. If any instance of an event counter overflows, the value returned for that event instance will be CUPTI_EVENT_OVERFLOW . The only allowed value for flags is CUPTI_EVENT_READ_FLAG_NONE . Reading an event from a disabled event group is not allowed. After being read, an event\u2019s value is reset to zero. Thread-safety : this function is thread safe but client must guard against simultaneous destruction or modification of eventGroup (for example, client must guard against simultaneous calls to cuptiEventGroupDestroy , cuptiEventGroupAddEvent , etc.), and must guard against simultaneous destruction of the context in which eventGroup was created (for example, client must guard against simultaneous calls to cudaDeviceReset, cuCtxDestroy, etc.). If cuptiEventGroupResetAllEvents is called simultaneously with this function, then returned event values are undefined. Parameters eventGroup \u2013 The event group flags \u2013 Flags controlling the reading mode event \u2013 The event to read eventValueBufferSizeBytes \u2013 The size of eventValueBuffer in bytes, and returns the number of bytes written to eventValueBuffer  eventValueBuffer \u2013 Returns the event value(s) Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_EVENT_ID \u2013 CUPTI_ERROR_HARDWARE \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is disabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup , eventValueBufferSizeBytes or eventValueBuffer is NULL CUPTI_ERROR_PARAMETER_SIZE_NOT_SUFFICIENT \u2013 if size of eventValueBuffer is not sufficient", "keywords": []}, {"id": 1291, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupRemoveAllEvents", "display_name": "cuptiEventGroupRemoveAllEvents", "type": "function", "display_type": "C++ function", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv430cuptiEventGroupRemoveAllEvents16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupRemoveAllEvents CUpti_EventGroup  eventGroup Remove all events from an event group. Remove all events from an event group. Events cannot be removed if the event group is enabled. Thread-safety : this function is thread safe. Parameters eventGroup \u2013 The event group Return values CUPTI_SUCCESS \u2013 CUPTI_ERROR_NOT_INITIALIZED \u2013 CUPTI_ERROR_INVALID_OPERATION \u2013 if eventGroup is enabled CUPTI_ERROR_INVALID_PARAMETER \u2013 if eventGroup is NULL", "keywords": []}, {"id": 1292, "doc_id": 1322, "filename": "api/group__CUPTI__EVENT__API.html", "domain_name": "cpp", "name": "cuptiEventGroupRemoveAllEvents::eventGroup", "display_name": "cuptiEventGroupRemoveAllEvents::eventGroup", "type": "functionParam", "display_type": "C++ function parameter", "docname": "api/group__CUPTI__EVENT__API", "anchor": "_CPPv430cuptiEventGroupRemoveAllEvents16CUpti_EventGroup", "priority": 1, "content": "CUptiResult  cuptiEventGroupRemoveAllEvents CUpti_EventGroup  eventGroup Remove all events from an event group. Remove all events from an event group. Events cannot be re