#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.41.2
visibility:           public
id:                   dhall-1.41.2-I4wtrAjwPfSHVTvmjdeIAQ
key:                  dhall-1.41.2-I4wtrAjwPfSHVTvmjdeIAQ
license:              BSD-3-Clause
copyright:            2017 Gabriel Gonzalez
maintainer:           Gabriel439@gmail.com
author:               Gabriel Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  8513d456bd766ad267d0c1bec746d224
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics Dhall.Parser
    Dhall.Parser.Expression Dhall.Parser.Token Dhall.Pretty Dhall.Repl
    Dhall.Schemas Dhall.Set Dhall.Src Dhall.Substitution Dhall.TH
    Dhall.Tags Dhall.Tutorial Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.Eval Dhall.Import.Types Dhall.Import.Headers
    Dhall.Marshal.Internal Dhall.Normalize Dhall.Parser.Combinators
    Dhall.Pretty.Internal Dhall.Syntax Dhall.URL Paths_dhall
    Dhall.Import.HTTP Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.41.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.41.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.41.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.41.2-I4wtrAjwPfSHVTvmjdeIAQ
depends:
    Diff-0.4.1-76hxB7iu2dgLeu2Kxqhnk5
    aeson-2.1.2.1-Kzzie09M6AYFH8VDx0mx86
    aeson-pretty-0.8.10-LSMEybji2H0AjtTXnGZSdX
    ansi-terminal-0.11.5-DgJDSat1zXpLe3d4scDJDO
    atomic-write-0.2.1.0-H4m4CYOBFdhH2uzWx9gF1b base-4.17.2.1
    base16-bytestring-1.0.2.0-KDSFpGK70SNFrMbzTIS4T1
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-AtT9PetKXQ46vh6orGagap
    cborg-0.2.9.0-CwOHIJeKK3UCNoRq4u9cSr
    cborg-json-0.2.5.0-8wqAEpQrR0fIKoyo05GTu9 containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-J67TLWTxrj33yKHRpICwc7
    data-fix-0.3.2-JNkfgh3sBrmALE891C7vSD deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-9550az1aJXYCamgHJfPTw3 exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-76VjKjDGzuw46Q8S8gTbbr
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig haskeline-0.8.2
    http-client-0.7.17-23w6wIj9GbeK9arRJvAmDK
    http-client-tls-0.3.6.3-2hSd1fCBdlWFtn05eObSxT
    http-types-0.12.4-D2DAVTmHvcDBQ0h7IvaEn9
    indexed-traversable-0.1.4-7ph7dHdACfa9uO4tGpH9sc
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-DSXrb12WW9pAlDntPLXdEB
    pretty-simple-4.1.3.0-CaupJMWQgal8iOQO2HSQjT
    prettyprinter-1.7.1-CrZ7BsQJ9pDCXOGGFM6iz2
    prettyprinter-ansi-terminal-1.1.3-IEr2TcuCyQgMLg4vnxF9Z
    profunctors-5.6.2-1y5eXinqMYuK1INvDQniNm
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-Jh9tJE2sLMpFL2bSsP8DMA
    serialise-0.2.6.1-IvMhZlMHqpSERXO15G7ard template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1u2p2wuU1tm7I7199hgaDv
    text-short-0.1.6-LHOZ8YG3dHr4Bc2V2LTWU4
    th-lift-instances-0.1.20-521aqb21wMBKDojpuvTtA0 time-1.12.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    uri-encode-1.5.0.7-F2IjGF38Gm3JJBGjWZTCgF
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

