#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-1Sq0RLHVQS9wRx7I3v9sA
key:                  dhall-1.42.1-1Sq0RLHVQS9wRx7I3v9sA
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  589d36bd2220d2f5c9c5d1d93b28cea3
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-1Sq0RLHVQS9wRx7I3v9sA
depends:
    Diff-0.4.1-BOxCLpHEbnv464iV7Wt9tY
    aeson-2.1.2.1-25ntyCXNIMdHgIjcbgcdOM
    aeson-pretty-0.8.10-8MzrxhWXAT5HuFSZrBjiEI
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc
    atomic-write-0.2.1.0-KKYeOEPrPK96Bs8FvGckg3 base-4.17.2.1
    base16-bytestring-1.0.2.0-LZWoqVsRU525spGmpCza2K
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-GbIPZPr2YUt5gu3TjAsadi
    cborg-0.2.9.0-VgE1ZKGxSP5YtdDndmCaU
    cborg-json-0.2.5.0-E3h2r6czZdUHyIzSv6hEtU containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-250PQLTYz41LEMbUeSi1az
    data-fix-0.3.2-At1uUHrE6lC1Zo5K7qlX0q deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-6aNHGy4tQhtHx1RN95SwYf exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-E1LlIe0hzkw3sgpiTlypC8
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1 haskeline-0.8.2
    http-client-0.7.17-DhDd3U2QPYs2m1aaZr4mcj
    http-client-tls-0.3.6.3-AmBifQza3vb6Zx7tdAKRl9
    http-types-0.12.4-84PTldXFVlSHvwiFY4h2Wj
    indexed-traversable-0.1.4-AabWb0rTj2074tslOlVynz
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-K6n3nDiAbysFzcr1mYtRG7
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-2U8duEjYT0p2SuyLAFgLE2
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-7AcapIsjct66ZeSNLGF65t
    pretty-simple-4.1.3.0-gdoKQqwqL4BEhmzWwDwVe
    prettyprinter-1.7.1-KbA7i78IS3P9O3YxKJ8q7i
    prettyprinter-ansi-terminal-1.1.3-DFIU9tKtYysH2zgsxPFCIr
    profunctors-5.6.2-9EQgL3T6SuTGHUVkpjenXY
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-LKd2L2qVPICBdMYOyCcex4
    serialise-0.2.6.1-ZxnyFaDgX8EaKTlW3qraU template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1u2p2wuU1tm7I7199hgaDv
    text-short-0.1.6-7jMKNwZWvow5bGSTCFjHPD
    th-lift-instances-0.1.20-B2XczfdPjvX7LT1CulVJAf time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-KodBgNM0fPsEC9GAASBuc8
    unordered-containers-0.2.20-2oScjwZejU42oDENjBi2vG
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

