#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall
version:              1.42.1
visibility:           public
id:                   dhall-1.42.1-9eJqSfYO8mV1KKHCWwELjh
key:                  dhall-1.42.1-9eJqSfYO8mV1KKHCWwELjh
license:              BSD-3-Clause
copyright:            2017 Gabriella Gonzalez
maintainer:           GenuineGabriella@gmail.com
author:               Gabriella Gonzalez
synopsis:             A configuration language guaranteed to terminate
description:
    Dhall is an explicitly typed configuration language that is not Turing
    complete.  Despite being Turing incomplete, Dhall is a real programming
    language with a type-checker and evaluator.

    Use this library to parse, type-check, evaluate, and pretty-print the Dhall
    configuration language.  This package also includes an executable which
    type-checks a Dhall file and reduces the file to a fully evaluated normal
    form.

    Read "Dhall.Tutorial" to learn how to use this library

category:             Compiler
abi:                  2131e9bcd88a6013d35087e1d255b980
exposed:              True
exposed-modules:
    Dhall Dhall.Binary Dhall.Context Dhall.Core Dhall.Crypto
    Dhall.Deriving Dhall.Diff Dhall.DirectoryTree Dhall.Format
    Dhall.Freeze Dhall.Import Dhall.Lint Dhall.Main Dhall.Map
    Dhall.Marshal.Decode Dhall.Marshal.Encode Dhall.Optics
    Dhall.Package Dhall.Parser Dhall.Parser.Expression
    Dhall.Parser.Token Dhall.Pretty Dhall.Repl Dhall.Schemas Dhall.Set
    Dhall.Src Dhall.Substitution Dhall.TH Dhall.Tags Dhall.Tutorial
    Dhall.TypeCheck Dhall.Util Dhall.Version

hidden-modules:
    Dhall.DirectoryTree.Types Dhall.Eval Dhall.Import.Types
    Dhall.Import.Headers Dhall.Marshal.Internal Dhall.Normalize
    Dhall.Parser.Combinators Dhall.Pretty.Internal Dhall.Syntax
    Dhall.Syntax.Binding Dhall.Syntax.Chunks Dhall.Syntax.Const
    Dhall.Syntax.Expr Dhall.Syntax.FunctionBinding Dhall.Syntax.Import
    Dhall.Syntax.Instances.Applicative Dhall.Syntax.Instances.Bifunctor
    Dhall.Syntax.Instances.Data Dhall.Syntax.Instances.Eq
    Dhall.Syntax.Instances.Foldable Dhall.Syntax.Instances.Functor
    Dhall.Syntax.Instances.Lift Dhall.Syntax.Instances.Monad
    Dhall.Syntax.Instances.NFData Dhall.Syntax.Instances.Ord
    Dhall.Syntax.Instances.Pretty Dhall.Syntax.Instances.Show
    Dhall.Syntax.Instances.Traversable Dhall.Syntax.MultiLet
    Dhall.Syntax.Operations Dhall.Syntax.RecordField Dhall.Syntax.Types
    Dhall.Syntax.Var Dhall.URL Paths_dhall Dhall.Import.HTTP
    Dhall.Import.Manager

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-1.42.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall
hs-libraries:         HSdhall-1.42.1-9eJqSfYO8mV1KKHCWwELjh
depends:
    Diff-0.4.1-LH1ky1AbixJl32mO74dkD
    aeson-2.1.2.1-G4Y2VMvw6jlHlUlOzfqhge
    aeson-pretty-0.8.10-KTiOu4YfIIJCr314ot6d0W
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc
    atomic-write-0.2.1.0-9xksR22qF9EJFs2H77i85H base-4.17.2.1
    base16-bytestring-1.0.2.0-IEtpsrDkMVlLM4YsQhzHqm
    bytestring-0.11.5.3 case-insensitive-1.2.1.0-BBd0FN3VG9pHwba5nfbZ8v
    cborg-0.2.9.0-JadtT8hVoV4Kxsek1Tm58s
    cborg-json-0.2.5.0-3l6EyiRqEFq1ioY59dHnrS containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    cryptohash-sha256-0.11.102.1-8svuiS5zIpw3aMouaqAqP7
    data-fix-0.3.3-1xrLcRXcGoAEy8ltTVfrkV deepseq-1.4.8.0
    directory-1.3.7.1 dotgen-0.4.3-DCEwHcGESGV7f7E3GHH98g
    either-5.0.2-Hwf6So7J7WiFk20J0F7eBd exceptions-0.10.5
    filepath-1.4.2.2 half-0.3.2-HEIOSCWXOUzI8Pf4n1aPkf
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw haskeline-0.8.2
    http-client-0.7.17-7ke50M5l2YA8vO0Zwid8PF
    http-client-tls-0.3.6.4-JDLohsQhzsUKRvOl7N0Lps
    http-types-0.12.4-1DZFzfvJVK9AHfgKU8FkY3
    indexed-traversable-0.1.4-AIrw26zjgKT4obC66VIWQz
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O
    mmorph-1.2.0-3nIz0RIlBAUER45blfkK28 mtl-2.2.2
    network-uri-2.6.4.2-EDr74t9h07L15oCNeDNFfl
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    parsers-0.12.12-FnpoOiuqefJ3wO6niERnzh
    pretty-simple-4.1.3.0-Hej2b0TxAMTLpMjeRpupzQ
    prettyprinter-1.7.1-4Mn04lWp3HTA5zh48zv2n2
    prettyprinter-ansi-terminal-1.1.3-6Eao8UWEb6h5bk4KkwJP4W
    profunctors-5.6.2-HIPCYf4suJh2mKMTWBW6VY
    repline-0.4.2.0-KVntTSpWnVfIRYxV1mly8a
    scientific-0.3.7.0-BkypiqTAkpN3suN2c81wMx
    serialise-0.2.6.1-3vwyIqmNPhOC2pUTxq5m6g template-haskell-2.19.0.0
    text-2.0.2 text-manipulate-0.3.1.0-1u2p2wuU1tm7I7199hgaDv
    text-short-0.1.6-twjb12lbHdEtDXZKcEsva
    th-lift-instances-0.1.20-45VGakeqcUODctOJKhXaAz time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unix-compat-0.7.3-9Tj09IRjFnyE6cgV0AVkT
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:   /usr/share/doc/dhall/html/dhall.haddock
haddock-html:         /usr/share/doc/dhall/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

