#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 dhall-docs
version:              1.0.11
visibility:           public
id:                   dhall-docs-1.0.11-GdJFRnHJiuc6i2mm6KKjaA
key:                  dhall-docs-1.0.11-GdJFRnHJiuc6i2mm6KKjaA
license:              BSD-3-Clause
copyright:            2020 Germán Robayo
maintainer:           GenuineGabriella@gmail.com
author:               Germán Robayo
synopsis:             Generate HTML docs from a dhall package
description:
    Use this package if you want to create HTML documentation from your dhall
    packages:

    * See the "Dhall.Docs" module if you want to use this package as a library

    * Use the @dhall-docs@ program from this package if you want an executable

    The "Dhall.Docs" module also contains instructions for how to use this package

category:             Compiler
abi:                  cc212f1a0286eda12411bcb95ba72051
exposed:              True
exposed-modules:      Dhall.Docs Dhall.Docs.Core
hidden-modules:
    Dhall.Docs.CodeRenderer Dhall.Docs.Comment Dhall.Docs.Embedded
    Dhall.Docs.Html Dhall.Docs.Markdown Dhall.Docs.Store
    Dhall.Docs.Util Paths_dhall_docs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.11
library-dirs:         /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.11
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/dhall-docs-1.0.11
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/dhall-docs
hs-libraries:         HSdhall-docs-1.0.11-GdJFRnHJiuc6i2mm6KKjaA
depends:
    base-4.17.2.1 base16-bytestring-1.0.2.0-KDSFpGK70SNFrMbzTIS4T1
    bytestring-0.11.5.3 containers-0.6.7
    cryptohash-sha256-0.11.102.1-J67TLWTxrj33yKHRpICwc7
    dhall-1.41.2-Gs1VwSTnmZlLfpuOyp8SZa directory-1.3.7.1
    file-embed-0.0.15.0-7OnjuFj6gBM9fqBKJCVXdU filepath-1.4.2.2
    lens-family-core-2.1.3-Ij4qXDXH4U49wX5TL83dlV
    lucid-2.11.20230408-JfR12R91w1w5j8wnsfeyZT
    megaparsec-9.6.1-D3hnMTazjD69kPahnDEjhI
    mmark-0.0.7.6-2WIAVoKr2kB16Sd6MhGg9b mtl-2.2.2
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    path-0.9.5-LP407prVl4P3hZzGqV0DwD
    path-io-1.8.2-CVPxF3eU4lCKtRnwLFVqKz
    prettyprinter-1.7.1-CrZ7BsQJ9pDCXOGGFM6iz2 text-2.0.2
    transformers-0.5.6.2

haddock-interfaces:   /usr/share/doc/dhall-docs/html/dhall-docs.haddock
haddock-html:         /usr/share/doc/dhall-docs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

