%% Generated by the Erlang ASN.1 BER compiler. Version: 5.4
%% Purpose: Encoding and decoding of the types in CryptographicMessageSyntaxAlgorithms-2009.

-module('CryptographicMessageSyntaxAlgorithms-2009').
-moduledoc false.
-compile(nowarn_unused_vars).
-dialyzer(no_improper_lists).
-dialyzer(no_match).
-include("CryptographicMessageSyntaxAlgorithms-2009.hrl").
-asn1_info([{vsn,'5.4'},
            {module,'CryptographicMessageSyntaxAlgorithms-2009'},
            {options,[{i,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 warnings,ber,errors,
 {cwd,"/build/erlang/src/otp/lib/public_key/asn1"},
 {outdir,"/build/erlang/src/otp/lib/public_key/asn1/../src"},
 der,noobj,asn1config,
 {i,"."},
 {i,"/build/erlang/src/otp/lib/public_key/asn1"}]}]).

-export([encoding_rule/0,maps/0,bit_string_format/0,
         legacy_erlang_types/0]).
-export(['dialyzer-suppressions'/1]).
-export([
enc_KeyWrapAlgorithm/2,
enc_RC2wrapParameter/2,
enc_RC2ParameterVersion/2,
enc_CBCParameter/2,
enc_IV/2,
enc_RC2CBCParameter/2,
'enc_PBKDF2-PRFsAlgorithmIdentifier'/2,
'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'/2,
'enc_PBKDF2-params'/2
]).

-export([
dec_KeyWrapAlgorithm/2,
dec_RC2wrapParameter/2,
dec_RC2ParameterVersion/2,
dec_CBCParameter/2,
dec_IV/2,
dec_RC2CBCParameter/2,
'dec_PBKDF2-PRFsAlgorithmIdentifier'/2,
'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'/2,
'dec_PBKDF2-params'/2
]).

-export([
'enc_maca-hMAC-SHA1'/3,
'enc_alg-hMAC-SHA1'/3,
'enc_kaa-esdh'/3,
'enc_kaa-ssdh'/3,
'enc_pk-originator-dh'/3,
'enc_kwa-3DESWrap'/3,
'enc_kwa-RC2Wrap'/3,
'enc_kda-PBKDF2'/3,
'enc_cea-3DES-cbc'/3,
'enc_cea-RC2-cbc'/3,
'enc_kt-rsa'/3,
'enc_cap-3DESwrap'/3,
'enc_kwa-3DESWrap_smimeCaps'/3,
'enc_kaa-esdh_smimeCaps'/3,
'enc_kwa-RC2Wrap_smimeCaps'/3,
'enc_cea-3DES-cbc_smimeCaps'/3,
'enc_kt-rsa_smimeCaps'/3,
'enc_maca-hMAC-SHA1_smimeCaps'/3,
'enc_kaa-ssdh_smimeCaps'/3,
enc_KeyWrapAlgorithm_smimeCaps/3
]).

-export([
'dec_maca-hMAC-SHA1'/3,
'dec_alg-hMAC-SHA1'/3,
'dec_kaa-esdh'/3,
'dec_kaa-ssdh'/3,
'dec_pk-originator-dh'/3,
'dec_kwa-3DESWrap'/3,
'dec_kwa-RC2Wrap'/3,
'dec_kda-PBKDF2'/3,
'dec_cea-3DES-cbc'/3,
'dec_cea-RC2-cbc'/3,
'dec_kt-rsa'/3,
'dec_cap-3DESwrap'/3,
'dec_kwa-3DESWrap_smimeCaps'/3,
'dec_kaa-esdh_smimeCaps'/3,
'dec_kwa-RC2Wrap_smimeCaps'/3,
'dec_cea-3DES-cbc_smimeCaps'/3,
'dec_kt-rsa_smimeCaps'/3,
'dec_maca-hMAC-SHA1_smimeCaps'/3,
'dec_kaa-ssdh_smimeCaps'/3,
dec_KeyWrapAlgorithm_smimeCaps/3
]).

-export([
getenc_MessageDigestAlgs/1,
getenc_SignatureAlgs/1,
getenc_KeyAgreementAlgs/1,
getenc_KeyAgreePublicKeys/1,
getenc_KeyTransportAlgs/1,
getenc_KeyWrapAlgs/1,
getenc_KeyDerivationAlgs/1,
getenc_ContentEncryptionAlgs/1,
getenc_MessageAuthAlgs/1,
getenc_SMimeCaps/1,
'getenc_PBKDF2-PRFs'/1,
'getenc_PBKDF2-SaltSources'/1,
getenc_internal_object_set_argument_6/1,
getenc_internal_object_set_argument_4/1,
getenc_internal_object_set_argument_2/1
]).

-export([
getdec_MessageDigestAlgs/1,
getdec_SignatureAlgs/1,
getdec_KeyAgreementAlgs/1,
getdec_KeyAgreePublicKeys/1,
getdec_KeyTransportAlgs/1,
getdec_KeyWrapAlgs/1,
getdec_KeyDerivationAlgs/1,
getdec_ContentEncryptionAlgs/1,
getdec_MessageAuthAlgs/1,
getdec_SMimeCaps/1,
'getdec_PBKDF2-PRFs'/1,
'getdec_PBKDF2-SaltSources'/1,
getdec_internal_object_set_argument_6/1,
getdec_internal_object_set_argument_4/1,
getdec_internal_object_set_argument_2/1
]).

-export([
'id-alg-ESDH'/0,
'id-alg-SSDH'/0,
'id-alg-CMS3DESwrap'/0,
'id-alg-CMSRC2wrap'/0,
'des-ede3-cbc'/0,
'rc2-cbc'/0,
'hMAC-SHA1'/0,
'id-PBKDF2'/0,
defaultPBKDF2/0,
'dh-public-number'/0
]).

-export([info/0]).

-export([encode/2,decode/2]).

encoding_rule() -> ber.

maps() -> false.

bit_string_format() -> bitstring.

legacy_erlang_types() -> false.

encode(Type, Data) ->
try iolist_to_binary(element(1, encode_disp(Type, Data))) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.


decode(Type, Data) ->
try
   Result = decode_disp(Type, element(1, ber_decode_nif(Data))),
   {ok,Result}
  catch
    Class:Exception:Stk when Class =:= error; Class =:= exit ->
      case Exception of
        {error,{asn1,Reason}} ->
          {error,{asn1,{Reason,Stk}}};
        Reason ->
         {error,{asn1,{Reason,Stk}}}
      end
end.

encode_disp('KeyWrapAlgorithm', Data) -> enc_KeyWrapAlgorithm(Data);
encode_disp('RC2wrapParameter', Data) -> enc_RC2wrapParameter(Data);
encode_disp('RC2ParameterVersion', Data) -> enc_RC2ParameterVersion(Data);
encode_disp('CBCParameter', Data) -> enc_CBCParameter(Data);
encode_disp('IV', Data) -> enc_IV(Data);
encode_disp('RC2CBCParameter', Data) -> enc_RC2CBCParameter(Data);
encode_disp('PBKDF2-PRFsAlgorithmIdentifier', Data) -> 'enc_PBKDF2-PRFsAlgorithmIdentifier'(Data);
encode_disp('PBKDF2-SaltSourcesAlgorithmIdentifier', Data) -> 'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'(Data);
encode_disp('PBKDF2-params', Data) -> 'enc_PBKDF2-params'(Data);
encode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

decode_disp('KeyWrapAlgorithm', Data) -> dec_KeyWrapAlgorithm(Data);
decode_disp('RC2wrapParameter', Data) -> dec_RC2wrapParameter(Data);
decode_disp('RC2ParameterVersion', Data) -> dec_RC2ParameterVersion(Data);
decode_disp('CBCParameter', Data) -> dec_CBCParameter(Data);
decode_disp('IV', Data) -> dec_IV(Data);
decode_disp('RC2CBCParameter', Data) -> dec_RC2CBCParameter(Data);
decode_disp('PBKDF2-PRFsAlgorithmIdentifier', Data) -> 'dec_PBKDF2-PRFsAlgorithmIdentifier'(Data);
decode_disp('PBKDF2-SaltSourcesAlgorithmIdentifier', Data) -> 'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'(Data);
decode_disp('PBKDF2-params', Data) -> 'dec_PBKDF2-params'(Data);
decode_disp(Type, _Data) -> exit({error,{asn1,{undefined_type,Type}}}).

info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.


%%================================
%%  KeyWrapAlgorithm
%%================================
enc_KeyWrapAlgorithm(Val) ->
    enc_KeyWrapAlgorithm(Val, [<<48>>]).

enc_KeyWrapAlgorithm(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntaxAlgorithms-2009':'getenc_internal_object_set_argument_2'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_KeyWrapAlgorithm(Tlv) ->
   dec_KeyWrapAlgorithm(Tlv, [16]).

dec_KeyWrapAlgorithm(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntaxAlgorithms-2009':'getdec_internal_object_set_argument_2'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'KeyWrapAlgorithm',Term1,Term2},
Res1.


%%================================
%%  RC2wrapParameter
%%================================
enc_RC2wrapParameter(Val) ->
    enc_RC2wrapParameter(Val, [<<2>>]).

enc_RC2wrapParameter(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_RC2wrapParameter(Tlv) ->
   dec_RC2wrapParameter(Tlv, [2]).

dec_RC2wrapParameter(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  RC2ParameterVersion
%%================================
enc_RC2ParameterVersion(Val) ->
    enc_RC2ParameterVersion(Val, [<<2>>]).

enc_RC2ParameterVersion(Val, TagIn) ->
encode_integer(Val, TagIn).


dec_RC2ParameterVersion(Tlv) ->
   dec_RC2ParameterVersion(Tlv, [2]).

dec_RC2ParameterVersion(Tlv, TagIn) ->
decode_integer(Tlv, TagIn).



%%================================
%%  CBCParameter
%%================================
enc_CBCParameter(Val) ->
    enc_CBCParameter(Val, [<<4>>]).

enc_CBCParameter(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_CBCParameter(Tlv) ->
   dec_CBCParameter(Tlv, [4]).

dec_CBCParameter(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  IV
%%================================
enc_IV(Val) ->
    enc_IV(Val, [<<4>>]).

enc_IV(Val, TagIn) ->
encode_restricted_string(Val, TagIn).


dec_IV(Tlv) ->
   dec_IV(Tlv, [4]).

dec_IV(Tlv, TagIn) ->
decode_octet_string(Tlv, TagIn).



%%================================
%%  RC2CBCParameter
%%================================
enc_RC2CBCParameter(Val) ->
    enc_RC2CBCParameter(Val, [<<48>>]).

enc_RC2CBCParameter(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,

%%-------------------------------------------------
%% attribute rc2ParameterVersion(1) with type INTEGER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_integer(Cindex1, [<<2>>]),

%%-------------------------------------------------
%% attribute iv(2) with type OCTET STRING
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_restricted_string(Cindex2, [<<4>>]),

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


dec_RC2CBCParameter(Tlv) ->
   dec_RC2CBCParameter(Tlv, [16]).

dec_RC2CBCParameter(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute rc2ParameterVersion(1) with type INTEGER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = begin
Val1 = decode_integer(V1, [2]),
if 1 =< Val1, Val1 =< 256 ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute iv(2) with type OCTET STRING
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = decode_octet_string(V2, [4]),

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'RC2CBCParameter',Term1,Term2},
Res1.


%%================================
%%  PBKDF2-PRFsAlgorithmIdentifier
%%================================
'enc_PBKDF2-PRFsAlgorithmIdentifier'(Val) ->
    'enc_PBKDF2-PRFsAlgorithmIdentifier'(Val, [<<48>>]).

'enc_PBKDF2-PRFsAlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntaxAlgorithms-2009':'getenc_internal_object_set_argument_4'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PBKDF2-PRFsAlgorithmIdentifier'(Tlv) ->
   'dec_PBKDF2-PRFsAlgorithmIdentifier'(Tlv, [16]).

'dec_PBKDF2-PRFsAlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntaxAlgorithms-2009':'getdec_internal_object_set_argument_4'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-PRFsAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  PBKDF2-SaltSourcesAlgorithmIdentifier
%%================================
'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'(Val) ->
    'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'(Val, [<<48>>]).

'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'(Val, TagIn) ->
{_,Cindex1,Cindex2} = Val,
Objalgorithm = 
   'CryptographicMessageSyntaxAlgorithms-2009':'getenc_internal_object_set_argument_6'(                                   Cindex1),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
   {EncBytes1,EncLen1} = encode_object_identifier(Cindex1, [<<6>>]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
   {EncBytes2,EncLen2} =  case Cindex2 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            {TmpBytes2,_ } = Objalgorithm('Params', Cindex2, []),
   encode_open_type(TmpBytes2, [])
       end,

   BytesSoFar = [EncBytes1, EncBytes2],
LenSoFar = EncLen1 + EncLen2,
encode_tags(TagIn, BytesSoFar, LenSoFar).


'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'(Tlv) ->
   'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'(Tlv, [16]).

'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute algorithm(1) with type OBJECT IDENTIFIER
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = decode_object_identifier(V1, [6]),

%%-------------------------------------------------
%% attribute parameters(2) with type typefieldParams OPTIONAL
%%-------------------------------------------------
{Tmpterm1,Tlv3} = case Tlv2 of
[V2|TempTlv3] ->
    {decode_open_type(V2, []), TempTlv3};
    _ ->
        { asn1_NOVALUE, Tlv2}
end,

DecObjalgorithmTerm1 =
   'CryptographicMessageSyntaxAlgorithms-2009':'getdec_internal_object_set_argument_6'(Term1),
Term2 = 
   case Tmpterm1 of
      asn1_NOVALUE ->asn1_NOVALUE;
      _ ->
         case (catch DecObjalgorithmTerm1('Params', Tmpterm1, [])) of
            {'EXIT', Reason1} ->
               exit({'Type not compatible with table constraint',Reason1});
            Tmpterm2 ->
               Tmpterm2
         end
   end,

case Tlv3 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv3}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-SaltSourcesAlgorithmIdentifier',Term1,Term2},
Res1.


%%================================
%%  PBKDF2-params
%%================================
'enc_PBKDF2-params'(Val) ->
    'enc_PBKDF2-params'(Val, [<<48>>]).

'enc_PBKDF2-params'(Val, TagIn) ->
{_,Cindex1,Cindex2,Cindex3,Cindex4} = Val,

%%-------------------------------------------------
%% attribute salt(1) with type CHOICE
%%-------------------------------------------------
   {EncBytes1,EncLen1} = 'enc_PBKDF2-params_salt'(Cindex1, []),

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
   {EncBytes2,EncLen2} = encode_integer(Cindex2, [<<2>>]),

%%-------------------------------------------------
%% attribute keyLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
   {EncBytes3,EncLen3} =  case Cindex3 of
         asn1_NOVALUE -> {<<>>,0};
         _ ->
            encode_integer(Cindex3, [<<2>>])
       end,

%%-------------------------------------------------
%% attribute prf(4)   External CryptographicMessageSyntaxAlgorithms-2009:PBKDF2-PRFsAlgorithmIdentifier DEFAULT = {'PBKDF2-PRFsAlgorithmIdentifier',{1,3,6,1,5,5,8,1,2},'NULL'}
%%-------------------------------------------------
   {EncBytes4,EncLen4} =  case is_default_1(Cindex4) of
true -> {[],0};
false ->
'enc_PBKDF2-PRFsAlgorithmIdentifier'(Cindex4, [<<48>>])
       end,

   BytesSoFar = [EncBytes1, EncBytes2, EncBytes3, EncBytes4],
LenSoFar = EncLen1 + EncLen2 + EncLen3 + EncLen4,
encode_tags(TagIn, BytesSoFar, LenSoFar).



%%================================
%%  PBKDF2-params_salt
%%================================
'enc_PBKDF2-params_salt'(Val, TagIn) ->
      {EncBytes,EncLen} = case element(1,Val) of
      specified ->
         encode_restricted_string(element(2,Val), [<<4>>]);
      otherSource ->
         'enc_PBKDF2-SaltSourcesAlgorithmIdentifier'(element(2,Val), [<<48>>]);
      Else -> 
         exit({error,{asn1,{invalid_choice_type,Else}}})
   end,

encode_tags(TagIn, EncBytes, EncLen).




'dec_PBKDF2-params'(Tlv) ->
   'dec_PBKDF2-params'(Tlv, [16]).

'dec_PBKDF2-params'(Tlv, TagIn) ->
   %%-------------------------------------------------
   %% decode tag and length 
   %%-------------------------------------------------
Tlv1 = match_tags(Tlv, TagIn),

%%-------------------------------------------------
%% attribute salt(1) with type CHOICE
%%-------------------------------------------------
[V1|Tlv2] = Tlv1, 
Term1 = 'dec_PBKDF2-params_salt'(V1, []),

%%-------------------------------------------------
%% attribute iterationCount(2) with type INTEGER
%%-------------------------------------------------
[V2|Tlv3] = Tlv2, 
Term2 = begin
Val1 = decode_integer(V2, [2]),
if 1 =< Val1, Val1 =< 'MAX' ->
Val1;
true ->
exit({error,{asn1,bad_range}})
end
end,

%%-------------------------------------------------
%% attribute keyLength(3) with type INTEGER OPTIONAL
%%-------------------------------------------------
{Term3,Tlv4} = case Tlv3 of
[{2,V3}|TempTlv4] ->
    {begin
Val2 = decode_integer(V3, []),
if 1 =< Val2, Val2 =< 'MAX' ->
Val2;
true ->
exit({error,{asn1,bad_range}})
end
end, TempTlv4};
    _ ->
        { asn1_NOVALUE, Tlv3}
end,

%%-------------------------------------------------
%% attribute prf(4)   External CryptographicMessageSyntaxAlgorithms-2009:PBKDF2-PRFsAlgorithmIdentifier DEFAULT = {'PBKDF2-PRFsAlgorithmIdentifier',{1,3,6,1,5,5,8,1,2},'NULL'}
%%-------------------------------------------------
{Term4,Tlv5} = case Tlv4 of
[{16,V4}|TempTlv5] ->
    {'dec_PBKDF2-PRFsAlgorithmIdentifier'(V4, []), TempTlv5};
    _ ->
        {{'PBKDF2-PRFsAlgorithmIdentifier',{1,3,6,1,5,5,8,1,2},'NULL'},Tlv4}
end,

case Tlv5 of
[] -> true;_ -> exit({error,{asn1, {unexpected,Tlv5}}}) % extra fields not allowed
end,
Res1 = {'PBKDF2-params',Term1,Term2,Term3,Term4},
Res1.
'dec_PBKDF2-params_salt'(Tlv, TagIn) ->
Tlv1 = match_tags(Tlv, TagIn),
case (case Tlv1 of [CtempTlv1] -> CtempTlv1; _ -> Tlv1 end) of

%% 'specified'
    {4, V1} -> 
        {specified, decode_octet_string(V1, [])};


%% 'otherSource'
    {16, V1} -> 
        {otherSource, 'dec_PBKDF2-SaltSourcesAlgorithmIdentifier'(V1, [])};

      Else -> 
         exit({error,{asn1,{invalid_choice_tag,Else}}})
   end
.
'id-alg-ESDH'() ->
{1,2,840,113549,1,9,16,3,5}.

'id-alg-SSDH'() ->
{1,2,840,113549,1,9,16,3,10}.

'id-alg-CMS3DESwrap'() ->
{1,2,840,113549,1,9,16,3,6}.

'id-alg-CMSRC2wrap'() ->
{1,2,840,113549,1,9,16,3,7}.

'des-ede3-cbc'() ->
{1,2,840,113549,3,7}.

'rc2-cbc'() ->
{1,2,840,113549,3,2}.

'hMAC-SHA1'() ->
{1,3,6,1,5,5,8,1,2}.

'id-PBKDF2'() ->
{1,2,840,113549,1,5,12}.

defaultPBKDF2() ->
{'PBKDF2-PRFsAlgorithmIdentifier',{1,3,6,1,5,5,8,1,2},'NULL'}.

'dh-public-number'() ->
{1,2,840,10046,2,1}.




%%================================
%%  maca-hMAC-SHA1
%%================================
'enc_maca-hMAC-SHA1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_maca-hMAC-SHA1'(smimeCaps,  Val, [H|T]) ->
   'enc_maca-hMAC-SHA1_smimeCaps'(H, Val, T).


'dec_maca-hMAC-SHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_maca-hMAC-SHA1'(smimeCaps, Bytes,[H|T]) ->
   'dec_maca-hMAC-SHA1_smimeCaps'(H, Bytes, T).

tlv_format(Bytes) when is_binary(Bytes) ->
  {Tlv,_} = ber_decode_nif(Bytes),
  Tlv;
tlv_format(Bytes) ->
  Bytes.



%%================================
%%  alg-hMAC-SHA1
%%================================
'enc_alg-hMAC-SHA1'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_alg-hMAC-SHA1'(smimeCaps, _,_) ->
  exit({error,{'use of missing field in object', smimeCaps}}).


'dec_alg-hMAC-SHA1'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_alg-hMAC-SHA1'(smimeCaps, _,_) ->
  exit({error,{'illegal use of missing field in object', smimeCaps}}).




%%================================
%%  kaa-esdh
%%================================
'enc_kaa-esdh'('Params', Val, _RestPrimFieldName) ->
   enc_KeyWrapAlgorithm(Val, [<<48>>]);
'enc_kaa-esdh'('Ukm', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-esdh'(smimeCaps,  Val, [H|T]) ->
   'enc_kaa-esdh_smimeCaps'(H, Val, T).


'dec_kaa-esdh'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyWrapAlgorithm(Tlv, [16]);
'dec_kaa-esdh'('Ukm',  Bytes,_) ->
   Bytes;
'dec_kaa-esdh'(smimeCaps, Bytes,[H|T]) ->
   'dec_kaa-esdh_smimeCaps'(H, Bytes, T).




%%================================
%%  kaa-ssdh
%%================================
'enc_kaa-ssdh'('Params', Val, _RestPrimFieldName) ->
   enc_KeyWrapAlgorithm(Val, [<<48>>]);
'enc_kaa-ssdh'('Ukm', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_kaa-ssdh'(smimeCaps,  Val, [H|T]) ->
   'enc_kaa-ssdh_smimeCaps'(H, Val, T).


'dec_kaa-ssdh'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyWrapAlgorithm(Tlv, [16]);
'dec_kaa-ssdh'('Ukm',  Bytes,_) ->
   Bytes;
'dec_kaa-ssdh'(smimeCaps, Bytes,[H|T]) ->
   'dec_kaa-ssdh_smimeCaps'(H, Bytes, T).




%%================================
%%  pk-originator-dh
%%================================
'enc_pk-originator-dh'('KeyValue', Val, _RestPrimFieldName) ->
   'PKIXAlgs-2009':enc_DHPublicKey(Val, [<<2>>]);
'enc_pk-originator-dh'('Params', Val, _RestPrimFieldName) ->
   {Val,0};
'enc_pk-originator-dh'('PrivateKey', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_pk-originator-dh'('KeyValue', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'PKIXAlgs-2009':dec_DHPublicKey(Tlv, [2]);
'dec_pk-originator-dh'('Params',  Bytes,_) ->
   Bytes;
'dec_pk-originator-dh'('PrivateKey',  Bytes,_) ->
   Bytes.




%%================================
%%  kwa-3DESWrap
%%================================
'enc_kwa-3DESWrap'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_kwa-3DESWrap'(smimeCaps,  Val, [H|T]) ->
   'enc_kwa-3DESWrap_smimeCaps'(H, Val, T).


'dec_kwa-3DESWrap'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_kwa-3DESWrap'(smimeCaps, Bytes,[H|T]) ->
   'dec_kwa-3DESWrap_smimeCaps'(H, Bytes, T).




%%================================
%%  kwa-RC2Wrap
%%================================
'enc_kwa-RC2Wrap'('Params', Val, _RestPrimFieldName) ->
   enc_RC2wrapParameter(Val, [<<2>>]);
'enc_kwa-RC2Wrap'(smimeCaps,  Val, [H|T]) ->
   'enc_kwa-RC2Wrap_smimeCaps'(H, Val, T).


'dec_kwa-RC2Wrap'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RC2wrapParameter(Tlv, [2]);
'dec_kwa-RC2Wrap'(smimeCaps, Bytes,[H|T]) ->
   'dec_kwa-RC2Wrap_smimeCaps'(H, Bytes, T).




%%================================
%%  kda-PBKDF2
%%================================
'enc_kda-PBKDF2'('Params', Val, _RestPrimFieldName) ->
   'enc_PBKDF2-params'(Val, [<<48>>]);
'enc_kda-PBKDF2'(smimeCaps, _,_) ->
  exit({error,{'use of missing field in object', smimeCaps}}).


'dec_kda-PBKDF2'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   'dec_PBKDF2-params'(Tlv, [16]);
'dec_kda-PBKDF2'(smimeCaps, _,_) ->
  exit({error,{'illegal use of missing field in object', smimeCaps}}).




%%================================
%%  cea-3DES-cbc
%%================================
'enc_cea-3DES-cbc'('Params', Val, _RestPrimFieldName) ->
   enc_IV(Val, [<<4>>]);
'enc_cea-3DES-cbc'(smimeCaps,  Val, [H|T]) ->
   'enc_cea-3DES-cbc_smimeCaps'(H, Val, T).


'dec_cea-3DES-cbc'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_IV(Tlv, [4]);
'dec_cea-3DES-cbc'(smimeCaps, Bytes,[H|T]) ->
   'dec_cea-3DES-cbc_smimeCaps'(H, Bytes, T).




%%================================
%%  cea-RC2-cbc
%%================================
'enc_cea-RC2-cbc'('Params', Val, _RestPrimFieldName) ->
   enc_RC2CBCParameter(Val, [<<48>>]);
'enc_cea-RC2-cbc'(smimeCaps,  Val, [H|T]) ->
   'SecureMimeMessageV3dot1-2009':'enc_cap-RC2CBC'(H, Val, T).


'dec_cea-RC2-cbc'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_RC2CBCParameter(Tlv, [16]);
'dec_cea-RC2-cbc'(smimeCaps, Bytes,[H|T]) ->
   'SecureMimeMessageV3dot1-2009':'dec_cap-RC2CBC'(H, Bytes, T).




%%================================
%%  kt-rsa
%%================================
'enc_kt-rsa'('Params', Val, _RestPrimFieldName) ->
encode_null(Val, [<<5>>]);
'enc_kt-rsa'(smimeCaps,  Val, [H|T]) ->
   'enc_kt-rsa_smimeCaps'(H, Val, T).


'dec_kt-rsa'('Params', Bytes,_) ->
  Tlv = tlv_format(Bytes),
decode_null(Tlv, [5]);
'dec_kt-rsa'(smimeCaps, Bytes,[H|T]) ->
   'dec_kt-rsa_smimeCaps'(H, Bytes, T).




%%================================
%%  cap-3DESwrap
%%================================
'enc_cap-3DESwrap'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cap-3DESwrap'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kwa-3DESWrap_smimeCaps
%%================================
'enc_kwa-3DESWrap_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kwa-3DESWrap_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kaa-esdh_smimeCaps
%%================================
'enc_kaa-esdh_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   enc_KeyWrapAlgorithm(Val, [<<48>>]).


'dec_kaa-esdh_smimeCaps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyWrapAlgorithm(Tlv, [16]).




%%================================
%%  kwa-RC2Wrap_smimeCaps
%%================================
'enc_kwa-RC2Wrap_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kwa-RC2Wrap_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  cea-3DES-cbc_smimeCaps
%%================================
'enc_cea-3DES-cbc_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_cea-3DES-cbc_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kt-rsa_smimeCaps
%%================================
'enc_kt-rsa_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_kt-rsa_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  maca-hMAC-SHA1_smimeCaps
%%================================
'enc_maca-hMAC-SHA1_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


'dec_maca-hMAC-SHA1_smimeCaps'('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  kaa-ssdh_smimeCaps
%%================================
'enc_kaa-ssdh_smimeCaps'('Type', Val, _RestPrimFieldName) ->
   enc_KeyWrapAlgorithm(Val, [<<48>>]).


'dec_kaa-ssdh_smimeCaps'('Type', Bytes,_) ->
  Tlv = tlv_format(Bytes),
   dec_KeyWrapAlgorithm(Tlv, [16]).




%%================================
%%  KeyWrapAlgorithm_smimeCaps
%%================================
enc_KeyWrapAlgorithm_smimeCaps('Type', Val, _RestPrimFieldName) ->
   {Val,0}.


dec_KeyWrapAlgorithm_smimeCaps('Type',  Bytes,_) ->
   Bytes.




%%================================
%%  MessageDigestAlgs
%%================================
getenc_MessageDigestAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_MessageDigestAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SignatureAlgs
%%================================
getenc_SignatureAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_SignatureAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyAgreementAlgs
%%================================
getenc_KeyAgreementAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
    fun 'enc_kaa-esdh'/3;
getenc_KeyAgreementAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
    fun 'enc_kaa-ssdh'/3;
getenc_KeyAgreementAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyAgreementAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,5} ->
    fun 'dec_kaa-esdh'/3;
getdec_KeyAgreementAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,10} ->
    fun 'dec_kaa-ssdh'/3;
getdec_KeyAgreementAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyAgreePublicKeys
%%================================
getenc_KeyAgreePublicKeys(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'enc_pk-dh'(T,V,O) end;
getenc_KeyAgreePublicKeys(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyAgreePublicKeys(Id) when Id =:= {1,2,840,10046,2,1} ->
   fun(T,V,O) -> 'PKIXAlgs-2009':'dec_pk-dh'(T,V,O) end;
getdec_KeyAgreePublicKeys(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyTransportAlgs
%%================================
getenc_KeyTransportAlgs(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'enc_kt-rsa'/3;
getenc_KeyTransportAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyTransportAlgs(Id) when Id =:= {1,2,840,113549,1,1,1} ->
    fun 'dec_kt-rsa'/3;
getdec_KeyTransportAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyWrapAlgs
%%================================
getenc_KeyWrapAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
    fun 'enc_kwa-3DESWrap'/3;
getenc_KeyWrapAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
    fun 'enc_kwa-RC2Wrap'/3;
getenc_KeyWrapAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyWrapAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
    fun 'dec_kwa-3DESWrap'/3;
getdec_KeyWrapAlgs(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
    fun 'dec_kwa-RC2Wrap'/3;
getdec_KeyWrapAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  KeyDerivationAlgs
%%================================
getenc_KeyDerivationAlgs(Id) when Id =:= {1,2,840,113549,1,5,12} ->
    fun 'enc_kda-PBKDF2'/3;
getenc_KeyDerivationAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_KeyDerivationAlgs(Id) when Id =:= {1,2,840,113549,1,5,12} ->
    fun 'dec_kda-PBKDF2'/3;
getdec_KeyDerivationAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  ContentEncryptionAlgs
%%================================
getenc_ContentEncryptionAlgs(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'enc_cea-RC2-cbc'/3;
getenc_ContentEncryptionAlgs(Id) when Id =:= {1,2,840,113549,3,7} ->
    fun 'enc_cea-3DES-cbc'/3;
getenc_ContentEncryptionAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_ContentEncryptionAlgs(Id) when Id =:= {1,2,840,113549,3,2} ->
    fun 'dec_cea-RC2-cbc'/3;
getdec_ContentEncryptionAlgs(Id) when Id =:= {1,2,840,113549,3,7} ->
    fun 'dec_cea-3DES-cbc'/3;
getdec_ContentEncryptionAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  MessageAuthAlgs
%%================================
getenc_MessageAuthAlgs(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'enc_maca-hMAC-SHA1'/3;
getenc_MessageAuthAlgs(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_MessageAuthAlgs(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'dec_maca-hMAC-SHA1'/3;
getdec_MessageAuthAlgs(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  SMimeCaps
%%================================
getenc_SMimeCaps({1,2,840,113549,3,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'SecureMimeMessageV3dot1-2009':'enc_SMIMECapabilitiesParametersForRC2CBC'(Val, [<<2>>])
      end
   end;
getenc_SMimeCaps({1,2,840,113549,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,1,1}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_KeyWrapAlgorithm'(Val)
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'enc_KeyWrapAlgorithm'(Val)
      end
   end;
getenc_SMimeCaps({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Val, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Val of
             {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
               {Bin,byte_size(Bin)}
           end
      end
   end;
getenc_SMimeCaps(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_SMimeCaps'({1,2,840,113549,3,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'SecureMimeMessageV3dot1-2009':'dec_SMIMECapabilitiesParametersForRC2CBC'(Bytes, [2])
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,1,1}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,9,16,3,5}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_KeyWrapAlgorithm'(Bytes)
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,9,16,3,6}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,9,16,3,7}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
'getdec_SMimeCaps'({1,2,840,113549,1,9,16,3,10}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
            'dec_KeyWrapAlgorithm'(Bytes)
      end
   end;
'getdec_SMimeCaps'({1,3,6,1,5,5,8,1,2}) ->
   fun(Type, Bytes, _RestPrimFieldName) ->
      case Type of
         'Type' ->
           case Bytes of
             Bin when is_binary(Bin) -> 
               {asn1_OPENTYPE,Bin};
             _ ->
               {asn1_OPENTYPE,ber_encode(Bytes)}
           end
      end
   end;
getdec_SMimeCaps(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBKDF2-PRFs
%%================================
'getenc_PBKDF2-PRFs'(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'enc_alg-hMAC-SHA1'/3;
'getenc_PBKDF2-PRFs'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBKDF2-PRFs'(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'dec_alg-hMAC-SHA1'/3;
'getdec_PBKDF2-PRFs'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  PBKDF2-SaltSources
%%================================
'getenc_PBKDF2-SaltSources'(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

'getdec_PBKDF2-SaltSources'(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_6
%%================================
getenc_internal_object_set_argument_6(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_6(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_4
%%================================
getenc_internal_object_set_argument_4(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'enc_alg-hMAC-SHA1'/3;
getenc_internal_object_set_argument_4(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_4(Id) when Id =:= {1,3,6,1,5,5,8,1,2} ->
    fun 'dec_alg-hMAC-SHA1'/3;
getdec_internal_object_set_argument_4(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.





%%================================
%%  internal_object_set_argument_2
%%================================
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
    fun 'enc_kwa-3DESWrap'/3;
getenc_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
    fun 'enc_kwa-RC2Wrap'/3;
getenc_internal_object_set_argument_2(_) ->
  fun(_, Val, _RestPrimFieldName) ->
    case Val of
      {asn1_OPENTYPE,Bin} when is_binary(Bin) ->
        {Bin,byte_size(Bin)}
    end
  end.

getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,3,6} ->
    fun 'dec_kwa-3DESWrap'/3;
getdec_internal_object_set_argument_2(Id) when Id =:= {1,2,840,113549,1,9,16,3,7} ->
    fun 'dec_kwa-RC2Wrap'/3;
getdec_internal_object_set_argument_2(_) ->
  fun(_,Bytes, _RestPrimFieldName) ->
    case Bytes of
      Bin when is_binary(Bin) -> 
        {asn1_OPENTYPE,Bin};
      _ ->
        {asn1_OPENTYPE,ber_encode(Bytes)}
    end
  end.



%%%
%%% Run-time functions.
%%%

'dialyzer-suppressions'(Arg) ->
    ok.

is_default_1(asn1_DEFAULT) ->
true;
is_default_1(Value) ->
try is_default_cs_2(Value) of
_ -> true
catch throw:false -> false
end.


is_default_cs_2(Value) ->
case Value of
{'PBKDF2-PRFsAlgorithmIdentifier',
E1,
'NULL'} ->
check_objectidentifier(E1, {[[1,iso],[3,'identified-organization']],[6,1,5,5,8,1,2]});
_ ->
throw(false)
end.

ber_decode_nif(B) ->
    asn1rt_nif:decode_ber_tlv(B).

ber_encode([Tlv]) ->
    ber_encode(Tlv);
ber_encode(Tlv) when is_binary(Tlv) ->
    Tlv;
ber_encode(Tlv) ->
    asn1rt_nif:encode_ber_tlv(Tlv).

check_objectidentifier(Value, {Prefix, Tail}) when is_tuple(Value) ->
    check_oid(tuple_to_list(Value), Prefix, Tail);
check_objectidentifier(_, _) ->
    throw(false).

check_oid([H | T], [K | Ks], Tail) ->
    case lists:member(H, K) of
        false ->
            throw(false);
        true ->
            check_oid(T, Ks, Tail)
    end;
check_oid(Tail, [], Tail) ->
    true;
check_oid(_, _, _) ->
    throw(false).

collect_parts(TlvList) ->
    collect_parts(TlvList, []).

collect_parts([{_, L} | Rest], Acc) when is_list(L) ->
    collect_parts(Rest, [collect_parts(L) | Acc]);
collect_parts([{3, <<Unused,Bits/binary>>} | Rest], _Acc) ->
    collect_parts_bit(Rest, [Bits], Unused);
collect_parts([{_T, V} | Rest], Acc) ->
    collect_parts(Rest, [V | Acc]);
collect_parts([], Acc) ->
    list_to_binary(lists:reverse(Acc)).

collect_parts_bit([{3, <<Unused,Bits/binary>>} | Rest], Acc, Uacc) ->
    collect_parts_bit(Rest, [Bits | Acc], Unused + Uacc);
collect_parts_bit([], Acc, Uacc) ->
    list_to_binary([Uacc | lists:reverse(Acc)]).

dec_subidentifiers(<<>>, _Av, Al) ->
    lists:reverse(Al);
dec_subidentifiers(<<1:1,H:7,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, Av bsl 7 + H, Al);
dec_subidentifiers(<<H,T/binary>>, Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 + H | Al]).

decode_integer(Tlv, TagIn) ->
    Bin = match_tags(Tlv, TagIn),
    Len = byte_size(Bin),
    <<Int:Len/signed-unit:8>> = Bin,
    Int.

decode_null(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    case Val of
        <<>> ->
            'NULL';
        _ ->
            exit({error, {asn1, {decode_null, Val}}})
    end.

decode_object_identifier(Tlv, Tags) ->
    Val = match_tags(Tlv, Tags),
    [AddedObjVal | ObjVals] = dec_subidentifiers(Val, 0, []),
    {Val1, Val2} =
        if
            AddedObjVal < 40 ->
                {0, AddedObjVal};
            AddedObjVal < 80 ->
                {1, AddedObjVal - 40};
            true ->
                {2, AddedObjVal - 80}
        end,
    list_to_tuple([Val1, Val2 | ObjVals]).

decode_octet_string(Tlv, TagsIn) ->
    Bin = match_and_collect(Tlv, TagsIn),
    binary:copy(Bin).

decode_open_type(Tlv, TagIn) ->
    case match_tags(Tlv, TagIn) of
        Bin when is_binary(Bin) ->
            {InnerTlv, _} = ber_decode_nif(Bin),
            InnerTlv;
        TlvBytes ->
            TlvBytes
    end.

e_object_identifier({'OBJECT IDENTIFIER', V}) ->
    e_object_identifier(V);
e_object_identifier(V) when is_tuple(V) ->
    e_object_identifier(tuple_to_list(V));
e_object_identifier([E1, E2 | Tail]) ->
    Head = 40 * E1 + E2,
    {H, Lh} = mk_object_val(Head),
    {R, Lr} = lists:mapfoldl(fun enc_obj_id_tail/2, 0, Tail),
    {[H | R], Lh + Lr}.

enc_obj_id_tail(H, Len) ->
    {B, L} = mk_object_val(H),
    {B, Len + L}.

encode_integer(Val) ->
    Bytes =
        if
            Val >= 0 ->
                encode_integer_pos(Val, []);
            true ->
                encode_integer_neg(Val, [])
        end,
    {Bytes, length(Bytes)}.

encode_integer(Val, Tag) when is_integer(Val) ->
    encode_tags(Tag, encode_integer(Val));
encode_integer(Val, _Tag) ->
    exit({error, {asn1, {encode_integer, Val}}}).

encode_integer_neg(-1, [B1 | _T] = L) when B1 > 127 ->
    L;
encode_integer_neg(N, Acc) ->
    encode_integer_neg(N bsr 8, [N band 255 | Acc]).

encode_integer_pos(0, [B | _Acc] = L) when B < 128 ->
    L;
encode_integer_pos(N, Acc) ->
    encode_integer_pos(N bsr 8, [N band 255 | Acc]).

encode_length(L) when L =< 127 ->
    {[L], 1};
encode_length(L) ->
    Oct = minimum_octets(L),
    Len = length(Oct),
    if
        Len =< 126 ->
            {[128 bor Len | Oct], Len + 1};
        true ->
            exit({error, {asn1, too_long_length_oct, Len}})
    end.

encode_null(_Val, TagIn) ->
    encode_tags(TagIn, [], 0).

encode_object_identifier(Val, TagIn) ->
    encode_tags(TagIn, e_object_identifier(Val)).

encode_open_type(Val, T) when is_list(Val) ->
    encode_open_type(list_to_binary(Val), T);
encode_open_type(Val, Tag) ->
    encode_tags(Tag, Val, byte_size(Val)).

encode_restricted_string(OctetList, TagIn) when is_binary(OctetList) ->
    encode_tags(TagIn, OctetList, byte_size(OctetList));
encode_restricted_string(OctetList, TagIn) when is_list(OctetList) ->
    encode_tags(TagIn, OctetList, length(OctetList)).

encode_tags(TagIn, {BytesSoFar, LenSoFar}) ->
    encode_tags(TagIn, BytesSoFar, LenSoFar).

encode_tags([Tag | Trest], BytesSoFar, LenSoFar) ->
    {Bytes2, L2} = encode_length(LenSoFar),
    encode_tags(Trest,
                [Tag, Bytes2 | BytesSoFar],
                LenSoFar + byte_size(Tag) + L2);
encode_tags([], BytesSoFar, LenSoFar) ->
    {BytesSoFar, LenSoFar}.

match_and_collect(Tlv, TagsIn) ->
    Val = match_tags(Tlv, TagsIn),
    case Val of
        [_ | _] = PartList ->
            collect_parts(PartList);
        Bin when is_binary(Bin) ->
            Bin
    end.

match_tags({T, V}, [T]) ->
    V;
match_tags({T, V}, [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, V}], [T | Tt]) ->
    match_tags(V, Tt);
match_tags([{T, _V} | _] = Vlist, [T]) ->
    Vlist;
match_tags(Tlv, []) ->
    Tlv;
match_tags({Tag, _V} = Tlv, [T | _Tt]) ->
    exit({error, {asn1, {wrong_tag, {{expected, T}, {got, Tag, Tlv}}}}}).

minimum_octets(0, Acc) ->
    Acc;
minimum_octets(Val, Acc) ->
    minimum_octets(Val bsr 8, [Val band 255 | Acc]).

minimum_octets(Val) ->
    minimum_octets(Val, []).

mk_object_val(0, Ack, Len) ->
    {Ack, Len};
mk_object_val(Val, Ack, Len) ->
    mk_object_val(Val bsr 7, [Val band 127 bor 128 | Ack], Len + 1).

mk_object_val(Val) when Val =< 127 ->
    {[255 band Val], 1};
mk_object_val(Val) ->
    mk_object_val(Val bsr 7, [Val band 127], 1).
