/**
 * @license
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: Apache-2.0
 */
import { type ExtensionUpdateAction, ExtensionUpdateState, type ExtensionUpdateStatus } from '../../ui/state/extensions.js';
import { type GeminiCLIExtension } from '@google/gemini-cli-core';
import { type ExtensionEnablementManager } from './extensionEnablement.js';
export interface ExtensionUpdateInfo {
    name: string;
    originalVersion: string;
    updatedVersion: string;
}
export declare function updateExtension(extension: GeminiCLIExtension, extensionEnablementManager: ExtensionEnablementManager, cwd: string | undefined, requestConsent: (consent: string) => Promise<boolean>, currentState: ExtensionUpdateState, dispatchExtensionStateUpdate: (action: ExtensionUpdateAction) => void): Promise<ExtensionUpdateInfo | undefined>;
export declare function updateAllUpdatableExtensions(cwd: string | undefined, requestConsent: (consent: string) => Promise<boolean>, extensions: GeminiCLIExtension[], extensionsState: Map<string, ExtensionUpdateStatus>, extensionEnablementManager: ExtensionEnablementManager, dispatch: (action: ExtensionUpdateAction) => void): Promise<ExtensionUpdateInfo[]>;
export interface ExtensionUpdateCheckResult {
    state: ExtensionUpdateState;
    error?: string;
}
export declare function checkForAllExtensionUpdates(extensions: GeminiCLIExtension[], extensionEnablementManager: ExtensionEnablementManager, dispatch: (action: ExtensionUpdateAction) => void, cwd?: string): Promise<void>;
