import { z, ZodTypeAny } from 'zod';
import { AuthInfo } from './server/auth/types.js';
export declare const LATEST_PROTOCOL_VERSION = "2025-06-18";
export declare const DEFAULT_NEGOTIATED_PROTOCOL_VERSION = "2025-03-26";
export declare const SUPPORTED_PROTOCOL_VERSIONS: string[];
export declare const JSONRPC_VERSION = "2.0";
/**
 * Utility types
 */
type ExpandRecursively<T> = T extends object ? (T extends infer O ? {
    [K in keyof O]: ExpandRecursively<O[K]>;
} : never) : T;
/**
 * A progress token, used to associate progress notifications with the original request.
 */
export declare const ProgressTokenSchema: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
/**
 * An opaque token used to represent a cursor for pagination.
 */
export declare const CursorSchema: z.ZodString;
declare const RequestMetaSchema: z.ZodObject<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
     */
    progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * Common params for any request.
 */
declare const BaseRequestParamsSchema: z.ZodObject<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const RequestSchema: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    method: string;
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
declare const NotificationsParamsSchema: z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    _meta?: Record<string, unknown> | undefined;
}, {
    _meta?: Record<string, unknown> | undefined;
}>;
export declare const NotificationSchema: z.ZodObject<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, "strip", z.ZodTypeAny, {
    method: string;
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const ResultSchema: z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, z.ZodTypeAny, "passthrough">>;
/**
 * A uniquely identifying ID for a request in JSON-RPC.
 */
export declare const RequestIdSchema: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
/**
 * A request that expects a response.
 */
export declare const JSONRPCRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isJSONRPCRequest: (value: unknown) => value is JSONRPCRequest;
/**
 * A notification which does not expect a response.
 */
export declare const JSONRPCNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isJSONRPCNotification: (value: unknown) => value is JSONRPCNotification;
/**
 * A successful (non-error) response to a request.
 */
export declare const JSONRPCResponseSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    result: z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: Record<string, unknown> | undefined;
    } & {
        [k: string]: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: Record<string, unknown> | undefined;
    } & {
        [k: string]: unknown;
    };
}>;
export declare const isJSONRPCResponse: (value: unknown) => value is JSONRPCResponse;
/**
 * Error codes defined by the JSON-RPC specification.
 */
export declare enum ErrorCode {
    ConnectionClosed = -32000,
    RequestTimeout = -32001,
    ParseError = -32700,
    InvalidRequest = -32600,
    MethodNotFound = -32601,
    InvalidParams = -32602,
    InternalError = -32603
}
/**
 * A response to a request that indicates an error occurred.
 */
export declare const JSONRPCErrorSchema: z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    error: z.ZodObject<{
        /**
         * The error type that occurred.
         */
        code: z.ZodNumber;
        /**
         * A short description of the error. The message SHOULD be limited to a concise single sentence.
         */
        message: z.ZodString;
        /**
         * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
         */
        data: z.ZodOptional<z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message: string;
        data?: unknown;
    }, {
        code: number;
        message: string;
        data?: unknown;
    }>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}>;
export declare const isJSONRPCError: (value: unknown) => value is JSONRPCError;
export declare const JSONRPCMessageSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    id: string | number;
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    jsonrpc: z.ZodLiteral<"2.0">;
}, {
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}>, "strict", z.ZodTypeAny, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: string;
    jsonrpc: "2.0";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    result: z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: Record<string, unknown> | undefined;
    } & {
        [k: string]: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    result: {
        _meta?: Record<string, unknown> | undefined;
    } & {
        [k: string]: unknown;
    };
}>, z.ZodObject<{
    jsonrpc: z.ZodLiteral<"2.0">;
    id: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    error: z.ZodObject<{
        /**
         * The error type that occurred.
         */
        code: z.ZodNumber;
        /**
         * A short description of the error. The message SHOULD be limited to a concise single sentence.
         */
        message: z.ZodString;
        /**
         * Additional information about the error. The value of this member is defined by the sender (e.g. detailed error information, nested errors etc.).
         */
        data: z.ZodOptional<z.ZodUnknown>;
    }, "strip", z.ZodTypeAny, {
        code: number;
        message: string;
        data?: unknown;
    }, {
        code: number;
        message: string;
        data?: unknown;
    }>;
}, "strict", z.ZodTypeAny, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}, {
    jsonrpc: "2.0";
    id: string | number;
    error: {
        code: number;
        message: string;
        data?: unknown;
    };
}>]>;
/**
 * A response that indicates success but carries no data.
 */
export declare const EmptyResultSchema: z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strict", z.ZodTypeAny, {
    _meta?: Record<string, unknown> | undefined;
}, {
    _meta?: Record<string, unknown> | undefined;
}>;
export declare const CancelledNotificationParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The ID of the request to cancel.
     *
     * This MUST correspond to the ID of a request previously issued in the same direction.
     */
    requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    /**
     * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
     */
    reason: z.ZodOptional<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    requestId: string | number;
    _meta?: Record<string, unknown> | undefined;
    reason?: string | undefined;
}, {
    requestId: string | number;
    _meta?: Record<string, unknown> | undefined;
    reason?: string | undefined;
}>;
/**
 * This notification can be sent by either side to indicate that it is cancelling a previously-issued request.
 *
 * The request SHOULD still be in-flight, but due to communication latency, it is always possible that this notification MAY arrive after the request has already finished.
 *
 * This notification indicates that the result will be unused, so any associated processing SHOULD cease.
 *
 * A client MUST NOT attempt to cancel its `initialize` request.
 */
export declare const CancelledNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/cancelled">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}>;
/**
 * Icon schema for use in tools, prompts, resources, and implementations.
 */
export declare const IconSchema: z.ZodObject<{
    /**
     * URL or data URI for the icon.
     */
    src: z.ZodString;
    /**
     * Optional MIME type for the icon.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * Optional array of strings that specify sizes at which the icon can be used.
     * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
     *
     * If not provided, the client should assume that the icon can be used at any size.
     */
    sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    src: string;
    mimeType?: string | undefined;
    sizes?: string[] | undefined;
}, {
    src: string;
    mimeType?: string | undefined;
    sizes?: string[] | undefined;
}>;
/**
 * Base schema to add `icons` property.
 *
 */
export declare const IconsSchema: z.ZodObject<{
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}, "strip", z.ZodTypeAny, {
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
}, {
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
}>;
/**
 * Base metadata interface for common properties across resources, tools, prompts, and implementations.
 */
export declare const BaseMetadataSchema: z.ZodObject<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name: string;
    title?: string | undefined;
}, {
    name: string;
    title?: string | undefined;
}>;
/**
 * Describes the name and version of an MCP implementation.
 */
export declare const ImplementationSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    version: z.ZodString;
    /**
     * An optional URL of the website for this implementation.
     */
    websiteUrl: z.ZodOptional<z.ZodString>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    version: string;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    websiteUrl?: string | undefined;
}, {
    name: string;
    version: string;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    websiteUrl?: string | undefined;
}>;
/**
 * Capabilities a client may support. Known capabilities are defined here, in this schema, but this is not a closed set: any client can define its own, additional capabilities.
 */
export declare const ClientCapabilitiesSchema: z.ZodObject<{
    /**
     * Experimental, non-standard capabilities that the client supports.
     */
    experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
    /**
     * Present if the client supports sampling from an LLM.
     */
    sampling: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
    /**
     * Present if the client supports eliciting user input.
     */
    elicitation: z.ZodIntersection<z.ZodOptional<z.ZodObject<{
        /**
         * Whether the client should apply defaults to the user input.
         */
        applyDefaults: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        applyDefaults?: boolean | undefined;
    }, {
        applyDefaults?: boolean | undefined;
    }>>, z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
    /**
     * Present if the client supports listing roots.
     */
    roots: z.ZodOptional<z.ZodObject<{
        /**
         * Whether the client supports issuing notifications for changes to the roots list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        listChanged?: boolean | undefined;
    }, {
        listChanged?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    experimental?: Record<string, object> | undefined;
    sampling?: object | undefined;
    elicitation?: ({
        applyDefaults?: boolean | undefined;
    } & Record<string, unknown>) | undefined;
    roots?: {
        listChanged?: boolean | undefined;
    } | undefined;
}, {
    experimental?: Record<string, object> | undefined;
    sampling?: object | undefined;
    elicitation?: ({
        applyDefaults?: boolean | undefined;
    } & Record<string, unknown>) | undefined;
    roots?: {
        listChanged?: boolean | undefined;
    } | undefined;
}>;
export declare const InitializeRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the client supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the client supports sampling from an LLM.
         */
        sampling: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the client supports eliciting user input.
         */
        elicitation: z.ZodIntersection<z.ZodOptional<z.ZodObject<{
            /**
             * Whether the client should apply defaults to the user input.
             */
            applyDefaults: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            applyDefaults?: boolean | undefined;
        }, {
            applyDefaults?: boolean | undefined;
        }>>, z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
        /**
         * Present if the client supports listing roots.
         */
        roots: z.ZodOptional<z.ZodObject<{
            /**
             * Whether the client supports issuing notifications for changes to the roots list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        sampling?: object | undefined;
        elicitation?: ({
            applyDefaults?: boolean | undefined;
        } & Record<string, unknown>) | undefined;
        roots?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        sampling?: object | undefined;
        elicitation?: ({
            applyDefaults?: boolean | undefined;
        } & Record<string, unknown>) | undefined;
        roots?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    protocolVersion: string;
    capabilities: {
        experimental?: Record<string, object> | undefined;
        sampling?: object | undefined;
        elicitation?: ({
            applyDefaults?: boolean | undefined;
        } & Record<string, unknown>) | undefined;
        roots?: {
            listChanged?: boolean | undefined;
        } | undefined;
    };
    clientInfo: {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    };
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    protocolVersion: string;
    capabilities: {
        experimental?: Record<string, object> | undefined;
        sampling?: object | undefined;
        elicitation?: ({
            applyDefaults?: boolean | undefined;
        } & Record<string, unknown>) | undefined;
        roots?: {
            listChanged?: boolean | undefined;
        } | undefined;
    };
    clientInfo: {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    };
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * This request is sent from the client to the server when it first connects, asking it to begin initialization.
 */
export declare const InitializeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"initialize">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
         */
        protocolVersion: z.ZodString;
        capabilities: z.ZodObject<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodIntersection<z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client should apply defaults to the user input.
                 */
                applyDefaults: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                applyDefaults?: boolean | undefined;
            }, {
                applyDefaults?: boolean | undefined;
            }>>, z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                listChanged?: boolean | undefined;
            }, {
                listChanged?: boolean | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        }, {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        }>;
        clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }>, "many">>;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        }, {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        }>;
    }>, "strip", z.ZodTypeAny, {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "initialize";
}, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "initialize";
}>;
export declare const isInitializeRequest: (value: unknown) => value is InitializeRequest;
/**
 * Capabilities that a server may support. Known capabilities are defined here, in this schema, but this is not a closed set: any server can define its own, additional capabilities.
 */
export declare const ServerCapabilitiesSchema: z.ZodObject<{
    /**
     * Experimental, non-standard capabilities that the server supports.
     */
    experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
    /**
     * Present if the server supports sending log messages to the client.
     */
    logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
    /**
     * Present if the server supports sending completions to the client.
     */
    completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
    /**
     * Present if the server offers any prompt templates.
     */
    prompts: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the prompt list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        listChanged?: boolean | undefined;
    }, {
        listChanged?: boolean | undefined;
    }>>;
    /**
     * Present if the server offers any resources to read.
     */
    resources: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports clients subscribing to resource updates.
         */
        subscribe: z.ZodOptional<z.ZodBoolean>;
        /**
         * Whether this server supports issuing notifications for changes to the resource list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        listChanged?: boolean | undefined;
        subscribe?: boolean | undefined;
    }, {
        listChanged?: boolean | undefined;
        subscribe?: boolean | undefined;
    }>>;
    /**
     * Present if the server offers any tools to call.
     */
    tools: z.ZodOptional<z.ZodObject<{
        /**
         * Whether this server supports issuing notifications for changes to the tool list.
         */
        listChanged: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        listChanged?: boolean | undefined;
    }, {
        listChanged?: boolean | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    experimental?: Record<string, object> | undefined;
    logging?: object | undefined;
    completions?: object | undefined;
    prompts?: {
        listChanged?: boolean | undefined;
    } | undefined;
    resources?: {
        listChanged?: boolean | undefined;
        subscribe?: boolean | undefined;
    } | undefined;
    tools?: {
        listChanged?: boolean | undefined;
    } | undefined;
}, {
    experimental?: Record<string, object> | undefined;
    logging?: object | undefined;
    completions?: object | undefined;
    prompts?: {
        listChanged?: boolean | undefined;
    } | undefined;
    resources?: {
        listChanged?: boolean | undefined;
        subscribe?: boolean | undefined;
    } | undefined;
    tools?: {
        listChanged?: boolean | undefined;
    } | undefined;
}>;
/**
 * After receiving an initialize request from the client, the server sends this response.
 */
export declare const InitializeResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * This notification is sent from the client to the server after initialization has finished.
 */
export declare const InitializedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/initialized">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/initialized";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/initialized";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const isInitializedNotification: (value: unknown) => value is InitializedNotification;
/**
 * A ping, issued by either the server or the client, to check that the other party is still alive. The receiver must promptly respond, or else may be disconnected.
 */
export declare const PingRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"ping">;
}>, "strip", z.ZodTypeAny, {
    method: "ping";
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "ping";
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const ProgressSchema: z.ZodObject<{
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: z.ZodNumber;
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: z.ZodOptional<z.ZodNumber>;
    /**
     * An optional message describing the current progress.
     */
    message: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    progress: number;
    message?: string | undefined;
    total?: number | undefined;
}, {
    progress: number;
    message?: string | undefined;
    total?: number | undefined;
}>;
export declare const ProgressNotificationParamsSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The progress thus far. This should increase every time progress is made, even if the total is unknown.
     */
    progress: z.ZodNumber;
    /**
     * Total number of items to process (or total progress required), if known.
     */
    total: z.ZodOptional<z.ZodNumber>;
    /**
     * An optional message describing the current progress.
     */
    message: z.ZodOptional<z.ZodString>;
}>, {
    /**
     * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
     */
    progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
}>, "strip", z.ZodTypeAny, {
    progressToken: string | number;
    progress: number;
    message?: string | undefined;
    _meta?: Record<string, unknown> | undefined;
    total?: number | undefined;
}, {
    progressToken: string | number;
    progress: number;
    message?: string | undefined;
    _meta?: Record<string, unknown> | undefined;
    total?: number | undefined;
}>;
/**
 * An out-of-band notification used to inform the receiver of a progress update for a long-running request.
 *
 * @category notifications/progress
 */
export declare const ProgressNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/progress">;
    params: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, "strip", z.ZodTypeAny, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}>;
export declare const PaginatedRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * An opaque token representing the current pagination position.
     * If provided, the server should return results starting after this cursor.
     */
    cursor: z.ZodOptional<z.ZodString>;
}>, "strip", z.ZodTypeAny, {
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    cursor?: string | undefined;
}, {
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    cursor?: string | undefined;
}>;
export declare const PaginatedRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, "strip", z.ZodTypeAny, {
    method: string;
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: string;
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>;
export declare const PaginatedResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * The contents of a specific resource or sub-resource.
 */
export declare const ResourceContentsSchema: z.ZodObject<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}>;
export declare const TextResourceContentsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
     */
    text: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    text: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}, {
    uri: string;
    text: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}>;
export declare const BlobResourceContentsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A base64-encoded string representing the binary data of the item.
     */
    blob: z.ZodEffects<z.ZodString, string, string>;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    blob: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}, {
    uri: string;
    blob: string;
    _meta?: Record<string, unknown> | undefined;
    mimeType?: string | undefined;
}>;
/**
 * A known resource that the server is capable of reading.
 */
export declare const ResourceSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    uri: string;
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}, {
    name: string;
    uri: string;
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}>;
/**
 * A template description for resources available on the server.
 */
export declare const ResourceTemplateSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * A URI template (according to RFC 6570) that can be used to construct resource URIs.
     */
    uriTemplate: z.ZodString;
    /**
     * A description of what this template is for.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    uriTemplate: string;
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}, {
    name: string;
    uriTemplate: string;
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}>;
/**
 * Sent from the client to request a list of resources the server has.
 */
export declare const ListResourcesRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"resources/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "resources/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>;
/**
 * The server's response to a resources/list request from the client.
 */
export declare const ListResourcesResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resources: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Sent from the client to request a list of resource templates the server has.
 */
export declare const ListResourceTemplatesRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"resources/templates/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/templates/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "resources/templates/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>;
/**
 * The server's response to a resources/templates/list request from the client.
 */
export declare const ListResourceTemplatesResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    resourceTemplates: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A URI template (according to RFC 6570) that can be used to construct resource URIs.
         */
        uriTemplate: z.ZodString;
        /**
         * A description of what this template is for.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type for all resources that match this template. This should only be included if all resources matching this template have the same type.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        name: string;
        uriTemplate: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
export declare const ResourceRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
     *
     * @format uri
     */
    uri: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    uri: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Parameters for a `resources/read` request.
 */
export declare const ReadResourceRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
     *
     * @format uri
     */
    uri: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    uri: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Sent from the client to the server, to read a specific resource URI.
 */
export declare const ReadResourceRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/read">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/read";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/read";
}>;
/**
 * The server's response to a resources/read request from the client.
 */
export declare const ReadResourceResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>]>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>]>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    contents: z.ZodArray<z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>]>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * An optional notification from the server to the client, informing it that the list of resources it can read from has changed. This may be issued by servers without any previous subscription from the client.
 */
export declare const ResourceListChangedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/resources/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/resources/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const SubscribeRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
     *
     * @format uri
     */
    uri: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    uri: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Sent from the client to request resources/updated notifications from the server whenever a particular resource changes.
 */
export declare const SubscribeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/subscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/subscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/subscribe";
}>;
export declare const UnsubscribeRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
     *
     * @format uri
     */
    uri: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    uri: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Sent from the client to request cancellation of resources/updated notifications from the server. This should follow a previous resources/subscribe request.
 */
export declare const UnsubscribeRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/unsubscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/unsubscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/unsubscribe";
}>;
/**
 * Parameters for a `notifications/resources/updated` notification.
 */
export declare const ResourceUpdatedNotificationParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
     */
    uri: z.ZodString;
}>, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
}>;
/**
 * A notification from the server to the client, informing it that a resource has changed and may need to be read again. This should only be sent if the client previously sent a resources/subscribe request.
 */
export declare const ResourceUpdatedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/updated">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    };
    method: "notifications/resources/updated";
}, {
    params: {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    };
    method: "notifications/resources/updated";
}>;
/**
 * Describes an argument that a prompt can accept.
 */
export declare const PromptArgumentSchema: z.ZodObject<{
    /**
     * The name of the argument.
     */
    name: z.ZodString;
    /**
     * A human-readable description of the argument.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * Whether this argument must be provided.
     */
    required: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    name: string;
    description?: string | undefined;
    required?: boolean | undefined;
}, {
    name: string;
    description?: string | undefined;
    required?: boolean | undefined;
}>;
/**
 * A prompt or prompt template that the server offers.
 */
export declare const PromptSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * An optional description of what this prompt provides
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * A list of arguments to use for templating the prompt.
     */
    arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * The name of the argument.
         */
        name: z.ZodString;
        /**
         * A human-readable description of the argument.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * Whether this argument must be provided.
         */
        required: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        description?: string | undefined;
        required?: boolean | undefined;
    }, {
        name: string;
        description?: string | undefined;
        required?: boolean | undefined;
    }>, "many">>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
    arguments?: {
        name: string;
        description?: string | undefined;
        required?: boolean | undefined;
    }[] | undefined;
}, {
    name: string;
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
    arguments?: {
        name: string;
        description?: string | undefined;
        required?: boolean | undefined;
    }[] | undefined;
}>;
/**
 * Sent from the client to request a list of prompts and prompt templates the server has.
 */
export declare const ListPromptsRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"prompts/list">;
}>, "strip", z.ZodTypeAny, {
    method: "prompts/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "prompts/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>;
/**
 * The server's response to a prompts/list request from the client.
 */
export declare const ListPromptsResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    prompts: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * An optional description of what this prompt provides
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A list of arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * The name of the argument.
             */
            name: z.ZodString;
            /**
             * A human-readable description of the argument.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * Whether this argument must be provided.
             */
            required: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }, {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }>, "many">>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        arguments?: {
            name: string;
            description?: string | undefined;
            required?: boolean | undefined;
        }[] | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Parameters for a `prompts/get` request.
 */
export declare const GetPromptRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The name of the prompt or prompt template.
     */
    name: z.ZodString;
    /**
     * Arguments to use for templating the prompt.
     */
    arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    arguments?: Record<string, string> | undefined;
}, {
    name: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    arguments?: Record<string, string> | undefined;
}>;
/**
 * Used by the client to get a prompt provided by the server.
 */
export declare const GetPromptRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"prompts/get">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the prompt or prompt template.
         */
        name: z.ZodString;
        /**
         * Arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    };
    method: "prompts/get";
}, {
    params: {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    };
    method: "prompts/get";
}>;
/**
 * Text provided to or from an LLM.
 */
export declare const TextContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "text";
    text: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "text";
    text: string;
    _meta?: Record<string, unknown> | undefined;
}>;
/**
 * An image provided to or from an LLM.
 */
export declare const ImageContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "image";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "image";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}>;
/**
 * An Audio provided to or from an LLM.
 */
export declare const AudioContentSchema: z.ZodObject<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "audio";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "audio";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}>;
/**
 * The contents of a resource, embedded into a prompt or tool call result.
 */
export declare const EmbeddedResourceSchema: z.ZodObject<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "resource";
    resource: {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    } | {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "resource";
    resource: {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    } | {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
}>;
/**
 * A resource that the server is capable of reading, included in a prompt or tool call result.
 *
 * Note: resource links returned by tools are not guaranteed to appear in the results of `resources/list` requests.
 */
export declare const ResourceLinkSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, "strip", z.ZodTypeAny, {
    type: "resource_link";
    name: string;
    uri: string;
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}, {
    type: "resource_link";
    name: string;
    uri: string;
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}>;
/**
 * A content block that can be used in prompts and tool results.
 */
export declare const ContentBlockSchema: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"text">;
    /**
     * The text content of the message.
     */
    text: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "text";
    text: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "text";
    text: string;
    _meta?: Record<string, unknown> | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"image">;
    /**
     * The base64-encoded image data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the image. Different providers may support different image types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "image";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "image";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"audio">;
    /**
     * The base64-encoded audio data.
     */
    data: z.ZodEffects<z.ZodString, string, string>;
    /**
     * The MIME type of the audio. Different providers may support different audio types.
     */
    mimeType: z.ZodString;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "audio";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "audio";
    data: string;
    mimeType: string;
    _meta?: Record<string, unknown> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * The URI of this resource.
     */
    uri: z.ZodString;
    /**
     * A description of what this resource represents.
     *
     * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * The MIME type of this resource, if known.
     */
    mimeType: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, {
    type: z.ZodLiteral<"resource_link">;
}>, "strip", z.ZodTypeAny, {
    type: "resource_link";
    name: string;
    uri: string;
    _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}, {
    type: "resource_link";
    name: string;
    uri: string;
    _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
    mimeType?: string | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"resource">;
    resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
         */
        text: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<{
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * A base64-encoded string representing the binary data of the item.
         */
        blob: z.ZodEffects<z.ZodString, string, string>;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }, {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    }>]>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    type: "resource";
    resource: {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    } | {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
}, {
    type: "resource";
    resource: {
        uri: string;
        text: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    } | {
        uri: string;
        blob: string;
        _meta?: Record<string, unknown> | undefined;
        mimeType?: string | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
}>]>;
/**
 * Describes a message returned as part of a prompt.
 */
export declare const PromptMessageSchema: z.ZodObject<{
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}, "strip", z.ZodTypeAny, {
    role: "user" | "assistant";
    content: {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    };
}, {
    role: "user" | "assistant";
    content: {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    };
}>;
/**
 * The server's response to a prompts/get request from the client.
 */
export declare const GetPromptResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "strip", z.ZodTypeAny, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }>]>;
    }, "strip", z.ZodTypeAny, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "strip", z.ZodTypeAny, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }>]>;
    }, "strip", z.ZodTypeAny, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
             */
            description: z.ZodOptional<z.ZodString>;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }>, "many">>;
        }>, {
            type: z.ZodLiteral<"resource_link">;
        }>, "strip", z.ZodTypeAny, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }, {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"resource">;
            resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
                 */
                text: z.ZodString;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>, z.ZodObject<z.objectUtil.extendShape<{
                /**
                 * The URI of this resource.
                 */
                uri: z.ZodString;
                /**
                 * The MIME type of this resource, if known.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, {
                /**
                 * A base64-encoded string representing the binary data of the item.
                 */
                blob: z.ZodEffects<z.ZodString, string, string>;
            }>, "strip", z.ZodTypeAny, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }, {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            }>]>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        }>]>;
    }, "strip", z.ZodTypeAny, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource";
            resource: {
                uri: string;
                text: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            } | {
                uri: string;
                blob: string;
                _meta?: Record<string, unknown> | undefined;
                mimeType?: string | undefined;
            };
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "resource_link";
            name: string;
            uri: string;
            _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
            mimeType?: string | undefined;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            description?: string | undefined;
        };
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * An optional notification from the server to the client, informing it that the list of prompts it offers has changed. This may be issued by servers without any previous subscription from the client.
 */
export declare const PromptListChangedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/prompts/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/prompts/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/prompts/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * Additional properties describing a Tool to clients.
 *
 * NOTE: all properties in ToolAnnotations are **hints**.
 * They are not guaranteed to provide a faithful description of
 * tool behavior (including descriptive properties like `title`).
 *
 * Clients should never make tool use decisions based on ToolAnnotations
 * received from untrusted servers.
 */
export declare const ToolAnnotationsSchema: z.ZodObject<{
    /**
     * A human-readable title for the tool.
     */
    title: z.ZodOptional<z.ZodString>;
    /**
     * If true, the tool does not modify its environment.
     *
     * Default: false
     */
    readOnlyHint: z.ZodOptional<z.ZodBoolean>;
    /**
     * If true, the tool may perform destructive updates to its environment.
     * If false, the tool performs only additive updates.
     *
     * (This property is meaningful only when `readOnlyHint == false`)
     *
     * Default: true
     */
    destructiveHint: z.ZodOptional<z.ZodBoolean>;
    /**
     * If true, calling the tool repeatedly with the same arguments
     * will have no additional effect on the its environment.
     *
     * (This property is meaningful only when `readOnlyHint == false`)
     *
     * Default: false
     */
    idempotentHint: z.ZodOptional<z.ZodBoolean>;
    /**
     * If true, this tool may interact with an "open world" of external
     * entities. If false, the tool's domain of interaction is closed.
     * For example, the world of a web search tool is open, whereas that
     * of a memory tool is not.
     *
     * Default: true
     */
    openWorldHint: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    title?: string | undefined;
    readOnlyHint?: boolean | undefined;
    destructiveHint?: boolean | undefined;
    idempotentHint?: boolean | undefined;
    openWorldHint?: boolean | undefined;
}, {
    title?: string | undefined;
    readOnlyHint?: boolean | undefined;
    destructiveHint?: boolean | undefined;
    idempotentHint?: boolean | undefined;
    openWorldHint?: boolean | undefined;
}>;
/**
 * Definition for a tool the client can call.
 */
export declare const ToolSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
    name: z.ZodString;
    /**
     * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
     * even by those unfamiliar with domain-specific terminology.
     *
     * If not provided, the name should be used for display (except for Tool,
     * where `annotations.title` should be given precedence over using `name`,
     * if present).
     */
    title: z.ZodOptional<z.ZodString>;
}, {
    /**
     * A human-readable description of the tool.
     */
    description: z.ZodOptional<z.ZodString>;
    /**
     * A JSON Schema object defining the expected parameters for the tool.
     */
    inputSchema: z.ZodObject<{
        type: z.ZodLiteral<"object">;
        properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
    }, {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
    }>;
    /**
     * An optional JSON Schema object defining the structure of the tool's output returned in
     * the structuredContent field of a CallToolResult.
     */
    outputSchema: z.ZodOptional<z.ZodObject<{
        type: z.ZodLiteral<"object">;
        properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        /**
         * Not in the MCP specification, but added to support the Ajv validator while removing .passthrough() which previously allowed additionalProperties to be passed through.
         */
        additionalProperties: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
        additionalProperties?: boolean | undefined;
    }, {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
        additionalProperties?: boolean | undefined;
    }>>;
    /**
     * Optional additional tool information.
     */
    annotations: z.ZodOptional<z.ZodObject<{
        /**
         * A human-readable title for the tool.
         */
        title: z.ZodOptional<z.ZodString>;
        /**
         * If true, the tool does not modify its environment.
         *
         * Default: false
         */
        readOnlyHint: z.ZodOptional<z.ZodBoolean>;
        /**
         * If true, the tool may perform destructive updates to its environment.
         * If false, the tool performs only additive updates.
         *
         * (This property is meaningful only when `readOnlyHint == false`)
         *
         * Default: true
         */
        destructiveHint: z.ZodOptional<z.ZodBoolean>;
        /**
         * If true, calling the tool repeatedly with the same arguments
         * will have no additional effect on the its environment.
         *
         * (This property is meaningful only when `readOnlyHint == false`)
         *
         * Default: false
         */
        idempotentHint: z.ZodOptional<z.ZodBoolean>;
        /**
         * If true, this tool may interact with an "open world" of external
         * entities. If false, the tool's domain of interaction is closed.
         * For example, the world of a web search tool is open, whereas that
         * of a memory tool is not.
         *
         * Default: true
         */
        openWorldHint: z.ZodOptional<z.ZodBoolean>;
    }, "strip", z.ZodTypeAny, {
        title?: string | undefined;
        readOnlyHint?: boolean | undefined;
        destructiveHint?: boolean | undefined;
        idempotentHint?: boolean | undefined;
        openWorldHint?: boolean | undefined;
    }, {
        title?: string | undefined;
        readOnlyHint?: boolean | undefined;
        destructiveHint?: boolean | undefined;
        idempotentHint?: boolean | undefined;
        openWorldHint?: boolean | undefined;
    }>>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}>, {
    /**
     * Optional set of sized icons that the client can display in a user interface.
     *
     * Clients that support rendering icons MUST support at least the following MIME types:
     * - `image/png` - PNG images (safe, universal compatibility)
     * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
     *
     * Clients that support rendering icons SHOULD also support:
     * - `image/svg+xml` - SVG images (scalable but requires security precautions)
     * - `image/webp` - WebP images (modern, efficient format)
     */
    icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * URL or data URI for the icon.
         */
        src: z.ZodString;
        /**
         * Optional MIME type for the icon.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * Optional array of strings that specify sizes at which the icon can be used.
         * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
         *
         * If not provided, the client should assume that the icon can be used at any size.
         */
        sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }, {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }>, "many">>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    inputSchema: {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
    outputSchema?: {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
        additionalProperties?: boolean | undefined;
    } | undefined;
    annotations?: {
        title?: string | undefined;
        readOnlyHint?: boolean | undefined;
        destructiveHint?: boolean | undefined;
        idempotentHint?: boolean | undefined;
        openWorldHint?: boolean | undefined;
    } | undefined;
}, {
    name: string;
    inputSchema: {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
    };
    _meta?: Record<string, unknown> | undefined;
    icons?: {
        src: string;
        mimeType?: string | undefined;
        sizes?: string[] | undefined;
    }[] | undefined;
    title?: string | undefined;
    description?: string | undefined;
    outputSchema?: {
        type: "object";
        required?: string[] | undefined;
        properties?: Record<string, object> | undefined;
        additionalProperties?: boolean | undefined;
    } | undefined;
    annotations?: {
        title?: string | undefined;
        readOnlyHint?: boolean | undefined;
        destructiveHint?: boolean | undefined;
        idempotentHint?: boolean | undefined;
        openWorldHint?: boolean | undefined;
    } | undefined;
}>;
/**
 * Sent from the client to request a list of tools the server has.
 */
export declare const ListToolsRequestSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"tools/list">;
}>, "strip", z.ZodTypeAny, {
    method: "tools/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "tools/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>;
/**
 * The server's response to a tools/list request from the client.
 */
export declare const ListToolsResultSchema: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    tools: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A human-readable description of the tool.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A JSON Schema object defining the expected parameters for the tool.
         */
        inputSchema: z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }>;
        /**
         * An optional JSON Schema object defining the structure of the tool's output returned in
         * the structuredContent field of a CallToolResult.
         */
        outputSchema: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            /**
             * Not in the MCP specification, but added to support the Ajv validator while removing .passthrough() which previously allowed additionalProperties to be passed through.
             */
            additionalProperties: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }>>;
        /**
         * Optional additional tool information.
         */
        annotations: z.ZodOptional<z.ZodObject<{
            /**
             * A human-readable title for the tool.
             */
            title: z.ZodOptional<z.ZodString>;
            /**
             * If true, the tool does not modify its environment.
             *
             * Default: false
             */
            readOnlyHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, the tool may perform destructive updates to its environment.
             * If false, the tool performs only additive updates.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: true
             */
            destructiveHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, calling the tool repeatedly with the same arguments
             * will have no additional effect on the its environment.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: false
             */
            idempotentHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, this tool may interact with an "open world" of external
             * entities. If false, the tool's domain of interaction is closed.
             * For example, the world of a web search tool is open, whereas that
             * of a memory tool is not.
             *
             * Default: true
             */
            openWorldHint: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }>>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    tools: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A human-readable description of the tool.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A JSON Schema object defining the expected parameters for the tool.
         */
        inputSchema: z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }>;
        /**
         * An optional JSON Schema object defining the structure of the tool's output returned in
         * the structuredContent field of a CallToolResult.
         */
        outputSchema: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            /**
             * Not in the MCP specification, but added to support the Ajv validator while removing .passthrough() which previously allowed additionalProperties to be passed through.
             */
            additionalProperties: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }>>;
        /**
         * Optional additional tool information.
         */
        annotations: z.ZodOptional<z.ZodObject<{
            /**
             * A human-readable title for the tool.
             */
            title: z.ZodOptional<z.ZodString>;
            /**
             * If true, the tool does not modify its environment.
             *
             * Default: false
             */
            readOnlyHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, the tool may perform destructive updates to its environment.
             * If false, the tool performs only additive updates.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: true
             */
            destructiveHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, calling the tool repeatedly with the same arguments
             * will have no additional effect on the its environment.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: false
             */
            idempotentHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, this tool may interact with an "open world" of external
             * entities. If false, the tool's domain of interaction is closed.
             * For example, the world of a web search tool is open, whereas that
             * of a memory tool is not.
             *
             * Default: true
             */
            openWorldHint: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }>>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An opaque token representing the pagination position after the last returned result.
     * If present, there may be more results available.
     */
    nextCursor: z.ZodOptional<z.ZodString>;
}>, {
    tools: z.ZodArray<z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * A human-readable description of the tool.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * A JSON Schema object defining the expected parameters for the tool.
         */
        inputSchema: z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        }>;
        /**
         * An optional JSON Schema object defining the structure of the tool's output returned in
         * the structuredContent field of a CallToolResult.
         */
        outputSchema: z.ZodOptional<z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            /**
             * Not in the MCP specification, but added to support the Ajv validator while removing .passthrough() which previously allowed additionalProperties to be passed through.
             */
            additionalProperties: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }, {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        }>>;
        /**
         * Optional additional tool information.
         */
        annotations: z.ZodOptional<z.ZodObject<{
            /**
             * A human-readable title for the tool.
             */
            title: z.ZodOptional<z.ZodString>;
            /**
             * If true, the tool does not modify its environment.
             *
             * Default: false
             */
            readOnlyHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, the tool may perform destructive updates to its environment.
             * If false, the tool performs only additive updates.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: true
             */
            destructiveHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, calling the tool repeatedly with the same arguments
             * will have no additional effect on the its environment.
             *
             * (This property is meaningful only when `readOnlyHint == false`)
             *
             * Default: false
             */
            idempotentHint: z.ZodOptional<z.ZodBoolean>;
            /**
             * If true, this tool may interact with an "open world" of external
             * entities. If false, the tool's domain of interaction is closed.
             * For example, the world of a web search tool is open, whereas that
             * of a memory tool is not.
             *
             * Default: true
             */
            openWorldHint: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }, {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        }>>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }, {
        name: string;
        inputSchema: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
        outputSchema?: {
            type: "object";
            required?: string[] | undefined;
            properties?: Record<string, object> | undefined;
            additionalProperties?: boolean | undefined;
        } | undefined;
        annotations?: {
            title?: string | undefined;
            readOnlyHint?: boolean | undefined;
            destructiveHint?: boolean | undefined;
            idempotentHint?: boolean | undefined;
            openWorldHint?: boolean | undefined;
        } | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * The server's response to a tool call.
 */
export declare const CallToolResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * CallToolResultSchema extended with backwards compatibility to protocol version 2024-10-07.
 */
export declare const CompatibilityCallToolResultSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * A list of content objects that represent the result of the tool call.
     *
     * If the Tool does not define an outputSchema, this field MUST be present in the result.
     * For backwards compatibility, this field is always present, but it may be empty.
     */
    content: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        /**
         * The URI of this resource.
         */
        uri: z.ZodString;
        /**
         * A description of what this resource represents.
         *
         * This can be used by clients to improve the LLM's understanding of available resources. It can be thought of like a "hint" to the model.
         */
        description: z.ZodOptional<z.ZodString>;
        /**
         * The MIME type of this resource, if known.
         */
        mimeType: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{}, "passthrough", z.ZodTypeAny, z.objectOutputType<{}, z.ZodTypeAny, "passthrough">, z.objectInputType<{}, z.ZodTypeAny, "passthrough">>>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, {
        type: z.ZodLiteral<"resource_link">;
    }>, "strip", z.ZodTypeAny, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectOutputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }, {
        type: "resource_link";
        name: string;
        uri: string;
        _meta?: z.objectInputType<{}, z.ZodTypeAny, "passthrough"> | undefined;
        mimeType?: string | undefined;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        description?: string | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"resource">;
        resource: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * The text of the item. This must only be set if the item can actually be represented as text (not binary data).
             */
            text: z.ZodString;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<{
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * The MIME type of this resource, if known.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, {
            /**
             * A base64-encoded string representing the binary data of the item.
             */
            blob: z.ZodEffects<z.ZodString, string, string>;
        }>, "strip", z.ZodTypeAny, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }, {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        }>]>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "resource";
        resource: {
            uri: string;
            text: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        } | {
            uri: string;
            blob: string;
            _meta?: Record<string, unknown> | undefined;
            mimeType?: string | undefined;
        };
        _meta?: Record<string, unknown> | undefined;
    }>]>, "many">>;
    /**
     * An object containing structured tool output.
     *
     * If the Tool defines an outputSchema, this field MUST be present in the result, and contain a JSON object that matches the schema.
     */
    structuredContent: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    /**
     * Whether the tool call ended in an error.
     *
     * If not set, this is assumed to be false (the call was successful).
     *
     * Any errors that originate from the tool SHOULD be reported inside the result
     * object, with `isError` set to true, _not_ as an MCP protocol-level error
     * response. Otherwise, the LLM would not be able to see that an error occurred
     * and self-correct.
     *
     * However, any errors in _finding_ the tool, an error indicating that the
     * server does not support tool calls, or any other exceptional conditions,
     * should be reported as an MCP error response.
     */
    isError: z.ZodOptional<z.ZodBoolean>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    toolResult: z.ZodUnknown;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    toolResult: z.ZodUnknown;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    toolResult: z.ZodUnknown;
}>, z.ZodTypeAny, "passthrough">>]>;
/**
 * Parameters for a `tools/call` request.
 */
export declare const CallToolRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The name of the tool to call.
     */
    name: z.ZodString;
    /**
     * Arguments to pass to the tool.
     */
    arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}>, "strip", z.ZodTypeAny, {
    name: string;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    arguments?: Record<string, unknown> | undefined;
}, {
    name: string;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    arguments?: Record<string, unknown> | undefined;
}>;
/**
 * Used by the client to invoke a tool provided by the server.
 */
export declare const CallToolRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"tools/call">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the tool to call.
         */
        name: z.ZodString;
        /**
         * Arguments to pass to the tool.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    };
    method: "tools/call";
}, {
    params: {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    };
    method: "tools/call";
}>;
/**
 * An optional notification from the server to the client, informing it that the list of tools it offers has changed. This may be issued by servers without any previous subscription from the client.
 */
export declare const ToolListChangedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/tools/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/tools/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/tools/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * The severity of a log message.
 */
export declare const LoggingLevelSchema: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
/**
 * Parameters for a `logging/setLevel` request.
 */
export declare const SetLevelRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The level of logging that the client wants to receive from the server. The server should send all logs at this level and higher (i.e., more severe) to the client as notifications/logging/message.
     */
    level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
}>, "strip", z.ZodTypeAny, {
    level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * A request from the client to the server, to enable or adjust logging.
 */
export declare const SetLevelRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"logging/setLevel">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The level of logging that the client wants to receive from the server. The server should send all logs at this level and higher (i.e., more severe) to the client as notifications/logging/message.
         */
        level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
    }>, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "logging/setLevel";
}, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "logging/setLevel";
}>;
/**
 * Parameters for a `notifications/message` notification.
 */
export declare const LoggingMessageNotificationParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The severity of this log message.
     */
    level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
    /**
     * An optional name of the logger issuing this message.
     */
    logger: z.ZodOptional<z.ZodString>;
    /**
     * The data to be logged, such as a string message or an object. Any JSON serializable type is allowed here.
     */
    data: z.ZodUnknown;
}>, "strip", z.ZodTypeAny, {
    level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
    _meta?: Record<string, unknown> | undefined;
    data?: unknown;
    logger?: string | undefined;
}, {
    level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
    _meta?: Record<string, unknown> | undefined;
    data?: unknown;
    logger?: string | undefined;
}>;
/**
 * Notification of a log message passed from server to client. If no logging/setLevel request has been sent from the client, the server MAY decide which messages to send automatically.
 */
export declare const LoggingMessageNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/message">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The severity of this log message.
         */
        level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
        /**
         * An optional name of the logger issuing this message.
         */
        logger: z.ZodOptional<z.ZodString>;
        /**
         * The data to be logged, such as a string message or an object. Any JSON serializable type is allowed here.
         */
        data: z.ZodUnknown;
    }>, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    }, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    };
    method: "notifications/message";
}, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    };
    method: "notifications/message";
}>;
/**
 * Hints to use for model selection.
 */
export declare const ModelHintSchema: z.ZodObject<{
    /**
     * A hint for a model name.
     */
    name: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    name?: string | undefined;
}, {
    name?: string | undefined;
}>;
/**
 * The server's preferences for model selection, requested of the client during sampling.
 */
export declare const ModelPreferencesSchema: z.ZodObject<{
    /**
     * Optional hints to use for model selection.
     */
    hints: z.ZodOptional<z.ZodArray<z.ZodObject<{
        /**
         * A hint for a model name.
         */
        name: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        name?: string | undefined;
    }, {
        name?: string | undefined;
    }>, "many">>;
    /**
     * How much to prioritize cost when selecting a model.
     */
    costPriority: z.ZodOptional<z.ZodNumber>;
    /**
     * How much to prioritize sampling speed (latency) when selecting a model.
     */
    speedPriority: z.ZodOptional<z.ZodNumber>;
    /**
     * How much to prioritize intelligence and capabilities when selecting a model.
     */
    intelligencePriority: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    hints?: {
        name?: string | undefined;
    }[] | undefined;
    costPriority?: number | undefined;
    speedPriority?: number | undefined;
    intelligencePriority?: number | undefined;
}, {
    hints?: {
        name?: string | undefined;
    }[] | undefined;
    costPriority?: number | undefined;
    speedPriority?: number | undefined;
    intelligencePriority?: number | undefined;
}>;
/**
 * Describes a message issued to or received from an LLM API.
 */
export declare const SamplingMessageSchema: z.ZodObject<{
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}, "strip", z.ZodTypeAny, {
    role: "user" | "assistant";
    content: {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    };
}, {
    role: "user" | "assistant";
    content: {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    } | {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    };
}>;
/**
 * Parameters for a `sampling/createMessage` request.
 */
export declare const CreateMessageRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>]>;
    }, "strip", z.ZodTypeAny, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        };
    }, {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        };
    }>, "many">;
    /**
     * The server's preferences for which model to select. The client MAY modify or omit this request.
     */
    modelPreferences: z.ZodOptional<z.ZodObject<{
        /**
         * Optional hints to use for model selection.
         */
        hints: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * A hint for a model name.
             */
            name: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            name?: string | undefined;
        }, {
            name?: string | undefined;
        }>, "many">>;
        /**
         * How much to prioritize cost when selecting a model.
         */
        costPriority: z.ZodOptional<z.ZodNumber>;
        /**
         * How much to prioritize sampling speed (latency) when selecting a model.
         */
        speedPriority: z.ZodOptional<z.ZodNumber>;
        /**
         * How much to prioritize intelligence and capabilities when selecting a model.
         */
        intelligencePriority: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        hints?: {
            name?: string | undefined;
        }[] | undefined;
        costPriority?: number | undefined;
        speedPriority?: number | undefined;
        intelligencePriority?: number | undefined;
    }, {
        hints?: {
            name?: string | undefined;
        }[] | undefined;
        costPriority?: number | undefined;
        speedPriority?: number | undefined;
        intelligencePriority?: number | undefined;
    }>>;
    /**
     * An optional system prompt the server wants to use for sampling. The client MAY modify or omit this prompt.
     */
    systemPrompt: z.ZodOptional<z.ZodString>;
    /**
     * A request to include context from one or more MCP servers (including the caller), to be attached to the prompt. The client MAY ignore this request.
     */
    includeContext: z.ZodOptional<z.ZodEnum<["none", "thisServer", "allServers"]>>;
    temperature: z.ZodOptional<z.ZodNumber>;
    /**
     * The requested maximum number of tokens to sample (to prevent runaway completions).
     *
     * The client MAY choose to sample fewer tokens than the requested maximum.
     */
    maxTokens: z.ZodNumber;
    stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    /**
     * Optional metadata to pass through to the LLM provider. The format of this metadata is provider-specific.
     */
    metadata: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
}>, "strip", z.ZodTypeAny, {
    messages: {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        };
    }[];
    maxTokens: number;
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    modelPreferences?: {
        hints?: {
            name?: string | undefined;
        }[] | undefined;
        costPriority?: number | undefined;
        speedPriority?: number | undefined;
        intelligencePriority?: number | undefined;
    } | undefined;
    systemPrompt?: string | undefined;
    includeContext?: "none" | "thisServer" | "allServers" | undefined;
    temperature?: number | undefined;
    stopSequences?: string[] | undefined;
    metadata?: object | undefined;
}, {
    messages: {
        role: "user" | "assistant";
        content: {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        } | {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        };
    }[];
    maxTokens: number;
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    modelPreferences?: {
        hints?: {
            name?: string | undefined;
        }[] | undefined;
        costPriority?: number | undefined;
        speedPriority?: number | undefined;
        intelligencePriority?: number | undefined;
    } | undefined;
    systemPrompt?: string | undefined;
    includeContext?: "none" | "thisServer" | "allServers" | undefined;
    temperature?: number | undefined;
    stopSequences?: string[] | undefined;
    metadata?: object | undefined;
}>;
/**
 * A request from the server to sample an LLM via the client. The client has full discretion over which model to select. The client should also inform the user before beginning sampling, to allow them to inspect the request (human in the loop) and decide whether to approve it.
 */
export declare const CreateMessageRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"sampling/createMessage">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        messages: z.ZodArray<z.ZodObject<{
            role: z.ZodEnum<["user", "assistant"]>;
            content: z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"text">;
                /**
                 * The text content of the message.
                 */
                text: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
                /**
                 * The base64-encoded image data.
                 */
                data: z.ZodEffects<z.ZodString, string, string>;
                /**
                 * The MIME type of the image. Different providers may support different image types.
                 */
                mimeType: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
                /**
                 * The base64-encoded audio data.
                 */
                data: z.ZodEffects<z.ZodString, string, string>;
                /**
                 * The MIME type of the audio. Different providers may support different audio types.
                 */
                mimeType: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }>]>;
        }, "strip", z.ZodTypeAny, {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }, {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }>, "many">;
        /**
         * The server's preferences for which model to select. The client MAY modify or omit this request.
         */
        modelPreferences: z.ZodOptional<z.ZodObject<{
            /**
             * Optional hints to use for model selection.
             */
            hints: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * A hint for a model name.
                 */
                name: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                name?: string | undefined;
            }, {
                name?: string | undefined;
            }>, "many">>;
            /**
             * How much to prioritize cost when selecting a model.
             */
            costPriority: z.ZodOptional<z.ZodNumber>;
            /**
             * How much to prioritize sampling speed (latency) when selecting a model.
             */
            speedPriority: z.ZodOptional<z.ZodNumber>;
            /**
             * How much to prioritize intelligence and capabilities when selecting a model.
             */
            intelligencePriority: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        }, {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        }>>;
        /**
         * An optional system prompt the server wants to use for sampling. The client MAY modify or omit this prompt.
         */
        systemPrompt: z.ZodOptional<z.ZodString>;
        /**
         * A request to include context from one or more MCP servers (including the caller), to be attached to the prompt. The client MAY ignore this request.
         */
        includeContext: z.ZodOptional<z.ZodEnum<["none", "thisServer", "allServers"]>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        /**
         * The requested maximum number of tokens to sample (to prevent runaway completions).
         *
         * The client MAY choose to sample fewer tokens than the requested maximum.
         */
        maxTokens: z.ZodNumber;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        /**
         * Optional metadata to pass through to the LLM provider. The format of this metadata is provider-specific.
         */
        metadata: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
    }>, "strip", z.ZodTypeAny, {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    }, {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    };
    method: "sampling/createMessage";
}, {
    params: {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    };
    method: "sampling/createMessage";
}>;
/**
 * The client's response to a sampling/create_message request from the server. The client should inform the user before returning the sampled message, to allow them to inspect the response (human in the loop) and decide whether to allow the server to see it.
 */
export declare const CreateMessageResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Primitive schema definition for boolean fields.
 */
export declare const BooleanSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    default: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    title?: string | undefined;
    description?: string | undefined;
    default?: boolean | undefined;
}, {
    type: "boolean";
    title?: string | undefined;
    description?: string | undefined;
    default?: boolean | undefined;
}>;
/**
 * Primitive schema definition for string fields.
 */
export declare const StringSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minLength: z.ZodOptional<z.ZodNumber>;
    maxLength: z.ZodOptional<z.ZodNumber>;
    format: z.ZodOptional<z.ZodEnum<["email", "uri", "date", "date-time"]>>;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    title?: string | undefined;
    description?: string | undefined;
    minLength?: number | undefined;
    maxLength?: number | undefined;
    default?: string | undefined;
    format?: "date" | "uri" | "email" | "date-time" | undefined;
}, {
    type: "string";
    title?: string | undefined;
    description?: string | undefined;
    minLength?: number | undefined;
    maxLength?: number | undefined;
    default?: string | undefined;
    format?: "date" | "uri" | "email" | "date-time" | undefined;
}>;
/**
 * Primitive schema definition for number fields.
 */
export declare const NumberSchemaSchema: z.ZodObject<{
    type: z.ZodEnum<["number", "integer"]>;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minimum: z.ZodOptional<z.ZodNumber>;
    maximum: z.ZodOptional<z.ZodNumber>;
    default: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    type: "number" | "integer";
    minimum?: number | undefined;
    maximum?: number | undefined;
    title?: string | undefined;
    description?: string | undefined;
    default?: number | undefined;
}, {
    type: "number" | "integer";
    minimum?: number | undefined;
    maximum?: number | undefined;
    title?: string | undefined;
    description?: string | undefined;
    default?: number | undefined;
}>;
/**
 * Schema for single-selection enumeration without display titles for options.
 */
export declare const UntitledSingleSelectEnumSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>;
/**
 * Schema for single-selection enumeration with display titles for each option.
 */
export declare const TitledSingleSelectEnumSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    oneOf: z.ZodArray<z.ZodObject<{
        const: z.ZodString;
        title: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        title: string;
        const: string;
    }, {
        title: string;
        const: string;
    }>, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>;
/**
 * Use TitledSingleSelectEnumSchema instead.
 * This interface will be removed in a future version.
 */
export declare const LegacyTitledEnumSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}>;
export declare const SingleSelectEnumSchemaSchema: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    oneOf: z.ZodArray<z.ZodObject<{
        const: z.ZodString;
        title: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        title: string;
        const: string;
    }, {
        title: string;
        const: string;
    }>, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>]>;
/**
 * Schema for multiple-selection enumeration without display titles for options.
 */
export declare const UntitledMultiSelectEnumSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        type: z.ZodLiteral<"string">;
        enum: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        enum: string[];
    }, {
        type: "string";
        enum: string[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>;
/**
 * Schema for multiple-selection enumeration with display titles for each option.
 */
export declare const TitledMultiSelectEnumSchemaSchema: z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        anyOf: z.ZodArray<z.ZodObject<{
            const: z.ZodString;
            title: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            title: string;
            const: string;
        }, {
            title: string;
            const: string;
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>;
/**
 * Combined schema for multiple-selection enumeration
 */
export declare const MultiSelectEnumSchemaSchema: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        type: z.ZodLiteral<"string">;
        enum: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        enum: string[];
    }, {
        type: "string";
        enum: string[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        anyOf: z.ZodArray<z.ZodObject<{
            const: z.ZodString;
            title: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            title: string;
            const: string;
        }, {
            title: string;
            const: string;
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>]>;
/**
 * Primitive schema definition for enum fields.
 */
export declare const EnumSchemaSchema: z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}>, z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    oneOf: z.ZodArray<z.ZodObject<{
        const: z.ZodString;
        title: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        title: string;
        const: string;
    }, {
        title: string;
        const: string;
    }>, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>]>, z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        type: z.ZodLiteral<"string">;
        enum: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        enum: string[];
    }, {
        type: "string";
        enum: string[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        anyOf: z.ZodArray<z.ZodObject<{
            const: z.ZodString;
            title: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            title: string;
            const: string;
        }, {
            title: string;
            const: string;
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>]>]>;
/**
 * Union of all primitive schema definitions.
 */
export declare const PrimitiveSchemaDefinitionSchema: z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
    enumNames?: string[] | undefined;
}>, z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    enum: z.ZodArray<z.ZodString, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    enum: string[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    oneOf: z.ZodArray<z.ZodObject<{
        const: z.ZodString;
        title: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        title: string;
        const: string;
    }, {
        title: string;
        const: string;
    }>, "many">;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}, {
    type: "string";
    oneOf: {
        title: string;
        const: string;
    }[];
    title?: string | undefined;
    description?: string | undefined;
    default?: string | undefined;
}>]>, z.ZodUnion<[z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        type: z.ZodLiteral<"string">;
        enum: z.ZodArray<z.ZodString, "many">;
    }, "strip", z.ZodTypeAny, {
        type: "string";
        enum: string[];
    }, {
        type: "string";
        enum: string[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        type: "string";
        enum: string[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"array">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minItems: z.ZodOptional<z.ZodNumber>;
    maxItems: z.ZodOptional<z.ZodNumber>;
    items: z.ZodObject<{
        anyOf: z.ZodArray<z.ZodObject<{
            const: z.ZodString;
            title: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            title: string;
            const: string;
        }, {
            title: string;
            const: string;
        }>, "many">;
    }, "strip", z.ZodTypeAny, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }, {
        anyOf: {
            title: string;
            const: string;
        }[];
    }>;
    default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
}, "strip", z.ZodTypeAny, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}, {
    type: "array";
    items: {
        anyOf: {
            title: string;
            const: string;
        }[];
    };
    title?: string | undefined;
    description?: string | undefined;
    default?: string[] | undefined;
    minItems?: number | undefined;
    maxItems?: number | undefined;
}>]>]>, z.ZodObject<{
    type: z.ZodLiteral<"boolean">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    default: z.ZodOptional<z.ZodBoolean>;
}, "strip", z.ZodTypeAny, {
    type: "boolean";
    title?: string | undefined;
    description?: string | undefined;
    default?: boolean | undefined;
}, {
    type: "boolean";
    title?: string | undefined;
    description?: string | undefined;
    default?: boolean | undefined;
}>, z.ZodObject<{
    type: z.ZodLiteral<"string">;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minLength: z.ZodOptional<z.ZodNumber>;
    maxLength: z.ZodOptional<z.ZodNumber>;
    format: z.ZodOptional<z.ZodEnum<["email", "uri", "date", "date-time"]>>;
    default: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    type: "string";
    title?: string | undefined;
    description?: string | undefined;
    minLength?: number | undefined;
    maxLength?: number | undefined;
    default?: string | undefined;
    format?: "date" | "uri" | "email" | "date-time" | undefined;
}, {
    type: "string";
    title?: string | undefined;
    description?: string | undefined;
    minLength?: number | undefined;
    maxLength?: number | undefined;
    default?: string | undefined;
    format?: "date" | "uri" | "email" | "date-time" | undefined;
}>, z.ZodObject<{
    type: z.ZodEnum<["number", "integer"]>;
    title: z.ZodOptional<z.ZodString>;
    description: z.ZodOptional<z.ZodString>;
    minimum: z.ZodOptional<z.ZodNumber>;
    maximum: z.ZodOptional<z.ZodNumber>;
    default: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    type: "number" | "integer";
    minimum?: number | undefined;
    maximum?: number | undefined;
    title?: string | undefined;
    description?: string | undefined;
    default?: number | undefined;
}, {
    type: "number" | "integer";
    minimum?: number | undefined;
    maximum?: number | undefined;
    title?: string | undefined;
    description?: string | undefined;
    default?: number | undefined;
}>]>;
/**
 * Parameters for an `elicitation/create` request.
 */
export declare const ElicitRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    /**
     * The message to present to the user.
     */
    message: z.ZodString;
    /**
     * A restricted subset of JSON Schema.
     * Only top-level properties are allowed, without nesting.
     */
    requestedSchema: z.ZodObject<{
        type: z.ZodLiteral<"object">;
        properties: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"string">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            enum: z.ZodArray<z.ZodString, "many">;
            enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        }, {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        }>, z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"string">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            enum: z.ZodArray<z.ZodString, "many">;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        }, {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"string">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            oneOf: z.ZodArray<z.ZodObject<{
                const: z.ZodString;
                title: z.ZodString;
            }, "strip", z.ZodTypeAny, {
                title: string;
                const: string;
            }, {
                title: string;
                const: string;
            }>, "many">;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        }, {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        }>]>, z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"array">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            minItems: z.ZodOptional<z.ZodNumber>;
            maxItems: z.ZodOptional<z.ZodNumber>;
            items: z.ZodObject<{
                type: z.ZodLiteral<"string">;
                enum: z.ZodArray<z.ZodString, "many">;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                enum: string[];
            }, {
                type: "string";
                enum: string[];
            }>;
            default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }, {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"array">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            minItems: z.ZodOptional<z.ZodNumber>;
            maxItems: z.ZodOptional<z.ZodNumber>;
            items: z.ZodObject<{
                anyOf: z.ZodArray<z.ZodObject<{
                    const: z.ZodString;
                    title: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    title: string;
                    const: string;
                }, {
                    title: string;
                    const: string;
                }>, "many">;
            }, "strip", z.ZodTypeAny, {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            }, {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            }>;
            default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }, {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>]>]>, z.ZodObject<{
            type: z.ZodLiteral<"boolean">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            default: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        }, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"string">;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            minLength: z.ZodOptional<z.ZodNumber>;
            maxLength: z.ZodOptional<z.ZodNumber>;
            format: z.ZodOptional<z.ZodEnum<["email", "uri", "date", "date-time"]>>;
            default: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        }, {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        }>, z.ZodObject<{
            type: z.ZodEnum<["number", "integer"]>;
            title: z.ZodOptional<z.ZodString>;
            description: z.ZodOptional<z.ZodString>;
            minimum: z.ZodOptional<z.ZodNumber>;
            maximum: z.ZodOptional<z.ZodNumber>;
            default: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        }, {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        }>]>>;
        required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
    }, "strip", z.ZodTypeAny, {
        type: "object";
        properties: Record<string, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        } | {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        } | {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        } | {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        } | {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>;
        required?: string[] | undefined;
    }, {
        type: "object";
        properties: Record<string, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        } | {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        } | {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        } | {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        } | {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>;
        required?: string[] | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    message: string;
    requestedSchema: {
        type: "object";
        properties: Record<string, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        } | {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        } | {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        } | {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        } | {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>;
        required?: string[] | undefined;
    };
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    message: string;
    requestedSchema: {
        type: "object";
        properties: Record<string, {
            type: "boolean";
            title?: string | undefined;
            description?: string | undefined;
            default?: boolean | undefined;
        } | {
            type: "string";
            title?: string | undefined;
            description?: string | undefined;
            minLength?: number | undefined;
            maxLength?: number | undefined;
            default?: string | undefined;
            format?: "date" | "uri" | "email" | "date-time" | undefined;
        } | {
            type: "number" | "integer";
            minimum?: number | undefined;
            maximum?: number | undefined;
            title?: string | undefined;
            description?: string | undefined;
            default?: number | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            oneOf: {
                title: string;
                const: string;
            }[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
        } | {
            type: "string";
            enum: string[];
            title?: string | undefined;
            description?: string | undefined;
            default?: string | undefined;
            enumNames?: string[] | undefined;
        } | {
            type: "array";
            items: {
                type: "string";
                enum: string[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        } | {
            type: "array";
            items: {
                anyOf: {
                    title: string;
                    const: string;
                }[];
            };
            title?: string | undefined;
            description?: string | undefined;
            default?: string[] | undefined;
            minItems?: number | undefined;
            maxItems?: number | undefined;
        }>;
        required?: string[] | undefined;
    };
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * A request from the server to elicit user input via the client.
 * The client should present the message and form fields to the user.
 */
export declare const ElicitRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"elicitation/create">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The message to present to the user.
         */
        message: z.ZodString;
        /**
         * A restricted subset of JSON Schema.
         * Only top-level properties are allowed, without nesting.
         */
        requestedSchema: z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                enum: z.ZodArray<z.ZodString, "many">;
                enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            }, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            }>, z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                enum: z.ZodArray<z.ZodString, "many">;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                oneOf: z.ZodArray<z.ZodObject<{
                    const: z.ZodString;
                    title: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    title: string;
                    const: string;
                }, {
                    title: string;
                    const: string;
                }>, "many">;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }, {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }>]>, z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"array">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minItems: z.ZodOptional<z.ZodNumber>;
                maxItems: z.ZodOptional<z.ZodNumber>;
                items: z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    enum: z.ZodArray<z.ZodString, "many">;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    enum: string[];
                }, {
                    type: "string";
                    enum: string[];
                }>;
                default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }, {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"array">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minItems: z.ZodOptional<z.ZodNumber>;
                maxItems: z.ZodOptional<z.ZodNumber>;
                items: z.ZodObject<{
                    anyOf: z.ZodArray<z.ZodObject<{
                        const: z.ZodString;
                        title: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        title: string;
                        const: string;
                    }, {
                        title: string;
                        const: string;
                    }>, "many">;
                }, "strip", z.ZodTypeAny, {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                }, {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                }>;
                default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }, {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>]>]>, z.ZodObject<{
                type: z.ZodLiteral<"boolean">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                default: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            }, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minLength: z.ZodOptional<z.ZodNumber>;
                maxLength: z.ZodOptional<z.ZodNumber>;
                format: z.ZodOptional<z.ZodEnum<["email", "uri", "date", "date-time"]>>;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            }, {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            }>, z.ZodObject<{
                type: z.ZodEnum<["number", "integer"]>;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minimum: z.ZodOptional<z.ZodNumber>;
                maximum: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            }, {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            }>]>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        }, {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        }>;
    }>, "strip", z.ZodTypeAny, {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "elicitation/create";
}, {
    params: {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "elicitation/create";
}>;
/**
 * The client's response to an elicitation/create request from the server.
 */
export declare const ElicitResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * A reference to a resource or resource template definition.
 */
export declare const ResourceTemplateReferenceSchema: z.ZodObject<{
    type: z.ZodLiteral<"ref/resource">;
    /**
     * The URI or URI template of the resource.
     */
    uri: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "ref/resource";
    uri: string;
}, {
    type: "ref/resource";
    uri: string;
}>;
/**
 * @deprecated Use ResourceTemplateReferenceSchema instead
 */
export declare const ResourceReferenceSchema: z.ZodObject<{
    type: z.ZodLiteral<"ref/resource">;
    /**
     * The URI or URI template of the resource.
     */
    uri: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "ref/resource";
    uri: string;
}, {
    type: "ref/resource";
    uri: string;
}>;
/**
 * Identifies a prompt.
 */
export declare const PromptReferenceSchema: z.ZodObject<{
    type: z.ZodLiteral<"ref/prompt">;
    /**
     * The name of the prompt or prompt template
     */
    name: z.ZodString;
}, "strip", z.ZodTypeAny, {
    type: "ref/prompt";
    name: string;
}, {
    type: "ref/prompt";
    name: string;
}>;
/**
 * Parameters for a `completion/complete` request.
 */
export declare const CompleteRequestParamsSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
     */
    _meta: z.ZodOptional<z.ZodObject<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    ref: z.ZodUnion<[z.ZodObject<{
        type: z.ZodLiteral<"ref/prompt">;
        /**
         * The name of the prompt or prompt template
         */
        name: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: "ref/prompt";
        name: string;
    }, {
        type: "ref/prompt";
        name: string;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"ref/resource">;
        /**
         * The URI or URI template of the resource.
         */
        uri: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        type: "ref/resource";
        uri: string;
    }, {
        type: "ref/resource";
        uri: string;
    }>]>;
    /**
     * The argument's information
     */
    argument: z.ZodObject<{
        /**
         * The name of the argument
         */
        name: z.ZodString;
        /**
         * The value of the argument to use for completion matching.
         */
        value: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        value: string;
        name: string;
    }, {
        value: string;
        name: string;
    }>;
    context: z.ZodOptional<z.ZodObject<{
        /**
         * Previously-resolved variables in a URI template or prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        arguments?: Record<string, string> | undefined;
    }, {
        arguments?: Record<string, string> | undefined;
    }>>;
}>, "strip", z.ZodTypeAny, {
    ref: {
        type: "ref/resource";
        uri: string;
    } | {
        type: "ref/prompt";
        name: string;
    };
    argument: {
        value: string;
        name: string;
    };
    _meta?: z.objectOutputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    context?: {
        arguments?: Record<string, string> | undefined;
    } | undefined;
}, {
    ref: {
        type: "ref/resource";
        uri: string;
    } | {
        type: "ref/prompt";
        name: string;
    };
    argument: {
        value: string;
        name: string;
    };
    _meta?: z.objectInputType<{
        /**
         * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
         */
        progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
    context?: {
        arguments?: Record<string, string> | undefined;
    } | undefined;
}>;
/**
 * A request from the client to the server, to ask for completion options.
 */
export declare const CompleteRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"completion/complete">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        ref: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"ref/prompt">;
            /**
             * The name of the prompt or prompt template
             */
            name: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "ref/prompt";
            name: string;
        }, {
            type: "ref/prompt";
            name: string;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"ref/resource">;
            /**
             * The URI or URI template of the resource.
             */
            uri: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "ref/resource";
            uri: string;
        }, {
            type: "ref/resource";
            uri: string;
        }>]>;
        /**
         * The argument's information
         */
        argument: z.ZodObject<{
            /**
             * The name of the argument
             */
            name: z.ZodString;
            /**
             * The value of the argument to use for completion matching.
             */
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            value: string;
            name: string;
        }, {
            value: string;
            name: string;
        }>;
        context: z.ZodOptional<z.ZodObject<{
            /**
             * Previously-resolved variables in a URI template or prompt.
             */
            arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            arguments?: Record<string, string> | undefined;
        }, {
            arguments?: Record<string, string> | undefined;
        }>>;
    }>, "strip", z.ZodTypeAny, {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    }, {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    };
    method: "completion/complete";
}, {
    params: {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    };
    method: "completion/complete";
}>;
export declare function assertCompleteRequestPrompt(request: CompleteRequest): asserts request is CompleteRequestPrompt;
export declare function assertCompleteRequestResourceTemplate(request: CompleteRequest): asserts request is CompleteRequestResourceTemplate;
/**
 * The server's response to a completion/complete request
 */
export declare const CompleteResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * Represents a root directory or file that the server can operate on.
 */
export declare const RootSchema: z.ZodObject<{
    /**
     * The URI identifying the root. This *must* start with file:// for now.
     */
    uri: z.ZodString;
    /**
     * An optional name for the root.
     */
    name: z.ZodOptional<z.ZodString>;
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strip", z.ZodTypeAny, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
    name?: string | undefined;
}, {
    uri: string;
    _meta?: Record<string, unknown> | undefined;
    name?: string | undefined;
}>;
/**
 * Sent from the server to request a list of root URIs from the client.
 */
export declare const ListRootsRequestSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"roots/list">;
}>, "strip", z.ZodTypeAny, {
    method: "roots/list";
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "roots/list";
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
/**
 * The client's response to a roots/list request from the server.
 */
export declare const ListRootsResultSchema: z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>;
/**
 * A notification from the client to the server, informing it that the list of roots has changed.
 */
export declare const RootsListChangedNotificationSchema: z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/roots/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/roots/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/roots/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>;
export declare const ClientRequestSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"ping">;
}>, "strip", z.ZodTypeAny, {
    method: "ping";
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "ping";
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"initialize">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The latest version of the Model Context Protocol that the client supports. The client MAY decide to support older versions as well.
         */
        protocolVersion: z.ZodString;
        capabilities: z.ZodObject<{
            /**
             * Experimental, non-standard capabilities that the client supports.
             */
            experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
            /**
             * Present if the client supports sampling from an LLM.
             */
            sampling: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
            /**
             * Present if the client supports eliciting user input.
             */
            elicitation: z.ZodIntersection<z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client should apply defaults to the user input.
                 */
                applyDefaults: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                applyDefaults?: boolean | undefined;
            }, {
                applyDefaults?: boolean | undefined;
            }>>, z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>>;
            /**
             * Present if the client supports listing roots.
             */
            roots: z.ZodOptional<z.ZodObject<{
                /**
                 * Whether the client supports issuing notifications for changes to the roots list.
                 */
                listChanged: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                listChanged?: boolean | undefined;
            }, {
                listChanged?: boolean | undefined;
            }>>;
        }, "strip", z.ZodTypeAny, {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        }, {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        }>;
        clientInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            version: z.ZodString;
            /**
             * An optional URL of the website for this implementation.
             */
            websiteUrl: z.ZodOptional<z.ZodString>;
        }>, {
            /**
             * Optional set of sized icons that the client can display in a user interface.
             *
             * Clients that support rendering icons MUST support at least the following MIME types:
             * - `image/png` - PNG images (safe, universal compatibility)
             * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
             *
             * Clients that support rendering icons SHOULD also support:
             * - `image/svg+xml` - SVG images (scalable but requires security precautions)
             * - `image/webp` - WebP images (modern, efficient format)
             */
            icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * URL or data URI for the icon.
                 */
                src: z.ZodString;
                /**
                 * Optional MIME type for the icon.
                 */
                mimeType: z.ZodOptional<z.ZodString>;
                /**
                 * Optional array of strings that specify sizes at which the icon can be used.
                 * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
                 *
                 * If not provided, the client should assume that the icon can be used at any size.
                 */
                sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }, {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }>, "many">>;
        }>, "strip", z.ZodTypeAny, {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        }, {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        }>;
    }>, "strip", z.ZodTypeAny, {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "initialize";
}, {
    params: {
        protocolVersion: string;
        capabilities: {
            experimental?: Record<string, object> | undefined;
            sampling?: object | undefined;
            elicitation?: ({
                applyDefaults?: boolean | undefined;
            } & Record<string, unknown>) | undefined;
            roots?: {
                listChanged?: boolean | undefined;
            } | undefined;
        };
        clientInfo: {
            name: string;
            version: string;
            icons?: {
                src: string;
                mimeType?: string | undefined;
                sizes?: string[] | undefined;
            }[] | undefined;
            title?: string | undefined;
            websiteUrl?: string | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "initialize";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"completion/complete">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        ref: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"ref/prompt">;
            /**
             * The name of the prompt or prompt template
             */
            name: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "ref/prompt";
            name: string;
        }, {
            type: "ref/prompt";
            name: string;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"ref/resource">;
            /**
             * The URI or URI template of the resource.
             */
            uri: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            type: "ref/resource";
            uri: string;
        }, {
            type: "ref/resource";
            uri: string;
        }>]>;
        /**
         * The argument's information
         */
        argument: z.ZodObject<{
            /**
             * The name of the argument
             */
            name: z.ZodString;
            /**
             * The value of the argument to use for completion matching.
             */
            value: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            value: string;
            name: string;
        }, {
            value: string;
            name: string;
        }>;
        context: z.ZodOptional<z.ZodObject<{
            /**
             * Previously-resolved variables in a URI template or prompt.
             */
            arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
        }, "strip", z.ZodTypeAny, {
            arguments?: Record<string, string> | undefined;
        }, {
            arguments?: Record<string, string> | undefined;
        }>>;
    }>, "strip", z.ZodTypeAny, {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    }, {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    };
    method: "completion/complete";
}, {
    params: {
        ref: {
            type: "ref/resource";
            uri: string;
        } | {
            type: "ref/prompt";
            name: string;
        };
        argument: {
            value: string;
            name: string;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        context?: {
            arguments?: Record<string, string> | undefined;
        } | undefined;
    };
    method: "completion/complete";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"logging/setLevel">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The level of logging that the client wants to receive from the server. The server should send all logs at this level and higher (i.e., more severe) to the client as notifications/logging/message.
         */
        level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
    }>, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "logging/setLevel";
}, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "logging/setLevel";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"prompts/get">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the prompt or prompt template.
         */
        name: z.ZodString;
        /**
         * Arguments to use for templating the prompt.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodString>>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    };
    method: "prompts/get";
}, {
    params: {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, string> | undefined;
    };
    method: "prompts/get";
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"prompts/list">;
}>, "strip", z.ZodTypeAny, {
    method: "prompts/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "prompts/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"resources/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "resources/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"resources/templates/list">;
}>, "strip", z.ZodTypeAny, {
    method: "resources/templates/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "resources/templates/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/read">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/read";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/read";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/subscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/subscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/subscribe";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"resources/unsubscribe">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The URI of the resource to read. The URI can use any protocol; it is up to the server how to interpret it.
         *
         * @format uri
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/unsubscribe";
}, {
    params: {
        uri: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "resources/unsubscribe";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"tools/call">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The name of the tool to call.
         */
        name: z.ZodString;
        /**
         * Arguments to pass to the tool.
         */
        arguments: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    }, {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        name: string;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    };
    method: "tools/call";
}, {
    params: {
        name: string;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        arguments?: Record<string, unknown> | undefined;
    };
    method: "tools/call";
}>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    params: z.ZodOptional<z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * An opaque token representing the current pagination position.
         * If provided, the server should return results starting after this cursor.
         */
        cursor: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }, {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    }>>;
}>, {
    method: z.ZodLiteral<"tools/list">;
}>, "strip", z.ZodTypeAny, {
    method: "tools/list";
    params?: {
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}, {
    method: "tools/list";
    params?: {
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        cursor?: string | undefined;
    } | undefined;
}>]>;
export declare const ClientNotificationSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/cancelled">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/progress">;
    params: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, "strip", z.ZodTypeAny, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/initialized">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/initialized";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/initialized";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/roots/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/roots/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/roots/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>]>;
export declare const ClientResultSchema: z.ZodUnion<[z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strict", z.ZodTypeAny, {
    _meta?: Record<string, unknown> | undefined;
}, {
    _meta?: Record<string, unknown> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The name of the model that generated the message.
     */
    model: z.ZodString;
    /**
     * The reason why sampling stopped.
     */
    stopReason: z.ZodOptional<z.ZodUnion<[z.ZodEnum<["endTurn", "stopSequence", "maxTokens"]>, z.ZodString]>>;
    role: z.ZodEnum<["user", "assistant"]>;
    content: z.ZodDiscriminatedUnion<"type", [z.ZodObject<{
        type: z.ZodLiteral<"text">;
        /**
         * The text content of the message.
         */
        text: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "text";
        text: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"image">;
        /**
         * The base64-encoded image data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the image. Different providers may support different image types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "image";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>, z.ZodObject<{
        type: z.ZodLiteral<"audio">;
        /**
         * The base64-encoded audio data.
         */
        data: z.ZodEffects<z.ZodString, string, string>;
        /**
         * The MIME type of the audio. Different providers may support different audio types.
         */
        mimeType: z.ZodString;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        type: "audio";
        data: string;
        mimeType: string;
        _meta?: Record<string, unknown> | undefined;
    }>]>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The user action in response to the elicitation.
     * - "accept": User submitted the form/confirmed the action
     * - "decline": User explicitly decline the action
     * - "cancel": User dismissed without making an explicit choice
     */
    action: z.ZodEnum<["accept", "decline", "cancel"]>;
    /**
     * The submitted form data, only present when action is "accept".
     * Contains values matching the requested schema.
     */
    content: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodString, z.ZodNumber, z.ZodBoolean, z.ZodArray<z.ZodString, "many">]>>>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    roots: z.ZodArray<z.ZodObject<{
        /**
         * The URI identifying the root. This *must* start with file:// for now.
         */
        uri: z.ZodString;
        /**
         * An optional name for the root.
         */
        name: z.ZodOptional<z.ZodString>;
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
        name?: string | undefined;
    }>, "many">;
}>, z.ZodTypeAny, "passthrough">>]>;
export declare const ServerRequestSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"ping">;
}>, "strip", z.ZodTypeAny, {
    method: "ping";
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "ping";
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"sampling/createMessage">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        messages: z.ZodArray<z.ZodObject<{
            role: z.ZodEnum<["user", "assistant"]>;
            content: z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"text">;
                /**
                 * The text content of the message.
                 */
                text: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"image">;
                /**
                 * The base64-encoded image data.
                 */
                data: z.ZodEffects<z.ZodString, string, string>;
                /**
                 * The MIME type of the image. Different providers may support different image types.
                 */
                mimeType: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"audio">;
                /**
                 * The base64-encoded audio data.
                 */
                data: z.ZodEffects<z.ZodString, string, string>;
                /**
                 * The MIME type of the audio. Different providers may support different audio types.
                 */
                mimeType: z.ZodString;
                /**
                 * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
                 * for notes on _meta usage.
                 */
                _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
            }, "strip", z.ZodTypeAny, {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }, {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            }>]>;
        }, "strip", z.ZodTypeAny, {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }, {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }>, "many">;
        /**
         * The server's preferences for which model to select. The client MAY modify or omit this request.
         */
        modelPreferences: z.ZodOptional<z.ZodObject<{
            /**
             * Optional hints to use for model selection.
             */
            hints: z.ZodOptional<z.ZodArray<z.ZodObject<{
                /**
                 * A hint for a model name.
                 */
                name: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                name?: string | undefined;
            }, {
                name?: string | undefined;
            }>, "many">>;
            /**
             * How much to prioritize cost when selecting a model.
             */
            costPriority: z.ZodOptional<z.ZodNumber>;
            /**
             * How much to prioritize sampling speed (latency) when selecting a model.
             */
            speedPriority: z.ZodOptional<z.ZodNumber>;
            /**
             * How much to prioritize intelligence and capabilities when selecting a model.
             */
            intelligencePriority: z.ZodOptional<z.ZodNumber>;
        }, "strip", z.ZodTypeAny, {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        }, {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        }>>;
        /**
         * An optional system prompt the server wants to use for sampling. The client MAY modify or omit this prompt.
         */
        systemPrompt: z.ZodOptional<z.ZodString>;
        /**
         * A request to include context from one or more MCP servers (including the caller), to be attached to the prompt. The client MAY ignore this request.
         */
        includeContext: z.ZodOptional<z.ZodEnum<["none", "thisServer", "allServers"]>>;
        temperature: z.ZodOptional<z.ZodNumber>;
        /**
         * The requested maximum number of tokens to sample (to prevent runaway completions).
         *
         * The client MAY choose to sample fewer tokens than the requested maximum.
         */
        maxTokens: z.ZodNumber;
        stopSequences: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        /**
         * Optional metadata to pass through to the LLM provider. The format of this metadata is provider-specific.
         */
        metadata: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
    }>, "strip", z.ZodTypeAny, {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    }, {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    };
    method: "sampling/createMessage";
}, {
    params: {
        messages: {
            role: "user" | "assistant";
            content: {
                type: "text";
                text: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "image";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            } | {
                type: "audio";
                data: string;
                mimeType: string;
                _meta?: Record<string, unknown> | undefined;
            };
        }[];
        maxTokens: number;
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
        modelPreferences?: {
            hints?: {
                name?: string | undefined;
            }[] | undefined;
            costPriority?: number | undefined;
            speedPriority?: number | undefined;
            intelligencePriority?: number | undefined;
        } | undefined;
        systemPrompt?: string | undefined;
        includeContext?: "none" | "thisServer" | "allServers" | undefined;
        temperature?: number | undefined;
        stopSequences?: string[] | undefined;
        metadata?: object | undefined;
    };
    method: "sampling/createMessage";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"elicitation/create">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, {
        /**
         * The message to present to the user.
         */
        message: z.ZodString;
        /**
         * A restricted subset of JSON Schema.
         * Only top-level properties are allowed, without nesting.
         */
        requestedSchema: z.ZodObject<{
            type: z.ZodLiteral<"object">;
            properties: z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                enum: z.ZodArray<z.ZodString, "many">;
                enumNames: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            }, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            }>, z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                enum: z.ZodArray<z.ZodString, "many">;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }, {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                oneOf: z.ZodArray<z.ZodObject<{
                    const: z.ZodString;
                    title: z.ZodString;
                }, "strip", z.ZodTypeAny, {
                    title: string;
                    const: string;
                }, {
                    title: string;
                    const: string;
                }>, "many">;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }, {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            }>]>, z.ZodUnion<[z.ZodObject<{
                type: z.ZodLiteral<"array">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minItems: z.ZodOptional<z.ZodNumber>;
                maxItems: z.ZodOptional<z.ZodNumber>;
                items: z.ZodObject<{
                    type: z.ZodLiteral<"string">;
                    enum: z.ZodArray<z.ZodString, "many">;
                }, "strip", z.ZodTypeAny, {
                    type: "string";
                    enum: string[];
                }, {
                    type: "string";
                    enum: string[];
                }>;
                default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }, {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"array">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minItems: z.ZodOptional<z.ZodNumber>;
                maxItems: z.ZodOptional<z.ZodNumber>;
                items: z.ZodObject<{
                    anyOf: z.ZodArray<z.ZodObject<{
                        const: z.ZodString;
                        title: z.ZodString;
                    }, "strip", z.ZodTypeAny, {
                        title: string;
                        const: string;
                    }, {
                        title: string;
                        const: string;
                    }>, "many">;
                }, "strip", z.ZodTypeAny, {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                }, {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                }>;
                default: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }, {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>]>]>, z.ZodObject<{
                type: z.ZodLiteral<"boolean">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                default: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            }, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            }>, z.ZodObject<{
                type: z.ZodLiteral<"string">;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minLength: z.ZodOptional<z.ZodNumber>;
                maxLength: z.ZodOptional<z.ZodNumber>;
                format: z.ZodOptional<z.ZodEnum<["email", "uri", "date", "date-time"]>>;
                default: z.ZodOptional<z.ZodString>;
            }, "strip", z.ZodTypeAny, {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            }, {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            }>, z.ZodObject<{
                type: z.ZodEnum<["number", "integer"]>;
                title: z.ZodOptional<z.ZodString>;
                description: z.ZodOptional<z.ZodString>;
                minimum: z.ZodOptional<z.ZodNumber>;
                maximum: z.ZodOptional<z.ZodNumber>;
                default: z.ZodOptional<z.ZodNumber>;
            }, "strip", z.ZodTypeAny, {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            }, {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            }>]>>;
            required: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        }, {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        }>;
    }>, "strip", z.ZodTypeAny, {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }, {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "elicitation/create";
}, {
    params: {
        message: string;
        requestedSchema: {
            type: "object";
            properties: Record<string, {
                type: "boolean";
                title?: string | undefined;
                description?: string | undefined;
                default?: boolean | undefined;
            } | {
                type: "string";
                title?: string | undefined;
                description?: string | undefined;
                minLength?: number | undefined;
                maxLength?: number | undefined;
                default?: string | undefined;
                format?: "date" | "uri" | "email" | "date-time" | undefined;
            } | {
                type: "number" | "integer";
                minimum?: number | undefined;
                maximum?: number | undefined;
                title?: string | undefined;
                description?: string | undefined;
                default?: number | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                oneOf: {
                    title: string;
                    const: string;
                }[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
            } | {
                type: "string";
                enum: string[];
                title?: string | undefined;
                description?: string | undefined;
                default?: string | undefined;
                enumNames?: string[] | undefined;
            } | {
                type: "array";
                items: {
                    type: "string";
                    enum: string[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            } | {
                type: "array";
                items: {
                    anyOf: {
                        title: string;
                        const: string;
                    }[];
                };
                title?: string | undefined;
                description?: string | undefined;
                default?: string[] | undefined;
                minItems?: number | undefined;
                maxItems?: number | undefined;
            }>;
            required?: string[] | undefined;
        };
        _meta?: z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough"> | undefined;
    };
    method: "elicitation/create";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"roots/list">;
}>, "strip", z.ZodTypeAny, {
    method: "roots/list";
    params?: z.objectOutputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "roots/list";
    params?: z.objectInputType<{
        /**
         * See [General fields: `_meta`](/specification/draft/basic/index#meta) for notes on `_meta` usage.
         */
        _meta: z.ZodOptional<z.ZodObject<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
            /**
             * If specified, the caller is requesting out-of-band progress notifications for this request (as represented by notifications/progress). The value of this parameter is an opaque token that will be attached to any subsequent notifications. The receiver is not obligated to provide these notifications.
             */
            progressToken: z.ZodOptional<z.ZodUnion<[z.ZodString, z.ZodNumber]>>;
        }, z.ZodTypeAny, "passthrough">>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>]>;
export declare const ServerNotificationSchema: z.ZodUnion<[z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/cancelled">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The ID of the request to cancel.
         *
         * This MUST correspond to the ID of a request previously issued in the same direction.
         */
        requestId: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
        /**
         * An optional string describing the reason for the cancellation. This MAY be logged or presented to the user.
         */
        reason: z.ZodOptional<z.ZodString>;
    }>, "strip", z.ZodTypeAny, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }, {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}, {
    params: {
        requestId: string | number;
        _meta?: Record<string, unknown> | undefined;
        reason?: string | undefined;
    };
    method: "notifications/cancelled";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/progress">;
    params: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The progress thus far. This should increase every time progress is made, even if the total is unknown.
         */
        progress: z.ZodNumber;
        /**
         * Total number of items to process (or total progress required), if known.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * An optional message describing the current progress.
         */
        message: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * The progress token which was given in the initial request, used to associate this notification with the request that is proceeding.
         */
        progressToken: z.ZodUnion<[z.ZodString, z.ZodNumber]>;
    }>, "strip", z.ZodTypeAny, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }, {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}, {
    params: {
        progressToken: string | number;
        progress: number;
        message?: string | undefined;
        _meta?: Record<string, unknown> | undefined;
        total?: number | undefined;
    };
    method: "notifications/progress";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/message">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The severity of this log message.
         */
        level: z.ZodEnum<["debug", "info", "notice", "warning", "error", "critical", "alert", "emergency"]>;
        /**
         * An optional name of the logger issuing this message.
         */
        logger: z.ZodOptional<z.ZodString>;
        /**
         * The data to be logged, such as a string message or an object. Any JSON serializable type is allowed here.
         */
        data: z.ZodUnknown;
    }>, "strip", z.ZodTypeAny, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    }, {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    };
    method: "notifications/message";
}, {
    params: {
        level: "error" | "debug" | "info" | "notice" | "warning" | "critical" | "alert" | "emergency";
        _meta?: Record<string, unknown> | undefined;
        data?: unknown;
        logger?: string | undefined;
    };
    method: "notifications/message";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/updated">;
    params: z.ZodObject<z.objectUtil.extendShape<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, {
        /**
         * The URI of the resource that has been updated. This might be a sub-resource of the one that the client actually subscribed to.
         */
        uri: z.ZodString;
    }>, "strip", z.ZodTypeAny, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    }, {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    }>;
}>, "strip", z.ZodTypeAny, {
    params: {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    };
    method: "notifications/resources/updated";
}, {
    params: {
        uri: string;
        _meta?: Record<string, unknown> | undefined;
    };
    method: "notifications/resources/updated";
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/resources/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/resources/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/resources/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/tools/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/tools/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/tools/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    method: z.ZodString;
    params: z.ZodOptional<z.ZodObject<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough">>>;
}, {
    method: z.ZodLiteral<"notifications/prompts/list_changed">;
}>, "strip", z.ZodTypeAny, {
    method: "notifications/prompts/list_changed";
    params?: z.objectOutputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}, {
    method: "notifications/prompts/list_changed";
    params?: z.objectInputType<{
        /**
         * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
         * for notes on _meta usage.
         */
        _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
    }, z.ZodTypeAny, "passthrough"> | undefined;
}>]>;
export declare const ServerResultSchema: z.ZodUnion<[z.ZodObject<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, "strict", z.ZodTypeAny, {
    _meta?: Record<string, unknown> | undefined;
}, {
    _meta?: Record<string, unknown> | undefined;
}>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * The version of the Model Context Protocol that the server wants to use. This may not match the version that the client requested. If the client cannot support this version, it MUST disconnect.
     */
    protocolVersion: z.ZodString;
    capabilities: z.ZodObject<{
        /**
         * Experimental, non-standard capabilities that the server supports.
         */
        experimental: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodType<object, z.ZodTypeDef, object>>>;
        /**
         * Present if the server supports sending log messages to the client.
         */
        logging: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server supports sending completions to the client.
         */
        completions: z.ZodOptional<z.ZodType<object, z.ZodTypeDef, object>>;
        /**
         * Present if the server offers any prompt templates.
         */
        prompts: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the prompt list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any resources to read.
         */
        resources: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports clients subscribing to resource updates.
             */
            subscribe: z.ZodOptional<z.ZodBoolean>;
            /**
             * Whether this server supports issuing notifications for changes to the resource list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        }>>;
        /**
         * Present if the server offers any tools to call.
         */
        tools: z.ZodOptional<z.ZodObject<{
            /**
             * Whether this server supports issuing notifications for changes to the tool list.
             */
            listChanged: z.ZodOptional<z.ZodBoolean>;
        }, "strip", z.ZodTypeAny, {
            listChanged?: boolean | undefined;
        }, {
            listChanged?: boolean | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }, {
        experimental?: Record<string, object> | undefined;
        logging?: object | undefined;
        completions?: object | undefined;
        prompts?: {
            listChanged?: boolean | undefined;
        } | undefined;
        resources?: {
            listChanged?: boolean | undefined;
            subscribe?: boolean | undefined;
        } | undefined;
        tools?: {
            listChanged?: boolean | undefined;
        } | undefined;
    }>;
    serverInfo: z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<{
        /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
        name: z.ZodString;
        /**
         * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
         * even by those unfamiliar with domain-specific terminology.
         *
         * If not provided, the name should be used for display (except for Tool,
         * where `annotations.title` should be given precedence over using `name`,
         * if present).
         */
        title: z.ZodOptional<z.ZodString>;
    }, {
        version: z.ZodString;
        /**
         * An optional URL of the website for this implementation.
         */
        websiteUrl: z.ZodOptional<z.ZodString>;
    }>, {
        /**
         * Optional set of sized icons that the client can display in a user interface.
         *
         * Clients that support rendering icons MUST support at least the following MIME types:
         * - `image/png` - PNG images (safe, universal compatibility)
         * - `image/jpeg` (and `image/jpg`) - JPEG images (safe, universal compatibility)
         *
         * Clients that support rendering icons SHOULD also support:
         * - `image/svg+xml` - SVG images (scalable but requires security precautions)
         * - `image/webp` - WebP images (modern, efficient format)
         */
        icons: z.ZodOptional<z.ZodArray<z.ZodObject<{
            /**
             * URL or data URI for the icon.
             */
            src: z.ZodString;
            /**
             * Optional MIME type for the icon.
             */
            mimeType: z.ZodOptional<z.ZodString>;
            /**
             * Optional array of strings that specify sizes at which the icon can be used.
             * Each string should be in WxH format (e.g., `"48x48"`, `"96x96"`) or `"any"` for scalable formats like SVG.
             *
             * If not provided, the client should assume that the icon can be used at any size.
             */
            sizes: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        }, "strip", z.ZodTypeAny, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }, {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }>, "many">>;
    }>, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }, {
        name: string;
        version: string;
        icons?: {
            src: string;
            mimeType?: string | undefined;
            sizes?: string[] | undefined;
        }[] | undefined;
        title?: string | undefined;
        websiteUrl?: string | undefined;
    }>;
    /**
     * Instructions describing how to use the server and its features.
     *
     * This can be used by clients to improve the LLM's understanding of available tools, resources, etc. It can be thought of like a "hint" to the model. For example, this information MAY be added to the system prompt.
     */
    instructions: z.ZodOptional<z.ZodString>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, "passthrough", z.ZodTypeAny, z.objectOutputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">, z.objectInputType<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    completion: z.ZodObject<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        /**
         * An array of completion values. Must not exceed 100 items.
         */
        values: z.ZodArray<z.ZodString, "many">;
        /**
         * The total number of completion options available. This can exceed the number of values actually sent in the response.
         */
        total: z.ZodOptional<z.ZodNumber>;
        /**
         * Indicates whether there are additional completion options beyond those provided in the current response, even if the exact total is unknown.
         */
        hasMore: z.ZodOptional<z.ZodBoolean>;
    }, z.ZodTypeAny, "passthrough">>;
}>, z.ZodTypeAny, "passthrough">>, z.ZodObject<z.objectUtil.extendShape<{
    /**
     * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
     * for notes on _meta usage.
     */
    _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
}, {
    /**
     * An optional description for the prompt.
     */
    description: z.ZodOptional<z.ZodString>;
    messages: z.ZodArray<z.ZodObject<{
        role: z.ZodEnum<["user", "assistant"]>;
        content: z.ZodUnion<[z.ZodObject<{
            type: z.ZodLiteral<"text">;
            /**
             * The text content of the message.
             */
            text: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "text";
            text: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"image">;
            /**
             * The base64-encoded image data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the image. Different providers may support different image types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "image";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<{
            type: z.ZodLiteral<"audio">;
            /**
             * The base64-encoded audio data.
             */
            data: z.ZodEffects<z.ZodString, string, string>;
            /**
             * The MIME type of the audio. Different providers may support different audio types.
             */
            mimeType: z.ZodString;
            /**
             * See [MCP specification](https://github.com/modelcontextprotocol/modelcontextprotocol/blob/47339c03c143bb4ec01a26e721a1b8fe66634ebe/docs/specification/draft/basic/index.mdx#general-fields)
             * for notes on _meta usage.
             */
            _meta: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodUnknown>>;
        }, "strip", z.ZodTypeAny, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }, {
            type: "audio";
            data: string;
            mimeType: string;
            _meta?: Record<string, unknown> | undefined;
        }>, z.ZodObject<z.objectUtil.extendShape<z.objectUtil.extendShape<z.objectUtil.extendShape<{
            /** Intended for programmatic or logical use, but used as a display name in past specs or fallback */
            name: z.ZodString;
            /**
             * Intended for UI and end-user contexts — optimized to be human-readable and easily understood,
             * even by those unfamiliar with domain-specific terminology.
             *
             * If not provided, the name should be used for display (except for Tool,
             * where `annotations.title` should be given precedence over using `name`,
             * if present).
             */
            title: z.ZodOptional<z.ZodString>;
        }, {
            /**
             * The URI of this resource.
             */
            uri: z.ZodString;
            /**
             * A description of what this resource represents.
             *
             * This can be used by cl