#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 gitit
version:              0.15.1.2
visibility:           public
id:                   gitit-0.15.1.2-IsTpj3udJAeE9nPP4v4fge
key:                  gitit-0.15.1.2-IsTpj3udJAeE9nPP4v4fge
license:              LicenseRef-GPL
maintainer:           jgm@berkeley.edu
author:               John MacFarlane
stability:            experimental
synopsis:             Wiki using happstack, git or darcs, and pandoc.
description:
    Gitit is a wiki backed by a git, darcs, or mercurial
    filestore.  Pages and uploaded files can be modified either
    directly via the VCS'\''s command-line tools or through
    the wiki'\''s web interface. Pandoc is used for markup
    processing, so pages may be written in
    (extended) markdown, reStructuredText, LaTeX, HTML,
    or literate Haskell.

    Notable features include

    * plugins: dynamically loaded page
    transformations written in Haskell (see
    "Network.Gitit.Interface")

    * conversion of TeX math to MathML for display in
    web browsers

    * syntax highlighting of source code
    files and code snippets

    * Atom feeds (site-wide and per-page)

    * a library, "Network.Gitit", that makes it simple
    to include a gitit wiki in any happstack application

    For usage information:  @gitit --help@

category:             Network
abi:                  593bf72f07987eeb3a2108952ba3dc7d
exposed:              True
exposed-modules:
    Network.Gitit Network.Gitit.Authentication
    Network.Gitit.Authentication.Github Network.Gitit.Cache
    Network.Gitit.Compat.Except Network.Gitit.Config
    Network.Gitit.ContentTransformer Network.Gitit.Feed
    Network.Gitit.Framework Network.Gitit.Handlers
    Network.Gitit.Initialize Network.Gitit.Interface
    Network.Gitit.Layout Network.Gitit.Page Network.Gitit.Plugins
    Network.Gitit.Rpxnow Network.Gitit.Server Network.Gitit.State
    Network.Gitit.Types Network.Gitit.Util Paths_gitit

import-dirs:          /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs:         /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/gitit-0.15.1.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/gitit
hs-libraries:         HSgitit-0.15.1.2-IsTpj3udJAeE9nPP4v4fge
depends:
    HStringTemplate-0.8.8-Dzlnd6S4LIk2t6XN83QClD
    HTTP-4000.4.1-JtRIgU9Z4IjIeZcvqE1nDr
    SHA-1.6.4.4-KRZJCS52poaHfqPlW5b8Sg
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E base-4.18.2.1
    base64-bytestring-1.2.1.0-yECTd8pImc5tCLSmRqH7t
    blaze-html-0.9.2.0-8CIOWujpLcd2fSwCqkXFhk bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.8.5
    doctemplates-0.11.0.1-8ehBKiuLkFbC80FQuqVX4u
    feed-1.3.2.1-8urYbHfYo9z4T0RpUOOqd5 filepath-1.4.300.1
    filestore-0.6.5.1-8NxTL1ibCiK1LMBjHWtZHm ghc-9.6.6
    ghc-paths-0.1.0.12-JSGGj7CcxjZ2Iy0LlOG5cZ
    happstack-server-7.9.3-2w1My6OV5pv28oIXKncPgS
    hoauth2-2.14.0-K78fiMYKK5W3eKwi5vxrdW
    hslogger-1.3.2.0-IhpivPgWtcx1ryOVbTDnai
    http-client-tls-0.3.6.4-C9vh29ljq9FHtoEMbpBYyb
    http-conduit-2.3.9.1-5y2Zd6e4KUv3WKM5rmfeZ8
    json-0.10-CVmt8wAUbKLCRDBxbUg8QP mtl-2.3.1
    network-3.1.4.0-IebBekr390i8Nw6inuvzzb
    network-bsd-2.8.1.0-5qoYeQ44n4L2jQi4qLTUb2
    network-uri-2.6.4.2-IQdxby3Fv1vL3jfFaSRPYt
    old-locale-1.0.0.7-Gunit3UBy5P9OGDVFY5MhC
    old-time-1.1.0.4-3lD0LwNFkdkGhWCMuxpBlx
    pandoc-3.4-2E1CWsHwYd4JPYRekgXb4N
    pandoc-types-1.23.1-EvvB1Sro1iZBgxxz3M0tjO parsec-3.1.16.1
    pretty-1.1.3.6 process-1.6.19.0
    random-1.2.1.3-C14Fl3rgvPx2fjwzAUclRk
    recaptcha-0.1.0.4-Iv6xCWmu6Vh1d0MidBGv9Y
    safe-0.3.21-J8yTbFjKPpT3oBMPyWIsQW
    skylighting-0.14.3-4t4VVhp7VVVJocJ9kwTalA
    split-0.2.5-KeBcC7WBTCHE2olxjxkqgK syb-0.7.3-MvqtDDcT2PHyhdKWhEKAp
    tagsoup-0.14.8-KVFHJLy1wUWCWr282Gb5Gp
    temporary-1.3-BNgycOdxWexDValYlv0b3b text-2.0.2 time-1.12.2
    uri-bytestring-0.3.3.1-HLp3KgqfrIuG1NSEl3UwPM
    url-2.1.3-6lCVh5KBkEyLo3Wl0jNv2j
    utf8-string-1.0.2-4PcjKdTUnsVIUZCxTUoFbK
    uuid-1.3.16-5fH18m9bDihDzTrO2jXEhv xhtml-3000.2.2.1
    xml-1.3.14-3CsuYrgQlhu1X5fBOwcswt
    xml-conduit-1.9.1.4-4egSc1tgxR2DRGp0ys5MCH
    xml-types-0.3.8-ISf6rjkeTjSFXsXdIGBwau
    xss-sanitize-0.3.7.2-4l1Lr8VBqqgK4SjPoJxe6Y
    zlib-0.7.0.0-GBD2OCBTLekFnb08cM0ZBB

haddock-interfaces:   /usr/share/doc/gitit/html/gitit.haddock
haddock-html:         /usr/share/doc/gitit/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

