#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-zjCM9P3WyaGTv04gJoI5c
key:                  glirc-2.40-zjCM9P3WyaGTv04gJoI5c
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  de0ab616fbd9e4f35fc744244bdce404
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-zjCM9P3WyaGTv04gJoI5c
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-HXooCNhjxUPBeXi8ZhiMVZ
    async-2.2.5-1OQdSrpaQikD5R3gghkNQo
    attoparsec-0.14.4-DGiM2cMH1LKFsy4siuUEV5 base-4.17.2.1
    base64-bytestring-1.2.1.0-JXBkDm4ttKKHxHDfgEAUvp
    bytestring-0.11.5.3 config-schema-1.3.0.0-4WPhDfqWjjGCat1voaQMvN
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8-BfS4HZNU38EFOIPL3U6wdP directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-3pNLUCadDUDI6UnmbEuzQl
    githash-0.1.6.3-BPndyrpx7os1V27mStUKTZ
    hashable-1.4.4.0-3qP5TxmiOmVGP173jSDFZO
    hookup-0.8-5GiSjpn6b1o9pdYkUuGDsi
    irc-core-2.12-9ndKM7DeJtTHAq9W59hgyq
    kan-extensions-5.2.6-8Os5HNafHqGFJhgRElojIL
    lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3
    network-3.1.4.0-ExLckjbUqaB9dQ68XDq8jI
    psqueues-0.2.8.1-1RC778fZ8zkljRuFFLO6z
    random-1.2.1.2-J6mYBSGGDLVAHQqGKIioSR
    regex-tdfa-1.3.2.2-D95SuRi2xoOHQuT5KVAOCg
    semigroupoids-6.0.0.1-GUkNESv7k4NIF0QikIaZGu
    split-0.2.5-KSNJtK4iVn96dAw1dg6ivl stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.11.1-A1lRJiHEFyHIgrzrvRJ9TV
    unix-2.7.3 unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj
    vector-0.13.1.0-3m7HMvWbOJNDnUiYgFdHrI
    vty-6.1-95w4bMyK5G6Dr2JLiCfCPH

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

