#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-7lr1bdYEoI3NesrWjON9T
key:                  glirc-2.40-7lr1bdYEoI3NesrWjON9T
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  7bf81adb7f314024b5aa3d7c6221a201
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-7lr1bdYEoI3NesrWjON9T
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-Csf3ccSUfEcCptzkvGvcZ4
    async-2.2.5-C82nSOzgP1IGLwyW5rdGdd
    attoparsec-0.14.4-GPSHKdrOxNAHtLNPx9PvVS base-4.17.2.1
    base64-bytestring-1.2.1.0-4fqTDsScuuX4b4re0JajdK
    bytestring-0.11.5.3 config-schema-1.3.0.0-GF1Sm2Rqahp35qJpQTEhkH
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8-BefaPhP8GAlLXAn4IX3tck directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-HhWVdOgT53PDesI8jmlVQC
    githash-0.1.6.3-3vcRf7hgbJ47LDacFT0SQm
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    hookup-0.8-9KUQzYGe5av4JGHuXL61Qz
    irc-core-2.12-5yRpzBbHiDNKfnCxuEm6Jt
    kan-extensions-5.2.6-2DC6czDLwl01MBOpMMKbfv
    lens-5.2.3-JlyZXwZS00NBv5ScwlVipn
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    psqueues-0.2.8.1-8U8VZXYCbTX2oFdgZWjXiI
    random-1.2.1.2-LUVepo9xpbYCdyIKOUBgF2
    regex-tdfa-1.3.2.2-Lx2wVcETmehVQz7NWfugc
    semigroupoids-6.0.0.1-7jmB6QISbXh15MEXUZPyZv
    split-0.2.5-1cvcRB3t1btB7X53ioPSfn stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.11.1-3S0MvfzaUHIG225I9c6Pmp
    unix-2.7.3 unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD
    vty-6.1-7sbdB0ou16a3rJ8cZdcBpj

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

