#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 glirc
version:              2.40
visibility:           public
id:                   glirc-2.40-9wsJLDz4i8RHpdEgfFLrmI
key:                  glirc-2.40-9wsJLDz4i8RHpdEgfFLrmI
license:              ISC
copyright:            2016-2019 Eric Mertens
maintainer:           emertens@gmail.com
author:               Eric Mertens
homepage:             https://github.com/glguy/irc-core
synopsis:             Console IRC client
description:
    Console IRC client

    glirc is a console IRC client with an emphasis on providing
    dynamic views into the model of your IRC connections.

    <https://github.com/glguy/irc-core/wiki Documentation Wiki>

category:             Network
abi:                  e757901f21b9743189c3ec35d0d4a1bc
exposed:              True
exposed-modules:
    Client.Authentication.Ecdh Client.Authentication.Ecdsa
    Client.Authentication.Scram Client.CApi Client.CApi.Exports
    Client.CApi.Types Client.Commands Client.Commands.Arguments.Parser
    Client.Commands.Arguments.Renderer Client.Commands.Arguments.Spec
    Client.Commands.Certificate Client.Commands.Channel
    Client.Commands.Chat Client.Commands.Connection
    Client.Commands.Exec Client.Commands.Interpolation
    Client.Commands.Operator Client.Commands.Queries
    Client.Commands.Recognizer Client.Commands.TabCompletion
    Client.Commands.Toggles Client.Commands.Types
    Client.Commands.Window Client.Commands.WordCompletion
    Client.Commands.ZNC Client.Configuration
    Client.Configuration.Colors Client.Configuration.Macros
    Client.Configuration.Notifications
    Client.Configuration.ServerSettings Client.Configuration.Sts
    Client.EventLoop Client.EventLoop.Actions Client.EventLoop.Errors
    Client.EventLoop.Network Client.Hook Client.Hook.DroneBLRelay
    Client.Hook.Matterbridge Client.Hook.Snotice
    Client.Hook.Znc.Buffextras Client.Hooks Client.Image
    Client.Image.Layout Client.Image.LineWrap Client.Image.Message
    Client.Image.MircFormatting Client.Image.PackedImage
    Client.Image.Palette Client.Image.StatusLine Client.Image.Textbox
    Client.Log Client.Mask Client.Message Client.Network.Async
    Client.Network.Connect Client.Options Client.State
    Client.State.Channel Client.State.EditBox
    Client.State.EditBox.Content Client.State.Extensions
    Client.State.Focus Client.State.Network Client.State.Url
    Client.State.Window Client.UserHost Client.View Client.View.Cert
    Client.View.ChannelInfo Client.View.ChannelList
    Client.View.Digraphs Client.View.Help Client.View.IgnoreList
    Client.View.KeyMap Client.View.MaskList Client.View.Mentions
    Client.View.Messages Client.View.Palette Client.View.RtsStats
    Client.View.UrlSelection Client.View.UserList Client.View.Who
    Client.View.Windows Client.WhoReply

hidden-modules:
    ContextFilter DigraphQuote Digraphs LensUtils RtsStats StrQuote
    StrictUnit Paths_glirc Build_glirc

import-dirs:          /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/glirc-2.40
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/glirc
hs-libraries:         HSglirc-2.40-9wsJLDz4i8RHpdEgfFLrmI
include-dirs:         /usr/lib/ghc-9.4.8/site-local/glirc-2.40/include
includes:             include/glirc-api.h
depends:
    HsOpenSSL-0.11.7.9-2jzkn0T9f0OCYFODYYTVs4
    async-2.2.5-HIvtQdOwlf5Hsyin6u1n7Q
    attoparsec-0.14.4-8RYxJQa7MEjKmC3I11Us4k base-4.17.2.1
    base64-bytestring-1.2.1.0-4q5KLdrxF6BHAwlK9Y3XXj
    bytestring-0.11.5.3 config-schema-1.3.0.0-3Pl0kAgpqe32Jqeluclzo8
    config-value-0.8.3-AwfdtSmE9Y1aqPSXDWTLH containers-0.6.7
    curve25519-0.2.8-HWRA6BSVZQEB7HAqzUTfJW directory-1.3.7.1
    filepath-1.4.2.2 free-5.2-Gzsvuh9K9ZrKY2SDVNWOVR
    githash-0.1.6.3-ALQm9y6B8xv7q7eiZRNwFf
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    hookup-0.8-4TnPDzjrt0FL75e6ERLM3F
    irc-core-2.12-ICiefQh1aqU7qjv4vRVFYG
    kan-extensions-5.2.6-4FKr1KjZx8Q6bz3x67BRhi
    lens-5.2.3-DnVNcFpsuwMCXFWImXsY2L
    network-3.1.4.0-7d91dIi13MzEkgRQe6YDcO
    psqueues-0.2.8.1-BmPfQ6Xl0r3FjxEaLQ3Wop
    random-1.2.1.2-2GxRLB29YjZ5Hmc9ZOWGpv
    regex-tdfa-1.3.2.3-ATHs20GYS4zCnV1KwOyBL0
    semigroupoids-6.0.1-KJLmU5mrNHLKm7QTvtklBq
    split-0.2.5-zycrG25TwZLo8bmb9YFUF stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2 time-1.12.2
    transformers-0.5.6.2 typed-process-0.2.12.0-5y1FGPn10tC6Eamo7ngqtl
    unix-2.7.3 unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O
    vty-6.1-JC0iQyseQyzA59mU4YJX0L

haddock-interfaces:   /usr/share/doc/glirc/html/glirc.haddock
haddock-html:         /usr/share/doc/glirc/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

