/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cc.impl.serialize;

import com.esotericsoftware.kryo.io.Output;
import java.io.OutputStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.graph.StringEncoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u0014\u0010\u0019\u001a\u00020\u000f*\u00020\r2\u0006\u0010\u0017\u001a\u00020\tH\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/gradle/internal/cc/impl/serialize/ParallelStringEncoder;", "Lorg/gradle/internal/serialize/graph/StringEncoder;", "stream", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "strings", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "nextId", "Ljava/util/concurrent/atomic/AtomicInteger;", "output", "Lcom/esotericsoftware/kryo/io/Output;", "writeNullableString", "", "encoder", "Lorg/gradle/internal/serialize/Encoder;", "string", "", "writeString", "close", "doWriteString", "id", "key", "writeStringId", "configuration-cache"})
public final class ParallelStringEncoder
implements StringEncoder {
    @NotNull
    private final ConcurrentHashMap<String, Integer> strings;
    @NotNull
    private AtomicInteger nextId;
    @NotNull
    private final Output output;

    public ParallelStringEncoder(@NotNull OutputStream stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.strings = new ConcurrentHashMap();
        this.nextId = new AtomicInteger(1);
        this.output = new Output(stream);
    }

    public void writeNullableString(@NotNull Encoder encoder, @Nullable CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        if (string == null) {
            encoder.writeSmallInt(0);
        } else {
            this.writeString(encoder, string);
        }
    }

    public void writeString(@NotNull Encoder encoder, @NotNull CharSequence string) {
        Intrinsics.checkNotNullParameter((Object)encoder, (String)"encoder");
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Integer n = this.strings.computeIfAbsent(((Object)string).toString(), new Function(this){
            final /* synthetic */ ParallelStringEncoder this$0;
            {
                this.this$0 = $receiver;
            }

            public final Integer apply(String key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                int id2 = ParallelStringEncoder.access$getNextId$p(this.this$0).getAndIncrement();
                ParallelStringEncoder.access$doWriteString(this.this$0, id2, key);
                return id2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
        int id2 = ((Number)n).intValue();
        encoder.writeSmallInt(id2);
    }

    public void close() {
        this.writeStringId(this.output, 0);
        this.output.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void doWriteString(int id2, String key) {
        Output output = this.output;
        synchronized (output) {
            boolean bl = false;
            this.writeStringId(this.output, id2);
            this.output.writeString(key);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void writeStringId(Output $this$writeStringId, int id2) {
        $this$writeStringId.writeVarInt(id2, true);
    }

    public static final /* synthetic */ AtomicInteger access$getNextId$p(ParallelStringEncoder $this) {
        return $this.nextId;
    }

    public static final /* synthetic */ void access$doWriteString(ParallelStringEncoder $this, int id2, String key) {
        $this.doWriteString(id2, key);
    }
}

