/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import java.time.Duration;
import org.apache.commons.lang3.StringUtils;
import org.gradle.internal.resource.transport.http.HttpTimeoutSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSystemPropertiesHttpTimeoutSettings
implements HttpTimeoutSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(JavaSystemPropertiesHttpTimeoutSettings.class);
    public static final String CONNECTION_TIMEOUT_SYSTEM_PROPERTY = "org.gradle.internal.http.connectionTimeout";
    public static final String SOCKET_TIMEOUT_SYSTEM_PROPERTY = "org.gradle.internal.http.socketTimeout";
    public static final String IDLE_CONNECTION_TIMEOUT_SYSTEM_PROPERTY = "org.gradle.internal.http.idleConnectionTimeout";
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 30000;
    public static final int DEFAULT_IDLE_CONNECTION_TIMEOUT = (int)Duration.ofMinutes(3L).toMillis();
    private final int connectionTimeoutMs = this.initTimeout("org.gradle.internal.http.connectionTimeout", 30000);
    private final int socketTimeoutMs = this.initTimeout("org.gradle.internal.http.socketTimeout", 30000);
    private final int idleConnectionTimeoutMs = this.initTimeout("org.gradle.internal.http.idleConnectionTimeout", DEFAULT_IDLE_CONNECTION_TIMEOUT);

    @Override
    public int getConnectionTimeoutMs() {
        return this.connectionTimeoutMs;
    }

    @Override
    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    @Override
    public int getIdleConnectionTimeoutMs() {
        return this.idleConnectionTimeoutMs;
    }

    private int initTimeout(String propertyName, int defaultValue) {
        String systemProperty = System.getProperty(propertyName);
        if (!StringUtils.isBlank((CharSequence)systemProperty)) {
            try {
                return Integer.parseInt(systemProperty);
            }
            catch (NumberFormatException e) {
                LOGGER.warn("Invalid value for java system property '{}': {}. Default timeout '{}' will be used.", new Object[]{propertyName, systemProperty, defaultValue});
            }
        }
        return defaultValue;
    }
}

