#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 aeson
version:              2.1.2.1
visibility:           public
id:                   aeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj
key:                  aeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj
license:              BSD-3-Clause
copyright:
    (c) 2011-2016 Bryan O'\''Sullivan
    (c) 2011 MailRank, Inc.

maintainer:           Adam Bergmark <adam@bergmark.nl>
author:               Bryan O'\''Sullivan <bos@serpentine.com>
stability:            experimental
homepage:             https://github.com/haskell/aeson
synopsis:             Fast JSON parsing and encoding
description:
    A JSON parsing and encoding library optimized for ease of use
    and high performance.

    To get started, see the documentation for the @Data.Aeson@ module
    below.

    (A note on naming: in Greek mythology, Aeson was the father of Jason.)

category:             Text, Web, JSON
abi:                  49b2222bd6f78f539cca56fb2525ec98
exposed:              True
exposed-modules:
    Data.Aeson Data.Aeson.Decoding Data.Aeson.Decoding.ByteString
    Data.Aeson.Decoding.ByteString.Lazy Data.Aeson.Decoding.Tokens
    Data.Aeson.Encoding Data.Aeson.Encoding.Internal
    Data.Aeson.Internal Data.Aeson.Internal.Time Data.Aeson.Key
    Data.Aeson.KeyMap Data.Aeson.Parser Data.Aeson.Parser.Internal
    Data.Aeson.QQ.Simple Data.Aeson.TH Data.Aeson.Text Data.Aeson.Types

hidden-modules:
    Data.Aeson.Decoding.Internal Data.Aeson.Encoding.Builder
    Data.Aeson.Internal.ByteString Data.Aeson.Internal.Functions
    Data.Aeson.Internal.Integer Data.Aeson.Internal.Text
    Data.Aeson.Internal.TH Data.Aeson.Internal.Word8
    Data.Aeson.Parser.Time Data.Aeson.Parser.Unescape
    Data.Aeson.Types.Class Data.Aeson.Types.FromJSON
    Data.Aeson.Types.Generic Data.Aeson.Types.Internal
    Data.Aeson.Types.ToJSON Data.Attoparsec.Time
    Data.Attoparsec.Time.Internal Data.Aeson.Parser.UnescapePure

import-dirs:          /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/aeson-2.1.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-aeson
hs-libraries:         HSaeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj
depends:
    OneTuple-0.4.2-8zPraw5vLCQDdekNhkjOJE
    QuickCheck-2.14.3-6d1PIKLXLdiAlrbWNDjj9l
    attoparsec-0.14.4-8RYxJQa7MEjKmC3I11Us4k base-4.17.2.1
    base-compat-batteries-0.12.2-36igse6rdIdBbU6JcQRRPe
    bytestring-0.11.5.3 containers-0.6.7
    data-fix-0.3.3-1xrLcRXcGoAEy8ltTVfrkV deepseq-1.4.8.0
    dlist-1.0-I6FB5Nlk17hG16fxQzZSEb exceptions-0.10.5
    generically-0.1.1-FCo2PB10tCP3aBbYmyfCIL ghc-prim-0.9.1
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    indexed-traversable-0.1.4-AIrw26zjgKT4obC66VIWQz
    primitive-0.8.0.0-CgxKCR9ULfZ73CnNdOTvCD
    scientific-0.3.7.0-BkypiqTAkpN3suN2c81wMx
    semialign-1.3-7FNiLULDu9HLBvM6gONS63
    strict-0.5-4YIKjr8Hi454ypMcDfsmgm
    tagged-0.8.9-KMS3sfDasKWItFZcxfaN6C template-haskell-2.19.0.0
    text-2.0.2 text-short-0.1.6-twjb12lbHdEtDXZKcEsva
    th-abstraction-0.4.5.0-EtQVnbIEkAX5f6KN9Uwjhw
    these-1.2-FJpJ4Y80QbS4FsZ2fGftoO time-1.12.2
    time-compat-1.9.6.1-5XEWto2WHcACDPQKihpICz
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    uuid-types-1.0.6-D5yfte8gZaD2fsaKfuenjE
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O
    witherable-0.4.2-I2v0inbLoEA5X66gCoetRe

haddock-interfaces:   /usr/share/doc/haskell-aeson/html/aeson.haddock
haddock-html:         /usr/share/doc/haskell-aeson/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

