#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 algebraic-graphs
version:              0.7
visibility:           public
id:                   algebraic-graphs-0.7-Hw3tpXFLE1e2azH9uAL8Dd
key:                  algebraic-graphs-0.7-Hw3tpXFLE1e2azH9uAL8Dd
license:              MIT
copyright:            Andrey Mokhov, 2016-2022
maintainer:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard,
    Alexandre Moine <alexandre@moine.me>, github: @nobrakal

author:
    Andrey Mokhov <andrey.mokhov@gmail.com>, github: @snowleopard

homepage:             https://github.com/snowleopard/alga
synopsis:
    A library for algebraic graph construction and transformation

description:
    <https://github.com/snowleopard/alga Alga> is a library for algebraic construction and
    manipulation of graphs in Haskell. See <https://github.com/snowleopard/alga-paper this paper>
    for the motivation behind the library, the underlying theory and implementation details.

    The top-level module
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph.html Algebra.Graph>
    defines the main data type for /algebraic graphs/
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph.html#t:Graph Graph>,
    as well as associated algorithms. For type-safe representation and
    manipulation of /non-empty algebraic graphs/, see
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-NonEmpty.html Algebra.Graph.NonEmpty>.
    Furthermore, /algebraic graphs with edge labels/ are implemented in
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Labelled.html Algebra.Graph.Labelled>.

    The library also provides conventional graph data structures, such as
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-AdjacencyMap.html Algebra.Graph.AdjacencyMap>
    along with its various flavours:

    * adjacency maps specialised to graphs with vertices of type '\''Int'\''
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-AdjacencyIntMap.html Algebra.Graph.AdjacencyIntMap>),
    * non-empty adjacency maps
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-NonEmpty-AdjacencyMap.html Algebra.Graph.NonEmpty.AdjacencyMap>),
    * adjacency maps for undirected bipartite graphs
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Bipartite-AdjacencyMap.html Algebra.Graph.Bipartite.AdjacencyMap>),
    * adjacency maps with edge labels
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Labelled-AdjacencyMap.html Algebra.Graph.Labelled.AdjacencyMap>),
    * acyclic adjacency maps
    (<http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Acyclic-AdjacencyMap.html Algebra.Graph.Acyclic.AdjacencyMap>),

    A large part of the API of algebraic graphs and adjacency maps is available
    through the '\''Foldable'\''-like type class
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-ToGraph.html Algebra.Graph.ToGraph>.

    The type classes defined in
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-Class.html Algebra.Graph.Class>
    and
    <http://hackage.haskell.org/package/algebraic-graphs/docs/Algebra-Graph-HigherKinded-Class.html Algebra.Graph.HigherKinded.Class>
    can be used for polymorphic construction and manipulation of graphs.

    This is an experimental library and the API is expected to remain unstable until version 1.0.0.
    Please consider contributing to the on-going
    <https://github.com/snowleopard/alga/issues discussions on the library API>.

category:             Algebra, Algorithms, Data Structures, Graphs
abi:                  0c684f1d47c28bca143f25943eb915dd
exposed:              True
exposed-modules:
    Algebra.Graph Algebra.Graph.Acyclic.AdjacencyMap
    Algebra.Graph.AdjacencyIntMap
    Algebra.Graph.AdjacencyIntMap.Algorithm Algebra.Graph.AdjacencyMap
    Algebra.Graph.AdjacencyMap.Algorithm
    Algebra.Graph.Bipartite.AdjacencyMap
    Algebra.Graph.Bipartite.AdjacencyMap.Algorithm Algebra.Graph.Class
    Algebra.Graph.Example.Todo Algebra.Graph.Export
    Algebra.Graph.Export.Dot Algebra.Graph.HigherKinded.Class
    Algebra.Graph.Internal Algebra.Graph.Label Algebra.Graph.Labelled
    Algebra.Graph.Labelled.AdjacencyMap
    Algebra.Graph.Labelled.Example.Automaton
    Algebra.Graph.Labelled.Example.Network Algebra.Graph.NonEmpty
    Algebra.Graph.NonEmpty.AdjacencyMap Algebra.Graph.Relation
    Algebra.Graph.Relation.Preorder Algebra.Graph.Relation.Reflexive
    Algebra.Graph.Relation.Symmetric Algebra.Graph.Relation.Transitive
    Algebra.Graph.ToGraph Algebra.Graph.Undirected Data.Graph.Typed

import-dirs:          /usr/lib/ghc-9.4.8/site-local/algebraic-graphs-0.7
library-dirs:         /usr/lib/ghc-9.4.8/site-local/algebraic-graphs-0.7
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/algebraic-graphs-0.7
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-algebraic-graphs
hs-libraries:         HSalgebraic-graphs-0.7-Hw3tpXFLE1e2azH9uAL8Dd
depends:
    array-0.5.4.0 base-4.17.2.1 containers-0.6.7 deepseq-1.4.8.0
    transformers-0.5.6.2

haddock-interfaces:
    /usr/share/doc/haskell-algebraic-graphs/html/algebraic-graphs.haddock

haddock-html:         /usr/share/doc/haskell-algebraic-graphs/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

