#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 arithmoi
version:              0.13.0.1
visibility:           public
id:                   arithmoi-0.13.0.1-4b45wgqoSeRGNHpNyDBsqx
key:                  arithmoi-0.13.0.1-4b45wgqoSeRGNHpNyDBsqx
license:              MIT
copyright:
    (c) 2016-2021 Andrew Lelechenko, 2016-2019 Carter Schonwald, 2011 Daniel Fischer

maintainer:           Andrew Lelechenko <andrew.lelechenko@gmail.com>
author:               Andrew Lelechenko, Daniel Fischer
homepage:             https://github.com/Bodigrim/arithmoi
synopsis:             Efficient basic number-theoretic functions.
description:
    A library of basic functionality needed for
    number-theoretic calculations. The aim of this library
    is to provide efficient implementations of the functions.
    Primes and related things (totients, factorisation),
    powers (integer roots and tests, modular exponentiation).

category:             Math, Algorithms, Number Theory
abi:                  a4e24112ee74b89fc59b2042dee2f69d
exposed:              True
exposed-modules:
    Math.NumberTheory.ArithmeticFunctions
    Math.NumberTheory.ArithmeticFunctions.Inverse
    Math.NumberTheory.ArithmeticFunctions.Mertens
    Math.NumberTheory.ArithmeticFunctions.Moebius
    Math.NumberTheory.ArithmeticFunctions.NFreedom
    Math.NumberTheory.ArithmeticFunctions.SieveBlock
    Math.NumberTheory.Curves.Montgomery Math.NumberTheory.Diophantine
    Math.NumberTheory.DirichletCharacters
    Math.NumberTheory.Euclidean.Coprimes Math.NumberTheory.Moduli
    Math.NumberTheory.Moduli.Cbrt Math.NumberTheory.Moduli.Chinese
    Math.NumberTheory.Moduli.Class Math.NumberTheory.Moduli.Equations
    Math.NumberTheory.Moduli.Multiplicative
    Math.NumberTheory.Moduli.Singleton Math.NumberTheory.Moduli.Sqrt
    Math.NumberTheory.MoebiusInversion Math.NumberTheory.Prefactored
    Math.NumberTheory.Primes Math.NumberTheory.Primes.Counting
    Math.NumberTheory.Primes.IntSet Math.NumberTheory.Primes.Testing
    Math.NumberTheory.Quadratic.EisensteinIntegers
    Math.NumberTheory.Quadratic.GaussianIntegers
    Math.NumberTheory.Recurrences
    Math.NumberTheory.Recurrences.Bilinear
    Math.NumberTheory.Recurrences.Linear
    Math.NumberTheory.SmoothNumbers Math.NumberTheory.Zeta

hidden-modules:
    Math.NumberTheory.ArithmeticFunctions.Class
    Math.NumberTheory.ArithmeticFunctions.Standard
    Math.NumberTheory.Moduli.Internal
    Math.NumberTheory.Moduli.JacobiSymbol
    Math.NumberTheory.Moduli.SomeMod
    Math.NumberTheory.Primes.Counting.Approximate
    Math.NumberTheory.Primes.Counting.Impl
    Math.NumberTheory.Primes.Factorisation.Montgomery
    Math.NumberTheory.Primes.Factorisation.TrialDivision
    Math.NumberTheory.Primes.Sieve.Eratosthenes
    Math.NumberTheory.Primes.Sieve.Indexing
    Math.NumberTheory.Primes.Small
    Math.NumberTheory.Primes.Testing.Certified
    Math.NumberTheory.Primes.Testing.Probabilistic
    Math.NumberTheory.Primes.Types
    Math.NumberTheory.Recurrences.Pentagonal
    Math.NumberTheory.RootsOfUnity Math.NumberTheory.Utils
    Math.NumberTheory.Utils.DirichletSeries
    Math.NumberTheory.Utils.FromIntegral
    Math.NumberTheory.Utils.Hyperbola Math.NumberTheory.Zeta.Dirichlet
    Math.NumberTheory.Zeta.Hurwitz Math.NumberTheory.Zeta.Riemann
    Math.NumberTheory.Zeta.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/arithmoi-0.13.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-arithmoi
hs-libraries:         HSarithmoi-0.13.0.1-4b45wgqoSeRGNHpNyDBsqx
depends:
    array-0.5.4.0 base-4.17.2.1 chimera-0.4.1.0-1QvJ5g0C1N3FpsIl0knhyZ
    constraints-0.13.4-9t7M4RAom435nssV0Rpobx containers-0.6.7
    deepseq-1.4.8.0 exact-pi-0.5.0.2-3sspjcVVHYiBveSjknYzZC
    ghc-bignum-1.3 infinite-list-0.1.2-LPBe5hh42yV5YtxXePxUvv
    integer-logarithms-1.0.3.1-JfoQIJXh5PhDnmGGlkJE4T
    integer-roots-1.0.2.0-Jao0I9pGsa4E7RuIeQNy25
    mod-0.2.0.1-AfHuOcNqjz072esMCQmeTm
    random-1.2.1.2-2GxRLB29YjZ5Hmc9ZOWGpv
    semirings-0.6-4FtcNFGmwd27dkHmyIgA5A transformers-0.5.6.2
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:   /usr/share/doc/haskell-arithmoi/html/arithmoi.haddock
haddock-html:         /usr/share/doc/haskell-arithmoi/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

