#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 asn1-encoding
version:              0.9.6
visibility:           public
id:                   asn1-encoding-0.9.6-AdJ5yV3qAg5B42gEeXR6jO
key:                  asn1-encoding-0.9.6-AdJ5yV3qAg5B42gEeXR6jO
license:              BSD-3-Clause
copyright:            Vincent Hanquez <vincent@snarc.org>
maintainer:           vincent@snarc.org
author:               Vincent Hanquez <vincent@snarc.org>
stability:            experimental
homepage:             https://github.com/vincenthz/hs-asn1
synopsis:             ASN1 data reader and writer in RAW, BER and DER forms
description:
    ASN1 data reader and writer in raw form with supports for high level forms of ASN1 (BER, and DER).

category:             Data
abi:                  1ee4f871e4cd4b4db7d5d7a7090a6207
exposed:              True
exposed-modules:
    Data.ASN1.BinaryEncoding Data.ASN1.BinaryEncoding.Raw
    Data.ASN1.Encoding Data.ASN1.Error Data.ASN1.Object Data.ASN1.Prim
    Data.ASN1.Stream

hidden-modules:
    Data.ASN1.BinaryEncoding.Parse Data.ASN1.BinaryEncoding.Writer
    Data.ASN1.Internal Data.ASN1.Serialize Data.ASN1.Get

import-dirs:          /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
library-dirs:         /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/asn1-encoding-0.9.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-asn1-encoding
hs-libraries:         HSasn1-encoding-0.9.6-AdJ5yV3qAg5B42gEeXR6jO
depends:
    asn1-types-0.3.4-9xWSik4JBUzIO7zsNif5EI base-4.17.2.1
    bytestring-0.11.5.3 hourglass-0.2.12-AyVBqyOLmN8KoZGtIDPsMe

haddock-interfaces:
    /usr/share/doc/haskell-asn1-encoding/html/asn1-encoding.haddock

haddock-html:         /usr/share/doc/haskell-asn1-encoding/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

