#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 bin
version:              0.1.4
visibility:           public
id:                   bin-0.1.4-5WUu4hZlVLoL1Y1H11TMjN
key:                  bin-0.1.4-5WUu4hZlVLoL1Y1H11TMjN
license:              GPL-2.0-or-later
copyright:            (c) 2019-2021 Oleg Grenrus
maintainer:           Oleg.Grenrus <oleg.grenrus@iki.fi>
author:               Oleg Grenrus <oleg.grenrus@iki.fi>
homepage:             https://github.com/phadej/vec
synopsis:             Bin: binary natural numbers.
description:
    This package provides /binary natural numbers/ ("Data.Bin");
    also utilities to work on the type level with @DataKinds@ ("Data.Type.Bin").

    @
    data Bin
    \    = BZ       -- ^ zero
    \    | BP BinP  -- ^ non-zero

    data BinP
    \    = BE       -- ^ one
    \    | B0 BinP  -- ^ double
    \    | B1 BinP  -- ^ double plus 1
    @

    There are /ordinals/ in "Data.Bin.Pos" module, as well as
    fixed width integers in "Data.Wrd".

    Another implementation is at <https://hackage.haskell.org/package/nat>,
    this differs in naming, and provides promoted variant.

category:             Data, Dependent Types, Singletons, Math
abi:                  2bc8d20eda1f53f7915a26f32c300800
exposed:              True
exposed-modules:
    Data.Bin Data.Bin.Pos Data.BinP Data.BinP.PosP Data.Type.Bin
    Data.Type.BinP Data.Wrd

hidden-modules:       TrustworthyCompat
import-dirs:          /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/bin-0.1.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-bin
hs-libraries:         HSbin-0.1.4-5WUu4hZlVLoL1Y1H11TMjN
depends:
    QuickCheck-2.15.0.1-JsWG6I4IuTa3MyVRCp1l9o base-4.18.2.1
    boring-0.2.2-2aq1ciWPNkQB31v6aiIRKA
    dec-0.0.6-263DLNY3k7iJhcZSv4mNkm deepseq-1.4.8.1
    fin-0.3.2-7cyfNfGUVusL3WInBGjtns
    hashable-1.4.7.0-AkdCWGE5Cqm4vrMrQip090
    some-1.0.6-cBl1TQWrgGHtAYCHe6T1Z

haddock-interfaces:   /usr/share/doc/haskell-bin/html/bin.haddock
haddock-html:         /usr/share/doc/haskell-bin/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

