#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              1.8
visibility:           public
id:                   brick-1.8-7mexeqeaXci8TzXpF2TO5Q
key:                  brick-1.8-7mexeqeaXci8TzXpF2TO5Q
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  cbd08cabe7fb7ae47af2030b3e18d6db
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Parse Brick.Keybindings.Pretty Brick.Main
    Brick.Themes Brick.Types Brick.Util Brick.Widgets.Border
    Brick.Widgets.Border.Style Brick.Widgets.Center Brick.Widgets.Core
    Brick.Widgets.Dialog Brick.Widgets.Edit Brick.Widgets.FileBrowser
    Brick.Widgets.List Brick.Widgets.ProgressBar Brick.Widgets.Table
    Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-1.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-1.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-1.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-1.8-7mexeqeaXci8TzXpF2TO5Q
depends:
    base-4.17.2.1 bimap-0.5.0-CmtZxm0wY1PE5OtSalzGUB
    bytestring-0.11.5.3 config-ini-0.2.6.0-znqm2S4iL87J2FFup5zLQ
    containers-0.6.7 data-clist-0.2-IBWSZhcrx2iI3guHgUuZON
    deepseq-1.4.8.0 directory-1.3.7.1 exceptions-0.10.5
    filepath-1.4.2.2 microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO mtl-2.2.2 stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-8iNIVGlg4tKLdSuRJHjwxm unix-2.7.3
    vector-0.13.1.0-DP5vqiFKsIZ25TyoutQAjD
    vty-5.39-D4IQ5SMIqe3J0MlIWbKalt
    word-wrap-0.5-8COyVfO9Q3h9FIlQrxf8jm

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

