#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              2.4
visibility:           public
id:                   brick-2.4-98pH21XT3Y1KpnRrz8FV12
key:                  brick-2.4-98pH21XT3Y1KpnRrz8FV12
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2024
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  55ba0f0e15574b5d3159e9455212aad8
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Keybindings Brick.Keybindings.KeyConfig
    Brick.Keybindings.KeyDispatcher Brick.Keybindings.KeyEvents
    Brick.Keybindings.Normalize Brick.Keybindings.Parse
    Brick.Keybindings.Pretty Brick.Main Brick.Themes Brick.Types
    Brick.Util Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.EventM
    Brick.Types.Internal Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.6.6/site-local/brick-2.4
library-dirs:         /usr/lib/ghc-9.6.6/site-local/brick-2.4
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/brick-2.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick
hs-libraries:         HSbrick-2.4-98pH21XT3Y1KpnRrz8FV12
depends:
    base-4.18.2.1 bimap-0.5.0-HVeFhXHg4Ht7imLVIoLF2l
    bytestring-0.11.5.3 config-ini-0.2.7.0-8e2Ogjle9eJAT46o0H8nLV
    containers-0.6.7 data-clist-0.2-8w3Jo7SUg3CLI4c6wIkI6u
    deepseq-1.4.8.1 directory-1.3.8.5 exceptions-0.10.7
    filepath-1.4.300.1 microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-mtl-0.2.1.0-Ewo8HmKpWhTASatFX3KZGS
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1 stm-2.5.1.0
    template-haskell-2.20.0.0 text-2.0.2
    text-zipper-0.13-A8svStPSesC1Y64LYH7qre
    unix-compat-0.7.4.1-HX6CmWtGzNSCIQWePfXCFw
    vector-0.13.2.0-JoP5POFPMLsLn1of7TvjGI
    vty-6.2-INuzoHGEuLa5SMM40Z8Lln
    vty-crossplatform-0.4.0.0-JXeczINCqpc7njmMYOsM3T
    word-wrap-0.5-DXMEcpb3fSkLBynYecHCcY

haddock-interfaces:   /usr/share/doc/haskell-brick/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

