#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 brick
version:              0.71.1
visibility:           public
id:                   brick-0.71.1-6b4z67wapdt5cGvK6pDaXM
key:                  brick-0.71.1-6b4z67wapdt5cGvK6pDaXM
license:              BSD-3-Clause
copyright:            (c) Jonathan Daugherty 2015-2022
maintainer:           Jonathan Daugherty <cygnus@foobox.com>
author:               Jonathan Daugherty <cygnus@foobox.com>
homepage:             https://github.com/jtdaugherty/brick/
synopsis:             A declarative terminal user interface library
description:
    Write terminal user interfaces (TUIs) painlessly with '\''brick'\''! You
    write an event handler and a drawing function and the library does the
    rest.


    > module Main where
    >
    > import Brick
    >
    > ui :: Widget ()
    > ui = str "Hello, world!"
    >
    > main :: IO ()
    > main = simpleMain ui


    To get started, see:

    * <https://github.com/jtdaugherty/brick/blob/master/README.md The README>

    * The <https://github.com/jtdaugherty/brick/blob/master/docs/guide.rst Brick user guide>

    * The demonstration programs in the '\''programs'\'' directory


    This package deprecates <http://hackage.haskell.org/package/vty-ui vty-ui>.

category:             Graphics
abi:                  f57c009fba487fe529f875deb6cc4093
exposed:              True
exposed-modules:
    Brick Brick.AttrMap Brick.BChan Brick.BorderMap Brick.Focus
    Brick.Forms Brick.Main Brick.Themes Brick.Types Brick.Util
    Brick.Widgets.Border Brick.Widgets.Border.Style
    Brick.Widgets.Center Brick.Widgets.Core Brick.Widgets.Dialog
    Brick.Widgets.Edit Brick.Widgets.FileBrowser Brick.Widgets.List
    Brick.Widgets.ProgressBar Brick.Widgets.Table Data.IMap

hidden-modules:
    Brick.Types.Common Brick.Types.TH Brick.Types.Internal
    Brick.Widgets.Internal

import-dirs:          /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/brick-0.71.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-brick0.71
hs-libraries:         HSbrick-0.71.1-6b4z67wapdt5cGvK6pDaXM
depends:
    base-4.17.2.1 bytestring-0.11.5.3
    config-ini-0.2.6.0-15h9OwDfb7c4rMBSkBTyjD containers-0.6.7
    contravariant-1.5.5-p3peIMeiUA4Z37z2EtgYi
    data-clist-0.2-8XZU62q5m48CqnNg58Ezhe deepseq-1.4.8.0
    directory-1.3.7.1 dlist-1.0-I6FB5Nlk17hG16fxQzZSEb
    exceptions-0.10.5 filepath-1.4.2.2
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-mtl-0.2.0.3-vQELA1onhlLfPXHvjZtx7
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO stm-2.5.1.0
    template-haskell-2.19.0.0 text-2.0.2
    text-zipper-0.13-CubcuHAHc3T6dmW0zc5jyP transformers-0.5.6.2
    unix-2.7.3 vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX
    vty-5.39-CiU94786em4Lr8oKi5l4dG
    word-wrap-0.5-CLFbg9ZDn1vJTv1vptBR82

haddock-interfaces:   /usr/share/doc/haskell-brick0.71/html/brick.haddock
haddock-html:         /usr/share/doc/haskell-brick0.71/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

