#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 chimera
version:              0.4.1.0
visibility:           public
id:                   chimera-0.4.1.0-1QvJ5g0C1N3FpsIl0knhyZ
key:                  chimera-0.4.1.0-1QvJ5g0C1N3FpsIl0knhyZ
license:              BSD-3-Clause
copyright:            2017-2019 Bodigrim
maintainer:           andrew.lelechenko@gmail.com
author:               Bodigrim
homepage:             https://github.com/Bodigrim/chimera#readme
synopsis:
    Lazy infinite streams with O(1) indexing and applications for memoization

description:
    There are plenty of memoizing libraries on Hackage, but they
    usually fall into two categories:

    * Store cache as a flat array, enabling us
    to obtain cached values in O(1) time, which is nice.
    The drawback is that one must specify the size
    of the array beforehand,
    limiting an interval of inputs,
    and actually allocate it at once.
    * Store cache as a lazy binary tree.
    Thanks to laziness, one can freely use the full range of inputs.
    The drawback is that obtaining values from a tree
    takes logarithmic time and is unfriendly to CPU cache,
    which kinda defeats the purpose.

    This package intends to tackle both issues,
    providing a data type '\''Chimera'\'' for
    lazy infinite compact streams with cache-friendly O(1) indexing.

    Additional features include:

    * memoization of recursive functions and recurrent sequences,
    * memoization of functions of several, possibly signed arguments,
    * efficient memoization of boolean predicates.

category:             Data
abi:                  96c927199cd87f7f0e157a28eb5e540d
exposed:              True
exposed-modules:
    Data.Chimera Data.Chimera.ContinuousMapping
    Data.Chimera.WheelMapping

hidden-modules:
    Data.Chimera.Compat Data.Chimera.FromIntegral Data.Chimera.Internal
    Data.Chimera.Memoize

import-dirs:          /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/chimera-0.4.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-chimera
hs-libraries:         HSchimera-0.4.1.0-1QvJ5g0C1N3FpsIl0knhyZ
depends:
    adjunctions-4.4.2-LM47uNV7XKM7r8WwLHNHoZ base-4.17.2.1
    distributive-0.6.2.1-2YiBzgLXCd2kHPlGPsZiv
    infinite-list-0.1.2-LPBe5hh42yV5YtxXePxUvv mtl-2.2.2
    primitive-0.8.0.0-CgxKCR9ULfZ73CnNdOTvCD transformers-0.5.6.2
    vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O

haddock-interfaces:   /usr/share/doc/haskell-chimera/html/chimera.haddock
haddock-html:         /usr/share/doc/haskell-chimera/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

