#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 z-haskell-ci-z-haskell-ci-internal
version:              0.16
package-name:         haskell-ci
lib-name:             haskell-ci-internal
id:                   haskell-ci-0.16-40HJ1iOyyGzDW5eArCKe0e-haskell-ci-internal
key:                  haskell-ci-0.16-40HJ1iOyyGzDW5eArCKe0e-haskell-ci-internal
license:              GPL-3.0-or-later
maintainer:           hvr@gnu.org
author:               Herbert Valerio Riedel, Oleg Grenrus
homepage:             https://haskell-ci.rtfd.org/
synopsis:             Cabal package script generator for Travis-CI
description:
    Script generator (@haskell-ci@) for
    [GitHub Actions](https://docs.github.com/en/actions) and
    [Travis-CI](https://travis-ci.org/)
    for continuous-integration testing of Haskell Cabal packages.

    Included features (not limited to):

    * Multiple GHC support
    * Dependency caching
    * cabal.project support (see [Nix-style local builds documentation](https://cabal.readthedocs.io/en/latest/nix-local-build-overview.html))
    * Runs tests and builds benchmarks
    * Generates Haddocks
    * GHCJS support
    * building with specific constraints

    === Quick Start Guide

    Add a @tested-with@ line to your @.cabal@ file (e.g. @tested-with: GHC == 8.0.2 || == 8.2.2@) and then run @haskell-ci yourpackage.cabal -o .travis.yml@ to generate the Travis-CI job script.

    See @haskell-ci --help@ for more information.

category:             Development
abi:                  1cd0043cfc6522d90b2b92df793a5253
exposed-modules:
    HaskellCI HaskellCI.Auxiliary HaskellCI.Bash
    HaskellCI.Bash.Template HaskellCI.Cabal HaskellCI.Cli
    HaskellCI.Compiler HaskellCI.Config HaskellCI.Config.Components
    HaskellCI.Config.ConstraintSet HaskellCI.Config.CopyFields
    HaskellCI.Config.Docspec HaskellCI.Config.Doctest
    HaskellCI.Config.Dump HaskellCI.Config.Empty HaskellCI.Config.Folds
    HaskellCI.Config.HLint HaskellCI.Config.Installed
    HaskellCI.Config.Jobs HaskellCI.Config.PackageScope
    HaskellCI.Config.Ubuntu HaskellCI.Config.Validity
    HaskellCI.Diagnostics HaskellCI.Error HaskellCI.Ghcup
    HaskellCI.GitConfig HaskellCI.GitHub HaskellCI.GitHub.Yaml
    HaskellCI.HeadHackage HaskellCI.Jobs HaskellCI.List
    HaskellCI.MonadErr HaskellCI.Newtypes HaskellCI.OptionsGrammar
    HaskellCI.OptparseGrammar HaskellCI.Package HaskellCI.ParsecUtils
    HaskellCI.Prelude HaskellCI.Sh HaskellCI.ShVersionRange
    HaskellCI.TestedWith HaskellCI.Tools HaskellCI.Travis
    HaskellCI.Travis.Yaml HaskellCI.VersionInfo HaskellCI.YamlSyntax

import-dirs:          /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16
library-dirs:         /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/haskell-ci-0.16
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-ci
hs-libraries:
    HShaskell-ci-0.16-40HJ1iOyyGzDW5eArCKe0e-haskell-ci-internal

depends:
    Cabal-syntax-3.8.1.0 HsYAML-0.2.1.3-6RO3EH9K4lbCFqFZlQZbNr
    ShellCheck-0.10.0-Pw4wcZCyU8FSP8VKTlmBw
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3
    attoparsec-0.14.4-GPSHKdrOxNAHtLNPx9PvVS base-4.17.2.1
    base-compat-0.12.2-3peTS4EQIw912qC0ETmbL5
    base16-bytestring-1.0.2.0-KDSFpGK70SNFrMbzTIS4T1 binary-0.8.9.1
    bytestring-0.11.5.3
    cabal-install-parsers-0.6-KrsFuV9eUHQBu8jMT4Qzqs containers-0.6.7
    cryptohash-sha256-0.11.102.1-J67TLWTxrj33yKHRpICwc7 deepseq-1.4.8.0
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    generic-lens-lite-0.1.1-fdAG00wdys4njg4MryBwd
    indexed-traversable-0.1.4-3wYYO2pxMt36ZUEwKa9bh7
    indexed-traversable-instances-0.1.2-E04r5Pz2HrVD44Z3MLL9iO
    ini-0.4.2-JdtGu4YhpXvL1nDvdpLXA5
    lattices-2.2-IJQqgJxSDIi1u2FL4sKFGa mtl-2.2.2
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    optparse-applicative-0.17.1.0-3m15PZJ9R8tLZfnW85Yn0z
    parsec-3.1.16.1 pretty-1.1.3.6 process-1.6.18.0
    temporary-1.3-DSwRVjKLwjO89xYYcHNeSA text-2.0.2
    transformers-0.5.6.2
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    zinza-0.2-GBdNaEEif6t8uuWT6k4Tw7

haddock-interfaces:   /usr/share/doc/haskell-ci/html/haskell-ci.haddock
haddock-html:         /usr/share/doc/haskell-ci/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

