#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 conduit
version:              1.3.6.1
visibility:           public
id:                   conduit-1.3.6.1-I25roZFZ9rtE9pq7CzsSgq
key:                  conduit-1.3.6.1-I25roZFZ9rtE9pq7CzsSgq
license:              MIT
maintainer:           michael@snoyman.com
author:               Michael Snoyman
homepage:             http://github.com/snoyberg/conduit
synopsis:             Streaming data processing library.
description:
    `conduit` is a solution to the streaming data problem, allowing for production,
    transformation, and consumption of streams of data in constant memory. It is an
    alternative to lazy I\/O which guarantees deterministic resource handling.

    For more information about conduit in general, and how this package in
    particular fits into the ecosystem, see [the conduit
    homepage](https://github.com/snoyberg/conduit#readme).

    Hackage documentation generation is not reliable. For up to date documentation, please see: <http://www.stackage.org/package/conduit>.

category:             Data, Conduit
abi:                  8cb18a8933cddd15dc9ea94580c9ad40
exposed:              True
exposed-modules:
    Conduit Data.Conduit Data.Conduit.Combinators
    Data.Conduit.Combinators.Stream Data.Conduit.Internal
    Data.Conduit.Internal.Fusion Data.Conduit.Internal.List.Stream
    Data.Conduit.Lift Data.Conduit.List

hidden-modules:
    Data.Conduit.Internal.Pipe Data.Conduit.Internal.Conduit
    Data.Conduit.Combinators.Unqualified Data.Streaming.FileRead
    Data.Streaming.Filesystem

import-dirs:          /usr/lib/ghc-9.4.8/site-local/conduit-1.3.6.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/conduit-1.3.6.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/conduit-1.3.6.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-conduit
hs-libraries:         HSconduit-1.3.6.1-I25roZFZ9rtE9pq7CzsSgq
depends:
    base-4.17.2.1 bytestring-0.11.5.3 directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2
    mono-traversable-1.0.21.0-FcmFHeyT6qFIGqC2SEsEjv mtl-2.2.2
    primitive-0.7.4.0-K4IT7bUBj0c2CIJh0yt8eH
    resourcet-1.2.6-Emy1WDuYe6W3crmrzZuLqP text-2.0.2
    transformers-0.5.6.2 unix-2.7.3
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX

haddock-interfaces:   /usr/share/doc/haskell-conduit/html/conduit.haddock
haddock-html:         /usr/share/doc/haskell-conduit/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

