#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 edit-distance-vector
version:              1.0.0.4
visibility:           public
id:                   edit-distance-vector-1.0.0.4-51xGB1gOQRl8lp0kTsFSna
key:                  edit-distance-vector-1.0.0.4-51xGB1gOQRl8lp0kTsFSna
license:              BSD-3-Clause
copyright:            (c) 2015 Thomas Sutton and others.
maintainer:           me@thomas-sutton.id.au
author:               Thomas Sutton
homepage:             https://github.com/thsutton/edit-distance-vector
synopsis:             Calculate edit distances and edit scripts between vectors.
description:
    An implementation of the Wagner–Fischer dynamic programming algorithm to
    find the optimal edit script and cost between two sequences.

    The implementation in this package is specialised to sequences represented
    with "Data.Vector" but is otherwise agnostic to:

    * The type of values in the vectors;

    * The type representing edit operations; and

    * The type representing the cost of operations.

category:             Data, Data Structures, Algorithms
abi:                  6eaa3f290d14160e6838d0740406a941
exposed:              True
exposed-modules:      Data.Vector.Distance
import-dirs:          /usr/lib/ghc-9.4.8/site-local/edit-distance-vector-1.0.0.4
library-dirs:         /usr/lib/ghc-9.4.8/site-local/edit-distance-vector-1.0.0.4
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/edit-distance-vector-1.0.0.4
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-edit-distance-vector
hs-libraries:         HSedit-distance-vector-1.0.0.4-51xGB1gOQRl8lp0kTsFSna
depends:              base-4.17.2.1 vector-0.13.1.0-93FGbMU4lvK4yKJkYGTpJX
haddock-interfaces:
    /usr/share/doc/haskell-edit-distance-vector/html/edit-distance-vector.haddock

haddock-html:         /usr/share/doc/haskell-edit-distance-vector/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

