#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 esqueleto
version:              3.5.10.1
visibility:           public
id:                   esqueleto-3.5.10.1-Dv9triiBTtZIg7kjEpphGY
key:                  esqueleto-3.5.10.1-Dv9triiBTtZIg7kjEpphGY
license:              BSD-3-Clause
copyright:            (c) 2012-2016 Felipe Almeida Lessa
maintainer:           cma@bitemyapp.com
author:               Felipe Lessa
homepage:             https://github.com/bitemyapp/esqueleto
synopsis:             Type-safe EDSL for SQL queries on persistent backends.
description:
    @esqueleto@ is a bare bones, type-safe EDSL for SQL queries that works with unmodified @persistent@ SQL backends.  Its language closely resembles SQL, so you don'\''t have to learn new concepts, just new syntax, and it'\''s fairly easy to predict the generated SQL and optimize it for your backend. Most kinds of errors committed when writing SQL are caught as compile-time errors---although it is possible to write type-checked @esqueleto@ queries that fail at runtime.

    @persistent@ is a library for type-safe data serialization.  It has many kinds of backends, such as SQL backends (@persistent-mysql@, @persistent-postgresql@, @persistent-sqlite@) and NoSQL backends (@persistent-mongoDB@). While @persistent@ is a nice library for storing and retrieving records, including with filters, it does not try to support some of the features that are specific to SQL backends.  In particular, @esqueleto@ is the recommended library for type-safe @JOIN@s on @persistent@ SQL backends.  (The alternative is using raw SQL, but that'\''s error prone and does not offer any composability.)

    Currently, @SELECT@s, @UPDATE@s, @INSERT@s and @DELETE@s are supported. Not all SQL features are available, but most of them can be easily added (especially functions), so please open an issue or send a pull request if you need anything that is not covered by @esqueleto@ on <https://github.com/bitemyapp/esqueleto>.

    The name of this library means \"skeleton\" in Portuguese and contains all three SQL letters in the correct order =).  It was inspired by Scala'\''s Squeryl but created from scratch.

category:             Database
abi:                  e23a173f7101b8af6bcefb564b6d7c63
exposed:              True
exposed-modules:
    Database.Esqueleto Database.Esqueleto.Experimental
    Database.Esqueleto.Experimental.From
    Database.Esqueleto.Experimental.From.CommonTableExpression
    Database.Esqueleto.Experimental.From.Join
    Database.Esqueleto.Experimental.From.SqlSetOperation
    Database.Esqueleto.Experimental.ToAlias
    Database.Esqueleto.Experimental.ToAliasReference
    Database.Esqueleto.Experimental.ToMaybe
    Database.Esqueleto.Internal.ExprParser
    Database.Esqueleto.Internal.Internal Database.Esqueleto.Legacy
    Database.Esqueleto.MySQL Database.Esqueleto.PostgreSQL
    Database.Esqueleto.PostgreSQL.JSON Database.Esqueleto.Record
    Database.Esqueleto.SQLite

hidden-modules:
    Database.Esqueleto.PostgreSQL.JSON.Instances
    Database.Esqueleto.Internal.PersistentImport Paths_esqueleto

import-dirs:          /usr/lib/ghc-9.6.6/site-local/esqueleto-3.5.10.1
library-dirs:         /usr/lib/ghc-9.6.6/site-local/esqueleto-3.5.10.1
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/esqueleto-3.5.10.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-esqueleto
hs-libraries:         HSesqueleto-3.5.10.1-Dv9triiBTtZIg7kjEpphGY
depends:
    aeson-2.1.2.1-2mQErQ8BnomI9IyqbCda9E
    attoparsec-0.14.4-75nKbPMSPaLAG220BErtuR base-4.18.2.1
    blaze-html-0.9.2.0-8CIOWujpLcd2fSwCqkXFhk bytestring-0.11.5.3
    conduit-1.3.6.1-CdT4yEwurtEjnovKY3L8i containers-0.6.7
    monad-logger-0.3.42-JgnpJNLRkAAFEc9IHfoUYv
    persistent-2.14.5.2-Jyemj1Wzm00Cpj7VjLND3P
    resourcet-1.2.6-EtMPDqHsQrqoGIXSo7kAd
    tagged-0.8.9-2fCpivRH6QIGdlOWfdc5ig template-haskell-2.20.0.0
    text-2.0.2 time-1.12.2 transformers-0.6.1.0
    unliftio-0.2.25.1-KPdC22vM2NXFLmIWh7FN8O
    unordered-containers-0.2.20.1-LJBbYvuM7Af6ez80tefkUA

haddock-interfaces:   /usr/share/doc/haskell-esqueleto/html/esqueleto.haddock
haddock-html:         /usr/share/doc/haskell-esqueleto/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

