#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 free
version:              5.2
visibility:           public
id:                   free-5.2-6pWJt0CG6431iIw6uoA2Ur
key:                  free-5.2-6pWJt0CG6431iIw6uoA2Ur
license:              BSD-3-Clause
copyright:            Copyright (C) 2008-2015 Edward A. Kmett
maintainer:           Edward A. Kmett <ekmett@gmail.com>
author:               Edward A. Kmett
stability:            provisional
homepage:             http://github.com/ekmett/free/
synopsis:             Monads for free
description:
    Free monads are useful for many tree-like structures and domain specific languages.

    If @f@ is a '\''Functor'\'' then the free '\''Monad'\'' on @f@ is the type
    of trees whose nodes are labeled with the constructors of @f@. The word
    \"free\" is used in the sense of \"unrestricted\" rather than \"zero-cost\":
    @Free f@ makes no constraining assumptions beyond those given by @f@ and the
    definition of '\''Monad'\''. As used here it is a standard term from the
    mathematical theory of adjoint functors.

    Cofree comonads are dual to free monads. They provide convenient ways to talk
    about branching streams and rose-trees, and can be used to annotate syntax
    trees. The cofree comonad can be seen as a stream parameterized by a '\''Functor'\''
    that controls its branching factor.

    More information on free monads, including examples, can be found in the
    following blog posts:
    <https://ekmett.github.io/reader/2008/monads-for-free/>
    <https://ekmett.github.io/reader/2011/free-monads-for-less/>

category:             Control, Monads
abi:                  febe2f7813ff81ea66643b6772c74040
exposed:              True
exposed-modules:
    Control.Alternative.Free Control.Alternative.Free.Final
    Control.Applicative.Free Control.Applicative.Free.Fast
    Control.Applicative.Free.Final Control.Applicative.Trans.Free
    Control.Comonad.Cofree Control.Comonad.Cofree.Class
    Control.Comonad.Trans.Cofree Control.Comonad.Trans.Coiter
    Control.Monad.Free Control.Monad.Free.Ap Control.Monad.Free.Church
    Control.Monad.Free.Class Control.Monad.Free.TH
    Control.Monad.Trans.Free Control.Monad.Trans.Free.Ap
    Control.Monad.Trans.Free.Church Control.Monad.Trans.Iter

import-dirs:          /usr/lib/ghc-9.4.8/site-local/free-5.2
library-dirs:         /usr/lib/ghc-9.4.8/site-local/free-5.2
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/free-5.2
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-free
hs-libraries:         HSfree-5.2-6pWJt0CG6431iIw6uoA2Ur
depends:
    base-4.17.2.1 comonad-5.0.8-FaXCdIH358gBTaN3fXTS5x containers-0.6.7
    distributive-0.6.2.1-2YiBzgLXCd2kHPlGPsZiv exceptions-0.10.5
    indexed-traversable-0.1.4-EiyQIsHWfilLwzPb8OdnEq mtl-2.2.2
    profunctors-5.6.2-FU1ZJ7jAwY3FBezLPRDd4l
    semigroupoids-6.0.0.1-6AK4WuDDdcpGLtBowKfvAR
    template-haskell-2.19.0.0
    th-abstraction-0.4.5.0-EtQVnbIEkAX5f6KN9Uwjhw transformers-0.5.6.2
    transformers-base-0.4.6-4mAULAIhjKjG98g1VZHGsY

haddock-interfaces:   /usr/share/doc/haskell-free/html/free.haddock
haddock-html:         /usr/share/doc/haskell-free/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

