#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 happstack-server
version:              7.9.2.1
visibility:           public
id:                   happstack-server-7.9.2.1-4G54qAUajNV4g7a6V042dV
key:                  happstack-server-7.9.2.1-4G54qAUajNV4g7a6V042dV
license:              BSD-3-Clause
maintainer:           Happstack team <happs@googlegroups.com>
author:               Happstack team, HAppS LLC
homepage:             http://happstack.com
synopsis:             Web related tools and services.
description:
    Happstack Server provides an HTTP server and a rich set of functions for routing requests, handling query parameters, generating responses, working with cookies, serving files, and more. For in-depth documentation see the Happstack Crash Course <http://happstack.com/docs/crashcourse/index.html>

category:             Web, Happstack
abi:                  30cc81bc96be916d0ea21d64d89dfb2a
exposed:              True
exposed-modules:
    Happstack.Server Happstack.Server.Auth Happstack.Server.Compression
    Happstack.Server.Cookie Happstack.Server.Error
    Happstack.Server.FileServe
    Happstack.Server.FileServe.BuildingBlocks Happstack.Server.I18N
    Happstack.Server.Internal.Compression
    Happstack.Server.Internal.Cookie Happstack.Server.Internal.Handler
    Happstack.Server.Internal.Listen
    Happstack.Server.Internal.LogFormat
    Happstack.Server.Internal.LowLevel
    Happstack.Server.Internal.MessageWrap
    Happstack.Server.Internal.Monads
    Happstack.Server.Internal.Multipart
    Happstack.Server.Internal.RFC822Headers
    Happstack.Server.Internal.Socket
    Happstack.Server.Internal.TimeoutIO
    Happstack.Server.Internal.TimeoutManager
    Happstack.Server.Internal.TimeoutSocket
    Happstack.Server.Internal.Types Happstack.Server.Monads
    Happstack.Server.Response Happstack.Server.Routing
    Happstack.Server.RqData Happstack.Server.SURI
    Happstack.Server.SimpleHTTP Happstack.Server.Types
    Happstack.Server.Validation

hidden-modules:
    Happstack.Server.Internal.Clock Happstack.Server.Internal.LazyLiner
    Happstack.Server.SURI.ParseURI Paths_happstack_server

import-dirs:          /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.2.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.2.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/happstack-server-7.9.2.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-happstack-server
hs-libraries:         HShappstack-server-7.9.2.1-4G54qAUajNV4g7a6V042dV
depends:
    base-4.17.2.1 base64-bytestring-1.2.1.0-4fqTDsScuuX4b4re0JajdK
    blaze-html-0.9.2.0-CBx6h5MV2lk7ZdDgEHs1DN bytestring-0.11.5.3
    containers-0.6.7 directory-1.3.7.1 exceptions-0.10.5
    extensible-exceptions-0.1.1.4-AGheGT2ZUDiCzp52FHEfjQ
    filepath-1.4.2.2 hslogger-1.3.1.2-9r6004OoCOs6RTVCUN7pE1
    html-1.0.1.2-J6DAJfvF1D3ECsZlmS8hoI
    monad-control-1.0.3.1-9kuNlqWAv0v3CZ7ezVGs4u mtl-2.2.2
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    old-locale-1.0.0.7-KCPcWVOQKME2P4y4gxzvhh parsec-3.1.16.1
    process-1.6.18.0 sendfile-0.7.11.6-EDfWRvU2GZj8Sq1CUVE7W2
    syb-0.7.2.4-5EQR9W4f34Nc1xy39zlm4
    system-filepath-0.4.14.1-HpP4RrQYWBaAhjcrjoLPHY text-2.0.2
    threads-0.5.1.8-FkcdlW4hpWACKxeeeOEmuA time-1.12.2
    transformers-0.5.6.2 transformers-base-0.4.6-L9QACCq37DSHBaBrNyzkap
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ unix-2.7.3
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm xhtml-3000.2.2.1
    zlib-0.6.3.0-2KGvvtaXpEH3KVbFxvGmml

haddock-interfaces:
    /usr/share/doc/haskell-happstack-server/html/happstack-server.haddock

haddock-html:         /usr/share/doc/haskell-happstack-server/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

