#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hasql-dynamic-statements
version:              0.3.1.1
visibility:           public
id:                   hasql-dynamic-statements-0.3.1.1-FJErz2pA0DP5ewMih59NHU
key:                  hasql-dynamic-statements-0.3.1.1-FJErz2pA0DP5ewMih59NHU
license:              MIT
copyright:            (c) 2019, Nikita Volkov
maintainer:           Nikita Volkov <nikita.y.volkov@mail.ru>
author:               Nikita Volkov <nikita.y.volkov@mail.ru>
homepage:             https://github.com/nikita-volkov/hasql-dynamic-statements
synopsis:             Toolkit for constructing Hasql statements dynamically
description:
    This library introduces into the Hasql ecosystem a new abstraction named Snippet,
    which makes it trivial to construct SQL, while injecting values.
    It is intended to be used when the SQL of your statement depends on the parameters,
    that you want to pass in.

abi:                  c5f4d6fd628c0bae744706bb348dbeed
exposed:              True
exposed-modules:
    Hasql.DynamicStatements.Session Hasql.DynamicStatements.Snippet
    Hasql.DynamicStatements.Statement

hidden-modules:
    Hasql.DynamicStatements.Prelude
    Hasql.DynamicStatements.Snippet.Defs

import-dirs:
    /usr/lib/ghc-9.4.8/site-local/hasql-dynamic-statements-0.3.1.1

library-dirs:
    /usr/lib/ghc-9.4.8/site-local/hasql-dynamic-statements-0.3.1.1

library-dirs-static:
    /usr/lib/ghc-9.4.8/site-local/hasql-dynamic-statements-0.3.1.1

dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hasql-dynamic-statements
hs-libraries:         HShasql-dynamic-statements-0.3.1.1-FJErz2pA0DP5ewMih59NHU
depends:
    base-4.17.2.1 bytestring-0.11.5.3 containers-0.6.7
    hasql-1.5.0.4-9arpbJBdZIr7oPffqzZlO3
    hasql-implicits-0.1.0.5-IKhWC62zYRmCi8BliJmuRb
    ptr-0.16.8.7-JsO0XeDYTBQ5MRWoVm96Lj

haddock-interfaces:
    /usr/share/doc/haskell-hasql-dynamic-statements/html/hasql-dynamic-statements.haddock

haddock-html:         /usr/share/doc/haskell-hasql-dynamic-statements/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

