#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.32.1
visibility:           public
id:                   hledger-lib-1.32.1-AuWWmrJCB5JQkpFq0pTum
key:                  hledger-lib-1.32.1-AuWWmrJCB5JQkpFq0pTum
license:              GPL-3.0-only
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  3c18c8b98302f761dd5cdfc4005d951c
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Dates
    Hledger.Data.Errors Hledger.Data.Journal Hledger.Data.JournalChecks
    Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader Hledger.Read.CsvUtils
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Text.Tabular.AsciiWide

hidden-modules:
    Text.Megaparsec.Custom Text.WideString Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.32.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.32.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hledger-lib-1.32.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.32.1-AuWWmrJCB5JQkpFq0pTum
depends:
    Decimal-0.5.2-8Pcz1CUTBp0KHJwkjuxCBB
    Glob-0.10.2-FXgkuDBZUb2Gc2e66kmlY5
    aeson-2.1.2.1-BogEXKsQPCa9ALgQQ034ff
    aeson-pretty-0.8.10-1i80nKU9XQK9tJXNNhJ2PR
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc array-0.5.4.0
    base-4.17.2.1 base-compat-0.12.2-3peTS4EQIw912qC0ETmbL5
    blaze-markup-0.8.3.0-E3xIpXEfOxQ70jxLTxkTyw bytestring-0.11.5.3
    call-stack-0.4.0-AAQ0PbHtRxA9hkeprsdCAo
    cassava-0.5.3.2-DzzbHTAeXaRChXHFdPM2UR
    cassava-megaparsec-2.1.1-FPdyBk7pBJm5BH2XgIq1IO
    cmdargs-0.10.22-KMcxPO0UszDDPT8hI73uO5
    colour-2.3.6-Fuw3AbFioIZ9repUO0m0MS containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi deepseq-1.4.8.0
    directory-1.3.7.1 doclayout-0.4.0.1-FncRGvpl2Ap7XygFmE7lxE
    extra-1.7.16-EuapY98rdrN25pzQYLq3T2
    file-embed-0.0.15.0-7OnjuFj6gBM9fqBKJCVXdU filepath-1.4.2.2
    hashtables-1.3.1-ADrvCNjeKuDHf53POqMa3o
    megaparsec-9.6.1-2HDqovyWdJD7TkiDY5U33O
    microlens-0.4.13.1-BCmTOusOWAwKF1xfvNhRYd
    microlens-th-0.4.3.17-GNytIaHmI1f32SxxcUFLLO mtl-2.2.2
    pager-0.1.1.0-AKGC0aF1lq3L2GOfGKrzUH
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav
    pretty-simple-4.1.3.0-C0xtydBbnCDBtuV6SU6ZwV
    regex-tdfa-1.3.2.2-I6io9mqXIhYC0c5uz00Sgn
    safe-0.3.21-2z6THsw90lt9vpsKu2dhGD
    tabular-0.2.2.8-GPlaI3PukxDKI4c6j3m1vm
    tasty-1.4.3-1VgnHOByr8AIto1CnZp8DF
    tasty-hunit-0.10.1-q71iukSCC7EOanHbVCs3z template-haskell-2.19.0.0
    terminal-size-0.3.4-G9QKE0nIH70HWdqrMvHn0A text-2.0.2
    text-ansi-0.2.1.1-AX938w52lKy3kOn5X5BgE time-1.12.2
    timeit-2.0-GSLifhpRLI5Gr54jWRx5t0 transformers-0.5.6.2
    uglymemo-0.1.0.1-8AX9zjlFnnmIrnTboBgOzO
    unordered-containers-0.2.20-FzN23deFW3GkzXU7VwkDd
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

