#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hledger-lib
version:              1.50.3
visibility:           public
id:                   hledger-lib-1.50.3-A69MenCB2oA2R6U9TbqqS3
key:                  hledger-lib-1.50.3-A69MenCB2oA2R6U9TbqqS3
license:              GPL-3.0-or-later
maintainer:           Simon Michael <simon@joyful.com>
author:               Simon Michael <simon@joyful.com>
stability:            stable
homepage:             http://hledger.org
synopsis:             A library providing the core functionality of hledger
description:
    This library contains hledger'\''s core functionality.
    It is used by most hledger* packages so that they support the same
    command line options, file formats, reports, etc.

    hledger is a robust, cross-platform set of tools for tracking money,
    time, or any other commodity, using double-entry accounting and a
    simple, editable file format, with command-line, terminal and web
    interfaces. It is a Haskell rewrite of Ledger, and one of the leading
    implementations of Plain Text Accounting.

    See also:

    - https://hledger.org - hledger'\''s home page

    - https://hledger.org/dev.html - starting point for hledger'\''s developer docs

    - https://hackage.haskell.org/package/hledger-lib/docs/Hledger.html - starting point for hledger'\''s haddock docs

category:             Finance
abi:                  1d0fc1ff5cf8f61bd7cf4a133ecb6435
exposed:              True
exposed-modules:
    Hledger Hledger.Data Hledger.Data.Account Hledger.Data.AccountName
    Hledger.Data.Amount Hledger.Data.Balancing Hledger.Data.Currency
    Hledger.Data.Dates Hledger.Data.Errors Hledger.Data.Journal
    Hledger.Data.JournalChecks Hledger.Data.JournalChecks.Ordereddates
    Hledger.Data.JournalChecks.Uniqueleafnames Hledger.Data.Json
    Hledger.Data.Ledger Hledger.Data.Period
    Hledger.Data.PeriodicTransaction Hledger.Data.Posting
    Hledger.Data.RawOptions Hledger.Data.StringFormat
    Hledger.Data.Timeclock Hledger.Data.Transaction
    Hledger.Data.TransactionModifier Hledger.Data.Types
    Hledger.Data.Valuation Hledger.Query Hledger.Read
    Hledger.Read.Common Hledger.Read.CsvReader
    Hledger.Read.InputOptions Hledger.Read.JournalReader
    Hledger.Read.RulesReader Hledger.Read.TimeclockReader
    Hledger.Read.TimedotReader Hledger.Reports
    Hledger.Reports.AccountTransactionsReport
    Hledger.Reports.BalanceReport Hledger.Reports.BudgetReport
    Hledger.Reports.EntriesReport Hledger.Reports.MultiBalanceReport
    Hledger.Reports.PostingsReport Hledger.Reports.ReportOptions
    Hledger.Reports.ReportTypes Hledger.Utils Hledger.Utils.Debug
    Hledger.Utils.IO Hledger.Utils.Parse Hledger.Utils.Regex
    Hledger.Utils.String Hledger.Utils.Test Hledger.Utils.Text
    Hledger.Write.Beancount Hledger.Write.Csv Hledger.Write.Html
    Hledger.Write.Html.Attribute Hledger.Write.Html.Blaze
    Hledger.Write.Html.HtmlCommon Hledger.Write.Html.Lucid
    Hledger.Write.Ods Hledger.Write.Spreadsheet Text.Tabular.AsciiWide
    Text.WideString

hidden-modules:
    Hledger.Data.BalanceData Hledger.Data.DayPartition
    Hledger.Data.PeriodData Paths_hledger_lib

import-dirs:          /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
library-dirs:         /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/hledger-lib-1.50.3
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hledger-lib
hs-libraries:         HShledger-lib-1.50.3-A69MenCB2oA2R6U9TbqqS3
depends:
    Decimal-0.5.2-EfeRJOh9ESJFpVyAivOumF
    Glob-0.10.2-5epAlpFoAEIGHPBmPFvABy
    aeson-2.1.2.1-6DouAcLayfd1cKsM4PdlxR
    aeson-pretty-0.8.10-AABvmKOgjm1WKNxOhOXTU
    ansi-terminal-1.0.2-5XGQCBITBQK54h4mZtEY0l array-0.5.6.0
    base-4.18.2.1 blaze-html-0.9.2.0-ewkcMpB7hX5zM6Snyh7uM
    blaze-markup-0.8.3.0-J7VUp7h8NNh5WgPS0pzxN4 bytestring-0.11.5.3
    call-stack-0.4.0-2bP2isqo6m56I7hpBeHX0O
    cassava-0.5.4.1-G45W0flyx9AAogeh6zsTo8
    cassava-megaparsec-2.1.1-7UhuzQTScFe52SDRUqb6MM
    cmdargs-0.10.22-E2EkQI5shziHkHOdPiVHiM
    colour-2.3.6-IoZCkfJLswhJ7oGizLXX0H containers-0.6.7
    data-default-0.7.1.3-GjFcYIDEzFPmj8haZ8waF deepseq-1.4.8.1
    directory-1.3.8.5 doclayout-0.5-AzY66xM6VCn9pf7z28gwqH
    encoding-0.10.2-4gUx2DCjse02W6iiQjgUN5
    extra-1.7.16-8dGAsSrJDrL2Qv7CcA7Z6y
    file-embed-0.0.16.0-6A32wX7iXBC7ZTuLWlLLWz filepath-1.4.300.1
    hashtables-1.4.2-GEB0lN4qC2XQKPdFyG6oL
    lucid-2.11.20250303-JrdCWT5fSI8CcNIQxGfyDE
    megaparsec-9.7.0-EJ90AsoHAMdCjQYvJMoIz4
    microlens-0.4.14.0-IP2Uuhm3qTnDhkfYobH8B3
    microlens-th-0.4.3.17-IPbJLKFzpBF3M0tXA6bBdw mtl-2.3.1
    parser-combinators-1.3.0-20UTEUZ5CKDJdRu747ID48
    pretty-simple-4.1.4.0-JrPpxJXbArkDpLMms4WfTy process-1.6.19.0
    regex-tdfa-1.3.2.5-DTLCNeui6jjF7PuXyFzkbb
    safe-0.3.21-Jx1j9PonLpAIXmir4WvZhd
    tabular-0.2.2.8-Ly9fepE9sHFB2l1Bgv9bkV
    tasty-1.5.2-5ThorlfIy4bAzjwer0MKIq
    tasty-hunit-0.10.2-HLuhpg5chTALjPoc69Xunp template-haskell-2.20.0.0
    terminal-size-0.3.4-RfZxi4foNwK9w669pzI7h text-2.0.2
    these-1.2.1-4hTMfx1DS6oLW0Vj2YyJsc time-1.12.2
    timeit-2.0-DwmItJuhuSm6aktMh1S1ZM transformers-0.6.1.0
    uglymemo-0.1.0.1-9CTAG7WaUP4YIMm3gIN93
    unordered-containers-0.2.20.1-650icVWmHjf3WKXK0GKpae
    utf8-string-1.0.2-2At7L47Qsbs4rlGLlJEQb1

haddock-interfaces:   /usr/share/doc/haskell-hledger-lib/html/hledger-lib.haddock
haddock-html:         /usr/share/doc/haskell-hledger-lib/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

