#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.10.0
visibility:           public
id:                   hOpenPGP-2.10.0-JWzWBcxBZvM2IcyxiOl8eX
key:                  hOpenPGP-2.10.0-JWzWBcxBZvM2IcyxiOl8eX
license:              MIT
copyright:            2012-2024  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  f510fd7d4b6d9e154b65288e2e6b9623
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Crypton
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptonNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.10.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.10.0-JWzWBcxBZvM2IcyxiOl8eX
depends:
    aeson-2.1.2.1-7NKMY9av0haL3nHVKphSJj
    asn1-encoding-0.9.6-AdJ5yV3qAg5B42gEeXR6jO
    attoparsec-0.14.4-8RYxJQa7MEjKmC3I11Us4k base-4.17.2.1
    base16-bytestring-1.0.2.0-IEtpsrDkMVlLM4YsQhzHqm
    bifunctors-5.6-CjA2IHLDQKwEC0X4rT9ss0 binary-0.8.9.1
    binary-conduit-1.3.1-FN6pitW4UfICkw7FVFpYkY bytestring-0.11.5.3
    bz2-1.0.1.1-372MUQ8D58KKRIyIOUopDa
    conduit-1.3.6.1-86fl8mgs0PcICSp2A4xyva
    conduit-extra-1.3.6-2ISWqvhHdx25m1q6Z6zUj3 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    crypton-0.34-FBCi8YNA1Yo8PBEQxV02X0
    errors-2.3.0-CzddBR9NRhU3uYWEcQdISQ
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    incremental-parser-0.5.1-55pGZv6KdhJ3SHbUu22JuG
    ixset-typed-0.5.1.0-Jl03kLohIv9BKk76rkWRnl
    lens-5.2.3-4nDp1u1qKC5FV2ww18Mx1
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-EDr74t9h07L15oCNeDNFfl
    openpgp-asciiarmor-0.1.2-4SrMhrp7VYL4YfHczSY4LU
    prettyprinter-1.7.1-4Mn04lWp3HTA5zh48zv2n2
    resourcet-1.2.6-223TkNfardcC3p5LC28WLD
    split-0.2.5-zycrG25TwZLo8bmb9YFUF text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    zlib-0.6.3.0-pMzhPqoz0vBGpJZmwR4eF

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

