#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-1D6Rc12VDCA4vTsZueeZ0x
key:                  hOpenPGP-2.9.8-1D6Rc12VDCA4vTsZueeZ0x
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  64a9679c51c91bdec936ba5efc09ac07
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-1D6Rc12VDCA4vTsZueeZ0x
depends:
    aeson-2.1.2.1-8pX4IwvbwpcwXiIiReOQk
    asn1-encoding-0.9.6-1ejpYqziw9LGPZpUOEyjjr
    attoparsec-0.14.4-DGiM2cMH1LKFsy4siuUEV5 base-4.17.2.1
    base16-bytestring-1.0.2.0-H4mWquGqZ47CRtjSGnMbY4
    bifunctors-5.6-48r3ezHFX5DJYoFMQ8yZxh binary-0.8.9.1
    binary-conduit-1.3.1-1EFoTKfCbkML1Of0JbDa6o bytestring-0.11.5.3
    bz2-1.0.1.1-AoXtd8GXAjhEfb8ivlzO3K
    conduit-1.3.6.1-L447JUvNddBC7PkE6UyQyv
    conduit-extra-1.3.6-CzDgdjNDXBkKwoWdIabZpV containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    cryptonite-0.30-3dtYBQp3BahCQATU6BzFJT
    errors-2.3.0-9fFmbUGFRO4OusDPbEvm6
    hashable-1.4.4.0-3qP5TxmiOmVGP173jSDFZO
    incremental-parser-0.5.1-70lP8W7Wmeb99IrbVPBCOU
    ixset-typed-0.5.1.0-5Z0SbbXbotQBZWQCrWoBme
    lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-FySjo3JLI85BEi0FUQGaO
    openpgp-asciiarmor-0.1.2-Isx1k9623yKjDIj227EAc
    prettyprinter-1.7.1-6jCWnP5jsaKCzg7tcQDjYG
    resourcet-1.2.6-F9Fn1s8Ehj0BYy7paIyOT3
    split-0.2.5-KSNJtK4iVn96dAw1dg6ivl text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj
    zlib-0.6.3.0-GXRj3sTL3B9dMkQZOuXLX

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

