#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-IG4t8t5F2tDBRNOnvMBbne
key:                  hOpenPGP-2.9.8-IG4t8t5F2tDBRNOnvMBbne
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  2379095a9416540e91f761f30c2611cf
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-IG4t8t5F2tDBRNOnvMBbne
depends:
    aeson-2.1.2.1-Kzzie09M6AYFH8VDx0mx86
    asn1-encoding-0.9.6-FV40OL36SBl6GSSONmVdbP
    attoparsec-0.14.4-GPSHKdrOxNAHtLNPx9PvVS base-4.17.2.1
    base16-bytestring-1.0.2.0-KDSFpGK70SNFrMbzTIS4T1
    bifunctors-5.6-AKLUSgy5WQnxS8akTpx32 binary-0.8.9.1
    binary-conduit-1.3.1-B9VjijR6D7JDMI9UBwmaRS bytestring-0.11.5.3
    bz2-1.0.1.1-AQbv9C5xAOVBxI8csoYWme
    conduit-1.3.6.1-82jMOxZzolypQFNqeliRy
    conduit-extra-1.3.6-8gBiaUXtjjDExv3ODVmIAR containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    cryptonite-0.30-9srWWoVE7lJZSpxQsqkm
    errors-2.3.0-AdZel7p0JtH2zCOKfddTHc
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    incremental-parser-0.5.1-LvIL9c0I7Tv2VMYmRpC4hj
    ixset-typed-0.5.1.0-1QMJJ5Bw65O3vhthNDH7RH
    lens-5.2.3-JlyZXwZS00NBv5ScwlVipn
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    openpgp-asciiarmor-0.1.2-9b7xMBxKa6XFa3XvL656RQ
    prettyprinter-1.7.1-CrZ7BsQJ9pDCXOGGFM6iz2
    resourcet-1.2.6-BnzJKl3tMH97xEdk6b9UNW
    split-0.2.5-1cvcRB3t1btB7X53ioPSfn text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    zlib-0.6.3.0-2KGvvtaXpEH3KVbFxvGmml

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

