#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 hOpenPGP
version:              2.9.8
visibility:           public
id:                   hOpenPGP-2.9.8-99tMNCUMJ508IHbnDNEHXX
key:                  hOpenPGP-2.9.8-99tMNCUMJ508IHbnDNEHXX
license:              MIT
copyright:            2012-2022  Clint Adams
maintainer:           Clint Adams <clint@debian.org>
author:               Clint Adams
homepage:             https://salsa.debian.org/clint/hOpenPGP
synopsis:             native Haskell implementation of OpenPGP (RFC4880)
description:
    native Haskell implementation of OpenPGP (RFC4880), plus Camellia (RFC5581), plus ECC (RFC6637)

category:             Codec, Data
abi:                  af7308cd1d960562fcb3923d23cbe26e
exposed:              True
exposed-modules:
    Codec.Encryption.OpenPGP.CFB Codec.Encryption.OpenPGP.Compression
    Codec.Encryption.OpenPGP.Expirations
    Codec.Encryption.OpenPGP.Fingerprint
    Codec.Encryption.OpenPGP.KeyInfo
    Codec.Encryption.OpenPGP.KeySelection
    Codec.Encryption.OpenPGP.KeyringParser
    Codec.Encryption.OpenPGP.Ontology Codec.Encryption.OpenPGP.S2K
    Codec.Encryption.OpenPGP.SecretKey
    Codec.Encryption.OpenPGP.Serialize
    Codec.Encryption.OpenPGP.SignatureQualities
    Codec.Encryption.OpenPGP.Signatures Codec.Encryption.OpenPGP.Types
    Data.Conduit.OpenPGP.Compression Data.Conduit.OpenPGP.Decrypt
    Data.Conduit.OpenPGP.Filter Data.Conduit.OpenPGP.Keyring
    Data.Conduit.OpenPGP.Keyring.Instances Data.Conduit.OpenPGP.Verify

hidden-modules:
    Codec.Encryption.OpenPGP.Internal
    Codec.Encryption.OpenPGP.Internal.CryptoCipherTypes
    Codec.Encryption.OpenPGP.Internal.Cryptonite
    Codec.Encryption.OpenPGP.Internal.HOBlockCipher
    Codec.Encryption.OpenPGP.Types.Internal.Base
    Codec.Encryption.OpenPGP.Types.Internal.CryptoniteNewtypes
    Codec.Encryption.OpenPGP.Types.Internal.PKITypes
    Codec.Encryption.OpenPGP.Types.Internal.PacketClass
    Codec.Encryption.OpenPGP.Types.Internal.Pkt
    Codec.Encryption.OpenPGP.Types.Internal.PrettyUtils
    Codec.Encryption.OpenPGP.Types.Internal.TK
    Codec.Encryption.OpenPGP.BlockCipher
    Codec.Encryption.OpenPGP.SerializeForSigs

import-dirs:          /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs:         /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/hOpenPGP-2.9.8
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-hopenpgp
hs-libraries:         HShOpenPGP-2.9.8-99tMNCUMJ508IHbnDNEHXX
depends:
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A
    asn1-encoding-0.9.6-3BN4xVt1gAa9atD8vYkdu0
    attoparsec-0.14.4-21g0xvIiXNtBpdLdrKPYdv base-4.17.2.1
    base16-bytestring-1.0.2.0-LZWoqVsRU525spGmpCza2K
    bifunctors-5.6-9UAdy2Rz8TK2BlMm8XQUvc binary-0.8.9.1
    binary-conduit-1.3.1-LlzJCMlfrLSEAeyv0U4IhN bytestring-0.11.5.3
    bz2-1.0.1.1-7xOF3M3hjWJ2XsXCnWW0RA
    conduit-1.3.6.1-D4YiOfvDFG0FSohx4jmvQj
    conduit-extra-1.3.6-730UVkuRTVsDj6V9AWbsl9 containers-0.6.7
    crypto-cipher-types-0.0.9-56ZYVGDFxwtG8TJEc7UjH2
    cryptonite-0.30-EmQIMz5ymXy1lbqLHnuFM5
    errors-2.3.0-C1121m3iiOSD0pvXQOpkrw
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    incremental-parser-0.5.1-2HJAAXIXSAOHZJnZjW8umu
    ixset-typed-0.5.1.0-Egs3azlKHIE2XK4EK60x26
    lens-5.2.3-9tvnz3pLdcPH5JzlkQxTXA
    memory-0.18.0-1oHOZXUPjWrG0kImkORGvt
    monad-loops-0.4.3-KaRiS5mJjkQ1zBkxxbNC2Z
    nettle-0.3.1.1-1YbDn5AJWxHLXr6DClLuRr
    network-uri-2.6.4.2-2U8duEjYT0p2SuyLAFgLE2
    openpgp-asciiarmor-0.1.2-9nMJtK4ZX3ZBiGplyENjfY
    prettyprinter-1.7.1-KavgWlSYS7L7YXURHbWfqH
    resourcet-1.2.6-Emy1WDuYe6W3crmrzZuLqP
    split-0.2.5-3ghNiOjEzjd4I9aswWcGmY text-2.0.2 time-1.12.2
    time-locale-compat-0.1.1.5-1zJhxgkP2bvGiOhYof1wNA
    transformers-0.5.6.2 unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    zlib-0.6.3.0-Lc3DHeTx2uhI5X6rGvkbLK

haddock-interfaces:   /usr/share/doc/haskell-hopenpgp/html/hOpenPGP.haddock
haddock-html:         /usr/share/doc/haskell-hopenpgp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

