#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 HTF
version:              0.15.0.1
visibility:           public
id:                   HTF-0.15.0.1-A1DMjvhHuq3Gwo27WH2Vq
key:                  HTF-0.15.0.1-A1DMjvhHuq3Gwo27WH2Vq
license:              LGPL-2.1-only
copyright:            (c) 2005-2023 Stefan Wehr
maintainer:           Stefan Wehr
author:               Stefan Wehr
stability:            Beta
homepage:             https://github.com/skogsbaer/HTF/
synopsis:             The Haskell Test Framework
description:
    The Haskell Test Framework (/HTF/ for short) lets you define and organize unit tests,
    QuickCheck properties,
    and black box tests in an
    easy and convenient way. HTF uses a custom preprocessor that collects
    test definitions automatically.

    HTF produces highly readable output
    for failing test cases: it provides exact file name and line number
    information,
    it colors and pretty prints expected and
    actual results, and it displays a diff highlighting the mismatching parts.

    The documentation of the "Test.Framework.Tutorial" module
    provides a tutorial for HTF. The /sample/ directory in
    the HTF repo provides a good starting point for
    a project using HTF.

category:             Testing
abi:                  31fb31dcfd418e818227f26c498baf83
exposed:              True
exposed-modules:
    Test.Framework Test.Framework.AssertM Test.Framework.BlackBoxTest
    Test.Framework.HUnitWrapper Test.Framework.History
    Test.Framework.JsonOutput Test.Framework.Location
    Test.Framework.Preprocessor Test.Framework.Pretty
    Test.Framework.PrettyHaskell Test.Framework.QuickCheckWrapper
    Test.Framework.TestInterface Test.Framework.TestManager
    Test.Framework.TestTypes Test.Framework.ThreadPool
    Test.Framework.Tutorial Test.Framework.XmlOutput

hidden-modules:
    Paths_HTF Test.Framework.CmdlineOptions Test.Framework.Colors
    Test.Framework.Diff Test.Framework.Process
    Test.Framework.TestReporter Test.Framework.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs:         /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/HTF-0.15.0.1
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-htf
hs-libraries:         HSHTF-0.15.0.1-A1DMjvhHuq3Gwo27WH2Vq
depends:
    Diff-0.4.1-LH1ky1AbixJl32mO74dkD
    HUnit-1.6.2.0-DUvlqmsw2Kp6tCDRl9WtXA
    QuickCheck-2.14.3-6d1PIKLXLdiAlrbWNDjj9l
    aeson-2.1.2.1-G4Y2VMvw6jlHlUlOzfqhge array-0.5.4.0 base-4.17.2.1
    base64-bytestring-1.2.1.0-4q5KLdrxF6BHAwlK9Y3XXj
    bytestring-0.11.5.3 containers-0.6.7
    cpphs-1.20.9.1-KMTErBmnvc26XA8bncSIwV directory-1.3.7.1
    haskell-src-1.0.4.1-IJ0lDEmG89pJCfKtxG8zTh
    lifted-base-0.2.3.12-5aJT0Ukpe9IIhgidyvotpP
    monad-control-1.0.3.1-2ox58PDyrrF9r8TgoOtkMn mtl-2.2.2
    old-time-1.1.0.4-7kNg8VzooGoExH4yeT9sv9 pretty-1.1.3.6
    process-1.6.18.0 random-1.2.1.2-2GxRLB29YjZ5Hmc9ZOWGpv
    regex-compat-0.95.2.2-XQpODnagAHFJ9GlOSqau8 text-2.0.2 time-1.12.2
    unix-2.7.3 vector-0.13.1.0-D9au4GPCsbT1DKgXASrr5O
    xmlgen-0.6.2.2-4qvhrJrFVVzIc569EpvS7u

haddock-interfaces:   /usr/share/doc/haskell-htf/html/HTF.haddock
haddock-html:         /usr/share/doc/haskell-htf/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

