#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 http-client-restricted
version:              0.1.0
visibility:           public
id:                   http-client-restricted-0.1.0-AKX28W84RMYC1X5wcWhqTn
key:                  http-client-restricted-0.1.0-AKX28W84RMYC1X5wcWhqTn
license:              MIT
copyright:            2018 Joey Hess, 2013 Michael Snoyman
maintainer:           Joey Hess <id@joeyh.name>
author:               Joey Hess
synopsis:             restricting the servers that http-client will use
description:
    Addition to the http-client and http-client-tls
    libraries, that restricts the HTTP servers that can be used.

    This is useful when a security policy needs to eg, prevent connections to
    HTTP servers on localhost or a local network, or only allow connections
    to a specific HTTP server.

    It handles restricting redirects as well as the initial HTTP connection,
    and it also guards against DNS poisoning attacks.

category:             Network
abi:                  350ed5fd9de98df3311a2e0e8a0848e0
exposed:              True
exposed-modules:      Network.HTTP.Client.Restricted
import-dirs:          /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/http-client-restricted-0.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-http-client-restricted
hs-libraries:         HShttp-client-restricted-0.1.0-AKX28W84RMYC1X5wcWhqTn
depends:
    base-4.17.2.1 crypton-connection-0.3.2-LdBPvqD0MJS17F4y1oyxVt
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    http-client-0.7.17-2bmcHc0cHmODspv0lmZ3j1
    http-client-tls-0.3.6.3-4HJGt4uiE0c6Cw9rBFFelB
    network-3.1.4.0-HsnWpJCBJSkHDu8PyPRvYR
    network-bsd-2.8.1.0-IQp6jRy7V2rCowUHj6X0kW
    utf8-string-1.0.2-D0oARDqSiCF3CIA0pPBIDm

haddock-interfaces:
    /usr/share/doc/haskell-http-client-restricted/html/http-client-restricted.haddock

haddock-html:         /usr/share/doc/haskell-http-client-restricted/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

