#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.6.0.0
visibility:           public
id:                   lsp-1.6.0.0-EzZWHSTgh2eBqXWsr3rUZN
key:                  lsp-1.6.0.0-EzZWHSTgh2eBqXWsr3rUZN
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  75ce5322122e11723481d77810deec06
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Logging,
    Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.6.0.1-H2fJZN43yMpAmyISbT7lDk:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.1-H2fJZN43yMpAmyISbT7lDk:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.6.0.1-H2fJZN43yMpAmyISbT7lDk:Language.LSP.Types.Lens,
    Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.6.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp
hs-libraries:         HSlsp-1.6.0.0-EzZWHSTgh2eBqXWsr3rUZN
depends:
    aeson-2.1.2.1-G4Y2VMvw6jlHlUlOzfqhge
    async-2.2.5-HIvtQdOwlf5Hsyin6u1n7Q
    attoparsec-0.14.4-8RYxJQa7MEjKmC3I11Us4k base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.3-1k3G3kRu4JS6X7mFEq4nsf
    containers-0.6.7 data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi
    directory-1.3.7.1 exceptions-0.10.5 filepath-1.4.2.2
    hashable-1.4.4.0-nWtkxUvx9i9tMRJKCZgnw
    lens-5.2.3-DnVNcFpsuwMCXFWImXsY2L
    lsp-types-1.6.0.1-H2fJZN43yMpAmyISbT7lDk mtl-2.2.2
    prettyprinter-1.7.1-4Mn04lWp3HTA5zh48zv2n2
    random-1.2.1.2-2GxRLB29YjZ5Hmc9ZOWGpv
    sorted-list-0.2.2.0-3PKg8r9fLwKFsBj8pkAdRm stm-2.5.1.0
    temporary-1.3-5ukCxB0doMQ964otfCXv0z text-2.0.2
    text-rope-0.3-LQnOkPra7OBdPtjtRqXTz transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-1zjZuvvQz6A9v2Utwl5wnX
    uuid-1.3.16-872C2ncsprsByedHsPUft7

haddock-interfaces:   /usr/share/doc/haskell-lsp/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

