#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp-test
version:              0.14.1.0
visibility:           public
id:                   lsp-test-0.14.1.0-12231rgYtQVGCDD3mOGUbo
key:                  lsp-test-0.14.1.0-12231rgYtQVGCDD3mOGUbo
license:              BSD-3-Clause
copyright:            2021 Luke Lau
maintainer:           luke_lau@icloud.com
author:               Luke Lau
homepage:
    https://github.com/haskell/lsp/blob/master/lsp-test/README.md

synopsis:             Functional test framework for LSP servers.
description:
    A test framework for writing tests against
    <https://microsoft.github.io/language-server-protocol/ Language Server Protocol servers>.
    @Language.LSP.Test@ launches your server as a subprocess and allows you to simulate a session
    down to the wire.
    To see examples of it in action, check out <https://github.com/haskell/haskell-ide-engine haskell-ide-engine>,
    <https://github.com/haskell/haskell-language-server haskell-language-server> and
    <https://github.com/digital-asset/ghcide ghcide>.

category:             Testing
abi:                  f08abaa3a5014843e601d4e850b41aee
exposed:              True
exposed-modules:
    Control.Applicative.Combinators from parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav:Control.Applicative.Combinators,
    Language.LSP.Test,
    Language.LSP.Types from lsp-types-1.6.0.1-3Ph76KZqSJqK0YQo2w9ti3:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.6.0.1-3Ph76KZqSJqK0YQo2w9ti3:Language.LSP.Types.Capabilities

hidden-modules:
    Language.LSP.Test.Compat Language.LSP.Test.Decoding
    Language.LSP.Test.Exceptions Language.LSP.Test.Files
    Language.LSP.Test.Parsing Language.LSP.Test.Server
    Language.LSP.Test.Session

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-test-0.14.1.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp-test
hs-libraries:         HSlsp-test-0.14.1.0-12231rgYtQVGCDD3mOGUbo
depends:
    Diff-0.4.1-5YXeu67zblTJDvJ3gNHbyf
    Glob-0.10.2-2GkmIYHcPju6ikFwelkdas
    aeson-2.1.2.1-8pX4IwvbwpcwXiIiReOQk
    aeson-pretty-0.8.10-2gcmr9jutoDBcOX8VwwuWN
    ansi-terminal-1.0-LkJ9SxmfbHcAL1Z7MEt8xc
    async-2.2.5-1OQdSrpaQikD5R3gghkNQo base-4.17.2.1
    bytestring-0.11.5.3 co-log-core-0.3.2.3-Gh8aYM11kW04oatg89H8tA
    conduit-1.3.6.1-L447JUvNddBC7PkE6UyQyv
    conduit-parse-0.2.1.1-2yR9g9DPOJfPhY0OY7fZf containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi directory-1.3.7.1
    exceptions-0.10.5 filepath-1.4.2.2
    lens-5.2.3-ECHdyiBhGt3AEK5VHs81a3
    lsp-1.6.0.0-3LsX8V7dCXb5SsyCDeu2YI
    lsp-types-1.6.0.1-3Ph76KZqSJqK0YQo2w9ti3 mtl-2.2.2
    parser-combinators-1.3.0-11YwG5dPNej79xqbn9HKav process-1.6.18.0
    some-1.0.5-36xIADGNqiWGv9lC459cQD text-2.0.2 time-1.12.2
    transformers-0.5.6.2 unix-2.7.3
    unordered-containers-0.2.20-8U9CBLajvKUXcrLJVqNaj

haddock-interfaces:   /usr/share/doc/haskell-lsp-test/html/lsp-test.haddock
haddock-html:         /usr/share/doc/haskell-lsp-test/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

