#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-21U7RcYZJzb81sXpc09jAC
key:                  lsp-1.4.0.0-21U7RcYZJzb81sXpc09jAC
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  4fcf610a5994fcb9e8986b8c562189a1
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-CU3wGQL71IP6t3Mp0UjW6Z:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-CU3wGQL71IP6t3Mp0UjW6Z:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-CU3wGQL71IP6t3Mp0UjW6Z:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-CU3wGQL71IP6t3Mp0UjW6Z:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-21U7RcYZJzb81sXpc09jAC
depends:
    aeson-2.1.2.1-HgTvGelKFeMCs4MoB4HQQ3
    async-2.2.5-C82nSOzgP1IGLwyW5rdGdd
    attoparsec-0.14.4-GPSHKdrOxNAHtLNPx9PvVS base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi exceptions-0.10.5
    hashable-1.4.4.0-AtkYwZfsO44KEb9h1CQ6ig
    hslogger-1.3.1.2-9r6004OoCOs6RTVCUN7pE1
    lens-5.2.3-I3BlAHfqsGAEvCz93DUGGV
    lsp-types-1.4.0.1-CU3wGQL71IP6t3Mp0UjW6Z mtl-2.2.2
    network-uri-2.6.4.2-A65zHnygYht3ea081U7fDv
    random-1.2.1.2-LUVepo9xpbYCdyIKOUBgF2
    scientific-0.3.7.0-Jh9tJE2sLMpFL2bSsP8DMA
    sorted-list-0.2.2.0-JTSJ6Os6byOACBCSpMGlOt stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-6lPJVAOvNaZ2RxvZwsH66g
    uuid-1.3.16-2gEusA6tFh6LbhdUvzL7Yq

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

