#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 lsp
version:              1.4.0.0
visibility:           public
id:                   lsp-1.4.0.0-8iN8PNBIVINLb6u2vCZHnS
key:                  lsp-1.4.0.0-8iN8PNBIVINLb6u2vCZHnS
license:              MIT
copyright:            Alan Zimmerman, 2016-2021
maintainer:           alan.zimm@gmail.com
author:               Alan Zimmerman
homepage:             https://github.com/haskell/lsp
synopsis:             Haskell library for the Microsoft Language Server Protocol
description:
    An implementation of the types, and basic message server to
    allow language implementors to support the Language Server
    Protocol for their specific language.

    An example of this is for Haskell via the Haskell Language
    Server, at https://github.com/haskell/haskell-language-server

category:             Development
abi:                  8bcfbcdb76389bc5f53644a69f401551
exposed:              True
exposed-modules:
    Language.LSP.Diagnostics, Language.LSP.Server,
    Language.LSP.Types from lsp-types-1.4.0.1-98G0ba4WfHB9lyqufTXTa0:Language.LSP.Types,
    Language.LSP.Types.Capabilities from lsp-types-1.4.0.1-98G0ba4WfHB9lyqufTXTa0:Language.LSP.Types.Capabilities,
    Language.LSP.Types.Lens from lsp-types-1.4.0.1-98G0ba4WfHB9lyqufTXTa0:Language.LSP.Types.Lens,
    Language.LSP.VFS from lsp-types-1.4.0.1-98G0ba4WfHB9lyqufTXTa0:Language.LSP.VFS

hidden-modules:
    Language.LSP.Server.Core Language.LSP.Server.Control
    Language.LSP.Server.Processing

import-dirs:          /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs:         /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/lsp-1.4.0.0
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-lsp1.4
hs-libraries:         HSlsp-1.4.0.0-8iN8PNBIVINLb6u2vCZHnS
depends:
    aeson-2.1.2.1-3xjz2RyG2JVHhJgBzFxi7A
    async-2.2.5-EyV9emCuOIPGUIakwGPKTd
    attoparsec-0.14.4-21g0xvIiXNtBpdLdrKPYdv base-4.17.2.1
    bytestring-0.11.5.3 containers-0.6.7
    data-default-0.7.1.1-HuI8bY4bNR4F11jcRg6vOi exceptions-0.10.5
    hashable-1.4.4.0-3P57kjJkCag7O0bwYoaxX1
    hslogger-1.3.1.2-9N4mNhhL4yo6blkcs8hRve
    lens-5.2.3-9tvnz3pLdcPH5JzlkQxTXA
    lsp-types-1.4.0.1-98G0ba4WfHB9lyqufTXTa0 mtl-2.2.2
    network-uri-2.6.4.2-2U8duEjYT0p2SuyLAFgLE2
    random-1.2.1.2-IN7ymD0AKvltzeAmi6gkc
    scientific-0.3.7.0-LKd2L2qVPICBdMYOyCcex4
    sorted-list-0.2.2.0-KLOhmGZWmDJH27CWv49coS stm-2.5.1.0 text-2.0.2
    time-1.12.2 transformers-0.5.6.2
    unliftio-core-0.2.1.0-1JwPsdkrVim6892Z5vBeIT
    unordered-containers-0.2.20-4cFR6FXPxn69oePlCyMUKW
    uuid-1.3.16-5gzfU57PjbAAPEaoMEMRoj

haddock-interfaces:   /usr/share/doc/haskell-lsp1.4/html/lsp.haddock
haddock-html:         /usr/share/doc/haskell-lsp1.4/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

